/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.DetailCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.DetailPivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.SummaryCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.SummaryPivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.virtualentity.VirtualEntityCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.virtualentity.VirtualEntityDetailCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.virtualentity.VirtualEntityDetailPivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.virtualentity.VirtualEntitySummaryPivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;

public class CalculateAlgoXFactory {
    private static final Log LOGGER = LogFactory.getLog(CalculateAlgoXFactory.class);

    public static CalculateAlgoX getCalculate(HRComplexObjContext complexObjContext, ReportCalculateInfo calculateInfo) {
        if ("1".equals(calculateInfo.getReportType())) {
            if (complexObjContext.getVirtualEntity().booleanValue()) {
                LOGGER.info("[repCalculate-AlgoX]:detail report of virtual entity calculate by AlgoX");
                if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
                    LOGGER.info("[repCalculate-AlgoX]:detail report of rows to columns calculate by AlgoX");
                    return new VirtualEntityDetailPivotCalculateAlgoX(calculateInfo, complexObjContext);
                }
                return new VirtualEntityDetailCalculateAlgoX(calculateInfo, complexObjContext);
            }
            if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
                LOGGER.info("[repCalculate-AlgoX]:detail report of rows to columns calculate by AlgoX");
                return new DetailPivotCalculateAlgoX(calculateInfo, complexObjContext);
            }
            LOGGER.info("[repCalculate-AlgoX]:detail report calculate by AlgoX");
            return new DetailCalculateAlgoX(calculateInfo, complexObjContext);
        }
        if (complexObjContext.getVirtualEntity().booleanValue()) {
            LOGGER.info("[repCalculate-AlgoX]:summary report of virtual entity calculate by AlgoX");
            if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
                LOGGER.info("[repCalculate-AlgoX]:summary report of rows to columns calculate by AlgoX");
                return new VirtualEntitySummaryPivotCalculateAlgoX(calculateInfo, complexObjContext);
            }
            return new VirtualEntityCalculateAlgoX(calculateInfo, complexObjContext);
        }
        if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
            LOGGER.info("[repCalculate-AlgoX]:summary report of rows to columns calculate by AlgoX");
            return new SummaryPivotCalculateAlgoX(calculateInfo, complexObjContext);
        }
        LOGGER.info("[repCalculate-AlgoX]:summary report calculate by AlgoX");
        return new SummaryCalculateAlgoX(calculateInfo, complexObjContext);
    }
}

