/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.paging.Partition;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.func.algo.AlgoXAliasToUniqueKeyAlgoMapFunction;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.CacheUtils;

public class DetailCalculateAlgoX
extends CalculateAlgoX {
    private final String partitionCacheKey;
    private final String orderPartitionCacheKey;

    public DetailCalculateAlgoX(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
        boolean isIncludeSubOrg = calculateInfo.getAdminOrgSummaryInfo() != null && calculateInfo.getAdminOrgSummaryInfo().getIncludeSubOrg();
        this.partitionCacheKey = this.getPartitionCacheKey(calculateInfo, isIncludeSubOrg);
        this.orderPartitionCacheKey = "order_" + this.partitionCacheKey;
    }

    @Override
    public DataSet calculate(int start, int limit) {
        DataSet dataSet = super.queryOriginalDataSet(start, limit);
        dataSet = dataSet.map((MapFunction)new AlgoXAliasToUniqueKeyAlgoMapFunction(dataSet.getRowMeta(), this.calculateAlgoxParser.getRowFieldParser()));
        return dataSet;
    }

    @Override
    protected void beforeQuery() {
        super.beforeQuery();
        List<Partition> partitions = CacheUtils.getListFromPageCache(this.calculateInfo.getPageId(), this.partitionCacheKey, Partition.class);
        this.getComplexObjContext().addPartitions(partitions);
        List<Partition> orderPartitions = CacheUtils.getListFromPageCache(this.calculateInfo.getPageId(), this.orderPartitionCacheKey, Partition.class);
        this.getComplexObjContext().addOrderPartitions(orderPartitions);
    }

    @Override
    protected void afterQuery() {
        super.afterQuery();
        if (this.calculateInfo.isUpdateCachePartition()) {
            CacheUtils.putPageCache(this.calculateInfo.getPageId(), this.partitionCacheKey, this.getComplexObjContext().getPartitions());
            CacheUtils.putPageCache(this.calculateInfo.getPageId(), this.orderPartitionCacheKey, this.getComplexObjContext().getOrderPartitions());
        }
    }
}

