/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.complexobj.paging.Partition;
import kd.hr.hrptmc.business.repcalculate.algox.PivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.DetailTransposeCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.query.QueryServiceFactory;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.CacheUtils;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public class DetailPivotCalculateAlgoX
extends PivotCalculateAlgoX {
    private final String partitionCacheKey;
    private final String orderPartitionCacheKey;

    public DetailPivotCalculateAlgoX(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
        boolean isIncludeSubOrg = calculateInfo.getAdminOrgSummaryInfo() != null && calculateInfo.getAdminOrgSummaryInfo().getIncludeSubOrg();
        this.partitionCacheKey = this.getPartitionCacheKey(calculateInfo, isIncludeSubOrg);
        this.orderPartitionCacheKey = "order_" + this.partitionCacheKey;
    }

    @Override
    protected DataSetX doTransposeCalculate(DataSetX dataSetX, AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        RowFieldParser rowFieldParser = this.calculateAlgoxParser.getRowFieldParser();
        List<AlgoXCalculateAlgoXField> rowLatitudeList = algoxCalculateReduceGroupDTO.getRowLatitudeList();
        if (rowLatitudeList.size() > 0) {
            String[] rowLatitudeFieldOrderByArr = this.calculateAlgoxParser.getLatitudeFieldAlgoxAliasExtendOrderByArrByTransposeConfig(rowLatitudeList);
            dataSetX = dataSetX.groupBy(rowLatitudeFieldOrderByArr).reduceGroup((GroupReduceFunction)new DetailTransposeCalculateReduceGroupFunction(rowFieldParser, algoxCalculateReduceGroupDTO));
            dataSetX = this.addOrderBy(dataSetX);
        } else {
            dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new DetailTransposeCalculateReduceGroupFunction(rowFieldParser, algoxCalculateReduceGroupDTO));
        }
        return dataSetX;
    }

    @Override
    protected void beforeQuery() {
        super.beforeQuery();
        List<Partition> partitions = CacheUtils.getListFromPageCache(this.calculateInfo.getPageId(), this.partitionCacheKey, Partition.class);
        this.getComplexObjContext().addPartitions(partitions);
        List<Partition> orderPartitions = CacheUtils.getListFromPageCache(this.calculateInfo.getPageId(), this.orderPartitionCacheKey, Partition.class);
        this.getComplexObjContext().addOrderPartitions(orderPartitions);
    }

    @Override
    protected void afterQuery() {
        super.afterQuery();
        if (this.calculateInfo.isUpdateCachePartition()) {
            CacheUtils.putPageCache(this.calculateInfo.getPageId(), this.partitionCacheKey, this.getComplexObjContext().getPartitions());
            CacheUtils.putPageCache(this.calculateInfo.getPageId(), this.orderPartitionCacheKey, this.getComplexObjContext().getOrderPartitions());
        }
    }

    @Override
    protected IReportQueryPlan getReportQueryPlan() {
        HRComplexObjContext complexObjContext = this.getComplexObjContext();
        if (!this.calculateInfo.isAnObjPivot() || complexObjContext.getGroupFieldList().isEmpty()) {
            this.resetGroupField(complexObjContext);
        }
        return QueryServiceFactory.getReportQueryPlanByALgoX(this.calculateInfo, complexObjContext);
    }

    private void resetGroupField(HRComplexObjContext originalCompObj) {
        List fieldInfoList = originalCompObj.getGroupFieldList();
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        Set transLatitudes = transposeConfigInfoList.stream().flatMap(tr -> tr.getTransposeFieldUniKeyList().stream()).collect(Collectors.toSet());
        Map<String, SortFieldInfo> sortFieldInfoMap = originalCompObj.getSortFieldInfoList().stream().collect(Collectors.toMap(SortFieldInfo::getFieldAlias, sortFieldInfo -> sortFieldInfo, (x, y) -> x));
        Map<String, ReportField> reportFieldMap = this.getCalculateInfo().getRowFieldList().stream().collect(Collectors.toMap(ReportField::getFieldAlias, reportField -> reportField, (x, y) -> {
            if (transLatitudes.contains(x.getUniqueKey())) {
                return y;
            }
            return x;
        }));
        ArrayList sortFieldInfoList = Lists.newArrayListWithExpectedSize((int)fieldInfoList.size());
        for (int index = 0; index < fieldInfoList.size(); ++index) {
            HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)fieldInfoList.get(index);
            SortFieldInfo sortFieldInfo2 = new SortFieldInfo();
            ReportField reportField2 = reportFieldMap.get(fieldInfo.getAlias());
            SortFieldInfo originalSortField = sortFieldInfoMap.get(fieldInfo.getAlias());
            sortFieldInfo2.setFieldAlias(fieldInfo.getAlias());
            sortFieldInfo2.setReportId(this.getCalculateInfo().getReportId());
            sortFieldInfo2.setFieldId(reportField2.getFieldId());
            sortFieldInfo2.setSeq(index);
            sortFieldInfo2.setDataType(fieldInfo.getDataType());
            if (SortEnum.CUSTOM.getValue().equals(reportField2.getSortord()) && reportField2.getCustomSort() != null) {
                sortFieldInfo2.setValueType(reportField2.getCustomSort().getValueType());
                sortFieldInfo2.setValue(reportField2.getCustomSort().getValue());
            }
            if (originalSortField != null) {
                sortFieldInfo2.setSortord(originalSortField.getSortord());
            } else {
                sortFieldInfo2.setSortord(SortFieldInfo.SORTORD_ASC);
            }
            sortFieldInfoList.add(sortFieldInfo2);
        }
        originalCompObj.setSortFieldInfoList((List)sortFieldInfoList);
    }
}

