/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.ColumnCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.RowCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class SummaryCalculateAlgoX
extends CalculateAlgoX {
    private static final Log LOGGER = LogFactory.getLog(SummaryCalculateAlgoX.class);

    public SummaryCalculateAlgoX(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
    }

    @Override
    public DataSet calculate(int start, int limit) {
        int pageStart = start;
        int pageLimit = limit;
        if (this.isAdminOrgIncludeSub()) {
            pageStart = -1;
            pageLimit = -1;
        }
        DataSetX dataSetX = super.queryOriginalDataSetX(pageStart, pageLimit);
        dataSetX = this.calculateX(dataSetX, false);
        if (this.isAdminOrgIncludeSub() && this.notOnlyGroupByOrg() && start >= 0 && limit > 0) {
            dataSetX.top(start + limit);
        }
        DataSet dataSet = this.getAfterCalculateDataSet(dataSetX, true);
        if (this.isAdminOrgIncludeSub() && this.notOnlyGroupByOrg() && start >= 0 && limit > 0) {
            dataSet = dataSet.range(start, limit);
        }
        return dataSet;
    }

    @Override
    protected DataSetX calculateX(DataSetX dataSetX, boolean isTotalCalculate) {
        this.calculateInfo.getCostTimeHelper().nestedStart();
        if (this.calculateAlgoxParser.onlyRowField()) {
            dataSetX = this.doSimpleCalculate(dataSetX, isTotalCalculate);
        } else if (this.calculateAlgoxParser.existsColumnField()) {
            List<Map<String, Object>> columnData = this.calculateAlgoxParser.getColFieldParser().createColumnData(this.calculateInfo);
            dataSetX = this.doColumnCalculate(dataSetX, columnData, isTotalCalculate);
        }
        this.calculateInfo.getCostTimeHelper().logCost("algoX_calculateX", "algoX_calculateX");
        return dataSetX;
    }

    private DataSetX doSimpleCalculate(DataSetX dataSetX, boolean isTotalCalculate) {
        RowFieldParser rowFieldParser = this.calculateAlgoxParser.getRowFieldParser();
        List<AlgoXCalculateAlgoXField> rowLatitudeFieldList = rowFieldParser.getLatitudeFieldList();
        AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO = new AlgoxCalculateReduceGroupDTO().setRowLatitudeList(rowLatitudeFieldList).setRowOrderFieldList(rowFieldParser.getRowOrderFieldList()).setEntityPrimitiveIndexFieldList(rowFieldParser.getEntityPrimitiveIndexFieldListWithDp()).setAggregateIndexFieldList(rowFieldParser.getAggregateIndexFieldListWithDp()).setPresetIndexFieldList(rowFieldParser.getPresetIndexFieldListWithDp()).setTotalCalculate(isTotalCalculate).setRowSummaryInfo(this.calculateInfo.getRowSummaryInfo()).setTransferField(this.calculateInfo.isTransferField());
        if (rowLatitudeFieldList.size() > 0) {
            AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
            Object[] rowLatitudeFieldOrderByArr = this.calculateAlgoxParser.getGroupByAlgoXAliasExtendArr(rowLatitudeFieldList);
            if (this.isAdminOrgIncludeSub()) {
                dataSetX = this.addAdminOrgIncludeSub(dataSetX, adminOrgSummaryInfo);
            }
            LOGGER.info("SummaryCalculateAlgoX_distinct_fields_{}", (Object)Arrays.toString(rowLatitudeFieldOrderByArr));
            LOGGER.info("SummaryCalculateAlgoX_distinct_field_count_{}", (Object)rowLatitudeFieldOrderByArr.length);
            dataSetX = dataSetX.groupBy((String[])rowLatitudeFieldOrderByArr).reduceGroup((GroupReduceFunction)new RowCalculateReduceGroupFunction(algoxCalculateReduceGroupDTO));
            dataSetX = this.addOrderBy(dataSetX);
        } else {
            dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new RowCalculateReduceGroupFunction(algoxCalculateReduceGroupDTO));
        }
        return dataSetX;
    }

    private DataSetX doColumnCalculate(DataSetX dataSetX, List<Map<String, Object>> columnData, boolean isTotalCalculate) {
        RowFieldParser rowFieldParser = this.calculateAlgoxParser.getRowFieldParser();
        List<AlgoXCalculateAlgoXField> colLatitudeFieldList = this.calculateAlgoxParser.getColFieldParser().getLatitudeFieldList();
        List<AlgoXCalculateAlgoXField> rowLatitudeFieldList = rowFieldParser.getLatitudeFieldList();
        AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO = new AlgoxCalculateReduceGroupDTO().setRowLatitudeList(rowLatitudeFieldList).setRowOrderFieldList(rowFieldParser.getRowOrderFieldList()).setEntityPrimitiveIndexFieldList(rowFieldParser.getEntityPrimitiveIndexFieldList()).setAggregateIndexFieldList(rowFieldParser.getAggregateIndexFieldList()).setPresetIndexFieldList(rowFieldParser.getPresetIndexFieldList()).setColumnLatitudeList(colLatitudeFieldList).setColumnSummaryInfo(this.calculateInfo.getColumnSummaryInfo()).setColumnDataList(columnData).setTotalCalculate(isTotalCalculate).setRowSummaryInfo(this.calculateInfo.getRowSummaryInfo());
        if (rowLatitudeFieldList.size() > 0) {
            AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
            Object[] rowLatitudeFieldOrderByArr = this.calculateAlgoxParser.getGroupByAlgoXAliasExtendArr(rowLatitudeFieldList);
            if (this.isAdminOrgIncludeSub()) {
                dataSetX = this.addAdminOrgIncludeSub(dataSetX, adminOrgSummaryInfo);
            }
            LOGGER.info("SummaryCalculateAlgoX_distinct_fields_{}", (Object)Arrays.toString(rowLatitudeFieldOrderByArr));
            LOGGER.info("SummaryCalculateAlgoX_distinct_field_count_{}", (Object)rowLatitudeFieldOrderByArr.length);
            dataSetX = dataSetX.groupBy((String[])rowLatitudeFieldOrderByArr).reduceGroup((GroupReduceFunction)new ColumnCalculateReduceGroupFunction(algoxCalculateReduceGroupDTO));
            dataSetX = this.addOrderBy(dataSetX);
        } else {
            dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new ColumnCalculateReduceGroupFunction(algoxCalculateReduceGroupDTO));
        }
        return dataSetX;
    }
}

