/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.ColFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;

public class AlgoXAliasToAlgoXAliasExtendMapFunction
extends MapFunction {
    private static final long serialVersionUID = 7391330874576480520L;
    private final RowMeta oldRowMeta;
    private final RowFieldParser rowFieldParser;
    private final ColFieldParser colFieldParser;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> newFieldAliasToIndexMap;
    private final Map<String, Set<Integer>> oldAliasToNewIndexSetMap;

    public AlgoXAliasToAlgoXAliasExtendMapFunction(RowMeta oldRowMeta, RowFieldParser rowFieldParser, ColFieldParser colFieldParser) {
        this.oldRowMeta = oldRowMeta;
        this.rowFieldParser = rowFieldParser;
        this.colFieldParser = colFieldParser;
        this.newRowMeta = this.buildResultRowMeta();
        this.newFieldAliasToIndexMap = this.getFieldIndexMap();
        this.oldAliasToNewIndexSetMap = this.getAlgoXFieldIndexMap();
    }

    public RowX map(RowX row) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        Field[] fields = this.oldRowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String algoXAlias = field.getAlias();
            Set<Integer> indexList = this.oldAliasToNewIndexSetMap.get(algoXAlias);
            if (indexList == null) continue;
            for (Integer index : indexList) {
                Object value = row.get(i);
                if (value instanceof Integer) {
                    value = new BigDecimal(String.valueOf(value));
                }
                result.set(index.intValue(), value);
            }
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.buildResultRowMeta();
    }

    private RowMeta buildResultRowMeta() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fields = this.oldRowMeta.getFields();
        HashSet fieldExtendSet = Sets.newHashSetWithExpectedSize((int)this.oldRowMeta.getFields().length);
        for (Field field : fields) {
            String algoXAlias = field.getAlias();
            HashSet algoXAliasExtendSet = Sets.newHashSetWithExpectedSize((int)16);
            algoXAliasExtendSet.addAll(this.rowFieldParser.getAlgoXAliasExtend(algoXAlias));
            algoXAliasExtendSet.addAll(this.colFieldParser.getAlgoXAliasExtend(algoXAlias));
            for (String algoXAliasExtend : algoXAliasExtendSet) {
                if (!fieldExtendSet.add(algoXAliasExtend)) continue;
                DataType dataType = field.getDataType();
                if (DataType.IntegerType.equals((Object)dataType)) {
                    dataType = DataType.BigDecimalType;
                }
                fieldList.add(new Field(algoXAliasExtend, dataType));
            }
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private Map<String, Set<Integer>> getAlgoXFieldIndexMap() {
        Field[] oldRowMetaFields = this.oldRowMeta.getFields();
        HashMap aliasToIndexListMap = Maps.newHashMapWithExpectedSize((int)this.oldRowMeta.getFieldCount());
        for (Field oldRowMetaField : oldRowMetaFields) {
            HashSet algoXAliasExtendSet = Sets.newHashSetWithExpectedSize((int)16);
            algoXAliasExtendSet.addAll(this.rowFieldParser.getAlgoXAliasExtend(oldRowMetaField.getAlias()));
            algoXAliasExtendSet.addAll(this.colFieldParser.getAlgoXAliasExtend(oldRowMetaField.getAlias()));
            for (String algoXAliasExtend : algoXAliasExtendSet) {
                Integer index = this.newFieldAliasToIndexMap.get(algoXAliasExtend);
                if (index == null) continue;
                aliasToIndexListMap.putIfAbsent(oldRowMetaField.getAlias(), Sets.newHashSetWithExpectedSize((int)algoXAliasExtendSet.size()));
                aliasToIndexListMap.computeIfPresent(oldRowMetaField.getAlias(), (alias, indexSet) -> {
                    indexSet.add(index);
                    return indexSet;
                });
            }
        }
        return aliasToIndexListMap;
    }

    private Map<String, Integer> getFieldIndexMap() {
        HashMap fieldIndexMap = Maps.newHashMapWithExpectedSize((int)this.newRowMeta.getFieldCount());
        for (int index = 0; index < this.newRowMeta.getFieldCount(); ++index) {
            Field field = this.newRowMeta.getField(index);
            fieldIndexMap.put(field.getAlias(), index);
        }
        return fieldIndexMap;
    }
}

