/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXOrderAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.AlgoXCalculateHelper;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.utils.ObjectComparable;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public abstract class AlgoxCalculateReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 5162607349716315067L;
    protected AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO;
    protected AlgoXCalculateHelper algoxCalculateHelper;

    public AlgoxCalculateReduceGroupFunction() {
    }

    public AlgoxCalculateReduceGroupFunction(AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        this.algoxCalculateReduceGroupDTO = algoxCalculateReduceGroupDTO;
        this.algoxCalculateHelper = new AlgoXCalculateHelper();
        this.algoxCalculateHelper.setNewRowMetaFields(this.getResultRowMeta().getFields());
    }

    protected void setLatitudeResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXCalculateAlgoXField algoXLatitudeField : this.algoxCalculateReduceGroupDTO.getRowLatitudeList()) {
            this.algoxCalculateHelper.setResultRowX(this.sourceRowMeta, resultRowX, rowX, algoXLatitudeField.getAlgoXAliasExtend());
        }
    }

    protected void setCalculateResultRowX(String calcFunction, RowX resultRowX, RowX rowX, String algoXAliasExtend) {
        this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend, algoXAliasExtend);
    }

    protected void setCalculateResultRowX(String calcFunction, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        if (HRStringUtils.isNotEmpty((String)calcFunction)) {
            RowMeta sourceRowMeta = this.getSourceRowMeta();
            if ("sum".equals(calcFunction)) {
                this.algoxCalculateHelper.setSumCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
            }
            if ("avg".equals(calcFunction)) {
                this.algoxCalculateHelper.setAvgCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
            }
            if ("count".equals(calcFunction)) {
                this.algoxCalculateHelper.setCountCalculateResult(resultRowX, fieldName);
            }
        }
    }

    protected void setOrderResultRowX(RowX resultRowX, RowX rowX) {
        Set transConfigFieldUniqueKeySet = null;
        List<TransposeConfigInfo> transposeConfigInfoList = this.algoxCalculateReduceGroupDTO.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null) {
            transConfigFieldUniqueKeySet = transposeConfigInfoList.stream().flatMap(tr -> tr.getTransposeFieldUniKeyList().stream()).collect(Collectors.toSet());
        }
        for (AlgoXOrderAlgoXField orderAlgoXField : this.algoxCalculateReduceGroupDTO.getRowOrderFieldList()) {
            Object value;
            Object nowValue;
            int valIndex;
            Object newValue;
            int fieldIndex;
            String algoXAliasExtend = orderAlgoXField.getAlgoXAliasExtend();
            LatitudeField latitudeField = orderAlgoXField.getLatitudeField();
            if (transConfigFieldUniqueKeySet != null && transConfigFieldUniqueKeySet.contains(latitudeField.getUniqueKey())) continue;
            if (orderAlgoXField.isCustom()) {
                fieldIndex = this.sourceRowMeta.getFieldIndex(algoXAliasExtend, false);
                if (fieldIndex == -1) continue;
                newValue = rowX.getBigDecimal(fieldIndex);
                valIndex = this.algoxCalculateHelper.getValIndex(algoXAliasExtend);
                nowValue = resultRowX.getBigDecimal(valIndex);
                if (newValue == null) continue;
                value = newValue;
                if (nowValue != null) {
                    value = new BigDecimal(Math.min(((BigDecimal)newValue).intValue(), ((BigDecimal)nowValue).intValue()));
                }
                resultRowX.set(valIndex, value);
                continue;
            }
            if (!orderAlgoXField.isDependSortField()) continue;
            fieldIndex = this.sourceRowMeta.getFieldIndex(algoXAliasExtend);
            newValue = rowX.get(fieldIndex);
            valIndex = this.algoxCalculateHelper.getValIndex(algoXAliasExtend);
            nowValue = resultRowX.get(valIndex);
            if (newValue == null) continue;
            value = newValue;
            if (nowValue != null) {
                String order = orderAlgoXField.getOrder();
                Object headMostObject = ObjectComparable.getHeadMostObject(newValue, nowValue, order);
                value = headMostObject == null ? value : headMostObject;
            }
            resultRowX.set(valIndex, value);
        }
    }

    protected String getRowSummaryIndexFunction(String indexCalcFunction, String indexUniqueKey) {
        return RowSummaryInfo.getTotalCalFunction(indexUniqueKey, indexCalcFunction, this.algoxCalculateReduceGroupDTO.getRowSummaryInfo());
    }
}

