/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoxCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.ColumnHead;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.model.ColumnSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;

public class ColumnCalculateReduceGroupFunction
extends AlgoxCalculateReduceGroupFunction {
    private static final long serialVersionUID = -7697352627276779808L;

    public ColumnCalculateReduceGroupFunction(AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        super(algoxCalculateReduceGroupDTO);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX resultRowX = new RowX(this.algoxCalculateHelper.getNewRowMetaFields().length);
        for (RowX rowX : iterable) {
            this.setLatitudeResultRowX(resultRowX, rowX);
            this.setOrderResultRowX(resultRowX, rowX);
            this.setColFieldResultRowX(resultRowX, rowX);
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        boolean hasCalculateField = this.algoxCalculateReduceGroupDTO.columnHasCalculateField();
        boolean totalCalculate = this.algoxCalculateReduceGroupDTO.isTotalCalculate();
        RowSummaryInfo rowSummaryInfo = this.algoxCalculateReduceGroupDTO.getRowSummaryInfo();
        return new RowMetaBuilder("0", totalCalculate, rowSummaryInfo, this.algoxCalculateHelper, this.algoxCalculateReduceGroupDTO).createRowFieldBuilder(rowFieldBuilder -> rowFieldBuilder.addLatitudeField(this.algoxCalculateReduceGroupDTO.getRowLatitudeList()).addRowOrderLatitudeField(this.algoxCalculateReduceGroupDTO.getRowOrderFieldList())).createColumnFieldBuilder(hasCalculateField, this.algoxCalculateReduceGroupDTO.getColumnLatitudeList(), this.algoxCalculateReduceGroupDTO.getColumnSummaryInfo(), this.algoxCalculateReduceGroupDTO.getColumnDataList(), (fieldName, isSummary, columnFieldBuilder) -> columnFieldBuilder.addEntityPrimitiveIndexField((String)fieldName, (boolean)isSummary, this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()).addAggregateIndexFieldList((String)fieldName, (boolean)isSummary, this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()).addPresetIndexFieldList((String)fieldName, (boolean)isSummary, this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList()), (fieldName, isSummary, columnFieldBuilder) -> columnFieldBuilder.addColumnField((String)fieldName)).buildRowMeta();
    }

    public void setColFieldResultRowX(RowX resultRowX, RowX rowX) {
        if (this.algoxCalculateReduceGroupDTO.columnHasCalculateField()) {
            List<Map<String, Object>> columnDataList = this.algoxCalculateReduceGroupDTO.getColumnDataList();
            List<AlgoXCalculateAlgoXField> columnLatitudeList = this.algoxCalculateReduceGroupDTO.getColumnLatitudeList();
            ColumnSummaryInfo columnSummaryInfo = this.algoxCalculateReduceGroupDTO.getColumnSummaryInfo();
            for (Map<String, Object> data : columnDataList) {
                List<ColumnHead> columnHeads = this.buildColFieldPrefixStr(columnLatitudeList, columnSummaryInfo, data, rowX);
                for (ColumnHead columnHead : columnHeads) {
                    if (!columnHead.isHit()) continue;
                    this.setEntityPrimitiveIndexResultRowX(resultRowX, rowX, columnHead);
                    this.setAggregateIndexResultRowX(resultRowX, rowX, columnHead);
                    this.setPresetIndexResultRowX(resultRowX, rowX, columnHead);
                }
            }
        }
    }

    protected List<ColumnHead> buildColFieldPrefixStr(List<AlgoXCalculateAlgoXField> columnLatitudeList, ColumnSummaryInfo columnSummaryInfo, Map<String, Object> data, RowX rowX) {
        boolean fieldEqualsFlag;
        ArrayList columnHeadList = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder fieldBuilder = new StringBuilder();
        columnHeadList.add(new ColumnHead(fieldEqualsFlag, false, (fieldEqualsFlag = this.getColFieldPrefixes(columnLatitudeList, data, rowX, fieldBuilder)) ? fieldBuilder.substring(0, fieldBuilder.length() - 1) : fieldBuilder.toString()));
        if (fieldEqualsFlag && columnSummaryInfo != null) {
            if (columnSummaryInfo.isShowSubTotalCol()) {
                HashSet subTotalHeads = Sets.newHashSetWithExpectedSize((int)16);
                List<String> subTotalLatitudes = columnSummaryInfo.getSubTotalLatitudes();
                if (subTotalLatitudes.size() == columnLatitudeList.size()) {
                    subTotalLatitudes.remove(subTotalLatitudes.size() - 1);
                }
                for (String subTotalLatitude : subTotalLatitudes) {
                    ArrayList subLatitudeFields = Lists.newArrayListWithExpectedSize((int)columnLatitudeList.size());
                    for (AlgoXCalculateAlgoXField algoXLatitudeField : columnLatitudeList) {
                        if (algoXLatitudeField.getUniqueKey().equals(subTotalLatitude)) {
                            subLatitudeFields.add(algoXLatitudeField);
                            break;
                        }
                        subLatitudeFields.add(algoXLatitudeField);
                    }
                    subTotalHeads.add(this.appendSubHead(data, subLatitudeFields, columnSummaryInfo));
                }
                for (String subTotalHead : subTotalHeads) {
                    columnHeadList.add(new ColumnHead(true, true, subTotalHead));
                }
            }
            if (columnSummaryInfo.isShowTotalCol()) {
                columnHeadList.add(new ColumnHead(true, true, "\u03b8" + columnSummaryInfo.getTotalColName().getLocaleValue()));
            }
        }
        return columnHeadList;
    }

    private boolean getColFieldPrefixes(List<AlgoXCalculateAlgoXField> columnLatitudeList, Map<String, Object> data, RowX rowX, StringBuilder fieldBuilder) {
        boolean fieldEqualsFlag = true;
        for (AlgoXCalculateAlgoXField algoXLatitudeField : columnLatitudeList) {
            Object val = data.get(algoXLatitudeField.getUniqueKey());
            Object nowVal = rowX.get(this.sourceRowMeta.getFieldIndex(algoXLatitudeField.getAlgoXAliasExtend()));
            if (val == null || "".equals(val) || "null".equals(val)) {
                val = " ";
            }
            if (nowVal == null || "".equals(nowVal) || "null".equals(nowVal)) {
                nowVal = " ";
            }
            if (!HRObjectUtils.equals((Object)val, (Object)nowVal)) {
                fieldEqualsFlag = false;
                break;
            }
            fieldBuilder.append(val).append('\u03b5');
        }
        return fieldEqualsFlag;
    }

    protected void setEntityPrimitiveIndexResultRowX(RowX resultRowX, RowX rowX, ColumnHead columnHead) {
        ColumnSummaryInfo columnSummaryInfo = this.algoxCalculateReduceGroupDTO.getColumnSummaryInfo();
        Map<String, String> subTotalIndexCalcFunctionMap = null;
        if (columnSummaryInfo != null) {
            subTotalIndexCalcFunctionMap = columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
        }
        for (AlgoXEntityPrimitiveIndexAlgoXField entityPrimitiveIndexAlgoXField : this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()) {
            String calcFunction = null;
            if (columnHead.isSummary()) {
                if (subTotalIndexCalcFunctionMap != null) {
                    calcFunction = subTotalIndexCalcFunctionMap.get(entityPrimitiveIndexAlgoXField.getUniqueKey());
                }
                if (calcFunction == null) {
                    calcFunction = entityPrimitiveIndexAlgoXField.getEntityPrimitiveIndexField().getCalcFunction();
                }
            } else {
                calcFunction = entityPrimitiveIndexAlgoXField.getEntityPrimitiveIndexField().getCalcFunction();
            }
            String fieldName = columnHead.getColumnHeadStr() + '\u03b2' + entityPrimitiveIndexAlgoXField.getAlgoXAliasExtend();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, entityPrimitiveIndexAlgoXField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, entityPrimitiveIndexAlgoXField.getAlgoXAliasExtend(), fieldName);
        }
    }

    protected void setAggregateIndexResultRowX(RowX resultRowX, RowX rowX, ColumnHead columnHead) {
        ColumnSummaryInfo columnSummaryInfo = this.algoxCalculateReduceGroupDTO.getColumnSummaryInfo();
        Map<String, String> subTotalIndexCalcFunctionMap = null;
        if (columnSummaryInfo != null) {
            subTotalIndexCalcFunctionMap = columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
        }
        for (AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoXField : this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()) {
            String calcFunction = null;
            if (columnHead.isSummary()) {
                if (subTotalIndexCalcFunctionMap != null) {
                    calcFunction = subTotalIndexCalcFunctionMap.get(algoxAggregateIndexAlgoXField.getUniqueKey());
                }
                if (calcFunction == null) {
                    calcFunction = algoxAggregateIndexAlgoXField.getAggregateIndexField().getCalcFunction();
                }
            } else {
                calcFunction = algoxAggregateIndexAlgoXField.getAggregateIndexField().getCalcFunction();
            }
            String fieldName = columnHead.getColumnHeadStr() + '\u03b2' + algoxAggregateIndexAlgoXField.getAlgoXAliasExtend();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxAggregateIndexAlgoXField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxAggregateIndexAlgoXField.getAlgoXAliasExtend(), fieldName);
        }
    }

    protected void setPresetIndexResultRowX(RowX resultRowX, RowX rowX, ColumnHead columnHead) {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        for (AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoXField : this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList()) {
            if (!Arrays.stream(sourceRowMeta.getFields()).anyMatch(field -> HRStringUtils.equals((String)algoxPresetIndexAlgoXField.getAlgoXAliasExtend(), (String)field.getAlias()))) continue;
            String algoXAliasExtend = algoxPresetIndexAlgoXField.getAlgoXAliasExtend();
            String fieldName = columnHead.getColumnHeadStr() + '\u03b2' + algoXAliasExtend;
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calcFunction = algoxPresetIndexAlgoXField.getPresetIndexField().getCalcFunction();
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxPresetIndexAlgoXField.getUniqueKey());
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend, fieldName);
                continue;
            }
            this.algoxCalculateHelper.setAvgCalculateResultRowXForPreIndex(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
        }
    }

    private String appendSubHead(Map<String, Object> columnData, List<AlgoXCalculateAlgoXField> latitudeList, ColumnSummaryInfo columnSummaryInfo) {
        StringBuilder columnSubTotalPrefix = RowMetaBuilder.getColumnLatitudeHead(latitudeList, columnData);
        columnSubTotalPrefix.append("\u03b7").append(columnSummaryInfo.getSubTotalColName().getLocaleValue());
        return columnSubTotalPrefix.toString();
    }
}

