/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.formula.excel.Expr;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class NonAggIndexMapFunction
extends MapFunction {
    private static final long serialVersionUID = -823921961124798577L;
    private final RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;
    private final Map<String, Expr> exprCache = new HashMap<String, Expr>(16);
    private final List<NonAggregateIndexField> nonAggIndexFieldList;
    private final RowMeta oldRowMeta;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> fieldIndexMap;
    private final Map<String, ReportField> reportFieldMap;
    private final RowSummaryInfo rowSummaryInfo;
    private final String reportType;
    private final HRComplexObjContext context;

    public NonAggIndexMapFunction(ReportCalculateInfo calculateInfo, RowMeta oldRowMeta, HRComplexObjContext context) {
        this.nonAggIndexFieldList = calculateInfo.getRowFieldListWithoutDp(false).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map((? super T obj) -> (NonAggregateIndexField)obj).collect(Collectors.toList());
        this.reportType = calculateInfo.getReportType();
        this.oldRowMeta = oldRowMeta;
        this.rowSummaryInfo = calculateInfo.getRowSummaryInfo();
        List<ReportField> rowFieldList = calculateInfo.getRowFieldList();
        this.reportFieldMap = Maps.newHashMapWithExpectedSize((int)(rowFieldList.size() * 2));
        for (ReportField field2 : rowFieldList) {
            this.reportFieldMap.put(field2.getFieldAlias(), field2);
            if (!HRStringUtils.isNotEmpty((String)field2.getUniqueKey())) continue;
            this.reportFieldMap.put(field2.getUniqueKey(), field2);
        }
        this.newRowMeta = this.getResultRowMeta();
        Field[] fields = this.newRowMeta.getFields();
        this.fieldIndexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            this.fieldIndexMap.put(fields[index].getAlias(), index);
        }
        Map<String, TimeZoneInfo> timeZoneInfoMap = calculateInfo.getRowFieldList().stream().filter(field -> field instanceof EntityPropField && ((EntityPropField)field).getTimeZoneInfo() != null).collect(Collectors.toMap(ReportField::getFieldAlias, field -> ((EntityPropField)field).getTimeZoneInfo(), (k1, k2) -> k1));
        timeZoneInfoMap.putAll(calculateInfo.getColumnFieldList().stream().filter(field -> field instanceof EntityPropField && ((EntityPropField)field).getTimeZoneInfo() != null).collect(Collectors.toMap(ReportField::getFieldAlias, field -> ((EntityPropField)field).getTimeZoneInfo(), (k1, k2) -> k1)));
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(context, timeZoneInfoMap);
        this.context = context;
    }

    public RowX map(RowX rowX) {
        RowX resultRowX = new RowX(this.newRowMeta.getFieldCount());
        Field[] oldRowMetaFields = this.oldRowMeta.getFields();
        for (int index = 0; index < oldRowMetaFields.length; ++index) {
            resultRowX.set(index, rowX.get(index));
        }
        for (NonAggregateIndexField nonAggIndexField : this.nonAggIndexFieldList) {
            String formula = nonAggIndexField.getCalcFormulaInfo();
            Expr expr = this.getExpr(formula);
            Set<String> refFieldAliasSet = nonAggIndexField.getDependentFieldSet();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (String key : refFieldAliasSet) {
                ReportField field = this.reportFieldMap.get(key);
                String dataKey = field instanceof AggregateIndexField ? this.getAggFieldAlias((AggregateIndexField)field, nonAggIndexField) : (field instanceof EntityPrimitiveIndexField ? this.getEntityFieldAlias((EntityPrimitiveIndexField)field, nonAggIndexField) : (field instanceof NonAggregateIndexField ? this.getNonAggFieldAlias((NonAggregateIndexField)field, nonAggIndexField) : (field instanceof PresetIndexField ? this.getPreIndexFieldAlias((PresetIndexField)field, nonAggIndexField) : AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)field.getFieldAlias()), field.getUniqueKey()))));
                Integer fieldIndex = this.fieldIndexMap.get(dataKey);
                Object value = null;
                if (fieldIndex != null) {
                    value = fieldIndex < oldRowMetaFields.length ? rowX.get(fieldIndex.intValue()) : resultRowX.get(fieldIndex.intValue());
                }
                paramMap.putIfAbsent(key, value);
            }
            String algoXAliasExtend = this.getNonAggFieldAlias(nonAggIndexField, null);
            Integer fieldIndex = this.fieldIndexMap.get(algoXAliasExtend);
            if (fieldIndex == null) continue;
            Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
            Field field = this.newRowMeta.getField(fieldIndex.intValue());
            val = this.dataTypeCompatible(field.getDataType(), val);
            resultRowX.set(fieldIndex.intValue(), val);
            String totalCalFunction = RowSummaryInfo.getTotalCalFunction(nonAggIndexField.getUniqueKey(), null, this.rowSummaryInfo);
            if (!"avg".equals(totalCalFunction) || val == null) continue;
            resultRowX.set(this.fieldIndexMap.get(AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)nonAggIndexField.getFieldAlias()), nonAggIndexField.getUniqueKey()) + '\u03b1' + "avgsum").intValue(), (Object)new BigDecimal(String.valueOf(val)));
        }
        return resultRowX;
    }

    public final RowMeta getResultRowMeta() {
        Field[] oldRowMetaFields = this.oldRowMeta.getFields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)(oldRowMetaFields.length + this.nonAggIndexFieldList.size()));
        fields.addAll(Arrays.asList(oldRowMetaFields));
        for (NonAggregateIndexField nonAggIndexField : this.nonAggIndexFieldList) {
            String algoXAliasExtend = this.getNonAggFieldAlias(nonAggIndexField, null);
            fields.add(new Field(algoXAliasExtend, AlgoDataTypeTransUtil.getDataType((String)nonAggIndexField.getFieldType())));
            String totalCalFunction = RowSummaryInfo.getTotalCalFunction(nonAggIndexField.getUniqueKey(), null, this.rowSummaryInfo);
            if (!"avg".equals(totalCalFunction)) continue;
            fields.add(new Field(AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)nonAggIndexField.getFieldAlias()), nonAggIndexField.getUniqueKey()) + '\u03b1' + "avgsum", (DataType)DataType.BigDecimalType));
        }
        return new RowMeta(fields.toArray(new Field[0]));
    }

    private Expr getExpr(String formula) {
        Expr expr = this.exprCache.get(formula);
        if (expr == null) {
            expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
            this.exprCache.put(formula, expr);
        }
        return expr;
    }

    private String getNonAggFieldAlias(NonAggregateIndexField nonAggIndexField, NonAggregateIndexField parentIndex) {
        String algoXAliasExtend = AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)nonAggIndexField.getFieldAlias()), nonAggIndexField.getUniqueKey());
        algoXAliasExtend = this.getRowSumFunctionAlgoXAliasExtend(nonAggIndexField.getUniqueKey(), null, parentIndex, algoXAliasExtend);
        return algoXAliasExtend;
    }

    private String getAggFieldAlias(AggregateIndexField aggIndexField, NonAggregateIndexField parentIndex) {
        String algoXAliasExtend = AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)aggIndexField.getFieldAlias()), aggIndexField.getUniqueKey());
        algoXAliasExtend = this.getRowSumFunctionAlgoXAliasExtend(aggIndexField.getUniqueKey(), aggIndexField.getCalcFunction(), parentIndex, algoXAliasExtend);
        return algoXAliasExtend;
    }

    private String getEntityFieldAlias(EntityPrimitiveIndexField entityPrimitiveIndexField, NonAggregateIndexField parentIndex) {
        String algoXAliasExtend = AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)entityPrimitiveIndexField.getFieldAlias()), entityPrimitiveIndexField.getUniqueKey());
        algoXAliasExtend = this.getRowSumFunctionAlgoXAliasExtend(entityPrimitiveIndexField.getUniqueKey(), entityPrimitiveIndexField.getCalcFunction(), parentIndex, algoXAliasExtend);
        return algoXAliasExtend;
    }

    private String getPreIndexFieldAlias(PresetIndexField presetIndexField, NonAggregateIndexField parentIndex) {
        String algoXAliasExtend = AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)presetIndexField.getFieldAlias()), presetIndexField.getUniqueKey());
        if ("1".equals(this.reportType)) {
            return algoXAliasExtend;
        }
        return algoXAliasExtend + '\u03b1' + presetIndexField.getCalcFunction();
    }

    private Object dataTypeCompatible(DataType dataType, Object oldValue) {
        Object returnValue = oldValue;
        if (DataType.LongType.equals((Object)dataType)) {
            if (oldValue instanceof Integer || oldValue instanceof BigDecimal || oldValue instanceof Double || oldValue instanceof Float) {
                BigDecimal temp = new BigDecimal(String.valueOf(oldValue));
                returnValue = temp.longValue();
            }
        } else if (DataType.BigDecimalType.equals((Object)dataType)) {
            if (oldValue instanceof Integer || oldValue instanceof Long || oldValue instanceof Double || oldValue instanceof Float) {
                returnValue = new BigDecimal(String.valueOf(oldValue));
            }
        } else if (DataType.IntegerType.equals((Object)dataType) && (oldValue instanceof Long || oldValue instanceof BigDecimal || oldValue instanceof Double || oldValue instanceof Float)) {
            BigDecimal temp = new BigDecimal(String.valueOf(oldValue));
            returnValue = temp.intValue();
        }
        returnValue = QueryEntityUtil.convertDataValueType((DataTypeEnum)AlgoDataTypeTransUtil.getDataTypeEnum((DataType)dataType), (Object)returnValue, null, (HRComplexObjContext)this.context);
        return returnValue;
    }

    private String getRowSumFunctionAlgoXAliasExtend(String uniqueKey, String defaultFunction, NonAggregateIndexField parentIndex, String algoXAliasExtend) {
        if ("1".equals(this.reportType)) {
            return algoXAliasExtend;
        }
        String calFunction = RowSummaryInfo.getTotalCalFunction(uniqueKey, defaultFunction, this.rowSummaryInfo);
        if (HRStringUtils.isNotEmpty((String)calFunction)) {
            algoXAliasExtend = algoXAliasExtend + '\u03b1' + calFunction;
        } else if (parentIndex != null && HRStringUtils.isNotEmpty((String)(calFunction = RowSummaryInfo.getTotalCalFunction(uniqueKey, null, this.rowSummaryInfo)))) {
            algoXAliasExtend = algoXAliasExtend + '\u03b1' + calFunction;
        }
        return algoXAliasExtend;
    }
}

