/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class RemoveCustomOrderFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = 3433024928748249511L;
    private final RowMeta newRowMeta;
    private Set<Integer> customOrderFieldIndices;
    private final Set<String> customOrderFieldNames;

    public RemoveCustomOrderFieldMapFunction(RowMeta oldRowMeta, Set<String> customOrderFieldNames) {
        this.customOrderFieldNames = customOrderFieldNames;
        this.newRowMeta = this.buildNewRowMeta(oldRowMeta);
    }

    public RowX map(RowX rowX) {
        RowX resultRowX = new RowX(this.newRowMeta.getFieldCount());
        int resultFieldIndex = 0;
        for (int index = 0; index < rowX.size(); ++index) {
            if (this.customOrderFieldIndices != null && this.customOrderFieldIndices.contains(index)) continue;
            resultRowX.set(resultFieldIndex, rowX.get(index));
            ++resultFieldIndex;
        }
        return resultRowX;
    }

    private RowMeta buildNewRowMeta(RowMeta oldRowMeta) {
        Field[] fields = oldRowMeta.getFields();
        if (this.customOrderFieldIndices == null) {
            this.customOrderFieldIndices = Sets.newHashSetWithExpectedSize((int)fields.length);
        }
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.length);
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)16);
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            if (this.customOrderFieldNames == null || !this.customOrderFieldNames.contains(field.getAlias())) {
                if (!fieldNameSet.add(field.getName())) continue;
                newFields.add(field);
                continue;
            }
            this.customOrderFieldIndices.add(index);
        }
        return new RowMeta(newFields.toArray(new Field[0]));
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

