/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.util.Arrays;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoxCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;

public class RowCalculateReduceGroupFunction
extends AlgoxCalculateReduceGroupFunction {
    private static final long serialVersionUID = -7697352627276779808L;

    public RowCalculateReduceGroupFunction(AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        super(algoxCalculateReduceGroupDTO);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX resultRowX = new RowX(this.algoxCalculateHelper.getNewRowMetaFields().length);
        for (RowX rowX : iterable) {
            this.setLatitudeResultRowX(resultRowX, rowX);
            this.setEntityPrimitiveIndexResultRowX(resultRowX, rowX);
            this.setAggregateIndexResultRowX(resultRowX, rowX);
            this.setPresetIndexResultRowX(resultRowX, rowX);
            this.setOrderResultRowX(resultRowX, rowX);
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        boolean totalCalculate = this.algoxCalculateReduceGroupDTO.isTotalCalculate();
        RowSummaryInfo rowSummaryInfo = this.algoxCalculateReduceGroupDTO.getRowSummaryInfo();
        return new RowMetaBuilder("0", totalCalculate, rowSummaryInfo, this.algoxCalculateHelper, this.algoxCalculateReduceGroupDTO).createRowFieldBuilder(rowFieldBuilder -> rowFieldBuilder.addLatitudeField(this.algoxCalculateReduceGroupDTO.getRowLatitudeList()).addEntityPrimitiveIndexField(this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()).addAggregateIndexField(this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()).addPresetIndexField(this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList()).addRowOrderLatitudeField(this.algoxCalculateReduceGroupDTO.getRowOrderFieldList())).buildRowMeta();
    }

    protected void setEntityPrimitiveIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXEntityPrimitiveIndexAlgoXField algoxEntityPrimitiveIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()) {
            String calcFunction = algoxEntityPrimitiveIndexAlgoxField.getEntityPrimitiveIndexField().getCalcFunction();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxEntityPrimitiveIndexAlgoxField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxEntityPrimitiveIndexAlgoxField.getAlgoXAliasExtend());
        }
    }

    protected void setAggregateIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()) {
            String calcFunction = algoxAggregateIndexAlgoxField.getAggregateIndexField().getCalcFunction();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxAggregateIndexAlgoxField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxAggregateIndexAlgoxField.getAlgoXAliasExtend());
        }
    }

    protected void setPresetIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList()) {
            if (!Arrays.stream(this.sourceRowMeta.getFields()).anyMatch(field -> HRStringUtils.equals((String)algoxPresetIndexAlgoxField.getAlgoXAliasExtend(), (String)field.getAlias()))) continue;
            String algoXAliasExtend = algoxPresetIndexAlgoxField.getAlgoXAliasExtend();
            this.algoxCalculateHelper.setAvgCalculateResultRowXForPreIndex(this.getSourceRowMeta(), resultRowX, rowX, algoXAliasExtend, algoXAliasExtend);
        }
    }
}

