/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func.algo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;

public class AfterAnObjPivotQueryMapFunction
extends MapFunction {
    private static final long serialVersionUID = -8072562951469670819L;
    private final RowMeta rowMeta;
    private final Map<String, String> fieldAliasMap = Maps.newHashMapWithExpectedSize((int)16);
    private RowMeta newRowMeta;

    public AfterAnObjPivotQueryMapFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Object[] map(Row row) {
        Field[] newFields = this.newRowMeta.getFields();
        Object[] newRow = new Object[newFields.length];
        for (int i = 0; i < newFields.length; ++i) {
            String oldAlias = this.fieldAliasMap.get(newFields[i].getAlias());
            newRow[i] = row.get(oldAlias);
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = this.rowMeta.getFields();
        List fieldAliasList = Arrays.stream(fields).map(Field::getAlias).collect(Collectors.toList());
        List<Object> newAliasList = Lists.newArrayListWithCapacity((int)fieldAliasList.size());
        for (String alias : fieldAliasList) {
            String newAlias;
            int alphaIndex = alias.indexOf(945);
            int deltaIndex = AnalyseObjectUtil.getFieldAliasSplitIndex((String)alias);
            if (alphaIndex > 0) {
                newAlias = alias.substring(0, alphaIndex);
                if (newAliasList.contains(newAlias)) continue;
                newAliasList.add(newAlias);
                this.fieldAliasMap.put(newAlias, alias);
                continue;
            }
            if (deltaIndex > 0) {
                newAlias = alias.substring(0, deltaIndex);
                if (newAliasList.contains(newAlias)) continue;
                newAliasList.add(newAlias);
                this.fieldAliasMap.put(newAlias, alias);
                continue;
            }
            newAliasList.add(alias);
            this.fieldAliasMap.put(alias, alias);
        }
        newAliasList = newAliasList.stream().distinct().collect(Collectors.toList());
        Field[] newFields = new Field[newAliasList.size()];
        Map<String, Field> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getAlias, field -> field, (k1, k2) -> k1));
        for (int i = 0; i < newAliasList.size(); ++i) {
            String newAlias = (String)newAliasList.get(i);
            Field field2 = fieldMap.get(this.fieldAliasMap.get(newAlias));
            field2.setAlias(newAlias);
            field2.setName(newAlias);
            newFields[i] = field2;
        }
        this.newRowMeta = new RowMeta(newFields);
        return this.newRowMeta;
    }
}

