/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXOrderAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.AlgoXCalculateHelper;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.ColumnSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public class RowMetaBuilder {
    public static final Set<String> TOTALCALCULATE_SET = Sets.newHashSet((Object[])new String[]{DataType.BigDecimalType.getName(), DataType.IntegerType.getName(), DataType.LongType.getName(), DataType.DoubleType.getName()});
    private final String reportType;
    private final boolean isTotalCalculate;
    private final RowSummaryInfo rowSummaryInfo;
    private final List<Field> fieldList = new ArrayList<Field>();
    private final Set<String> fieldNameSet = Sets.newHashSetWithExpectedSize((int)16);
    private final AlgoXCalculateHelper algoxCalculateHelper;
    private final AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO;

    public RowMetaBuilder(String reportType, boolean isTotalCalculate, RowSummaryInfo rowSummaryInfo, AlgoXCalculateHelper algoxCalculateHelper, AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        this.reportType = reportType;
        this.isTotalCalculate = isTotalCalculate;
        this.rowSummaryInfo = rowSummaryInfo;
        this.algoxCalculateHelper = algoxCalculateHelper;
        this.algoxCalculateReduceGroupDTO = algoxCalculateReduceGroupDTO;
    }

    public RowMetaBuilder createRowFieldBuilder(Consumer<RowFieldBuilder> consumer) {
        RowFieldBuilder rowFieldBuilder = new RowFieldBuilder();
        consumer.accept(rowFieldBuilder);
        return this;
    }

    public RowMetaBuilder createColumnFieldBuilder(boolean hasCalculateField, List<AlgoXCalculateAlgoXField> columnLatitudeList, ColumnSummaryInfo columnSummaryInfo, List<Map<String, Object>> columnListMap, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> trueConsumer, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> falseConsumer) {
        ColumnFieldBuilder columnFieldBuilder = new ColumnFieldBuilder(hasCalculateField, columnLatitudeList, columnSummaryInfo, columnListMap);
        columnFieldBuilder.parseColumnData(trueConsumer, falseConsumer);
        return this;
    }

    public RowMetaBuilder createTransposeFieldBuilder(RowFieldParser rowFieldParser, List<TransposeConfigInfo> transposeConfigInfoList, List<List<Map<String, Object>>> transposeDataList, ThreeParamsConsumer<List<ReportField>, String, TransposeFieldBuilder> consumer) {
        TransposeFieldBuilder transposeFieldBuilder = new TransposeFieldBuilder(rowFieldParser, transposeConfigInfoList, transposeDataList);
        transposeFieldBuilder.parseTransposeData(consumer);
        return this;
    }

    public static RowMeta buildAlgoTotalResultRowMeta(RowMeta sourceRowMeta, String reportType, RowSummaryInfo rowSummaryInfo) {
        ArrayList<Field> resultList = new ArrayList<Field>();
        Field[] fields = sourceRowMeta.getFields();
        HashSet fieldNames = Sets.newHashSetWithExpectedSize((int)fields.length);
        for (Field field : fields) {
            DataType dataType = field.getDataType();
            String dataTypeName = dataType.getName();
            String alias = field.getAlias();
            if (TOTALCALCULATE_SET.contains(dataTypeName)) {
                String countAlias;
                String function;
                if (fieldNames.add(alias)) {
                    resultList.add(new Field(alias, (DataType)DataType.BigDecimalType));
                }
                if (!"1".equals(reportType) || !"avg".equals(function = RowSummaryInfo.getTotalCalFunction(alias, "sum", rowSummaryInfo))) continue;
                String sumAlias = alias + '\u03b1' + "avgsum";
                if (fieldNames.add(sumAlias)) {
                    resultList.add(new Field(sumAlias, (DataType)DataType.BigDecimalType));
                }
                if (!fieldNames.add(countAlias = alias + '\u03b1' + "avgcount")) continue;
                resultList.add(new Field(countAlias, (DataType)DataType.BigDecimalType));
                continue;
            }
            if (DataType.NullType.equals((Object)dataType)) {
                if (!fieldNames.add(alias)) continue;
                resultList.add(new Field(alias, (DataType)DataType.BigDecimalType));
                continue;
            }
            fieldNames.add(alias);
            resultList.add(field);
        }
        return new RowMeta(resultList.toArray(new Field[0]));
    }

    public static RowMeta buildAlgoXTotalResultRowMeta(RowMeta sourceRowMeta, String reportType, RowSummaryInfo rowSummaryInfo, RowFieldParser rowFieldParser) {
        ArrayList<Field> resultList = new ArrayList<Field>();
        Field[] fields = sourceRowMeta.getFields();
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)fields.length);
        for (Field field : fields) {
            DataType dataType = field.getDataType();
            String alias = field.getAlias();
            String dataTypeName = dataType.getName();
            if (TOTALCALCULATE_SET.contains(dataTypeName)) {
                if ("1".equals(reportType)) {
                    String uniqueKey;
                    String function;
                    if (fieldNameSet.add(alias)) {
                        resultList.add(new Field(alias, (DataType)DataType.BigDecimalType));
                    }
                    if (!"avg".equals(function = RowSummaryInfo.getTotalCalFunction(uniqueKey = rowFieldParser.getUniqueKeyByAlgoXAliasExtend(alias), "sum", rowSummaryInfo))) continue;
                    if (fieldNameSet.add(alias + '\u03b1' + "avgcount")) {
                        resultList.add(new Field(alias + '\u03b1' + "avgcount", (DataType)DataType.BigDecimalType));
                    }
                    if (!fieldNameSet.add(alias + '\u03b1' + "avgsum")) continue;
                    resultList.add(new Field(alias + '\u03b1' + "avgsum", (DataType)DataType.BigDecimalType));
                    continue;
                }
                if (!fieldNameSet.add(alias)) continue;
                resultList.add(new Field(alias, (DataType)DataType.BigDecimalType));
                continue;
            }
            if (DataType.NullType.equals((Object)dataType)) {
                if (!fieldNameSet.add(alias)) continue;
                resultList.add(new Field(alias, (DataType)DataType.BigDecimalType));
                continue;
            }
            if (!fieldNameSet.add(field.getName())) continue;
            resultList.add(field);
        }
        return new RowMeta(resultList.toArray(new Field[0]));
    }

    public RowMeta buildRowMeta() {
        return new RowMeta(this.fieldList.toArray(new Field[0]));
    }

    public static StringBuilder getTransLatitudeHead(List<ReportField> latitudeList, Map<String, Object> data, RowFieldParser rowFieldParser) {
        StringBuilder transUnkPrefix = new StringBuilder();
        StringBuilder transLatitudeVal = new StringBuilder();
        for (int i = 0; i < latitudeList.size(); ++i) {
            ReportField reportField = latitudeList.get(i);
            Object val = data.get(reportField.getUniqueKey());
            if (val == null || "".equals(val) || "null".equals(val)) {
                val = " ";
            }
            String transposeFieldAlgoXAlias = rowFieldParser.getAlgoXAliasExtend(reportField);
            transUnkPrefix.append(transposeFieldAlgoXAlias);
            transLatitudeVal.append(val);
            if (i >= latitudeList.size() - 1) continue;
            transUnkPrefix.append("\u03bb");
            transLatitudeVal.append("\u03b5");
        }
        transUnkPrefix.append('\u03b3').append((CharSequence)transLatitudeVal);
        return transUnkPrefix;
    }

    public static StringBuilder getColumnLatitudeHead(List<AlgoXCalculateAlgoXField> latitudeList, Map<String, Object> columnData) {
        StringBuilder columnSubTotalPrefix = new StringBuilder();
        for (AlgoXCalculateAlgoXField latitudeField : latitudeList) {
            Object val = columnData.get(latitudeField.getUniqueKey());
            if (val == null || "".equals(val) || "null".equals(val)) {
                val = " ";
            }
            columnSubTotalPrefix.append(val).append("\u03b5");
        }
        if (columnSubTotalPrefix.length() > 0) {
            columnSubTotalPrefix.deleteCharAt(columnSubTotalPrefix.length() - 1);
        }
        return columnSubTotalPrefix;
    }

    protected void addField(String name, DataType dataType) {
        if (this.fieldNameSet.contains(name)) {
            return;
        }
        if (!this.algoxCalculateReduceGroupDTO.isTransferField() && (DataType.BooleanType.equals((Object)dataType) || DataType.DateType.equals((Object)dataType) || DataType.TimestampType.equals((Object)dataType))) {
            dataType = DataType.StringType;
        }
        if (DataType.IntegerType.equals((Object)dataType)) {
            dataType = DataType.BigDecimalType;
        }
        Field field = new Field(name, dataType);
        this.fieldList.add(field);
        this.fieldNameSet.add(name);
    }

    protected void addTotalCalField(String uniqueKey, String fieldName, Set<String> hasAddFieldSet, String defaultFunction) {
        if (this.rowSummaryInfo != null && this.rowSummaryInfo.getIndexFunctionMap() != null) {
            Map<String, String> indexFunctionMap = this.rowSummaryInfo.getIndexFunctionMap();
            String function = indexFunctionMap.get(uniqueKey);
            if (HRStringUtils.isEmpty((String)function)) {
                function = defaultFunction;
            }
            if (HRStringUtils.isEmpty((String)function)) {
                function = "sum";
            }
            this.algoxCalculateHelper.addCalculateField(this.fieldList, hasAddFieldSet, function, fieldName);
        } else {
            this.algoxCalculateHelper.addCalculateField(this.fieldList, hasAddFieldSet, "sum", fieldName);
        }
    }

    public static interface ThreeParamsConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    public class TransposeFieldBuilder {
        private RowFieldParser rowFieldParser;
        private List<TransposeConfigInfo> transposeConfigInfoList;
        private List<List<Map<String, Object>>> transposeDataList;
        private Set<String> hasAddFieldSet = new HashSet<String>();

        public TransposeFieldBuilder(RowFieldParser rowFieldParser, List<TransposeConfigInfo> transposeConfigInfoList, List<List<Map<String, Object>>> transposeDataList) {
            this.rowFieldParser = rowFieldParser;
            this.transposeConfigInfoList = transposeConfigInfoList;
            this.transposeDataList = transposeDataList;
        }

        protected TransposeFieldBuilder parseTransposeData(ThreeParamsConsumer<List<ReportField>, String, TransposeFieldBuilder> consumer) {
            for (int i = 0; i < this.transposeConfigInfoList.size(); ++i) {
                TransposeConfigInfo transposeConfigInfo = this.transposeConfigInfoList.get(i);
                List<ReportField> transposeValueFieldList = transposeConfigInfo.getTransposeValueFieldList();
                List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
                List<Map<String, Object>> dataMapList = this.transposeDataList.get(i);
                for (Map<String, Object> data : dataMapList) {
                    StringBuilder fieldBuilder = RowMetaBuilder.getTransLatitudeHead(transposeFieldList, data, this.rowFieldParser);
                    String fieldName = fieldBuilder.toString();
                    consumer.accept(transposeValueFieldList, fieldName, this);
                }
            }
            return this;
        }

        public TransposeFieldBuilder addEntityPrimitiveIndexField(List<ReportField> transposeValueFieldList, String fieldName) {
            List entityPrimitiveIndexFieldList = transposeValueFieldList.stream().filter(reportField -> reportField instanceof EntityPrimitiveIndexField).map(reportField -> (EntityPrimitiveIndexField)reportField).collect(Collectors.toList());
            for (EntityPrimitiveIndexField entityPrimitiveIndexField : entityPrimitiveIndexFieldList) {
                String algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(entityPrimitiveIndexField);
                String addFieldName = fieldName + '\u03b2' + algoXAliasExtend;
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(entityPrimitiveIndexField.getUniqueKey(), addFieldName, this.hasAddFieldSet, entityPrimitiveIndexField.getCalcFunction());
                    continue;
                }
                if (HRStringUtils.equals((String)RowMetaBuilder.this.reportType, (String)"0")) {
                    RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, entityPrimitiveIndexField.getCalcFunction(), addFieldName);
                    continue;
                }
                this.addDetailField(addFieldName);
            }
            return this;
        }

        public TransposeFieldBuilder addAggregateIndexField(List<ReportField> transposeValueFieldList, String fieldName) {
            List aggregateIndexFieldList = transposeValueFieldList.stream().filter(reportField -> reportField instanceof AggregateIndexField).map(reportField -> (AggregateIndexField)reportField).collect(Collectors.toList());
            for (AggregateIndexField aggregateIndexField : aggregateIndexFieldList) {
                String algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(aggregateIndexField);
                String addFieldName = fieldName + '\u03b2' + algoXAliasExtend;
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(aggregateIndexField.getUniqueKey(), addFieldName, this.hasAddFieldSet, aggregateIndexField.getCalcFunction());
                    continue;
                }
                if (HRStringUtils.equals((String)RowMetaBuilder.this.reportType, (String)"0")) {
                    RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, aggregateIndexField.getCalcFunction(), addFieldName);
                    continue;
                }
                this.addDetailField(addFieldName);
            }
            return this;
        }

        public TransposeFieldBuilder addPresetIndexField(List<ReportField> transposeValueFieldList, String fieldName) {
            List presetIndexFieldList = transposeValueFieldList.stream().filter(reportField -> reportField instanceof PresetIndexField).map(reportField -> (PresetIndexField)reportField).collect(Collectors.toList());
            for (PresetIndexField presetIndexField : presetIndexFieldList) {
                String algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(presetIndexField);
                String addFieldName = fieldName + '\u03b2' + algoXAliasExtend;
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(presetIndexField.getUniqueKey(), addFieldName, this.hasAddFieldSet, presetIndexField.getCalcFunction());
                    continue;
                }
                RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, presetIndexField.getCalcFunction(), addFieldName);
            }
            return this;
        }

        protected void addDetailField(String fieldName) {
            if (this.hasAddFieldSet.add(fieldName)) {
                RowMetaBuilder.this.fieldList.add(new Field(fieldName, (DataType)DataType.BigDecimalType));
            }
        }
    }

    public class ColumnFieldBuilder {
        private final Set<String> hasAddFieldSet = new HashSet<String>();
        private final List<AlgoXCalculateAlgoXField> columnLatitudeList;
        private final ColumnSummaryInfo columnSummaryInfo;
        private final List<Map<String, Object>> columnListMap;
        private final boolean hasCalculateField;

        public ColumnFieldBuilder(boolean hasCalculateField, List<AlgoXCalculateAlgoXField> columnLatitudeList, ColumnSummaryInfo columnSummaryInfo, List<Map<String, Object>> columnListMap) {
            this.hasCalculateField = hasCalculateField;
            this.columnLatitudeList = columnLatitudeList;
            this.columnSummaryInfo = columnSummaryInfo;
            this.columnListMap = columnListMap;
        }

        protected ColumnFieldBuilder parseColumnData(ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> trueConsumer, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> falseConsumer) {
            this.appendSummaryHead("left", trueConsumer, falseConsumer);
            for (Map<String, Object> data : this.columnListMap) {
                StringBuilder fieldBuilder = RowMetaBuilder.getColumnLatitudeHead(this.columnLatitudeList, data);
                if (this.hasCalculateField) {
                    trueConsumer.accept(fieldBuilder.toString(), false, this);
                    continue;
                }
                falseConsumer.accept(fieldBuilder.toString(), false, this);
            }
            this.appendSummaryHead("right", trueConsumer, falseConsumer);
            return this;
        }

        public void appendSummaryHead(String showLocation, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> trueConsumer, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> falseConsumer) {
            this.appendTotalHead(showLocation, trueConsumer, falseConsumer);
            if (this.columnSummaryInfo != null && showLocation.equals(this.columnSummaryInfo.getShowLocation()) && this.columnSummaryInfo.isShowSubTotalCol()) {
                List<String> subTotalLatitudes = this.columnSummaryInfo.getSubTotalLatitudes();
                if (subTotalLatitudes.size() == this.columnLatitudeList.size()) {
                    AlgoXCalculateAlgoXField lastColLatitude = this.columnLatitudeList.get(this.columnLatitudeList.size() - 1);
                    subTotalLatitudes.removeIf(sub -> lastColLatitude.getUniqueKey().equals(sub));
                }
                for (String subTotalLatitude : subTotalLatitudes) {
                    ArrayList subLatitudeFields = Lists.newArrayListWithExpectedSize((int)this.columnLatitudeList.size());
                    for (AlgoXCalculateAlgoXField algoXLatitudeField : this.columnLatitudeList) {
                        if (algoXLatitudeField.getUniqueKey().equals(subTotalLatitude)) {
                            subLatitudeFields.add(algoXLatitudeField);
                            break;
                        }
                        subLatitudeFields.add(algoXLatitudeField);
                    }
                    Set<String> subHeads = this.appendSubHead(subLatitudeFields);
                    for (String subHead : subHeads) {
                        if (this.hasCalculateField) {
                            trueConsumer.accept(subHead, true, this);
                            continue;
                        }
                        falseConsumer.accept(subHead, true, this);
                    }
                }
            }
            this.appendTotalHead(showLocation, trueConsumer, falseConsumer);
        }

        private void appendTotalHead(String showLocation, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> trueConsumer, ThreeParamsConsumer<String, Boolean, ColumnFieldBuilder> falseConsumer) {
            if (this.columnSummaryInfo != null && showLocation.equals(this.columnSummaryInfo.getShowLocation()) && this.columnSummaryInfo.isShowTotalCol()) {
                String totalColHead = "\u03b8" + this.columnSummaryInfo.getTotalColName().getLocaleValue();
                if (this.hasCalculateField) {
                    trueConsumer.accept(totalColHead, true, this);
                } else {
                    falseConsumer.accept(totalColHead, true, this);
                }
            }
        }

        private Set<String> appendSubHead(List<AlgoXCalculateAlgoXField> latitudeList) {
            return this.columnListMap.stream().map(columnData -> {
                StringBuilder columnSubTotalPrefix = RowMetaBuilder.getColumnLatitudeHead(latitudeList, columnData);
                columnSubTotalPrefix.append("\u03b7").append(this.columnSummaryInfo.getSubTotalColName().getLocaleValue());
                return columnSubTotalPrefix.toString();
            }).collect(Collectors.toSet());
        }

        public ColumnFieldBuilder addColumnField(String fieldName) {
            RowMetaBuilder.this.addField(fieldName, (DataType)DataType.BigDecimalType);
            return this;
        }

        public ColumnFieldBuilder addEntityPrimitiveIndexField(String fieldName, boolean isSummary, List<AlgoXEntityPrimitiveIndexAlgoXField> entityPrimitiveIndexFieldList) {
            Map<String, String> summaryIndexFunctionMap = null;
            if (isSummary && this.columnSummaryInfo != null) {
                summaryIndexFunctionMap = this.columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
            }
            for (AlgoXEntityPrimitiveIndexAlgoXField entityPrimitiveIndexField : entityPrimitiveIndexFieldList) {
                String calcFunction = entityPrimitiveIndexField.getEntityPrimitiveIndexField().getCalcFunction();
                if (isSummary && summaryIndexFunctionMap != null) {
                    calcFunction = summaryIndexFunctionMap.get(entityPrimitiveIndexField.getUniqueKey());
                }
                String addFieldName = fieldName + '\u03b2' + entityPrimitiveIndexField.getAlgoXAliasExtend();
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(entityPrimitiveIndexField.getUniqueKey(), addFieldName, this.hasAddFieldSet, entityPrimitiveIndexField.getEntityPrimitiveIndexField().getCalcFunction());
                    continue;
                }
                RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, calcFunction, addFieldName);
            }
            return this;
        }

        public ColumnFieldBuilder addAggregateIndexFieldList(String fieldName, boolean isSummary, List<AlgoXAggregateIndexAlgoXField> aggregateIndexFieldList) {
            Map<String, String> summaryIndexFunctionMap = null;
            if (isSummary && this.columnSummaryInfo != null) {
                summaryIndexFunctionMap = this.columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
            }
            for (AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField : aggregateIndexFieldList) {
                String calcFunction = algoxAggregateIndexAlgoxField.getAggregateIndexField().getCalcFunction();
                if (isSummary && summaryIndexFunctionMap != null) {
                    calcFunction = summaryIndexFunctionMap.get(algoxAggregateIndexAlgoxField.getUniqueKey());
                }
                String addFieldName = fieldName + '\u03b2' + algoxAggregateIndexAlgoxField.getAlgoXAliasExtend();
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(algoxAggregateIndexAlgoxField.getUniqueKey(), addFieldName, this.hasAddFieldSet, algoxAggregateIndexAlgoxField.getAggregateIndexField().getCalcFunction());
                    continue;
                }
                RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, calcFunction, addFieldName);
            }
            return this;
        }

        public ColumnFieldBuilder addPresetIndexFieldList(String fieldName, boolean isSummary, List<AlgoXPresetIndexAlgoXField> presetIndexFieldList) {
            Map<String, String> summaryIndexFunctionMap = null;
            if (isSummary && this.columnSummaryInfo != null) {
                summaryIndexFunctionMap = this.columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
            }
            for (AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoxField : presetIndexFieldList) {
                String calcFunction = "avg";
                String addFieldName = fieldName + '\u03b2' + algoxPresetIndexAlgoxField.getAlgoXAliasExtend();
                RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, calcFunction, addFieldName);
            }
            return this;
        }
    }

    public class RowFieldBuilder {
        private Set<String> hasAddFieldSet = new HashSet<String>();

        public RowFieldBuilder addLatitudeField(List<AlgoXCalculateAlgoXField> rowLatitudeList) {
            for (AlgoXCalculateAlgoXField algoxLatitudeField : rowLatitudeList) {
                RowMetaBuilder.this.addField(algoxLatitudeField.getAlgoXAliasExtend(), AlgoDataTypeTransUtil.getDataType((DataTypeEnum)algoxLatitudeField.getDataType()));
            }
            return this;
        }

        public RowFieldBuilder addRowOrderLatitudeField(List<AlgoXOrderAlgoXField> rowLatitudeList) {
            for (AlgoXOrderAlgoXField algoXOrderAlgoXField : rowLatitudeList) {
                RowMetaBuilder.this.addField(algoXOrderAlgoXField.getAlgoXAliasExtend(), AlgoDataTypeTransUtil.getDataType((DataTypeEnum)algoXOrderAlgoXField.getDataType()));
            }
            return this;
        }

        public RowFieldBuilder addEntityPrimitiveIndexField(List<AlgoXEntityPrimitiveIndexAlgoXField> entityPrimitiveIndexFieldList) {
            for (AlgoXEntityPrimitiveIndexAlgoXField entityPrimitiveIndexField : entityPrimitiveIndexFieldList) {
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(entityPrimitiveIndexField.getUniqueKey(), entityPrimitiveIndexField.getAlgoXAliasExtend(), this.hasAddFieldSet, entityPrimitiveIndexField.getEntityPrimitiveIndexField().getCalcFunction());
                    continue;
                }
                if (HRStringUtils.equals((String)RowMetaBuilder.this.reportType, (String)"0")) {
                    RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, entityPrimitiveIndexField.getEntityPrimitiveIndexField().getCalcFunction(), entityPrimitiveIndexField.getAlgoXAliasExtend());
                    continue;
                }
                RowMetaBuilder.this.addField(entityPrimitiveIndexField.getAlgoXAliasExtend(), AlgoDataTypeTransUtil.getDataType((String)entityPrimitiveIndexField.getEntityPrimitiveIndexField().getFieldType()));
            }
            return this;
        }

        public RowFieldBuilder addAggregateIndexField(List<AlgoXAggregateIndexAlgoXField> aggregateIndexFieldList) {
            for (AlgoXAggregateIndexAlgoXField aggregateIndexAlgoXField : aggregateIndexFieldList) {
                if (RowMetaBuilder.this.isTotalCalculate) {
                    RowMetaBuilder.this.addTotalCalField(aggregateIndexAlgoXField.getUniqueKey(), aggregateIndexAlgoXField.getAlgoXAliasExtend(), this.hasAddFieldSet, aggregateIndexAlgoXField.getAggregateIndexField().getCalcFunction());
                    continue;
                }
                if (HRStringUtils.equals((String)RowMetaBuilder.this.reportType, (String)"0")) {
                    RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, aggregateIndexAlgoXField.getAggregateIndexField().getCalcFunction(), aggregateIndexAlgoXField.getAlgoXAliasExtend());
                    continue;
                }
                RowMetaBuilder.this.addField(aggregateIndexAlgoXField.getAlgoXAliasExtend(), AlgoDataTypeTransUtil.getDataType((String)aggregateIndexAlgoXField.getAggregateIndexField().getFieldType()));
            }
            return this;
        }

        public RowFieldBuilder addPresetIndexField(List<AlgoXPresetIndexAlgoXField> presetIndexFieldList) {
            for (AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoxField : presetIndexFieldList) {
                RowMetaBuilder.this.algoxCalculateHelper.addCalculateField(RowMetaBuilder.this.fieldList, this.hasAddFieldSet, algoxPresetIndexAlgoxField.getPresetIndexField().getCalcFunction(), algoxPresetIndexAlgoxField.getAlgoXAliasExtend());
            }
            return this;
        }
    }
}

