/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRStringUtils;

public class AlgoXFieldParser
implements Serializable {
    private static final long serialVersionUID = 9040589370130912845L;
    protected final HRComplexObjContext context;
    private final Map<String, AlgoXFieldInfo> allFieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, AlgoXFieldInfo> calculateFieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, AlgoXFieldInfo> presetIndexFieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, String> entityAliasToNumberMap = Maps.newHashMapWithExpectedSize((int)16);

    public AlgoXFieldParser(HRComplexObjContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        List joinRelationList = this.context.getJoinRelationList();
        if (joinRelationList != null) {
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                this.entityAliasToNumberMap.put(joinRelation.getRelEntityAlias(), joinRelation.getRelEntityNumber());
            }
        }
        this.parseAndAddEntityFieldInfo(this.context.getComplexObjFieldInfoList());
        List presetIndexFieldInfoList = this.context.getPresetIndexFieldInfoList();
        if (presetIndexFieldInfoList != null) {
            presetIndexFieldInfoList.forEach(this::addPresetIndexFieldInfo);
        }
    }

    public void parseAndAddEntityFieldInfo(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        Set<String> calculateFieldSet = complexObjFieldInfoList.stream().filter(complexObjFieldInfo -> !HRStringUtils.equals((String)complexObjFieldInfo.getFieldType(), (String)"1")).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        Map<String, HRComplexObjFieldInfo> complexObjFieldAliasMap = complexObjFieldInfoList.stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, context -> context, (x, y) -> y));
        for (HRComplexObjFieldInfo complexObjFieldInfo2 : complexObjFieldInfoList) {
            if (HRStringUtils.equals((String)complexObjFieldInfo2.getFieldType(), (String)"1")) {
                this.addEntityFieldInfo(complexObjFieldInfo2);
                continue;
            }
            Set refFieldAliasSet = complexObjFieldInfo2.getRefFieldAliasSet();
            for (String refFieldAlias : refFieldAliasSet) {
                if (this.isCalculateField(refFieldAlias, calculateFieldSet) || complexObjFieldInfo2.getRefFieldIsAnObjPivotIndexSet().contains(refFieldAlias)) continue;
                HRComplexObjFieldInfo refFieldInfo = complexObjFieldAliasMap.get(refFieldAlias);
                if (refFieldInfo == null) {
                    this.addEntityFieldInfo(refFieldAlias);
                    continue;
                }
                this.addEntityFieldInfo(refFieldInfo);
            }
            this.addCalculateFieldInfo(complexObjFieldInfo2);
        }
    }

    public void addEntityFieldInfo(HRComplexObjFieldInfo fieldInfo) {
        String alias = fieldInfo.getAlias();
        String prefixFullPath = this.getPrefixFullPath(fieldInfo);
        AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(alias);
        if (algoxFieldInfo == null) {
            algoxFieldInfo = HRStringUtils.isEmpty((String)prefixFullPath) ? AlgoXFieldInfo.createMainFieldInfo((HRComplexObjFieldInfo)fieldInfo) : AlgoXFieldInfo.createRelFieldInfo((HRComplexObjFieldInfo)fieldInfo);
            this.allFieldInfoMap.put(alias, algoxFieldInfo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void addEntityFieldInfo(String alias) {
        String fullPath = this.parseAliasReturnFullPath(alias);
        String prefixFullPath = this.getPrefixFullPath(fullPath);
        AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(alias);
        if (algoxFieldInfo == null) {
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(fullPath, alias);
            algoxFieldInfo = HRStringUtils.isEmpty((String)prefixFullPath) ? AlgoXFieldInfo.createMainFieldInfo((HRComplexObjFieldInfo)fieldInfo) : AlgoXFieldInfo.createRelFieldInfo((HRComplexObjFieldInfo)fieldInfo);
            this.allFieldInfoMap.put(alias, algoxFieldInfo);
        }
    }

    public void addCalculateFieldInfo(HRComplexObjFieldInfo complexObjFieldInfo) {
        this.calculateFieldInfoMap.put(complexObjFieldInfo.getAlias(), AlgoXFieldInfo.createCalculateFieldInfo((HRComplexObjFieldInfo)complexObjFieldInfo));
    }

    public void addPresetIndexFieldInfo(HRComplexObjFieldInfo complexObjFieldInfo) {
        this.presetIndexFieldInfoMap.put(complexObjFieldInfo.getAlias(), AlgoXFieldInfo.createCalculateFieldInfo((HRComplexObjFieldInfo)complexObjFieldInfo));
    }

    public boolean isCalculateField(String refFieldAlias, Set<String> calculateFieldSet) {
        return calculateFieldSet.contains(refFieldAlias);
    }

    public AlgoXFieldInfo getNormalAlgoXFieldInfo(String alias) {
        return this.allFieldInfoMap.get(alias);
    }

    public AlgoXFieldInfo getCalculateFieldInfo(String alias) {
        return this.calculateFieldInfoMap.get(alias);
    }

    public AlgoXFieldInfo getAlgoXFieldInfo(String alias) {
        AlgoXFieldInfo algoxFieldInfo = this.getNormalAlgoXFieldInfo(alias);
        if (algoxFieldInfo != null) {
            return algoxFieldInfo;
        }
        AlgoXFieldInfo calculateFieldInfo = this.getCalculateFieldInfo(alias);
        if (calculateFieldInfo != null) {
            return calculateFieldInfo;
        }
        return this.presetIndexFieldInfoMap.get(alias);
    }

    public HRComplexObjContext getContext() {
        return this.context;
    }

    private String parseFullPathReturnPrefix(String alias) {
        return alias.split("\\.")[0];
    }

    public String getPrefixFullPath(HRComplexObjFieldInfo fieldInfo) {
        return this.getPrefixFullPath(fieldInfo.getFullPath());
    }

    public String getPrefixFullPath(String fullPath) {
        String prefixFullPath = null;
        if (fullPath != null && fullPath.contains(".") && !this.entityAliasToNumberMap.containsValue(prefixFullPath = this.parseFullPathReturnPrefix(fullPath))) {
            prefixFullPath = null;
        }
        return prefixFullPath;
    }

    private String parseAliasReturnFullPath(String alias) {
        String prefixAlias = this.parseFullPathReturnPrefix(alias);
        return this.parseAliasReturnFullPath(prefixAlias, alias);
    }

    public String parseAliasReturnFullPath(String relEntityAlias, String fieldAlias) {
        if (this.containsRelEntity(relEntityAlias)) {
            String entityNumber = this.getRelEntityNumber(relEntityAlias);
            return entityNumber + fieldAlias.substring(relEntityAlias.length());
        }
        return fieldAlias;
    }

    public boolean containsRelEntity(String relEntityAlias) {
        return this.entityAliasToNumberMap.containsKey(relEntityAlias);
    }

    public String getRelEntityNumber(String relEntityAlias) {
        return this.entityAliasToNumberMap.get(relEntityAlias);
    }
}

