/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algox.DataSetX;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.parser.AlgoXFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.ColFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.TransposeParser;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public class CalculateAlgoxParser
implements Serializable {
    private static final long serialVersionUID = -754225643283318787L;
    public static final String PARSE_ROWFIELD = "0";
    public static final String PARSE_COLFIELD = "1";
    public static final String PARSE_TRANSPOSEFIELD = "2";
    protected HRComplexObjContext complexObjContext;
    protected AlgoXFieldParser algoXFieldParser;
    private final ReportCalculateInfo calculateInfo;
    private RowFieldParser rowFieldParser;
    private ColFieldParser colFieldParser;
    private TransposeParser transposeParser;
    private final Set<String> parseTypeSet = new HashSet<String>();

    public CalculateAlgoxParser(IReportQueryPlan reportQueryPlan, ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        this.calculateInfo = calculateInfo;
        this.complexObjContext = complexObjContext;
        this.init(reportQueryPlan);
    }

    private void init(IReportQueryPlan reportQueryPlan) {
        this.algoXFieldParser = new AlgoXFieldParser(this.complexObjContext);
        this.rowFieldParser = new RowFieldParser(reportQueryPlan, this.calculateInfo, this.algoXFieldParser);
        this.colFieldParser = new ColFieldParser(this.calculateInfo, this.algoXFieldParser);
        this.transposeParser = new TransposeParser(this.calculateInfo, this.algoXFieldParser);
        if (this.rowFieldParser.isParseFlag()) {
            this.parseTypeSet.add(PARSE_ROWFIELD);
        }
        if (this.colFieldParser.isParseFlag()) {
            this.parseTypeSet.add(PARSE_COLFIELD);
        }
        if (this.transposeParser.isParseFlag()) {
            this.parseTypeSet.add(PARSE_TRANSPOSEFIELD);
        }
    }

    public boolean onlyRowField() {
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        List<ReportField> columnFieldList = this.calculateInfo.getColumnFieldList();
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        return CollectionUtils.isEmpty(transposeConfigInfoList) && CollectionUtils.isEmpty(columnFieldList) && !CollectionUtils.isEmpty(rowFieldList);
    }

    public boolean existsColumnField() {
        return !CollectionUtils.isEmpty(this.calculateInfo.getColumnFieldList());
    }

    public RowFieldParser getRowFieldParser() {
        return this.rowFieldParser;
    }

    public ColFieldParser getColFieldParser() {
        return this.colFieldParser;
    }

    public TransposeParser getTransposeParser() {
        return this.transposeParser;
    }

    public List<AlgoXCalculateAlgoXField> getLatitudeFieldListByTransposeConfig() {
        List<AlgoXCalculateAlgoXField> latitudeFieldList = this.rowFieldParser.getLatitudeFieldList();
        List<AlgoXCalculateAlgoXField> transposeLatitudeFieldList = this.transposeParser.getLatitudeFieldList();
        return latitudeFieldList.stream().filter(algoXLatitudeAlgoXField -> {
            for (AlgoXCalculateAlgoXField transposeLatitudeField : transposeLatitudeFieldList) {
                if (!algoXLatitudeAlgoXField.getAlgoXAliasExtend().equals(transposeLatitudeField.getAlgoXAliasExtend())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public String[] getDistinctAlgoXAliasArr(List<AlgoXCalculateAlgoXField> fields) {
        return (String[])fields.stream().map(AlgoXField::getAlgoXAlias).distinct().toArray(String[]::new);
    }

    public String[] getGroupByAlgoXAliasExtendArr(List<AlgoXCalculateAlgoXField> rowLatitudeFieldList) {
        String[] latitudeFieldAlgoXAliasArr = this.getDistinctAlgoXAliasArr(rowLatitudeFieldList);
        ArrayList<String> resultList = new ArrayList<String>();
        block0: for (String latitudeFieldAlgoXAlias : latitudeFieldAlgoXAliasArr) {
            for (AlgoXCalculateAlgoXField algoxCalculateAlgoxField : this.rowFieldParser.getLatitudeFieldList()) {
                if (!latitudeFieldAlgoXAlias.equals(algoxCalculateAlgoxField.getAlgoXAlias())) continue;
                resultList.add(algoxCalculateAlgoxField.getAlgoXAliasExtend());
                continue block0;
            }
        }
        return resultList.toArray(new String[0]);
    }

    public List<AlgoXEntityPrimitiveIndexAlgoXField> getEntityPrimitiveIndexFieldListByTransposeConfig() {
        List<AlgoXEntityPrimitiveIndexAlgoXField> entityPrimitiveIndexFieldList = this.rowFieldParser.getEntityPrimitiveIndexFieldList();
        List<AlgoXEntityPrimitiveIndexAlgoXField> transposeEntityPrimitiveIndexFieldList = this.transposeParser.getEntityPrimitiveIndexFieldList();
        return entityPrimitiveIndexFieldList.stream().filter(algoXEntityPrimitiveIndexAlgoxField -> {
            for (AlgoXEntityPrimitiveIndexAlgoXField transposeEntityPrimitiveIndexField : transposeEntityPrimitiveIndexFieldList) {
                if (!algoXEntityPrimitiveIndexAlgoxField.getAlgoXAliasExtend().equals(transposeEntityPrimitiveIndexField.getAlgoXAliasExtend())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public List<AlgoXAggregateIndexAlgoXField> getAggregateIndexFieldListByTransposeConfig() {
        List<AlgoXAggregateIndexAlgoXField> aggregateIndexFieldList = this.rowFieldParser.getAggregateIndexFieldList();
        List<AlgoXAggregateIndexAlgoXField> transposeAggregateIndexFieldList = this.transposeParser.getAggregateIndexFieldList();
        return aggregateIndexFieldList.stream().filter(algoXAggregateIndexAlgoxField -> {
            for (AlgoXAggregateIndexAlgoXField transposeAggregateIndexField : transposeAggregateIndexFieldList) {
                if (!algoXAggregateIndexAlgoxField.getAlgoXAliasExtend().equals(transposeAggregateIndexField.getAlgoXAliasExtend())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public List<AlgoXPresetIndexAlgoXField> getPresetIndexFieldListByTransposeConfig() {
        List<AlgoXPresetIndexAlgoXField> presetIndexFieldList = this.rowFieldParser.getPresetIndexFieldList();
        List<AlgoXPresetIndexAlgoXField> transposePresetIndexAlgoxFieldList = this.transposeParser.getPresetIndexFieldList();
        return presetIndexFieldList.stream().filter(presetIndexField -> {
            for (AlgoXPresetIndexAlgoXField transposePresetIndexAlgoxField : transposePresetIndexAlgoxFieldList) {
                if (!presetIndexField.getAlgoXAliasExtend().equals(transposePresetIndexAlgoxField.getAlgoXAliasExtend())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public String[] getLatitudeFieldAlgoxAliasExtendOrderByArrByTransposeConfig(List<AlgoXCalculateAlgoXField> rowLatitudeFieldList) {
        return (String[])rowLatitudeFieldList.stream().map(AlgoXField::getAlgoXAliasExtend).toArray(String[]::new);
    }

    public Set<String> getParseTypeSet() {
        return this.parseTypeSet;
    }

    public String[] getLatitudeFieldAlgoXAliasExtendOrder(DataSetX dataSetX) {
        return this.rowFieldParser.getRowOrderAliasExtendArray(dataSetX);
    }
}

