/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXLatitudeAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.parser.AlgoXFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.ColFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.utils.ParseUtils;
import kd.hr.hrptmc.business.repcalculate.algox.query.QueryServiceFactory;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.ColumnAllValueHelper;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldUtils;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repcalculate.utils.sort.DimComparator;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public class TransposeParser
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(ColFieldParser.class);
    private static final long serialVersionUID = -6891653835558675396L;
    private final List<ReportField> transposeFields;
    protected AlgoXFieldParser algoXFieldParser;
    private ReportCalculateInfo calculateInfo;
    private HRComplexObjContext complexObjContext;
    private Map<String, AlgoXLatitudeAlgoXField> latitudeFieldMap = new LinkedHashMap<String, AlgoXLatitudeAlgoXField>();
    private Map<String, AlgoXEntityPrimitiveIndexAlgoXField> entityPrimitiveIndexFieldMap = new LinkedHashMap<String, AlgoXEntityPrimitiveIndexAlgoXField>();
    private Map<String, AlgoXAggregateIndexAlgoXField> aggregateIndexFieldMap = new LinkedHashMap<String, AlgoXAggregateIndexAlgoXField>();
    private Map<String, AlgoXPresetIndexAlgoXField> presetIndexFieldMap = new LinkedHashMap<String, AlgoXPresetIndexAlgoXField>();
    private boolean parseFlag;

    public TransposeParser(ReportCalculateInfo calculateInfo, AlgoXFieldParser algoXFieldParser) {
        this.calculateInfo = calculateInfo;
        this.algoXFieldParser = algoXFieldParser;
        this.complexObjContext = algoXFieldParser.getContext();
        this.transposeFields = Lists.newArrayListWithExpectedSize((int)10);
        this.parseFlag = this.init();
    }

    private boolean init() {
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (CollectionUtils.isEmpty(transposeConfigInfoList)) {
            return false;
        }
        for (TransposeConfigInfo transposeConfigInfo : transposeConfigInfoList) {
            List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
            for (ReportField reportField : transposeFieldList) {
                if (reportField instanceof LatitudeField) {
                    LatitudeField latitudeField = (LatitudeField)reportField;
                    this.putLatitudeField(latitudeField);
                    this.transposeFields.add(latitudeField);
                }
                if (!(reportField instanceof AggregateIndexField)) continue;
                AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                this.putAggregateIndexField(aggregateIndexField);
                this.transposeFields.add(aggregateIndexField);
            }
            List<ReportField> transposeValueFieldList = transposeConfigInfo.getTransposeValueFieldList();
            for (ReportField valueReportField : transposeValueFieldList) {
                if (valueReportField instanceof EntityPrimitiveIndexField) {
                    EntityPrimitiveIndexField entityPrimitiveIndexField = (EntityPrimitiveIndexField)valueReportField;
                    this.putEntityPrimitiveIndexField(entityPrimitiveIndexField);
                }
                if (valueReportField instanceof AggregateIndexField) {
                    AggregateIndexField aggregateIndexField = (AggregateIndexField)valueReportField;
                    this.putAggregateIndexField(aggregateIndexField);
                }
                if (!(valueReportField instanceof PresetIndexField)) continue;
                PresetIndexField presetIndexField = (PresetIndexField)valueReportField;
                this.putPresetIndexField(presetIndexField);
            }
        }
        return true;
    }

    private void putLatitudeField(LatitudeField latitudeField) {
        String fieldAlias = latitudeField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXLatitudeAlgoXField algoxLatitudeField = new AlgoXLatitudeAlgoXField(latitudeField, algoxFieldInfo);
        this.latitudeFieldMap.put(algoxLatitudeField.getAlgoXAliasExtend(), algoxLatitudeField);
    }

    private void putEntityPrimitiveIndexField(EntityPrimitiveIndexField entityPrimitiveIndexField) {
        String fieldAlias = entityPrimitiveIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXEntityPrimitiveIndexAlgoXField algoxEntityPrimitiveIndexField = new AlgoXEntityPrimitiveIndexAlgoXField(entityPrimitiveIndexField, algoxFieldInfo);
        this.entityPrimitiveIndexFieldMap.put(algoxEntityPrimitiveIndexField.getAlgoXAliasExtend(), algoxEntityPrimitiveIndexField);
    }

    private void putAggregateIndexField(AggregateIndexField aggregateIndexField) {
        String fieldAlias = aggregateIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField = new AlgoXAggregateIndexAlgoXField(aggregateIndexField, algoxFieldInfo);
        this.aggregateIndexFieldMap.put(algoxAggregateIndexAlgoxField.getAlgoXAliasExtend(), algoxAggregateIndexAlgoxField);
    }

    private void putPresetIndexField(PresetIndexField presetIndexField) {
        String fieldAlias = presetIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXPresetIndexAlgoXField algoxAggregateIndexAlgoxField = new AlgoXPresetIndexAlgoXField(presetIndexField, algoxFieldInfo);
        this.presetIndexFieldMap.put(algoxAggregateIndexAlgoxField.getAlgoXAliasExtend(), algoxAggregateIndexAlgoxField);
    }

    public List<AlgoXCalculateAlgoXField> getLatitudeFieldList() {
        return ParseUtils.getLatitudeFieldList(this.transposeFields, this.latitudeFieldMap, this.aggregateIndexFieldMap);
    }

    public List<AlgoXEntityPrimitiveIndexAlgoXField> getEntityPrimitiveIndexFieldList() {
        return this.entityPrimitiveIndexFieldMap.values().stream().filter(algoxEntityPrimitiveIndexAlgoxField -> !algoxEntityPrimitiveIndexAlgoxField.getEntityPrimitiveIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<AlgoXAggregateIndexAlgoXField> getAggregateIndexFieldList() {
        return this.aggregateIndexFieldMap.values().stream().filter(algoxAggregateIndexAlgoxField -> algoxAggregateIndexAlgoxField.getAggregateIndexField().isIndexField()).filter(algoxAggregateIndexAlgoxField -> !algoxAggregateIndexAlgoxField.getAggregateIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<AlgoXPresetIndexAlgoXField> getPresetIndexFieldList() {
        return this.presetIndexFieldMap.values().stream().filter(algoxPresetIndexAlgoxField -> !algoxPresetIndexAlgoxField.getPresetIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<List<Map<String, Object>>> createTransposeData() {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        for (TransposeConfigInfo transposeConfigInfo : this.calculateInfo.getTransposeConfigInfoList()) {
            ArrayList transposeData;
            List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
            ReportField transposeField = transposeFieldList.get(0);
            if (transposeField instanceof LatitudeField) {
                LatitudeField transposeLatitudeField = (LatitudeField)transposeField;
                List<Object> transPositionNames = transposeLatitudeField.getTransPositionNames();
                if (transPositionNames != null && !transPositionNames.isEmpty()) {
                    String fieldAlias = transposeLatitudeField.getFieldAlias();
                    transposeData = Lists.newArrayListWithCapacity((int)transPositionNames.size());
                    for (Object transPositionName : transPositionNames) {
                        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
                        map.put(fieldAlias, String.valueOf(transPositionName));
                        transposeData.add(map);
                    }
                } else {
                    transposeData = this.createTransposeData(transposeFieldList);
                }
            } else {
                transposeData = this.createTransposeData(transposeFieldList);
            }
            resultList.add(transposeData);
        }
        return resultList;
    }

    public List<Map<String, Object>> createTransposeData(List<ReportField> reportFieldList) {
        HRComplexObjContext context = new HRComplexObjContext();
        context.setQueryMode("2");
        List<ReportField> reportFields = SortFieldUtil.resetDepSortField(reportFieldList);
        ArrayList complexObjFieldInfoList = Lists.newArrayListWithExpectedSize((int)reportFields.size());
        for (ReportField newField : reportFields) {
            HRComplexObjFieldInfo complexObjFieldInfo;
            if (newField instanceof LatitudeField) {
                complexObjFieldInfo = ReportFieldUtils.entityField2ComplexField((LatitudeField)newField);
            } else {
                AggregateIndexField transposeAggregateIndexField = (AggregateIndexField)newField;
                complexObjFieldInfo = ReportFieldUtils.aggregateIndexField2ComplexField(transposeAggregateIndexField);
                this.addCalculateFieldDependFields(transposeAggregateIndexField, complexObjFieldInfoList);
            }
            complexObjFieldInfoList.add(complexObjFieldInfo);
        }
        context.setGroupFieldList(ReportFieldUtils.getGroupByComplexFieldsWithDepend(reportFields));
        List<ReportField> sortFields = ParseUtils.getSortFields(reportFieldList);
        context.setComplexObjFieldInfoList((List)complexObjFieldInfoList);
        context.setTransferField(this.complexObjContext.isTransferField());
        context.setReturnEnumOriginalValue(true);
        context.setEntityNumber(this.complexObjContext.getEntityNumber());
        context.setEntityTable(this.complexObjContext.getEntityTable());
        context.setJoinRelationList(this.complexObjContext.getJoinRelationList());
        context.setVirtualEntity(this.complexObjContext.getVirtualEntity());
        context.setDistinct(true);
        context.setVirtualEntityQueryParamInfo(ParseUtils.getVirtualEntityQueryParamInfoWithColList(this.complexObjContext, context, reportFields));
        context.setVirtualEntityQueryService(this.complexObjContext.getVirtualEntityQueryService());
        context.setQfilterList(this.complexObjContext.getQfilterList());
        context.setOrder(false);
        context.setReturnDependOrderValue(true);
        SortFieldUtil.initSortField(context, reportFields, this.calculateInfo.getReportId());
        context.setAlgoxJobKey(String.format("%s_transpose", this.complexObjContext.getAlgoxJobKey()));
        LOGGER.info("TransposeParser_query_context_{}" + context);
        IReportQueryPlan reportQueryPlan = QueryServiceFactory.getReportQueryPlanByALgoX(this.calculateInfo, context);
        List dimensionData = reportQueryPlan.queryDimensionData();
        ColumnAllValueHelper transposeAllValueHelper = new ColumnAllValueHelper(this.complexObjContext, reportFieldList);
        List<Map<String, DimensionData>> allDimensionData = transposeAllValueHelper.getAllDimensionData(dimensionData);
        if (!sortFields.isEmpty()) {
            allDimensionData.sort(new DimComparator(sortFields));
        }
        return ColumnAllValueHelper.convertToObjMapList(allDimensionData);
    }

    private void addCalculateFieldDependFields(AggregateIndexField aggregateIndexField, List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        Set<String> dependentFieldSet = aggregateIndexField.getDependentFieldSet();
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        if (dependentFieldSet != null && !dependentFieldSet.isEmpty()) {
            for (ReportField field : rowFieldList) {
                HRComplexObjFieldInfo fieldInfo;
                if (!dependentFieldSet.contains(field.getFieldAlias())) continue;
                if (field instanceof EntityPropField) {
                    fieldInfo = ReportFieldUtils.entityField2ComplexField((EntityPropField)field);
                    complexObjFieldInfoList.add(fieldInfo);
                    continue;
                }
                if (field instanceof AggregateIndexField) {
                    fieldInfo = ReportFieldUtils.aggregateIndexField2ComplexField((AggregateIndexField)field);
                    this.addCalculateFieldDependFields((AggregateIndexField)field, complexObjFieldInfoList);
                    complexObjFieldInfoList.add(fieldInfo);
                    continue;
                }
                if (!(field instanceof PresetIndexField)) continue;
                fieldInfo = ReportFieldUtils.presetIndexField2ComplexField((PresetIndexField)field);
                complexObjFieldInfoList.add(fieldInfo);
            }
        }
    }

    public boolean isParseFlag() {
        return this.parseFlag;
    }
}

