/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser.specific.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXLatitudeAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXOrderAlgoXField;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class ParseUtils {
    public static List<ReportField> getSortFields(List<ReportField> fields) {
        ArrayList sortFields = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (ReportField reportField : fields) {
            if (!HRStringUtils.isNotEmpty((String)reportField.getSortord()) || SortEnum.NONE.getValue().equals(reportField.getSortord())) continue;
            sortFields.add(reportField);
            if (reportField.getFieldSort() == null) continue;
            ReportField copyField = new ReportField();
            copyField.setFieldAlias(reportField.getFieldAlias());
            copyField.setUniqueKey(reportField.getUniqueKey());
            copyField.setFieldId(reportField.getFieldId());
            copyField.setSortord(SortEnum.ASC.getValue());
            copyField.setFieldSeq(reportField.getFieldSeq());
            copyField.setFieldType(reportField.getFieldType());
            sortFields.add(copyField);
        }
        return sortFields;
    }

    @ExcludeFromJacocoGeneratedReport
    public static VirtualEntityQueryParamInfo getVirtualEntityQueryParamInfoWithColList(HRComplexObjContext oldContext, HRComplexObjContext newContext, List<ReportField> reportFields) {
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = oldContext.getVirtualEntityQueryParamInfo();
        Map<String, ReportField> reportFieldMap = reportFields.stream().collect(Collectors.toMap(ReportField::getFieldAlias, field -> field, (x, y) -> x));
        if (virtualEntityQueryParamInfo != null) {
            virtualEntityQueryParamInfo.setColumnDimensionList(newContext.getComplexObjFieldInfoList().stream().map(fieldInfo -> {
                VirtualFieldInfo virtualFieldInfo = new VirtualFieldInfo(Long.valueOf(0L), fieldInfo.getAlias(), "");
                ReportField reportField = (ReportField)reportFieldMap.get(fieldInfo.getAlias());
                virtualFieldInfo.setFieldPath(fieldInfo.getFullPath());
                virtualFieldInfo.setFieldValueType(fieldInfo.getDataType());
                virtualFieldInfo.setVirtualEntityId(String.valueOf(virtualEntityQueryParamInfo.getVirtualEntityInfo().getId()));
                virtualFieldInfo.setCommonField(HRStringUtils.isNotEmpty((String)fieldInfo.getFullPath()));
                if (reportField instanceof EntityPropField) {
                    virtualFieldInfo.setControlType(((EntityPropField)reportField).getFieldControlType());
                    virtualFieldInfo.setComplexType(((EntityPropField)reportField).getFieldComplexType());
                }
                return virtualFieldInfo;
            }).collect(Collectors.toList()));
            List<SortFieldInfo> sortFieldInfoList = SortFieldUtil.genSortFieldInfos(reportFields, virtualEntityQueryParamInfo.getReportId());
            LinkedHashMap sortFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)sortFieldInfoList.size());
            for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
                sortFieldMap.put(sortFieldInfo.getFieldAlias(), sortFieldInfo.getSortord());
            }
            virtualEntityQueryParamInfo.setColSortFieldsMap(sortFieldMap);
        }
        return virtualEntityQueryParamInfo;
    }

    public static List<AlgoXCalculateAlgoXField> getLatitudeFieldList(List<ReportField> fieldList, Map<String, AlgoXLatitudeAlgoXField> latitudeFieldMap, Map<String, AlgoXAggregateIndexAlgoXField> aggregateIndexFieldMap) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)fieldList.size());
        fieldMap.putAll(latitudeFieldMap.values().stream().filter(algoXLatitudeAlgoXField -> !algoXLatitudeAlgoXField.getLatitudeField().isDependField()).collect(Collectors.toMap(AlgoXField::getAlgoXAliasExtend, Function.identity())));
        fieldMap.putAll(aggregateIndexFieldMap.values().stream().filter(algoXAggregateIndexAlgoXField -> !algoXAggregateIndexAlgoXField.getAggregateIndexField().isIndexField()).filter(algoXAggregateIndexAlgoXField -> !algoXAggregateIndexAlgoXField.getAggregateIndexField().isDependField()).collect(Collectors.toMap(AlgoXField::getAlgoXAliasExtend, Function.identity())));
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)fieldList.size());
        for (ReportField field : fieldList) {
            String algoXAliasExtend = AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)field.getFieldAlias()), field.getUniqueKey());
            AlgoXCalculateAlgoXField algoXField = (AlgoXCalculateAlgoXField)fieldMap.get(algoXAliasExtend);
            if (algoXField == null) continue;
            returnList.add(algoXField);
        }
        return returnList;
    }

    public static void addToAllAliasFieldMap(AlgoXField field, Map<String, Map<String, AlgoXField>> allAliasFieldMap) {
        if (field == null || field.getAlgoXAlias() == null || field instanceof AlgoXOrderAlgoXField) {
            return;
        }
        allAliasFieldMap.putIfAbsent(field.getAlgoXAlias(), Maps.newHashMapWithExpectedSize((int)16));
        allAliasFieldMap.computeIfPresent(field.getAlgoXAlias(), (key, map) -> {
            map.put(field.getAlgoXAliasExtend(), field);
            return map;
        });
    }
}

