/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.chart.adapter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.chart.adapter.AbstractRptChartQueryAdapter;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.chart.RptBarChartResult;

public class RptBarChartQueryAdapter
extends AbstractRptChartQueryAdapter {
    @Override
    public void assembleReportField(ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        reportQueryParamInfo.setLimit(this.queryThreshold + 1);
        reportQueryParamInfo.setStart(0);
        List<FieldInfo> indexes = reportManageConfigInfo.getColumns();
        List rowIndexes = indexes.stream().map(RowFieldInfo::new).collect(Collectors.toList());
        reportManageConfigInfo.getRows().addAll(rowIndexes);
        reportManageConfigInfo.getColumns().clear();
        List<FieldInfo> legend = reportManageConfigInfo.getReportConfig().getLegend();
        if (legend != null && !legend.isEmpty()) {
            reportManageConfigInfo.getColumns().addAll(legend);
        }
        reportManageConfigInfo.getReportConfig().setType("0");
    }

    @Override
    protected void doAdaptChartData(ReportQueryParamInfo reportQueryParamInfo, ReportInfo reportInfo) {
        ReportManageConfigInfo rptManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportHeadInfo head = reportInfo.getHead();
        List<ReportBodyRowInfo> body = reportInfo.getBody();
        RptBarChartResult chartResult = new RptBarChartResult();
        ArrayList dataset = Lists.newArrayListWithCapacity((int)16);
        List<String> rowDims = this.getRowDims(head, rptManageConfigInfo, chartResult);
        List<Object> typeList = this.collectTypes(body, rowDims, chartResult);
        dataset.add(typeList);
        List<String> legendList = this.getLegendList(head, rptManageConfigInfo);
        ArrayList legendNameList = Lists.newArrayListWithExpectedSize((int)legendList.size());
        for (String legend : legendList) {
            ArrayList dataList = Lists.newArrayListWithCapacity((int)16);
            String legendName = this.getLegendName(legend, rptManageConfigInfo);
            dataList.add(legendName);
            legendNameList.add(legendName);
            if (body.size() > 0) {
                ReportBodyRowInfo firstRowInfo = body.get(0);
                int cellIndex = this.findCellIndexForLegend(firstRowInfo.getR(), legend);
                for (ReportBodyRowInfo reportBodyRowInfo : body) {
                    ReportBodyCellInfo cellInfo = reportBodyRowInfo.getR().get(cellIndex);
                    dataList.add(cellInfo.getV());
                }
            }
            dataset.add(dataList);
        }
        chartResult.setLegend(legendNameList);
        chartResult.setDataSet(dataset);
        reportInfo.setChartResult(chartResult);
    }

    private int findCellIndexForLegend(List<ReportBodyCellInfo> cellInfoList, String legend) {
        int size = cellInfoList.size();
        for (int i = 0; i < size; ++i) {
            String key = cellInfoList.get(i).getK();
            if (key.contains("\u03b2")) {
                key = key.substring(0, key.indexOf("\u03b2"));
            }
            if (!HRStringUtils.equals((String)legend, (String)key)) continue;
            return i;
        }
        return 0;
    }

    private List<String> getLegendList(ReportHeadInfo head, ReportManageConfigInfo reportManageConfigInfo) {
        if (this.hasLegendField(reportManageConfigInfo)) {
            return head.getHf().stream().filter(ReportHeadRowInfo::getHasChildren).map(ReportHeadRowInfo::getCodeAlias).collect(Collectors.toList());
        }
        List indexes = reportManageConfigInfo.getCurWorkRpt().getRows().stream().filter(rowField -> HRStringUtils.equals((String)rowField.getGroupName().getType(), (String)"2")).map(rowField -> rowField.getGroupName().getNumberAlias()).collect(Collectors.toList());
        return head.getHf().stream().map(ReportHeadRowInfo::getCodeAlias).filter(indexes::contains).collect(Collectors.toList());
    }

    private boolean hasLegendField(ReportManageConfigInfo reportManageConfigInfo) {
        List<FieldInfo> legend = reportManageConfigInfo.getReportConfig().getLegend();
        return legend != null && !legend.isEmpty();
    }

    private String getLegendName(String legend, ReportManageConfigInfo reportManageConfigInfo) {
        List<FieldInfo> legendList = reportManageConfigInfo.getReportConfig().getLegend();
        if (legendList != null && !legendList.isEmpty()) {
            return legend;
        }
        Optional<String> nameOp = reportManageConfigInfo.getCurWorkRpt().getRows().stream().filter(rowField -> HRStringUtils.equals((String)rowField.getGroupName().getNumberAlias(), (String)legend)).map(rowFieldInfo -> rowFieldInfo.getGroupName().getDisplayName().getLocaleValue()).findFirst();
        return nameOp.orElse(legend);
    }
}

