/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.func.algo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hrptmc.common.constant.repcalculate.RepCalculateConstants;

public class RemoveIndexSuffixFunction
extends MapFunction {
    private static final long serialVersionUID = 2834650449726143255L;
    private final RowMeta rowMeta;

    public RemoveIndexSuffixFunction(RowMeta rowMeta) {
        this.rowMeta = this.buildRowMeta(rowMeta);
    }

    public Object[] map(Row row) {
        int fieldCount = this.rowMeta.getFieldCount();
        Object[] data = new Object[fieldCount];
        for (int index = 0; index < fieldCount; ++index) {
            data[index] = row.get(index);
        }
        return data;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowMeta buildRowMeta(RowMeta originalRowMeta) {
        Field[] fields = originalRowMeta.getFields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.length);
        for (Field field : fields) {
            String suffix;
            String[] split;
            String alias = field.getAlias();
            if (alias.contains("\u03b1") && (split = alias.split("\u03b1")).length > 1 && !RepCalculateConstants.NOT_NEED_REMOVE_SUFFIX_SET.contains(suffix = split[1])) {
                alias = split[0];
            }
            newFields.add(new Field(alias, field.getDataType()));
        }
        return new RowMeta(newFields.toArray(new Field[0]));
    }
}

