/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.cache.es;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportRow;
import kd.hr.hrptmc.business.repcalculate.org.cache.AdminOrgCacheInterface;
import kd.hr.hrptmc.business.repcalculate.org.cache.es.ReportEsStorageService;
import kd.hr.hrptmc.business.repcalculate.org.constants.ReportOrgConstants;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AdminOrgEsCache
implements AdminOrgCacheInterface,
ReportOrgConstants {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgEsCache.class);
    public static final String ES_INDEX_NAME_PREFIX = "es_report_tree_prefix_";

    @Override
    public ReportResult getCacheCalResult(String pageId, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            RowMeta rowMeta;
            long parentOrgId = adminOrgSummaryInfo._getRootOrgId();
            if (parentOrgId == 0L) {
                parentOrgId = OrgUnitServiceHelper.getRootOrgId();
            }
            if ((rowMeta = this.buildRowMeta(pageId)) == null) {
                return null;
            }
            QFilter parentOrgIdFilter = new QFilter("longOrgId", "like", (Object)String.valueOf(parentOrgId));
            EsResultVo esResultVo = ReportEsStorageService.queryByFilters(this.getEsIndexName(pageId), AdminOrgEsCache.getSelectFieldNames(), Lists.newArrayList((Object[])new QFilter[]{parentOrgIdFilter}), true, 0, 100000);
            Map<Long, CalResult> calResultMapByEsDto = this.getCalResultMapByEsDto(esResultVo, rowMeta);
            if (calResultMapByEsDto != null) {
                Integer returnLevel = CalResult.getReturnLevel(adminOrgSummaryInfo);
                CalResult parentResult = calResultMapByEsDto.get(parentOrgId);
                if (parentResult != null) {
                    List<CalResult> childResultList = parentResult.getChildResultList();
                    if (childResultList != null) {
                        for (CalResult child : childResultList) {
                            CalResult.cutLevelData(child, returnLevel, CalResult.getBottomIsNull(adminOrgSummaryInfo, returnLevel + 1));
                        }
                    }
                    return new ReportResult(rowMeta, Lists.newArrayList((Object[])new CalResult[]{parentResult}));
                }
            }
        }
        return null;
    }

    @Override
    public void putCalResultIntoCache(String pageId, RowMeta rowMeta, List<CalResult> calResults) {
        List<EsBatchValue> dtoList;
        if (HRStringUtils.isNotEmpty((String)pageId) && (dtoList = this.buildCacheList(pageId, calResults)) != null && !dtoList.isEmpty() && rowMeta != null) {
            this.putRowMetaIntoCache(pageId, rowMeta);
            QFilter pageIdFilter = new QFilter("pageId", "=", (Object)pageId);
            ReportEsStorageService.createIndex(this.getEsIndexName(pageId));
            ReportEsStorageService.deleteByQuery(this.getEsIndexName(pageId), Lists.newArrayList((Object[])new QFilter[]{pageIdFilter}));
            ReportEsStorageService.batchSave(this.getEsIndexName(pageId), dtoList.toArray(new EsBatchValue[0]));
        }
    }

    @Override
    public boolean cleanCalResultCache(String pageId) {
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            return ReportEsStorageService.deleteIndex(this.getEsIndexName(pageId));
        }
        return true;
    }

    @Override
    public boolean clearCalResultCache(String index) {
        if (HRStringUtils.isNotEmpty((String)index)) {
            return ReportEsStorageService.removeIndices(index);
        }
        return true;
    }

    @Override
    public boolean isCacheServiceHeath() {
        try {
            return ReportEsStorageService.ping();
        }
        catch (Exception e) {
            LOGGER.error("es_ping_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    private String getEsIndexName(String pageId) {
        return ES_INDEX_NAME_PREFIX + pageId;
    }

    private static String[] getSelectFieldNames() {
        return new String[]{"orgId", "parentOrgId", "longOrgId", "values"};
    }

    public List<EsBatchValue> buildCacheList(String pageId, List<CalResult> calResults) {
        if (calResults == null) {
            return null;
        }
        ArrayList cacheList = Lists.newArrayListWithExpectedSize((int)calResults.size());
        for (CalResult calResult : calResults) {
            this.putCalResultIntoEsCacheList(pageId, cacheList, calResult);
        }
        return cacheList;
    }

    private void putCalResultIntoEsCacheList(String pageId, List<EsBatchValue> list, CalResult calResult) {
        EsBatchValue esValue = this.convertToEsDto(pageId, calResult);
        list.add(esValue);
        List<CalResult> childResultList = calResult.getChildResultList();
        if (childResultList != null && !childResultList.isEmpty()) {
            for (CalResult child : childResultList) {
                this.putCalResultIntoEsCacheList(pageId, list, child);
            }
        }
    }

    private EsBatchValue convertToEsDto(String pageId, CalResult calResult) {
        EsPropertyValue[] propertyValues = new EsPropertyValue[5];
        propertyValues[0] = new EsPropertyValue("orgId", EsDataType.LONG, (Object)calResult.getOrgId());
        propertyValues[1] = new EsPropertyValue("parentOrgId", EsDataType.LONG, (Object)calResult.getParentOrgId());
        propertyValues[2] = new EsPropertyValue("longOrgId", EsDataType.TEXT, (Object)calResult.getLongOrgId());
        propertyValues[3] = new EsPropertyValue("pageId", EsDataType.TEXT, (Object)pageId);
        Object[] values = null;
        Row rowData = calResult.getRowData();
        if (rowData instanceof AbstractRow) {
            values = ((AbstractRow)rowData).values();
        } else if (rowData.size() != 0) {
            values = new Object[rowData.size()];
            for (int loopIndex = 0; loopIndex < rowData.size(); ++loopIndex) {
                values[loopIndex] = rowData.get(loopIndex);
            }
        }
        if (values != null) {
            propertyValues[4] = new EsPropertyValue("values", EsDataType.ARRAY, (Object)Arrays.stream(values).map(value -> {
                if (value != null) {
                    return String.valueOf(value);
                }
                return null;
            }).toArray());
        }
        return new EsBatchValue((Object)calResult.getOrgId(), propertyValues);
    }

    private Map<Long, CalResult> getCalResultMapByEsDto(EsResultVo esResultVo, RowMeta rowMeta) {
        List resultData = esResultVo.getResultData();
        if (resultData != null) {
            HashMap resultTempMap = Maps.newHashMapWithExpectedSize((int)resultData.size());
            HashMap childrenTempMap = Maps.newHashMapWithExpectedSize((int)resultData.size());
            for (Map dataMap : resultData) {
                CalResult calResult = new CalResult();
                calResult.setOrgId(dataMap.get("orgId") != null ? Long.valueOf(Long.parseLong(String.valueOf(dataMap.get("orgId")))) : null);
                calResult.setParentOrgId(dataMap.get("parentOrgId") != null ? Long.valueOf(Long.parseLong(String.valueOf(dataMap.get("parentOrgId")))) : null);
                List valueList = (List)dataMap.get("values");
                Object[] values = valueList != null ? valueList.toArray() : new Object[rowMeta.getFieldCount()];
                ReportRow row = new ReportRow(rowMeta, values);
                calResult.setRowData((Row)row);
                resultTempMap.put(calResult.getOrgId(), calResult);
                CalResult parent = (CalResult)resultTempMap.get(calResult.getParentOrgId());
                if (parent == null) {
                    childrenTempMap.putIfAbsent(calResult.getParentOrgId(), Lists.newArrayListWithExpectedSize((int)10));
                    childrenTempMap.computeIfPresent(calResult.getParentOrgId(), (key, value) -> {
                        value.add(calResult);
                        return value;
                    });
                } else {
                    parent.addChildResult(calResult);
                }
                calResult.setChildResultList((List)childrenTempMap.get(calResult.getOrgId()));
                childrenTempMap.remove(calResult.getOrgId());
            }
            return resultTempMap;
        }
        return null;
    }
}

