/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class AdminOrgLatitudeReduceGroupFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 6454616749837286018L;
    private final RowMeta rowMeta;

    public AdminOrgLatitudeReduceGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        Field[] fields = this.rowMeta.getFields();
        Object[] resultRow = new Object[this.rowMeta.getFieldCount()];
        while (iterator.hasNext()) {
            Row row = iterator.next();
            for (int index = 0; index < fields.length; ++index) {
                String aliasName = fields[index].getName();
                if (aliasName.contains("\u03b1")) {
                    this.setCalculateResultRow(resultRow, row, index, aliasName);
                    continue;
                }
                Object value = row.get(index);
                if (value == null) continue;
                resultRow[index] = value;
            }
        }
        collector.collect(resultRow);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void setCalculateResultRow(Object[] resultRow, Row row, int index, String aliasName) {
        String[] tempArr = aliasName.split("\u03b1");
        String fieldName = tempArr[0];
        String calculateSuffix = tempArr[1];
        if ("sum".equals(calculateSuffix) || "count".equals(calculateSuffix) || "avgsum".equals(calculateSuffix) || "avgcount".equals(calculateSuffix)) {
            this.setSumCalculateResultRow(resultRow, row, index);
        }
        if ("avg".equals(calculateSuffix)) {
            this.setAvgCalculateResultRow(resultRow, row, index, fieldName);
        }
    }

    private BigDecimal setSumCalculateResultRow(Object[] resultRow, Row row, int index) {
        BigDecimal calculateVal = row.getBigDecimal(index);
        Object resultValue = resultRow[index];
        BigDecimal nowVal = resultValue instanceof Integer ? new BigDecimal((Integer)resultValue) : (resultValue instanceof BigDecimal ? (BigDecimal)resultRow[index] : BigDecimal.ZERO);
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRow[index] = this.convertBigDecimalValueType(nowVal, index);
        return nowVal;
    }

    public void setAvgCalculateResultRow(Object[] resultRow, Row row, int index, String fieldName) {
        String avgSumFieldName = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.rowMeta.getFieldIndex(avgSumFieldName);
        BigDecimal sumVal = this.setSumCalculateResultRow(resultRow, row, avgSumIndex);
        String countFieldName = fieldName + '\u03b1' + "avgcount";
        int countFieldIndex = this.rowMeta.getFieldIndex(countFieldName);
        BigDecimal countVal = this.setSumCalculateResultRow(resultRow, row, countFieldIndex);
        if (countVal.equals(BigDecimal.ZERO)) {
            resultRow[index] = null;
            return;
        }
        BigDecimal avgVal = sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRow[index] = avgVal;
    }

    private Object convertBigDecimalValueType(BigDecimal bigDecimal, int fieldIndex) {
        Field field = this.rowMeta.getField(fieldIndex);
        Number resultValue = DataType.IntegerType.equals((Object)field.getDataType()) ? (Number)bigDecimal.intValue() : (Number)(DataType.LongType.equals((Object)field.getDataType()) ? Long.valueOf(bigDecimal.longValue()) : bigDecimal);
        return resultValue;
    }
}

