/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.algox.helper.AlgoxJobKeyHelper;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgFlatMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLongNumberMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgGroupHandler;
import kd.hr.hrptmc.business.repcalculate.org.model.AdminOrg;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class AdminOrgHandler
extends ReportCalculateHandler {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgGroupHandler.class);
    private final AdminOrgSummaryInfo adminOrgSummaryInfo;
    private static final String SESSION_JOB_NAME = "HR_REPORT_ADMIN_ORG_JOB_GROUP";
    private static final String SESSION_JOB_TITLE = "HR_REPORT_ADMIN_ORG_JOB_GROUP_TITLE";
    private String algoXJobKey;
    private final boolean isAlgoX;

    public AdminOrgHandler(ReportCalculateInfo calculateInfo, boolean isAlgoX) {
        super(calculateInfo);
        this.adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        this.isAlgoX = isAlgoX;
        if (calculateInfo.getAnObjRelId() == null || calculateInfo.getAnObjRelId() == 0L) {
            return;
        }
        this.algoXJobKey = calculateInfo.getReportId() != null && calculateInfo.getReportId() != 0L ? AlgoxJobKeyHelper.getRepAlgoxJobKeyByReportmanage(calculateInfo.getReportId()) : AlgoxJobKeyHelper.getRepAlgoxJobKeyByAnalyseObject(calculateInfo.getAnObjRelId());
    }

    @Override
    public DataSet doHandler(DataSet dataSet) {
        if (this.hasPresetIndex()) {
            this.calculateInfo.getCostTimeHelper().nestedStart();
            LOGGER.info("[repcalculate-ALGOX] AdminOrgGroupHandler doHandler for preset index algoXJobKey:{}", (Object)this.algoXJobKey);
            AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
            if (adminOrgSummaryInfo != null && (adminOrgSummaryInfo.getTreeShow() || adminOrgSummaryInfo.getIncludeSubOrg())) {
                int orgFieldAliasIndex;
                int orgIdIndex;
                DataSet copy;
                HashMap<Long, String> adminOrgValueMap;
                AdminOrg rootOrg;
                block9: {
                    Map<Long, AdminOrg> adminOrgMap = adminOrgSummaryInfo.getAdminOrgIdMap();
                    rootOrg = adminOrgMap.get(adminOrgSummaryInfo._getRootOrgId());
                    if (rootOrg == null) {
                        return this.doNext(dataSet);
                    }
                    adminOrgValueMap = new HashMap<Long, String>(16);
                    copy = dataSet.copy();
                    String adminOrgSelectField = adminOrgSummaryInfo.getAdminOrgSelectField();
                    String adminOrgFieldAlias = adminOrgSummaryInfo.getAdminOrgFieldAlias();
                    if (this.isAlgoX) {
                        adminOrgSelectField = adminOrgSelectField.replace(".", "_DOC_SPLIT_");
                        adminOrgFieldAlias = adminOrgFieldAlias.replace(".", "_DOC_SPLIT_");
                    }
                    orgIdIndex = copy.getRowMeta().getFieldIndex(adminOrgSelectField);
                    orgFieldAliasIndex = -1;
                    if (this.calculateInfo.getStoreFieldMapList() != null && !this.calculateInfo.getStoreFieldMapList().isEmpty()) {
                        for (RptMetaFieldMap rptMetaFieldMap : this.calculateInfo.getStoreFieldMapList()) {
                            if (!HRStringUtils.equals((String)rptMetaFieldMap.getMetaFieldNumber(), (String)adminOrgSelectField)) continue;
                            String suffix = adminOrgFieldAlias.substring(adminOrgFieldAlias.lastIndexOf("."));
                            String originNum = rptMetaFieldMap.getFieldAlias().replace(".id", suffix);
                            for (RptMetaFieldMap metaFieldMap : this.calculateInfo.getStoreFieldMapList()) {
                                if (!HRStringUtils.equals((String)metaFieldMap.getFieldAlias(), (String)originNum)) continue;
                                orgFieldAliasIndex = copy.getRowMeta().getFieldIndex(metaFieldMap.getMetaFieldNumber());
                                break block9;
                            }
                            break;
                        }
                    } else {
                        orgFieldAliasIndex = copy.getRowMeta().getFieldIndex(adminOrgFieldAlias);
                    }
                }
                for (Row row : copy) {
                    Long orgId = row.getLong(orgIdIndex);
                    String orgName = row.getString(orgFieldAliasIndex);
                    adminOrgValueMap.put(orgId, orgName);
                }
                DataSetBuilder dataSetBuilder = Algo.create((String)"AdminOrgQuery").createDataSetBuilder(dataSet.getRowMeta());
                String showField = adminOrgSummaryInfo.getAdminOrgFieldAlias().substring(adminOrgSummaryInfo.getAdminOrgFieldAlias().lastIndexOf(".") + 1);
                this.buildAdminOrgRow("", rootOrg, orgIdIndex, orgFieldAliasIndex, showField, dataSetBuilder, dataSet.getRowMeta(), adminOrgValueMap);
                DataSet build = dataSetBuilder.build();
                dataSet = dataSet.union(build);
                String traceId = TraceIdUtil.getCurrentTraceIdString();
                JobSession session = AlgoX.createSession((String)(SESSION_JOB_NAME + this.algoXJobKey + "_" + traceId), (String)(SESSION_JOB_TITLE + this.algoXJobKey + "_" + traceId));
                DataSetX dataSetX = session.fromInput((Input)new DataSetInput(dataSet));
                DataSetX addLongStructNumberDataSetX = dataSetX.map((MapFunction)new AdminOrgLongNumberMapFunction(adminOrgSummaryInfo, dataSetX.getRowMeta()));
                RowMeta newRowMeta = addLongStructNumberDataSetX.getRowMeta();
                DataSetX newResultDataSetX = addLongStructNumberDataSetX.flatMap((FlatMapFunction)new AdminOrgFlatMapFunction(adminOrgSummaryInfo, newRowMeta, this.calculateInfo.getStoreFieldMapList()));
                DataSetOutput output = new DataSetOutput(newResultDataSetX.getRowMeta());
                String id = output.getId();
                newResultDataSetX.output((Output)output);
                session.commit(600, TimeUnit.SECONDS);
                dataSet = session.readDataSet(id);
                adminOrgSummaryInfo.setHasDoneFlatMap(true);
            }
            this.calculateInfo.getCostTimeHelper().logCost("AdminOrgHandler", "AdminOrgHandler");
        }
        return this.doNext(dataSet);
    }

    private void buildAdminOrgRow(String structLongNumber, AdminOrg currentOrg, int orgIdIndex, int orgFieldAliasIndex, String showField, DataSetBuilder dataSetBuilder, RowMeta rowMeta, Map<Long, String> adminOrgValueMap) {
        List<AdminOrg> childOrgList = currentOrg.getChildOrgList();
        long orgId = currentOrg.getOrgId();
        if (!adminOrgValueMap.containsKey(orgId)) {
            Field[] fields = rowMeta.getFields();
            Object[] rowValues = new Object[fields.length];
            for (int i = 0; i < rowValues.length; ++i) {
                rowValues[i] = i == orgIdIndex ? Long.valueOf(orgId) : (i == orgFieldAliasIndex ? currentOrg.getShowValue(showField) : null);
            }
            dataSetBuilder.append(rowValues);
        }
        if (childOrgList == null || childOrgList.isEmpty()) {
            return;
        }
        structLongNumber = HRStringUtils.isEmpty((String)structLongNumber) ? String.valueOf(currentOrg.getOrgId()) : structLongNumber + "!" + currentOrg.getOrgId();
        for (AdminOrg child : childOrgList) {
            Set structNumbers = Arrays.stream(structLongNumber.split("!")).collect(Collectors.toSet());
            if (!structNumbers.contains(String.valueOf(child.getOrgId()))) {
                this.buildAdminOrgRow(structLongNumber, child, orgIdIndex, orgFieldAliasIndex, showField, dataSetBuilder, rowMeta, adminOrgValueMap);
                continue;
            }
            LOGGER.info("AdminOrgHandler.buildAdminOrgRow: orgId: {}, orgNum: {}, orgLongNumber: {}", new Object[]{child.getOrgId(), child.getOrgNumber(), child.getStructLongNumber()});
        }
    }

    private boolean hasPresetIndex() {
        return this.calculateInfo.getRowFieldList().stream().anyMatch(field -> field instanceof PresetIndexField);
    }
}

