/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.handler;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLatitudeReduceGroupFunction;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class AdminOrgLatitudeReduceHandler
extends ReportCalculateHandler {
    private final AdminOrgSummaryInfo adminOrgSummaryInfo;
    private final boolean isAnBoPivot;
    private int start = -1;
    private int limit = -1;

    public AdminOrgLatitudeReduceHandler(ReportCalculateInfo calculateInfo) {
        super(calculateInfo);
        this.adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        this.isAnBoPivot = calculateInfo.isAnObjPivot() && calculateInfo.getAnObjPivotService() == null;
    }

    @Override
    public DataSet doHandler(DataSet dataSet) {
        if (this.isAdminOrgIncludeSub()) {
            String adminOrgIdAlias = this.adminOrgSummaryInfo.getAdminOrgSelectField();
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{adminOrgIdAlias});
            DataSet resultDataSet = groupbyDataSet.reduceGroup((ReduceGroupFunctionWithCollector)new AdminOrgLatitudeReduceGroupFunction(dataSet.getRowMeta()));
            if (this.start >= 0 && this.limit > 0) {
                resultDataSet = resultDataSet.range(this.start, this.limit);
            }
            return this.doNext(resultDataSet);
        }
        return this.doNext(dataSet);
    }

    protected boolean isAdminOrgIncludeSub() {
        return !this.isAnBoPivot && this.adminOrgSummaryInfo != null && !this.adminOrgSummaryInfo.getTreeShow() && this.adminOrgSummaryInfo.getIncludeSubOrg() && this.adminOrgSummaryInfo.isOnlyGroupOrg();
    }

    public AdminOrgLatitudeReduceHandler setPagingConfig(int start, int limit) {
        this.start = start;
        this.limit = limit;
        return this;
    }
}

