/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repcalculate.org.cache.AdminOrgCacheConfig;
import kd.hr.hrptmc.business.repcalculate.org.cache.AdminOrgCacheFactory;
import kd.hr.hrptmc.business.repcalculate.org.cache.AdminOrgCacheInterface;
import kd.hr.hrptmc.business.repcalculate.org.model.AdminOrg;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.AuthorityInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AdminOrgCalHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgCalHelper.class);
    private static final String META_NUMBER_HRPTMC_REPORT_PREVIEW = "hrptmc_report_preview";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"AdminOrgCalHelperThreadPool", (int)ZkConfig.getNumOfWorkThread());
    public static final String ADMIN_ORG_TREE_DATA_LOCK_PREFIX = "admin_org_tree_data_lock_prefix_";

    public static AuthorizedOrgResult getAuthorityOrgResult(AuthorityInfo authorityInfo) {
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSetWithDate", (Object[])new Object[]{authorityInfo.getUserId(), authorityInfo.getAppId(), authorityInfo.getEntityNumber(), authorityInfo.getPermItemId(), authorityInfo.getPropKey(), authorityInfo.getDate(), authorityInfo.getDate()});
    }

    public static ReportResult buildReportResult(ReportCalculateInfo reportCalculateInfo, String pageId, DataSet dataSet) {
        int fieldIndex;
        AdminOrgSummaryInfo adminOrgSummaryInfo = reportCalculateInfo.getAdminOrgSummaryInfo();
        List<ReportField> rowFieldListWithoutDp = reportCalculateInfo.getRowFieldListWithoutDp(false);
        RowMeta rowMeta = dataSet.getRowMeta();
        if (adminOrgSummaryInfo != null && HRStringUtils.isNotEmpty((String)adminOrgSummaryInfo.getAdminOrgSelectField()) && (fieldIndex = rowMeta.getFieldIndex(adminOrgSummaryInfo.getAdminOrgSelectField(), false)) != -1) {
            boolean findAdminField = false;
            for (ReportField reportField : rowFieldListWithoutDp) {
                if (!reportField.getFieldAlias().equals(adminOrgSummaryInfo.getAdminOrgFieldPrefix() + ".name") && !reportField.getFieldAlias().equals(adminOrgSummaryInfo.getAdminOrgFieldPrefix() + ".number")) continue;
                findAdminField = true;
                break;
            }
            if (!findAdminField) {
                Object[] fields = rowMeta.getFields();
                ArrayList newFields = Lists.newArrayList((Object[])fields);
                newFields.remove(fieldIndex);
                rowMeta = new RowMeta(newFields.toArray(new Field[0]));
            }
        }
        return new ReportResult(rowMeta, CalResult.buildResult(adminOrgSummaryInfo, pageId, dataSet));
    }

    public static boolean buildAdminOrgStructure(ReportCalculateInfo calculateInfo) {
        Long admOrgArchitectureId;
        AuthorizedOrgResult authorizedOrgResult;
        AdminOrgSummaryInfo adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        List<Long> rootOrgIds = adminOrgSummaryInfo.getAdminOrgIds();
        Date date = adminOrgSummaryInfo.getDate();
        if (date == null) {
            date = new Date();
        }
        calculateInfo.getCostTimeHelper().nestedStart(false);
        AuthorityInfo authorityInfo = adminOrgSummaryInfo.getAuthorityInfo();
        List authorityOrgIds = null;
        if (authorityInfo != null && !META_NUMBER_HRPTMC_REPORT_PREVIEW.equals(authorityInfo.getEntityNumber()) && (authorizedOrgResult = AdminOrgCalHelper.getAuthorityOrgResult(authorityInfo)) != null && !authorizedOrgResult.isHasAllOrgPerm()) {
            authorityOrgIds = authorizedOrgResult.getHasPermOrgs();
        }
        if ((admOrgArchitectureId = adminOrgSummaryInfo.getAdmOrgArchitectureId()) == null) {
            admOrgArchitectureId = 1010L;
        }
        Integer querySubLevel = adminOrgSummaryInfo.getQuerySubLevel();
        LOGGER.info("adminOrg_batchGetAllSubOrg_querySubLevel={}", (Object)querySubLevel);
        int level = 15;
        if (!adminOrgSummaryInfo.getTreeShow() && !adminOrgSummaryInfo.getIncludeSubOrg() && querySubLevel != null) {
            level = querySubLevel;
        }
        Map orgResults = null;
        calculateInfo.getCostTimeHelper().logCost("adminOrg_getAuthorityOrgIds", true, "adminOrg_getAuthorityOrgIds");
        LOGGER.info("adminOrg_batchGetAllSubOrg_rootOrgIds={}", rootOrgIds);
        LOGGER.info("adminOrg_batchGetAllSubOrg_admOrgArchitectureId={}", (Object)admOrgArchitectureId);
        orgResults = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructInfoByProIdAndLevel", (Object[])new Object[]{rootOrgIds, date, admOrgArchitectureId, level});
        calculateInfo.getCostTimeHelper().logCost("adminOrg_batchGetAllSubOrg", true, "adminOrg_batchGetAllSubOrg");
        if (orgResults != null && !orgResults.isEmpty()) {
            LOGGER.info("adminOrg_batchGetAllSubOrg_get_result_size_is_{}", (Object)orgResults.size());
            HashMap orgMap = Maps.newHashMapWithExpectedSize((int)orgResults.size());
            HashMap longNumberOrgMap = Maps.newHashMapWithExpectedSize((int)orgResults.size());
            HashMap childOrgList = Maps.newHashMapWithExpectedSize((int)orgResults.size());
            for (Map row : orgResults.values()) {
                Long orgId2 = (Long)row.get("boid");
                AdminOrg org = new AdminOrg();
                org.setOrgId(orgId2);
                org.setOrgNumber((String)row.get("number"));
                org.setOrgName((String)row.get("name"));
                org.setParentOrgId((Long)row.get("parentorg"));
                org.setStructLongNumber((String)row.get("structlongnumber"));
                org.setChildOrgList((List)childOrgList.remove(orgId2));
                orgMap.put(orgId2, org);
                longNumberOrgMap.put(org.getStructLongNumber(), org);
                AdminOrg parentOrg = (AdminOrg)orgMap.get(org.getParentOrgId());
                if (parentOrg == null) {
                    childOrgList.putIfAbsent(org.getParentOrgId(), Lists.newArrayListWithExpectedSize((int)10));
                    childOrgList.computeIfPresent(org.getParentOrgId(), (key, value) -> {
                        value.add(org);
                        return value;
                    });
                    continue;
                }
                parentOrg.addChildOrg(org);
            }
            if (authorityOrgIds != null) {
                authorityOrgIds.removeIf(orgId -> !orgMap.containsKey(orgId));
                adminOrgSummaryInfo.setAuthorityOrgIds(Sets.newHashSet((Iterable)authorityOrgIds));
            }
            adminOrgSummaryInfo.setAdminOrgIdMap(orgMap);
            adminOrgSummaryInfo.setAdminLongNumberMap(longNumberOrgMap);
            AdminOrgCalHelper.adminOrgDrillDown(adminOrgSummaryInfo);
            calculateInfo.getCostTimeHelper().logCost("adminOrg_buildStructure", "adminOrg_buildStructure");
            return true;
        }
        return false;
    }

    public static ReportResult getCacheCalResult(String pageId, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        try {
            return AdminOrgCalHelper.getAdminOrgCache().getCacheCalResult(pageId, adminOrgSummaryInfo);
        }
        catch (Exception e) {
            LOGGER.error("AdminOrgCalHelper_getCacheCalResult_error_pageId_{}_{}", (Object)pageId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static void putCalResultIntoCache(String pageId, RowMeta rowMeta, List<CalResult> calResults) {
        THREAD_POOL.execute(() -> {
            try (DLock lock = DLock.create((String)(ADMIN_ORG_TREE_DATA_LOCK_PREFIX + pageId));){
                lock.lock();
                AdminOrgCalHelper.getAdminOrgCache().putCalResultIntoCache(pageId, rowMeta, calResults);
            }
            catch (Exception exc) {
                LOGGER.error("AdminOrgCalHelper_putCalResultIntoCache_error_pageId_{}_{}", (Object)pageId, (Object)ExceptionUtils.getStackTrace((Throwable)exc));
            }
        });
    }

    public static boolean cleanCalResultCache(String pageId) {
        try {
            return AdminOrgCalHelper.getAdminOrgCache().cleanCalResultCache(pageId);
        }
        catch (Exception e) {
            LOGGER.error("AdminOrgCalHelper_cleanCalResultCache_error_pageId_{}_{}", (Object)pageId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    private static AdminOrgCacheInterface getAdminOrgCache() {
        return AdminOrgCacheFactory.getAdminOrgCache(AdminOrgCacheConfig.getAdminOrgCacheConfig());
    }

    private static void adminOrgDrillDown(AdminOrgSummaryInfo adminOrgSummaryInfo) {
        Integer querySubLevel;
        if (adminOrgSummaryInfo != null && (querySubLevel = adminOrgSummaryInfo.getQuerySubLevel()) != null) {
            List<Long> adminOrgIds = adminOrgSummaryInfo.getAdminOrgIds();
            Map<Long, AdminOrg> adminOrgIdMap = adminOrgSummaryInfo.getAdminOrgIdMap();
            HashSet newAdminOrgSet = Sets.newHashSetWithExpectedSize((int)16);
            for (Long adminOrgId : adminOrgIds) {
                AdminOrg parentOrg = adminOrgIdMap.get(adminOrgId);
                if (parentOrg == null) continue;
                newAdminOrgSet.addAll(AdminOrgCalHelper.getSubOrgIds(parentOrg, querySubLevel));
            }
            adminOrgSummaryInfo.setOriginalSelectAdminOrgIds(adminOrgIds);
            adminOrgSummaryInfo.setAdminOrgIds(Lists.newArrayList((Iterable)newAdminOrgSet));
        }
    }

    private static Set<Long> getSubOrgIds(AdminOrg parentOrg, int subLevel) {
        LinkedHashSet subOrgIds = Sets.newLinkedHashSetWithExpectedSize((int)16);
        subOrgIds.add(parentOrg.getOrgId());
        if (subLevel > 0) {
            --subLevel;
            List<AdminOrg> childOrgList = parentOrg.getChildOrgList();
            if (childOrgList != null) {
                for (AdminOrg childOrg : childOrgList) {
                    subOrgIds.add(childOrg.getOrgId());
                    subOrgIds.addAll(AdminOrgCalHelper.getSubOrgIds(childOrg, subLevel));
                }
            }
        }
        return subOrgIds;
    }
}

