/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hrptmc.business.repcalculate.utils.DimensionAllValueHelper;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class TransposeAllValueHelper
extends DimensionAllValueHelper {
    private final List<ReportField> columnFieldList;
    private final List<EntityPropField> showAllColumnValueFields;

    public TransposeAllValueHelper(HRComplexObjContext complexObjContext, List<ReportField> columnFieldList) {
        super(complexObjContext);
        this.showAllColumnValueFields = Lists.newArrayListWithExpectedSize((int)columnFieldList.size());
        this.columnFieldList = Lists.newArrayListWithExpectedSize((int)columnFieldList.size());
        for (ReportField reportField : columnFieldList) {
            EntityPropField entityPropField;
            String fieldAlias = reportField.getFieldAlias();
            if (fieldAlias.contains("!")) {
                reportField.setFieldType(DataTypeEnum.STRING.getDataTypeKey());
            }
            if (reportField instanceof EntityPropField && (entityPropField = (EntityPropField)reportField).isShowAllColValue()) {
                this.showAllColumnValueFields.add(entityPropField);
            }
            if (reportField.isDependField()) continue;
            this.columnFieldList.add(reportField);
        }
    }

    public List<Map<String, DimensionData>> getAllDimensionData(List<Map<String, DimensionData>> queryDims) {
        return this.getAllDimensionData(queryDims, this.getShowAllColValueSet());
    }

    public List<Map<String, DimensionData>> getAllDimensionData(List<Map<String, DimensionData>> queryDims, Map<String, List<DimensionData>> allColValues) {
        HashMap allDimensionDataMap = Maps.newHashMapWithExpectedSize((int)this.columnFieldList.size());
        for (ReportField colField : this.columnFieldList) {
            List<DimensionData> allDimensionData;
            List<DimensionData> dimensionData = queryDims.stream().filter(queryDim -> queryDim.get(colField.getFieldAlias()) != null).map(queryDim -> (DimensionData)queryDim.get(colField.getFieldAlias())).collect(Collectors.toList());
            if (allColValues != null && !allColValues.isEmpty() && (allDimensionData = allColValues.get(colField.getFieldAlias())) != null && !allDimensionData.isEmpty()) {
                dimensionData.addAll(allDimensionData);
            }
            allDimensionData = this.distinctDimensionData(colField, dimensionData);
            allDimensionDataMap.put(colField.getUniqueKey(), allDimensionData);
        }
        return this.exhaustAllDimensionData(this.columnFieldList.stream().map(ReportField::getUniqueKey).collect(Collectors.toList()), allDimensionDataMap);
    }

    public Map<String, List<DimensionData>> getShowAllColValueSet() {
        HashMap aliasToAllColValue = Maps.newHashMapWithExpectedSize((int)this.showAllColumnValueFields.size());
        for (EntityPropField propField : this.showAllColumnValueFields) {
            String propFullPath = propField.getPropFullPath();
            FieldControlType fieldControlType = propField.getFieldControlType();
            FieldComplexType fieldComplexType = propField.getFieldComplexType();
            String entityNumber = this.getEntityNumberFromFullPath(propFullPath);
            if (FieldControlType.COMBO == fieldControlType || FieldControlType.MUL_COMBO == fieldControlType) {
                String realEntityNumber = entityNumber;
                if (FieldComplexType.BASE_DATA == fieldComplexType || FieldComplexType.HIS_BASE_DATA == fieldComplexType || FieldComplexType.ADMIN_ORG == fieldComplexType) {
                    realEntityNumber = propField.getBaseDataNumber();
                }
                aliasToAllColValue.put(propField.getFieldAlias(), this.getEnumAllValue(realEntityNumber, this.getRealFieldNameFromFullPath(entityNumber, propFullPath), SortEnum.CUSTOM.getValue().equals(propField.getSortord())));
                continue;
            }
            if (FieldComplexType.BASE_DATA != fieldComplexType && FieldComplexType.HIS_BASE_DATA != fieldComplexType && FieldComplexType.ADMIN_ORG != fieldComplexType) continue;
            aliasToAllColValue.put(propField.getFieldAlias(), this.getBaseDataAllValue(fieldComplexType, propField.getBaseDataNumber(), this.getRealFieldNameFromFullPath(entityNumber, propFullPath), SortEnum.CUSTOM.getValue().equals(propField.getSortord())));
        }
        return aliasToAllColValue;
    }
}

