/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils.sort;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;

public class DimComparator
implements Comparator<Map<String, DimensionData>> {
    private final List<ReportField> sortedFields;
    private final Map<String, Map<String, Integer>> aliasCustomOrderMap;

    public DimComparator(List<ReportField> sortedFields) {
        this.sortedFields = sortedFields;
        this.aliasCustomOrderMap = this.initCustomOrderMap(sortedFields);
    }

    private Map<String, Map<String, Integer>> initCustomOrderMap(List<ReportField> sortedFields) {
        HashMap aliasCustomOrderMap = Maps.newHashMapWithExpectedSize((int)sortedFields.size());
        for (ReportField sortedField : sortedFields) {
            List<String> value;
            CustomSortInfo customSort;
            if (!SortEnum.CUSTOM.getValue().equals(sortedField.getSortord()) || (customSort = sortedField.getCustomSort()) == null || (value = customSort.getValue()) == null) continue;
            HashMap orderMap = Maps.newHashMapWithExpectedSize((int)value.size());
            for (int index = 0; index < value.size(); ++index) {
                orderMap.put(value.get(index), index);
            }
            aliasCustomOrderMap.put(sortedField.getUniqueKey(), orderMap);
        }
        return aliasCustomOrderMap;
    }

    @Override
    public int compare(Map<String, DimensionData> o1, Map<String, DimensionData> o2) {
        int compareResult = 0;
        for (ReportField sortedField : this.sortedFields) {
            String sorted = sortedField.getSortord();
            FieldSortInfo fieldSort = sortedField.getFieldSort();
            if (fieldSort != null) {
                sorted = fieldSort.getSort();
            }
            Object fieldValue1 = this.getOrderValue(sortedField, o1);
            Object fieldValue2 = this.getOrderValue(sortedField, o2);
            if (fieldValue1 != null && fieldValue2 != null) {
                String fieldType = sortedField.getRealFieldType();
                if (fieldSort != null) {
                    fieldType = fieldSort.getFieldType();
                }
                if (DataTypeEnum.DATETIME.getDataTypeKey().equals(fieldType)) {
                    Date fieldDateValue1 = this.convertDate(fieldValue1);
                    Date fieldDateValue2 = this.convertDate(fieldValue2);
                    compareResult = fieldDateValue1.compareTo(fieldDateValue2);
                } else {
                    compareResult = DataTypeEnum.BOOLEAN.getDataTypeKey().equals(fieldType) ? Boolean.valueOf(String.valueOf(fieldValue1)).compareTo(Boolean.valueOf(String.valueOf(fieldValue2))) : (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(fieldType) ? new BigDecimal(String.valueOf(fieldValue1)).compareTo(new BigDecimal(String.valueOf(fieldValue2))) : (fieldValue1 instanceof Integer && fieldValue2 instanceof Integer ? ((Integer)fieldValue1).compareTo((Integer)fieldValue2) : String.valueOf(fieldValue1).compareTo(String.valueOf(fieldValue2))));
                }
            } else {
                if (fieldValue1 == null && fieldValue2 == null) continue;
                if (fieldValue1 == null) {
                    return 1;
                }
                return -1;
            }
            if (compareResult == 0) continue;
            if (!SortEnum.DESC.getValue().equals(sorted)) break;
            compareResult *= -1;
            break;
        }
        return compareResult;
    }

    private Date convertDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return HRDateTimeUtils.parseDate((String)String.valueOf(value));
        }
        catch (ParseException e) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5931\u8d25\u3002\u65e5\u671f\u4e3a\u201c%1$s\u201d\u3002", (String)"DimComparator_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), value));
        }
    }

    private Object getOrderValue(ReportField field, Map<String, DimensionData> data) {
        String sorted = field.getSortord();
        FieldSortInfo fieldSort = field.getFieldSort();
        String fieldUniqueKey = field.getUniqueKey();
        DimensionData dimValue = data.get(fieldUniqueKey);
        if (SortEnum.CUSTOM.getValue().equals(sorted)) {
            if (field instanceof EntityPropField) {
                Map<String, Integer> orderMap = this.aliasCustomOrderMap.get(fieldUniqueKey);
                if (orderMap == null) {
                    return null;
                }
                if (dimValue != null) {
                    return orderMap.get(dimValue.getId());
                }
            }
        } else if (fieldSort != null) {
            return dimValue.getReferToOrderValue();
        }
        if (dimValue != null) {
            return dimValue.getValue();
        }
        return null;
    }
}

