/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FreezeInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportManageService
implements ReportManageConstants {
    private static final HRBaseServiceHelper RPT_MANAGE_HELPER = new HRBaseServiceHelper("hrptmc_reportmanage");
    private static final HRBaseServiceHelper WORK_RPT_HELPER = new HRBaseServiceHelper("hrptmc_workreport");
    private static final HRBaseServiceHelper ROW_FIELD_HELPER = new HRBaseServiceHelper("hrptmc_rowfield");
    private static final HRBaseServiceHelper COL_FIELD_HELPER = new HRBaseServiceHelper("hrptmc_colfield");
    private static final HRBaseServiceHelper RPT_CONFIG_HELPER = new HRBaseServiceHelper("hrptmc_reportconfig");
    private static final HRBaseServiceHelper CALC_FIELD_HELPER = new HRBaseServiceHelper("hrptmc_calculatefield");
    private static final HRBaseServiceHelper FILTER_HELPER = new HRBaseServiceHelper("hrptmc_filter");
    private static final HRBaseServiceHelper PRE_INDEX_HELPER = new HRBaseServiceHelper("hrptmc_reportpreindex");
    private static final HRBaseServiceHelper DIM_MAP_HELPER = new HRBaseServiceHelper("hrptmc_dimmap");
    private static final HRBaseServiceHelper RPT_QUERY_CONFIG_HELPER = new HRBaseServiceHelper("hrptmc_rptqueryconfig");
    private static final HRBaseServiceHelper CUSTOM_SORT_HELPER = new HRBaseServiceHelper("hrptmc_customsort");
    private static final HRBaseServiceHelper DISP_SCM_CHG_HELPER = new HRBaseServiceHelper("hrptmc_dispscmchg");
    private static final HRBaseServiceHelper DISP_SCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscm");
    private static final HRBaseServiceHelper ROW_DISP_SCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmrow");
    private static final HRBaseServiceHelper COL_DISP_SCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmcol");
    private static final HRBaseServiceHelper IDX_DISP_SCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmidx");
    private static final HRBaseServiceHelper USER_DISP_SCM_HELPER = new HRBaseServiceHelper("hrptmc_userdispscm");
    private static final HRBaseServiceHelper RPT_COM_REF_HELPER = new HRBaseServiceHelper("hrptmc_rptcomref");
    private static final HRBaseServiceHelper RPT_MARK_HELPER = new HRBaseServiceHelper("hrptmc_reportmark");
    private static final HRBaseServiceHelper RPT_MARK_CNT_HELPER = new HRBaseServiceHelper("hrptmc_rptmarkcontent");
    private static final HRBaseServiceHelper ALGORITHM_COL_HELPER = new HRBaseServiceHelper("hrptmc_algorithmcol");
    private static final HRBaseServiceHelper SPLIT_DATE_HELPER = new HRBaseServiceHelper("hrptmc_splitdate");
    private static final HRBaseServiceHelper PARAM_CONFIG_HELPER = new HRBaseServiceHelper("hrptmc_paramconfig");
    private static final HRBaseServiceHelper REPORT_MAPPING_HELPER = new HRBaseServiceHelper("hrptmc_reportmapping");
    private static final HRBaseServiceHelper JUMP_CONFIG_HELPER = new HRBaseServiceHelper("hrptmc_reportjump");
    private static final HRBaseServiceHelper REPORT_CENTER_HELPER = new HRBaseServiceHelper("hrptc_reportcenter");
    private static final HRBaseServiceHelper REPORT_GROUP_HELPER = new HRBaseServiceHelper("hrptc_reportgroup");
    private static final Log LOGGER = LogFactory.getLog(ReportManageService.class);
    private static final String USER_DISPSCM_SELECT_PROP = "rowentryentity,rowentryentity.seq,rowentryentity.rowfield,rowentryentity.rowsecondaryheader,rowentryentity.rowfreeze,rowentryentity.rowhide,colentryentity,colentryentity.seq,colentryentity.colfield,colentryentity.colhide,indexentryentity,indexentryentity.seq,indexentryentity.indexfield,indexentryentity.indexhide";

    public static DynamicObject getRptManage(Long id) {
        return RPT_MANAGE_HELPER.queryOne("id,name,anobjid,row,column,datafilter,drillingdrl", (Object)id);
    }

    public static Long getAnObjId(Long reportId) {
        DynamicObject rptDy = RPT_MANAGE_HELPER.queryOriginalOne("id,anobjid.id", (Object)reportId);
        if (rptDy == null) {
            return null;
        }
        return rptDy.getLong("anobjid.id");
    }

    public static DynamicObject getRptManage(String number) {
        return RPT_MANAGE_HELPER.queryOne("id,name,anobjid,row,column,datafilter,drillingdrl", new QFilter("number", "=", (Object)number));
    }

    public static DynamicObject getRptManage(Long rptManageId, Long anObjId) {
        return RPT_MANAGE_HELPER.queryOne(new QFilter[]{new QFilter("id", "=", (Object)rptManageId), new QFilter("anobjid.id", "=", (Object)anObjId)});
    }

    public static DynamicObject[] getBatchWorkRpt(Collection<Object> rptManageIds) {
        return WORK_RPT_HELPER.query("id,key,row,column,rptmanage,index", new QFilter[]{new QFilter("rptmanage", "in", rptManageIds)}, "index");
    }

    public static DynamicObject[] getWorkRpt(Long rptManageId) {
        return WORK_RPT_HELPER.query("id,key,row,column,rptmanage,index", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)}, "index");
    }

    public static DynamicObject[] loadWorkRpt(Long rptManageId) {
        return WORK_RPT_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteWorkRpt(Long rptManageId) {
        WORK_RPT_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static boolean isExistsRptId(Long id) {
        return RPT_MANAGE_HELPER.isExists((Object)id);
    }

    public static boolean isExistsRptNumber(String number) {
        return RPT_MANAGE_HELPER.isExists(new QFilter("number", "=", (Object)number));
    }

    public static boolean isExistsRptName(String name) {
        return RPT_MANAGE_HELPER.isExists(new QFilter("name", "=", (Object)name));
    }

    public static DynamicObject getRptBillHead(Long id) {
        return RPT_MANAGE_HELPER.queryOriginalOne("name,number,createorg,cloudid,anobjid,description", (Object)id);
    }

    public static DynamicObject[] getRowFields(long workRptId) {
        return ROW_FIELD_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
    }

    public static DynamicObject[] getRowFields(List<Long> rowFieldIds) {
        return ROW_FIELD_HELPER.loadDynamicObjectArray(rowFieldIds.toArray());
    }

    public static DynamicObject[] getColFields(long rptManageId) {
        return COL_FIELD_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObject[] getColFields(List<Long> colFieldIds) {
        return COL_FIELD_HELPER.loadDynamicObjectArray(colFieldIds.toArray());
    }

    public static DynamicObject getRptConfigNotNull(Long workRptId) {
        DynamicObject reportConfigDy = RPT_CONFIG_HELPER.loadDynamicObject(new QFilter("workrpt", "=", (Object)workRptId));
        if (reportConfigDy == null) {
            return RPT_CONFIG_HELPER.generateEmptyDynamicObject();
        }
        return reportConfigDy;
    }

    public static DynamicObject[] getBatchRptConfigs(Collection<Object> workRptIds) {
        return RPT_CONFIG_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static DynamicObject getRptConfig(Long workRptId) {
        return RPT_CONFIG_HELPER.loadDynamicObject(new QFilter("workrpt", "=", (Object)workRptId));
    }

    public static DynamicObject[] getRptConfigs(Long rptManageId) {
        return RPT_CONFIG_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteRows(List<Long> rowFieldIds) {
        ROW_FIELD_HELPER.delete(rowFieldIds.toArray());
    }

    public static void deleteRows(Long rptManageId) {
        ROW_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteRowsByWorkRpt(Long workRptId) {
        ROW_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
    }

    public static void deleteRowsByWorkRpts(List<Long> workRptIds) {
        ROW_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static void deleteCols(List<Long> colFieldIds) {
        COL_FIELD_HELPER.delete(colFieldIds.toArray());
    }

    public static void deleteCols(Long rptManageId) {
        COL_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteColsByWorkRpt(Long workRptId) {
        COL_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
    }

    public static void deleteColsByWorkRpts(List<Long> workRptIds) {
        COL_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static List<Long> getRptConfigId(Long rptManageId) {
        DynamicObject[] rptConfigDys = RPT_CONFIG_HELPER.queryOriginalArray("id", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        if (null == rptConfigDys || 0 == rptConfigDys.length) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(rptConfigDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static void deleteRptConfig(Long rptManageId) {
        RPT_CONFIG_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteRptCfgByWorkRpts(List<Long> workRptIds) {
        DynamicObject[] dys = RPT_CONFIG_HELPER.queryOriginalArray("id", new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
        List rptConfigIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ALGORITHM_COL_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptconfig", "in", rptConfigIds)});
        RPT_CONFIG_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
        JUMP_CONFIG_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static void deleteCalcField(Long rptManageId) {
        CALC_FIELD_HELPER.deleteByFilter(new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
    }

    public static void deletePreIdxRef(Long rptManageId) {
        PRE_INDEX_HELPER.deleteByFilter(new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
    }

    public static void deleteDimMapRef(Long workRptId) {
        DIM_MAP_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
    }

    public static void deleteDimMapByWorkRpts(List<Long> workRptIds) {
        DIM_MAP_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static void deleteFilter(Long rptManageId) {
        FILTER_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteFilterByQFilters(Long rptManageId, List<Long> longList) {
        FILTER_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("id", "not in", longList)});
    }

    public static DynamicObject[] queryFilter(Long rptManageId) {
        return FILTER_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteRptQueryConfig(Long rptManageId) {
        RPT_QUERY_CONFIG_HELPER.deleteByFilter(new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
    }

    public static boolean isEnableScheme(Long rptManageId) {
        DynamicObject dy = RPT_QUERY_CONFIG_HELPER.queryOriginalOne("enablescheme", new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
        if (dy == null) {
            return true;
        }
        return dy.getBoolean("enablescheme");
    }

    public static boolean isReportFileSourceType(long reportId) {
        DynamicObject reportDy = RPT_MANAGE_HELPER.queryOriginalOne("anobjid", (Object)reportId);
        long anObjId = reportDy.getLong("anobjid");
        return AnalyseObjectService.getInstance().isFileSourceAnObj(anObjId);
    }

    public static boolean isReportsFileSourceType(List<Object> reportIds) {
        DynamicObjectCollection reportDyCol = RPT_MANAGE_HELPER.queryOriginalCollection("anobjid", new QFilter[]{new QFilter("id", "in", reportIds)});
        Set<Long> anObjIds = reportDyCol.stream().map(dy -> dy.getLong("anobjid")).collect(Collectors.toSet());
        return AnalyseObjectService.getInstance().isFileSourceAnObjs(anObjIds);
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean isAdminOrgControl(QueryFieldBo queryFieldBo) {
        return FieldComplexType.BASE_DATA.getValue().equals(queryFieldBo.getComplexType()) && "bos_org".equals(queryFieldBo.getBaseDataNum()) && (queryFieldBo.getFieldNumber().endsWith(".name") || queryFieldBo.getFieldNumber().endsWith(".number"));
    }

    private static Map<String, String> entityAdminOrgMap(List<QueryFieldBo> queryFields) {
        Map<String, List<String>> entityAdminOrgMap = ReportManageService.getAdminOrgMap(queryFields);
        HashMap<String, String> entityFieldMap = new HashMap<String, String>(16);
        entityAdminOrgMap.forEach((key, value) -> {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)key);
            for (String adminOrgField : value) {
                ReportManageService.getEntityFieldMap(entityFieldMap, mainEntityType, adminOrgField, 0);
            }
        });
        return entityFieldMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void getEntityFieldMap(Map<String, String> entityFieldMap, MainEntityType mainEntityType, String adminOrgField, int index) {
        String field = adminOrgField.split("\\.")[index];
        IDataEntityProperty property = mainEntityType.findProperty(field);
        if (property instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)property;
            entityFieldMap.put(mainEntityType.getName() + "_" + adminOrgField, orgProp.getOrgFunc());
        } else if (property instanceof BasedataProp) {
            MainEntityType mainEntityType2 = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
            ReportManageService.getEntityFieldMap(entityFieldMap, mainEntityType2, adminOrgField, ++index);
        }
    }

    private static Map<String, List<String>> getAdminOrgMap(List<QueryFieldBo> queryFields) {
        HashMap<String, List<String>> adminOrgMap = new HashMap<String, List<String>>(16);
        for (QueryFieldBo queryFieldBo : queryFields) {
            if (queryFieldBo.isVirtualEntityField() || !ReportManageService.isAdminOrgControl(queryFieldBo)) continue;
            String entityNumber = queryFieldBo.getEntityNumber();
            if (!adminOrgMap.containsKey(entityNumber)) {
                ArrayList<String> adminOrgField = new ArrayList<String>(10);
                adminOrgField.add(queryFieldBo.getFieldNumber());
                adminOrgMap.put(entityNumber, adminOrgField);
                continue;
            }
            ((List)adminOrgMap.get(entityNumber)).add(queryFieldBo.getFieldNumber());
        }
        return adminOrgMap;
    }

    private static List<QueryFieldBo> queryAndAssembleQueryFields(Collection<Long> anoBjFieldIds) {
        List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anoBjFieldIds);
        Map<String, String> adminOrgMap = ReportManageService.entityAdminOrgMap(queryFieldBos);
        for (QueryFieldBo queryFieldBo : queryFieldBos) {
            String key;
            String data;
            if (queryFieldBo.isBaseDataId() || !StringUtils.isNotEmpty((CharSequence)(data = adminOrgMap.get(key = queryFieldBo.getEntityNumber() + "_" + queryFieldBo.getFieldNumber())))) continue;
            queryFieldBo.setData(data);
        }
        return queryFieldBos;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Map<String, String>> getFilter(Long rptManageId) {
        DynamicObject[] dynamicObjects = FILTER_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        List<Long> anoBjFieldIds = Stream.of(dynamicObjects).map(dataEntity -> dataEntity.getLong("anobjfield_id")).collect(Collectors.toList());
        List<QueryFieldBo> queryFieldBos = ReportManageService.queryAndAssembleQueryFields(anoBjFieldIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String filterType = dynamicObject.getString("filtertype");
            if (FilterType.DATE.getValue().equals(filterType) || FilterType.STRING.getValue().equals(filterType) || FilterType.NUMBER.getValue().equals(filterType) || FilterType.BOOLEAN.getValue().equals(filterType)) continue;
            String name = dynamicObject.getString("name");
            String number = "";
            String baseDataNum = "";
            String data = "";
            String entityNumber = "";
            String id = "";
            long anoId = dynamicObject.getLong("anobjfield_id");
            if (IDStringUtils.idEmpty((Long)anoId) || IDStringUtils.idNotEmpty((Long)dynamicObject.getLong("splitdate.id"))) continue;
            for (QueryFieldBo queryFieldBo : queryFieldBos) {
                if (!HRStringUtils.equals((String)queryFieldBo.getId(), (String)String.valueOf(anoId))) continue;
                number = queryFieldBo.getFieldAlias();
                entityNumber = queryFieldBo.getEntityNumber();
                id = queryFieldBo.getId();
                if (!FieldComplexType.BASE_DATA.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.ADMIN_ORG.getValue().equals(queryFieldBo.getComplexType())) continue;
                baseDataNum = queryFieldBo.getBaseDataNum();
                data = queryFieldBo.getData();
            }
            if (HRStringUtils.isEmpty((String)baseDataNum)) {
                resultMap.put(number, ReportManageService.genMap(id, entityNumber, number, name));
                continue;
            }
            number = number.substring(0, number.lastIndexOf(46));
            resultMap.put(number, ReportManageService.genMap(id, entityNumber, number, name, baseDataNum, "true", data));
        }
        return resultMap;
    }

    public static Map<String, Map<String, String>> getReportRefField(Long rptManageId) {
        Object[] rowFieldList = ROW_FIELD_HELPER.query("displayname, numberalias, anobjfield.id", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("type", "=", (Object)"1")});
        Object[] colFieldList = COL_FIELD_HELPER.query("displayname, numberalias, anobjfield.id", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        DynamicObject[] fieldList = (DynamicObject[])ArrayUtils.addAll((Object[])rowFieldList, (Object[])colFieldList);
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)fieldList.length);
        HashSet anObjFieldIds = Sets.newHashSetWithExpectedSize((int)fieldList.length);
        for (DynamicObject fieldDy : fieldList) {
            Long anObjFieldId;
            String key = ReportManageService.getNumber(fieldDy.getString("numberalias"));
            if (!fieldMap.containsKey(key)) {
                fieldMap.put(key, fieldDy.getString("displayname"));
            }
            if (!IDStringUtils.idNotEmpty((Long)(anObjFieldId = Long.valueOf(fieldDy.getLong("anobjfield.id"))))) continue;
            anObjFieldIds.add(anObjFieldId);
        }
        LOGGER.info("fieldMap:{}", (Object)SerializationUtils.toJsonString((Object)fieldMap));
        List<FieldInfo> legendFields = ReportManageService.getLegendField(rptManageId);
        for (FieldInfo fieldInfo : legendFields) {
            String anObjFieldId;
            String key = ReportManageService.getNumber(fieldInfo.getNumberAlias());
            if (!fieldMap.containsKey(key)) {
                fieldMap.put(key, fieldInfo.getDisplayName().getLocaleValue());
            }
            if (!IDStringUtils.idNotEmpty((String)(anObjFieldId = fieldInfo.getFieldId()))) continue;
            anObjFieldIds.add(Long.parseLong(anObjFieldId));
        }
        LOGGER.info("fieldMap:{}", (Object)SerializationUtils.toJsonString((Object)fieldMap));
        List<QueryFieldBo> queryFields = ReportManageService.queryAndAssembleQueryFields(anObjFieldIds);
        LOGGER.info("queryFields:{}", (Object)SerializationUtils.toJsonString(queryFields));
        Map<String, QueryFieldBo> numberEntityMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, queryFieldBo -> queryFieldBo));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fieldList.length);
        for (Map.Entry entry : fieldMap.entrySet()) {
            boolean isBasedata;
            String number = (String)entry.getKey();
            QueryFieldBo queryFieldBo2 = numberEntityMap.get(number);
            if (null == queryFieldBo2) continue;
            String fieldPath = queryFieldBo2.getFieldPath();
            String id = queryFieldBo2.getId();
            String entityNumber = queryFieldBo2.getEntityNumber();
            String key = fieldPath.contains(".") ? fieldPath.substring(0, fieldPath.lastIndexOf(46)) : fieldPath;
            boolean bl = isBasedata = FieldComplexType.BASE_DATA.getValue().equals(queryFieldBo2.getComplexType()) || FieldComplexType.ADMIN_ORG.getValue().equals(queryFieldBo2.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(queryFieldBo2.getComplexType());
            if (isBasedata && StringUtils.isNotEmpty((CharSequence)fieldPath) && fieldPath.endsWith(".name")) {
                boolean canOver;
                boolean bl2 = canOver = null != resultMap.get(key) && Boolean.parseBoolean((String)((Map)resultMap.get(key)).get("canOver"));
                if (resultMap.containsKey(key) && !canOver) continue;
                resultMap.put(key, ReportManageService.genMap(id, entityNumber, key, (String)entry.getValue(), queryFieldBo2.getBaseDataNum(), "false", queryFieldBo2.getData()));
                continue;
            }
            if (isBasedata && StringUtils.isNotEmpty((CharSequence)fieldPath) && fieldPath.endsWith(".number")) {
                if (resultMap.containsKey(key)) continue;
                resultMap.put(key, ReportManageService.genMap(id, entityNumber, key, (String)entry.getValue(), queryFieldBo2.getBaseDataNum(), "true", queryFieldBo2.getData()));
                continue;
            }
            if (!FieldControlType.COMBO.getValue().equals(queryFieldBo2.getControlType()) && !FieldControlType.MUL_COMBO.getValue().equals(queryFieldBo2.getControlType())) continue;
            resultMap.put(number, ReportManageService.genMap(id, entityNumber, number, (String)entry.getValue()));
        }
        return resultMap;
    }

    private static String getNumber(String numberAlias) {
        String[] str = numberAlias.split("\u03b4");
        String key = numberAlias;
        if (str.length == 3) {
            key = numberAlias.substring(0, numberAlias.lastIndexOf(948));
        } else if (str.length == 2) {
            try {
                Integer.parseInt(str[1]);
                key = str[0];
            }
            catch (NumberFormatException e) {
                key = numberAlias;
            }
        }
        return key;
    }

    private static List<FieldInfo> getLegendField(long rptManageId) {
        DynamicObject[] rptConfigDys;
        ArrayList<FieldInfo> legendFields = new ArrayList<FieldInfo>(10);
        for (DynamicObject rptConfigDy : rptConfigDys = RPT_CONFIG_HELPER.query("legend", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)})) {
            String legend = rptConfigDy.getString("legend");
            if (!StringUtils.isNotEmpty((CharSequence)legend)) continue;
            legendFields.addAll(SerializationUtils.fromJsonStringToList((String)legend, FieldInfo.class));
        }
        return legendFields;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<String, String> genMap(String id, String entityNumber, String number, String name) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("id", id);
        map.put("entityNumber", entityNumber);
        map.put("number", number);
        map.put("name", name);
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<String, String> genMap(String id, String entityNumber, String number, String name, String baseDataNum, String canOver, String data) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("id", id);
        map.put("entityNumber", entityNumber);
        map.put("number", number);
        map.put("name", name);
        map.put("baseDataNum", baseDataNum);
        map.put("canOver", canOver);
        map.put("bucafunc", data);
        return map;
    }

    public static String getUserDispScmChgState(Long rptManageId) {
        QFilter[] qFilters;
        DynamicObject dy;
        if (rptManageId != 0L && null != (dy = DISP_SCM_CHG_HELPER.queryOriginalOne("state", qFilters = new QFilter[]{new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()), new QFilter("known", "=", (Object)Boolean.FALSE), new QFilter("rptmanage", "=", (Object)rptManageId)}))) {
            return dy.getString("state");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void addUserDispScmChg(Long rptManageId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId())};
        if (DISP_SCM_CHG_HELPER.isExists(qFilters)) {
            return;
        }
        DynamicObject dy = DISP_SCM_CHG_HELPER.generateEmptyDynamicObject();
        dy.set("rptmanage", (Object)rptManageId);
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dy.set("known", (Object)Boolean.TRUE);
        DISP_SCM_CHG_HELPER.saveOne(dy);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateUserDispScmChg(Long rptManageId) {
        DynamicObject dy = DISP_SCM_CHG_HELPER.queryOne("known", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId())});
        if (dy != null) {
            dy.set("known", (Object)Boolean.TRUE);
            DISP_SCM_CHG_HELPER.updateOne(dy);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void batchUpdateUserDispScmChg(Long rptManageId, boolean known, String state) {
        DynamicObject[] dys = DISP_SCM_CHG_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        Arrays.stream(dys).forEach(dy -> {
            dy.set("known", (Object)known);
            dy.set("state", (Object)state);
        });
        DISP_SCM_CHG_HELPER.update(dys);
    }

    public static void deleteUserDispScmChg(Long rptManageId) {
        DISP_SCM_CHG_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteCustomSort(long workRptId) {
        CUSTOM_SORT_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
    }

    public static void deleteCustomSortByWorkRpts(List<Long> workRptIds) {
        CUSTOM_SORT_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    public static void deleteComRefByWorkRpts(List<Long> workRptIds) {
        RPT_COM_REF_HELPER.deleteByFilter(new QFilter[]{new QFilter("workrpt", "in", workRptIds)});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DisplaySchemeInfo getDisplaySchemeInfo(long workRptId) {
        DynamicObject[] idxDispScmDy;
        DynamicObject[] colDispScmDy;
        DisplaySchemeInfo displaySchemeInfo = new DisplaySchemeInfo();
        DynamicObject dispScmDy = DISP_SCM_HELPER.queryOriginalOne("id", new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        if (null == dispScmDy) {
            return new DisplaySchemeInfo();
        }
        long dispScmId = dispScmDy.getLong("id");
        displaySchemeInfo.setId(String.valueOf(dispScmId));
        DynamicObject[] rowDispScmDy = ROW_DISP_SCM_HELPER.queryOriginalArray("rowfield.id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId), new QFilter("enable", "=", (Object)"1")});
        if (null != rowDispScmDy && 0 != rowDispScmDy.length) {
            List rowFieldIds = Arrays.stream(rowDispScmDy).map(dy -> dy.getLong("rowfield.id")).collect(Collectors.toList());
            DynamicObject[] rowFieldDy = ROW_FIELD_HELPER.queryOriginalArray("numberalias", new QFilter[]{new QFilter("id", "in", rowFieldIds)});
            displaySchemeInfo.setSelectedRowField(Arrays.stream(rowFieldDy).map(dy -> dy.getString("numberalias")).collect(Collectors.toSet()));
        }
        if (null != (colDispScmDy = COL_DISP_SCM_HELPER.query("colfield.id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId), new QFilter("enable", "=", (Object)"1")})) && 0 != colDispScmDy.length) {
            List colFieldIds = Arrays.stream(colDispScmDy).map(dy -> dy.getLong("colfield.id")).collect(Collectors.toList());
            DynamicObject[] colFieldDy = COL_FIELD_HELPER.queryOriginalArray("numberalias", new QFilter[]{new QFilter("id", "in", colFieldIds)});
            displaySchemeInfo.setSelectedColField(Arrays.stream(colFieldDy).map(dy -> dy.getString("numberalias")).collect(Collectors.toSet()));
        }
        if (null != (idxDispScmDy = IDX_DISP_SCM_HELPER.query("rowfield.id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId), new QFilter("enable", "=", (Object)"1")})) && 0 != idxDispScmDy.length) {
            List rowFieldIds = Arrays.stream(idxDispScmDy).map(dy -> dy.getLong("rowfield.id")).collect(Collectors.toList());
            DynamicObject[] rowFieldDy = ROW_FIELD_HELPER.queryOriginalArray("numberalias", new QFilter[]{new QFilter("id", "in", rowFieldIds)});
            displaySchemeInfo.setSelectedIdxField(Arrays.stream(rowFieldDy).map(dy -> dy.getString("numberalias")).collect(Collectors.toSet()));
        }
        return displaySchemeInfo;
    }

    private static int handlerRowAndReturnFreeze(DynamicObjectCollection userRowDispScmColl, List<RowFieldInfo> rows, MergeInfo mergeInfo) {
        int freeze = 0;
        String lv2Head = "";
        for (DynamicObject userRowDispDy : userRowDispScmColl) {
            RowFieldInfo rowFieldInfo;
            if (userRowDispDy.getBoolean("rowhide")) continue;
            String newLv2Head = userRowDispDy.getString("rowsecondaryheader");
            if (StringUtils.isNotEmpty((CharSequence)newLv2Head)) {
                if (!newLv2Head.equals(lv2Head)) {
                    lv2Head = newLv2Head;
                    if (userRowDispDy.getBoolean("rowfreeze")) {
                        ++freeze;
                    }
                    rowFieldInfo = new RowFieldInfo();
                    rowFieldInfo.setType("1");
                    rowFieldInfo.setMergeType("1");
                    FieldInfo fieldInfo = new FieldInfo();
                    fieldInfo.setDisplayName(new LocaleString(newLv2Head));
                    fieldInfo.setType("0");
                    fieldInfo.setNumber(newLv2Head);
                    fieldInfo.setNumberAlias(newLv2Head);
                    rowFieldInfo.setGroupName(fieldInfo);
                    rowFieldInfo.addFields(ReportManageService.getFieldInfoAndSetFieldId(userRowDispDy.getString("rowfield_id")));
                    rows.add(rowFieldInfo);
                    mergeInfo.addHeaders(rowFieldInfo);
                    continue;
                }
                rowFieldInfo = rows.get(rows.size() - 1);
                rowFieldInfo.addFields(ReportManageService.getFieldInfoAndSetFieldId(userRowDispDy.getString("rowfield_id")));
                continue;
            }
            lv2Head = "";
            if (userRowDispDy.getBoolean("rowfreeze")) {
                ++freeze;
            }
            rowFieldInfo = new RowFieldInfo();
            rowFieldInfo.setType("0");
            rowFieldInfo.setMergeType("0");
            rowFieldInfo.setGroupName(ReportManageService.getFieldInfoAndSetFieldId(userRowDispDy.getString("rowfield_id")));
            rows.add(rowFieldInfo);
        }
        return freeze;
    }

    @ExcludeFromJacocoGeneratedReport
    public static ReportManageConfigInfo getUserDispScmRptCfgInfo(long userDispScmId) {
        DynamicObject userDispScmDy = USER_DISP_SCM_HELPER.queryOne(USER_DISPSCM_SELECT_PROP, new QFilter[]{new QFilter("id", "=", (Object)userDispScmId)});
        DynamicObjectCollection userRowDispScmColl = userDispScmDy.getDynamicObjectCollection("rowentryentity");
        DynamicObjectCollection userColDispScmColl = userDispScmDy.getDynamicObjectCollection("colentryentity");
        DynamicObjectCollection userIdxDispScmColl = userDispScmDy.getDynamicObjectCollection("indexentryentity");
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        WorkRptInfo workRptInfo = new WorkRptInfo();
        workRptInfo.setShow(true);
        reportManageConfigInfo.addWorkRpt(workRptInfo);
        MergeInfo mergeInfo = new MergeInfo();
        List<RowFieldInfo> rows = reportManageConfigInfo.getRows();
        int freeze = ReportManageService.handlerRowAndReturnFreeze(userRowDispScmColl, rows, mergeInfo);
        ReportConfigInfo reportConfigInfo = new ReportConfigInfo();
        reportConfigInfo.setFreezeCol(new FreezeInfo(freeze));
        reportConfigInfo.setHeaderMerge(mergeInfo);
        reportManageConfigInfo.getCurWorkRpt().setReportConfig(reportConfigInfo);
        for (DynamicObject userIdxDispDy : userIdxDispScmColl) {
            if (userIdxDispDy.getBoolean("indexhide")) continue;
            RowFieldInfo rowFieldInfo = new RowFieldInfo();
            rowFieldInfo.setType("0");
            rowFieldInfo.setMergeType("0");
            rowFieldInfo.setGroupName(ReportManageService.getFieldInfoAndSetFieldId(userIdxDispDy.getString("indexfield_id")));
            rows.add(rowFieldInfo);
        }
        List<FieldInfo> columns = reportManageConfigInfo.getColumns();
        for (DynamicObject userColDispDy : userColDispScmColl) {
            if (userColDispDy.getBoolean("colhide")) continue;
            columns.add(ReportManageService.getFieldInfoAndSetFieldId(userColDispDy.getString("colfield_id")));
        }
        return reportManageConfigInfo;
    }

    @ExcludeFromJacocoGeneratedReport
    private static FieldInfo getFieldInfoAndSetFieldId(String fieldId) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setRowFieldId(fieldId);
        return fieldInfo;
    }

    public static DynamicObjectCollection getCommonSortAndFieldSortField(long rptManageId) {
        DynamicObject rptManageDy = RPT_MANAGE_HELPER.queryOriginalOne("id,anobjid", (Object)rptManageId);
        DynamicObjectCollection commonColls = new DynamicObjectCollection();
        commonColls.addAll((Collection)ReportManageService.getCommonSortField(rptManageDy, false));
        commonColls.addAll((Collection)ReportManageService.getFieldSortField(rptManageDy, false));
        return commonColls;
    }

    public static List<Object> queryAnObjPkList(List<Object> rptManageIdList) {
        DynamicObject[] dynamicObjects = RPT_MANAGE_HELPER.queryOriginalArray("anobjid", new QFilter[]{new QFilter("id", "in", rptManageIdList)});
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("anobjid")).distinct().collect(Collectors.toList());
    }

    public static List<Object> queryPreIndexPkList(List<Object> rptManageIdList) {
        DynamicObject[] dynamicObjects = PRE_INDEX_HELPER.queryOriginalArray("preindex", new QFilter[]{new QFilter("report", "in", rptManageIdList)});
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("preindex")).distinct().collect(Collectors.toList());
    }

    public static DynamicObjectCollection getCommonSortField(DynamicObject rptManageDy, boolean isVirtualEntity) {
        DynamicObject[] workRptDys;
        DynamicObjectCollection commonColls = new DynamicObjectCollection();
        for (DynamicObject workRptDy : workRptDys = ReportManageService.getWorkRpt(rptManageDy.getLong("id"))) {
            String columnStr;
            String rowStr = workRptDy.getString("row");
            HRBaseServiceHelper commonHelper = new HRBaseServiceHelper("hrptmc_commonsort");
            if (StringUtils.isNotEmpty((CharSequence)rowStr)) {
                List rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
                for (RowFieldInfo rowFieldInfo : rows) {
                    ReportManageService.handleCommonSortField(rowFieldInfo.getGroupName(), commonHelper, commonColls, isVirtualEntity);
                    if (!rowFieldInfo._isMerge()) continue;
                    ReportManageService.recursive(rowFieldInfo._getChildFields(), fieldInfo -> ReportManageService.handleCommonSortField(fieldInfo, commonHelper, commonColls, isVirtualEntity));
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)(columnStr = workRptDy.getString("column")))) continue;
            List columns = SerializationUtils.fromJsonStringToList((String)columnStr, FieldInfo.class);
            for (FieldInfo fieldInfo2 : columns) {
                ReportManageService.handleCommonSortField(fieldInfo2, commonHelper, commonColls, isVirtualEntity);
            }
        }
        return commonColls;
    }

    public static DynamicObjectCollection getFieldSortField(DynamicObject rptManageDy, boolean isVirtualEntity) {
        DynamicObjectCollection fieldSortColls = new DynamicObjectCollection();
        DynamicObject[] workRptDys = ReportManageService.getWorkRpt(rptManageDy.getLong("id"));
        List<QueryFieldBo> queryFields = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(rptManageDy.getLong("anobjid"));
        for (DynamicObject workRptDy : workRptDys) {
            String rowStr = workRptDy.getString("row");
            String columnStr = workRptDy.getString("column");
            List rows = StringUtils.isNotEmpty((CharSequence)rowStr) ? SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class) : Collections.emptyList();
            List columns = StringUtils.isNotEmpty((CharSequence)columnStr) ? SerializationUtils.fromJsonStringToList((String)columnStr, FieldInfo.class) : Collections.emptyList();
            fieldSortColls.addAll((Collection)ReportManageService.getFieldSortField(rows, columns, queryFields, isVirtualEntity));
        }
        return fieldSortColls;
    }

    public static void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType())) {
                consumer.accept(children);
            }
            if (!CollectionUtils.isNotEmpty(children.getFields())) continue;
            ReportManageService.recursive(children.getFields(), consumer);
        }
    }

    public static List<String> getFieldSortNumbers(List<RowFieldInfo> rows, List<FieldInfo> columns) {
        FieldSortInfo fieldSortInfo;
        HashSet<String> fieldSortNumbers = new HashSet<String>(rows.size());
        for (RowFieldInfo rowFieldInfo : rows) {
            fieldSortInfo = rowFieldInfo.getGroupName().getFieldSortInfo();
            if (null != fieldSortInfo) {
                fieldSortNumbers.add(fieldSortInfo.getNumber());
            }
            if (!rowFieldInfo._isMerge()) continue;
            ReportManageService.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if (null != fieldInfo.getFieldSortInfo()) {
                    fieldSortNumbers.add(fieldInfo.getFieldSortInfo().getNumber());
                }
            });
        }
        for (FieldInfo fieldInfo2 : columns) {
            fieldSortInfo = fieldInfo2.getFieldSortInfo();
            if (null == fieldSortInfo) continue;
            fieldSortNumbers.add(fieldSortInfo.getNumber());
        }
        return new ArrayList<String>(fieldSortNumbers);
    }

    private static DynamicObjectCollection getFieldSortField(List<RowFieldInfo> rows, List<FieldInfo> columns, List<QueryFieldBo> queryFields, boolean isVirtualEntity) {
        HRBaseServiceHelper commonHelper = new HRBaseServiceHelper("hrptmc_commonsort");
        DynamicObjectCollection commonColls = new DynamicObjectCollection();
        List<String> fieldSortNumbers = ReportManageService.getFieldSortNumbers(rows, columns);
        List fieldSortList = queryFields.stream().filter(qf -> fieldSortNumbers.contains(qf.getFieldAlias())).map(qf -> {
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setBaseDataNum(qf.getBaseDataNum());
            fieldInfo.setNumber(qf.getFieldAlias());
            fieldInfo.setSort(SortEnum.ASC.getValue());
            fieldInfo.setFieldPath(qf.getFieldPath());
            return fieldInfo;
        }).collect(Collectors.toList());
        for (FieldInfo fieldInfo : fieldSortList) {
            ReportManageService.handleCommonSortField(fieldInfo, commonHelper, commonColls, isVirtualEntity);
        }
        return commonColls;
    }

    private static String getEntityNumber(FieldInfo fieldInfo, boolean isVirtualEntity) {
        if (StringUtils.isNotEmpty((CharSequence)fieldInfo.getBaseDataNum())) {
            return fieldInfo.getBaseDataNum();
        }
        if (isVirtualEntity) {
            if (StringUtils.isNotEmpty((CharSequence)fieldInfo.getFieldPath())) {
                return fieldInfo.getFieldPath().substring(0, fieldInfo.getFieldPath().indexOf(46));
            }
        } else {
            return fieldInfo.getEntityNumber();
        }
        return null;
    }

    private static void handleCommonSortField(FieldInfo fieldInfo, HRBaseServiceHelper commonHelper, DynamicObjectCollection commonColls, boolean isVirtualEntity) {
        if (fieldInfo.getSplitDateSub()) {
            return;
        }
        if (SortEnum.ASC.getValue().equals(fieldInfo.getSort()) || SortEnum.DESC.getValue().equals(fieldInfo.getSort())) {
            DynamicObject commonSortDy = commonHelper.generateEmptyDynamicObject();
            String entityNumber = ReportManageService.getEntityNumber(fieldInfo, isVirtualEntity);
            if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
                commonSortDy.set("entitynumber", (Object)entityNumber);
                String number = fieldInfo.getNumber();
                String field = number.contains(".") ? number.substring(number.lastIndexOf(46) + 1) : number;
                commonSortDy.set("entityfield", (Object)field);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if ("name".equals(field) || "number".equals(field)) {
                    String valueType = ReportManageService.getValueType(mainEntityType.getPrimaryKey().getPropertyType().getTypeName());
                    commonSortDy.set("fieldtype", (Object)"basedata");
                    commonSortDy.set("valuetype", (Object)valueType);
                    commonColls.add((Object)commonSortDy);
                } else {
                    DynamicProperty property = mainEntityType.getProperty(field);
                    String controlType = ((FieldProp)property).getFilterControlType();
                    if ("enum".equals(controlType)) {
                        commonSortDy.set("fieldtype", (Object)"enum");
                        commonSortDy.set("valuetype", (Object)"string");
                        commonColls.add((Object)commonSortDy);
                    }
                }
            }
        }
    }

    private static String getValueType(String type) {
        return "long".equals(type) ? "long" : "string";
    }

    public static void deleteDispScm(long rptManageId) {
        DynamicObject dispScmDy = DISP_SCM_HELPER.queryOriginalOne("id", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (null != dispScmDy) {
            long dispScmId = dispScmDy.getLong("id");
            ReportManageService.deleteDispScmRefByScmId(dispScmId);
            DISP_SCM_HELPER.deleteOne((Object)dispScmId);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void deleteDispScmRefByScmId(long dispScmId) {
        if (0L != dispScmId) {
            ROW_DISP_SCM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
            COL_DISP_SCM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
            IDX_DISP_SCM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
        }
    }

    public static void deleteUserDispScm(long rptManageId) {
        USER_DISP_SCM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObject[] getUserDispScmByRptId(long rptManageId) {
        return USER_DISP_SCM_HELPER.query(USER_DISPSCM_SELECT_PROP, new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static boolean isExistUserDispScmByRptId(long rptManageId) {
        return USER_DISP_SCM_HELPER.isExists(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void batchSaveUserDispScm(DynamicObject[] userDispScmDys) {
        USER_DISP_SCM_HELPER.save(userDispScmDys);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, String> getLv2HeadByRowFieldId(List<Long> rowFieldIds) {
        DynamicObject[] dynamicObjects = ROW_FIELD_HELPER.query("parentid.displayname", new QFilter[]{new QFilter("id", "in", rowFieldIds)});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> StringUtils.isNotEmpty((CharSequence)dy.getString("parentid.displayname")) ? dy.getString("parentid.displayname") : ""));
    }

    @ExcludeFromJacocoGeneratedReport
    public static void saveRptComRef(long rptManageId, long workRptId, List<Long> newComSortIds) {
        DynamicObject[] rptComRefDys = RPT_COM_REF_HELPER.query("commonsort.id", new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        ArrayList<Long> deleteIds = new ArrayList<Long>(newComSortIds.size());
        for (DynamicObject rptComRefDy : rptComRefDys) {
            if (newComSortIds.contains(rptComRefDy.getLong("commonsort.id"))) continue;
            deleteIds.add(rptComRefDy.getLong("id"));
        }
        RPT_COM_REF_HELPER.deleteByFilter(new QFilter[]{new QFilter("id", "in", deleteIds)});
        DynamicObjectCollection newColls = new DynamicObjectCollection();
        List oldComSortIdLists = Arrays.stream(rptComRefDys).map(dy -> dy.getLong("commonsort.id")).collect(Collectors.toList());
        for (Long id : newComSortIds) {
            if (oldComSortIdLists.contains(id)) continue;
            DynamicObject dy2 = RPT_COM_REF_HELPER.generateEmptyDynamicObject();
            dy2.set("rptmanage", (Object)rptManageId);
            dy2.set("workrpt", (Object)workRptId);
            dy2.set("commonsort", (Object)id);
            newColls.add((Object)dy2);
        }
        RPT_COM_REF_HELPER.save(newColls);
    }

    public static void deleteRptComRef(long rptManageId) {
        RPT_COM_REF_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObject getReportMark(long rptManageId) {
        return RPT_MARK_HELPER.queryOriginalOne("id, show", new QFilter("rptmanage", "=", (Object)rptManageId));
    }

    public static boolean isShowReportMark(long rptManageId) {
        DynamicObject dy = RPT_MARK_HELPER.queryOriginalOne("show", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (dy == null) {
            return false;
        }
        return "1".equals(dy.getString("show"));
    }

    public static long getReportMarkId(long rptManageId) {
        if (rptManageId == 0L) {
            return 0L;
        }
        DynamicObject dy = RPT_MARK_HELPER.queryOriginalOne("id", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    public static DynamicObject[] getRptMarkContent(long rptMarkId) {
        return RPT_MARK_CNT_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmark", "=", (Object)rptMarkId)});
    }

    public static DynamicObject getRptMarkContent(long rptManageId, String locale) {
        DynamicObject rptMarkDy = RPT_MARK_HELPER.queryOriginalOne("id", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (rptMarkDy == null) {
            return null;
        }
        return RPT_MARK_CNT_HELPER.queryOne("markcontent", new QFilter[]{new QFilter("rptmark", "=", (Object)rptMarkDy.getLong("id")), new QFilter("locale", "=", (Object)locale)});
    }

    public static void deleteReportMark(long rptManageId) {
        DynamicObject rptMarkDy = RPT_MARK_HELPER.queryOriginalOne("id", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (rptMarkDy != null) {
            RPT_MARK_CNT_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmark", "=", (Object)rptMarkDy.getLong("id"))});
        }
        RPT_MARK_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObject getAlgorithmCol(long rptConfigId) {
        return ALGORITHM_COL_HELPER.loadDynamicObject(new QFilter("rptconfig", "=", (Object)rptConfigId));
    }

    public static void deleteAlgorithmCol(long rptConfigId) {
        ALGORITHM_COL_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptconfig", "=", (Object)rptConfigId)});
    }

    public static void deleteSplitDate(long rptManageId) {
        SPLIT_DATE_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void deleteSplitDate(List<Long> splitDateIds) {
        SPLIT_DATE_HELPER.deleteByFilter(new QFilter[]{new QFilter("id", "in", splitDateIds)});
    }

    public static void saveSplitDate(DynamicObjectCollection collection) {
        SPLIT_DATE_HELPER.save(collection);
    }

    public static DynamicObject[] getSplitDate(long rptManageId) {
        return SPLIT_DATE_HELPER.query("id,number,anobjfield.fieldpath", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObject getParamConfigWithSchedule(long reportId) {
        return PARAM_CONFIG_HELPER.loadDynamicObject(new QFilter("report", "=", (Object)reportId));
    }

    public static boolean isEnableExtract(long reportId) {
        DynamicObject paramConfigWithSchedule = ReportManageService.getParamConfigWithSchedule(reportId);
        return paramConfigWithSchedule != null && paramConfigWithSchedule.getBoolean("enableextract");
    }

    public static DynamicObject[] getReportMappings(long reportId) {
        return REPORT_MAPPING_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "=", (Object)reportId)});
    }

    public static void deleteReportMappings(long reportId) {
        REPORT_MAPPING_HELPER.deleteByFilter(new QFilter[]{new QFilter("report", "=", (Object)reportId)});
    }

    public static void updateScheduleStatus(DynamicObject config, String status) {
        config.set("schedulestatus", (Object)status);
        PARAM_CONFIG_HELPER.saveOne(config);
    }

    public static DynamicObject getRptDispScm(long rptManageId) {
        return DISP_SCM_HELPER.loadDynamicObject(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void closeEnableScheme(DynamicObject config) {
        if (config != null) {
            config.set("enablescheme", (Object)false);
            PARAM_CONFIG_HELPER.saveOne(config);
        }
    }

    public static void saveReportCenter(long rptGroupId, long rptManageId) {
        DynamicObject dy = REPORT_CENTER_HELPER.generateEmptyDynamicObject();
        dy.set("reportgroup", (Object)rptGroupId);
        dy.set("reportmanage", (Object)rptManageId);
        REPORT_CENTER_HELPER.saveOne(dy);
    }

    public static void deleteReportCenter(long rptManageId) {
        REPORT_CENTER_HELPER.deleteByFilter(new QFilter[]{new QFilter("reportmanage", "=", (Object)rptManageId)});
    }

    public static void deleteReportSubscribe(long rptManageId) {
        try {
            Class<?> reportSubscribeConfigServiceClass = Class.forName("kd.hr.hrptc.business.subscribe.ReportSubscribeConfigService");
            Method deleteSubscribeMethod = reportSubscribeConfigServiceClass.getDeclaredMethod("deleteSubscribe", Long.class);
            deleteSubscribeMethod.invoke(reportSubscribeConfigServiceClass.newInstance(), rptManageId);
        }
        catch (Exception exception) {
            LOGGER.error("ReportManageService deleteReportSubscribe error: ", (Throwable)exception);
        }
    }

    public static DynamicObjectCollection queryAllRptGroup() {
        return REPORT_GROUP_HELPER.queryOriginalCollection("id,name,parent,longnumber,isendgroup", null);
    }

    public static DynamicObjectCollection queryAllRptCenter() {
        return REPORT_CENTER_HELPER.queryOriginalCollection("id,reportmanage,reportgroup", null);
    }

    public static DynamicObject queryRptGroup(Long rptManageId) {
        return REPORT_CENTER_HELPER.queryOriginalOne("reportgroup", new QFilter("reportmanage", "=", (Object)rptManageId));
    }

    public static Map<String, Map<String, String>> getPermFieldNumberMapNoSubEnum(long rptManageId) {
        Map<String, Map<String, String>> reportRefField = ReportManageService.getReportRefField(rptManageId);
        Map<String, Map<String, String>> filter = ReportManageService.getFilter(rptManageId);
        filter.putAll(reportRefField);
        List<String> subEnum = filter.values().stream().filter(map -> !map.containsKey("baseDataNum") && ((String)map.get("number")).contains(".")).map(map -> (String)map.get("number")).collect(Collectors.toList());
        subEnum.forEach(filter::remove);
        return filter;
    }

    public static Map<String, Map<String, String>> getPermFieldNumberMap(long rptManageId) {
        Map<String, Map<String, String>> reportRefField = ReportManageService.getReportRefField(rptManageId);
        Map<String, Map<String, String>> filter = ReportManageService.getFilter(rptManageId);
        filter.putAll(reportRefField);
        return filter;
    }

    public static Map<Long, Map<String, String>> getPermFieldIdMap(long rptManageId) {
        Map<String, Map<String, String>> permFieldMap = ReportManageService.getPermFieldNumberMap(rptManageId);
        HashMap<Long, Map<String, String>> permissionFieldMap = new HashMap<Long, Map<String, String>>(permFieldMap.size());
        LOGGER.info("permissionFieldMap:{}", (Object)SerializationUtils.toJsonString(permissionFieldMap));
        for (Map.Entry<String, Map<String, String>> entry : permFieldMap.entrySet()) {
            permissionFieldMap.put(Long.parseLong(entry.getValue().get("id")), entry.getValue());
        }
        return permissionFieldMap;
    }
}

