/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeFieldBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeValueBo;

@ExcludeFromJacocoGeneratedReport
public class ReportPreViewService
implements ReportManageConstants {
    private static final HRBaseServiceHelper RPTQUERY_SCHEME_HELPER = new HRBaseServiceHelper("hrptmc_queryscheme");
    private static final HRBaseServiceHelper RPTSHARE_SCHEME_HELPER = new HRBaseServiceHelper("hrptmc_share_filterscheme");
    private static final HRBaseServiceHelper RPTSHARE_SCHEME_CHG_HELPER = new HRBaseServiceHelper("hrptmc_queryscmchg");
    public static final String FILTER_TYPE = "2";
    public static final String CUSTOM_TYPE = "3";

    public static DynamicObject[] getQueryScheme(long rptManageId, String publishType) {
        QFilter publishTypeFilter = new QFilter("publishtype", "=", (Object)publishType);
        if ("appMenu".equals(publishType)) {
            publishTypeFilter.or(new QFilter("publishtype", "=", (Object)QEmptyValue.value));
        }
        return RPTQUERY_SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()), publishTypeFilter});
    }

    public static DynamicObject getQuerySchemeById(long id) {
        return RPTQUERY_SCHEME_HELPER.loadSingle((Object)id);
    }

    public static DynamicObject[] getShareScheme(long rptManageId, String publishType) {
        QFilter publishTypeFilter = new QFilter("scheme.publishtype", "=", (Object)publishType);
        if ("appMenu".equals(publishType)) {
            publishTypeFilter.or(new QFilter("scheme.publishtype", "=", (Object)QEmptyValue.value));
        }
        return RPTSHARE_SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId), new QFilter("userfield.fbasedataid.id", "in", (Object)RequestContext.get().getCurrUserId()), publishTypeFilter});
    }

    public static DynamicObject getShareSchemeBySchemeId(long schemeId) {
        return RPTSHARE_SCHEME_HELPER.queryOriginalOne("id,userfield", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
    }

    public static DynamicObject[] getShareSchemeChgBySchemeId(long rptManageId) {
        return RPTSHARE_SCHEME_CHG_HELPER.query("rptmanage,user,known,scheme", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static DynamicObjectCollection getShareUser(long id) {
        DynamicObject shareScheme = RPTSHARE_SCHEME_HELPER.queryOriginalOne("userfield", new QFilter[]{new QFilter("scheme", "=", (Object)id)});
        if (shareScheme == null) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection userField = shareScheme.getDynamicObjectCollection("userfield");
        return userField;
    }

    public static String saveScheme(QuerySchemeBo querySchemeBo, String publishType) {
        DynamicObject dy = RPTQUERY_SCHEME_HELPER.generateEmptyDynamicObject();
        if (HRStringUtils.isNotEmpty((String)querySchemeBo.getId())) {
            dy = RPTQUERY_SCHEME_HELPER.queryOne("defaultscheme,content,schemename,creator,createtime,rptmanage,publishtype", (Object)Long.parseLong(querySchemeBo.getId()));
        }
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dy.set("createtime", (Object)new Date());
        dy.set("rptmanage", (Object)Long.parseLong(querySchemeBo.getReportManageId()));
        dy.set("publishtype", (Object)publishType);
        dy.set("name", (Object)querySchemeBo.getSchemeName());
        dy.set("content", (Object)SerializationUtils.toJsonString((Object)querySchemeBo.getQuerySchemeList()));
        RPTQUERY_SCHEME_HELPER.saveOne(dy);
        return dy.getString("id");
    }

    public static void deleteScheme(long id) {
        DynamicObject scheme = ReportPreViewService.getQuerySchemeById(id);
        Long userId = scheme.getLong("creator.id");
        long currUserId = RequestContext.get().getCurrUserId();
        if (currUserId == userId) {
            RPTQUERY_SCHEME_HELPER.deleteOne((Object)id);
            RPTSHARE_SCHEME_HELPER.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)id)});
        } else {
            DynamicObject shareScheme = RPTSHARE_SCHEME_HELPER.queryOne("userfield,id", new QFilter[]{new QFilter("scheme", "=", (Object)id)});
            DynamicObjectCollection userField = shareScheme.getDynamicObjectCollection("userfield");
            Iterator iterator = userField.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (dynamicObject.getLong("fbasedataid.id") != currUserId) continue;
                iterator.remove();
            }
            if (userField.size() == 0) {
                scheme.set("sharescheme", (Object)false);
                RPTQUERY_SCHEME_HELPER.saveOne(scheme);
            }
            shareScheme.set("userfield", (Object)userField);
            RPTSHARE_SCHEME_HELPER.saveOne(shareScheme);
        }
    }

    public static void deleteSchemeByManageId(long rptManageId) {
        RPTQUERY_SCHEME_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        RPTSHARE_SCHEME_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    public static void shareScheme(long id, boolean isShare) {
        DynamicObject dy = RPTQUERY_SCHEME_HELPER.queryOne("sharescheme", (Object)id);
        dy.set("sharescheme", (Object)isShare);
        RPTQUERY_SCHEME_HELPER.saveOne(dy);
    }

    public static void setDefaultScheme(Map<String, Object> map, long reportId) {
        long schemeId = Long.parseLong((String)map.get("schemeId"));
        boolean defaultScheme = (Boolean)map.get("setDefault");
        if (defaultScheme) {
            DynamicObject[] defaults;
            for (DynamicObject aDefault : defaults = RPTQUERY_SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("defaultscheme", "=", (Object)true), new QFilter("rptmanage", "=", (Object)reportId)})) {
                aDefault.set("defaultscheme", (Object)false);
            }
            RPTQUERY_SCHEME_HELPER.save(defaults);
            DynamicObject scheme = RPTQUERY_SCHEME_HELPER.queryOne("defaultscheme", (Object)schemeId);
            scheme.set("defaultscheme", (Object)true);
            RPTQUERY_SCHEME_HELPER.saveOne(scheme);
        } else {
            DynamicObject scheme = RPTQUERY_SCHEME_HELPER.queryOne("defaultscheme", (Object)schemeId);
            scheme.set("defaultscheme", (Object)false);
            RPTQUERY_SCHEME_HELPER.saveOne(scheme);
        }
    }

    public static void synSchemeByReportSave(Long rptManageId, List<QuerySchemeFieldBo> fieldList) {
        DynamicObject[] queryColl = RPTQUERY_SCHEME_HELPER.query("id,defaultscheme,content,schemename,creator,createtime,rptmanage", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : queryColl) {
            String content = dynamicObject.getString("content");
            Long id = dynamicObject.getLong("id");
            if (!HRStringUtils.isNotEmpty((String)content)) continue;
            List querySchemeValueBoList = SerializationUtils.fromJsonStringToList((String)content, QuerySchemeValueBo.class);
            Iterator iterator = querySchemeValueBoList.iterator();
            while (iterator.hasNext()) {
                QuerySchemeValueBo querySchemeValueBo = (QuerySchemeValueBo)iterator.next();
                QuerySchemeFieldBo querySchemeFieldBo = querySchemeValueBo.getQuerySchemeFieldBo();
                if (HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)CUSTOM_TYPE)) continue;
                boolean isRetry = false;
                for (QuerySchemeFieldBo schemeFieldBo : fieldList) {
                    String fieldAlias1;
                    String fieldAlias = querySchemeFieldBo.getFieldAlias();
                    if (fieldAlias.contains("\u03b4")) {
                        fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
                    }
                    if ((fieldAlias1 = schemeFieldBo.getFieldAlias()).contains("\u03b4")) {
                        fieldAlias1 = fieldAlias1.substring(0, fieldAlias1.indexOf("\u03b4"));
                    }
                    if (!HRStringUtils.equals((String)fieldAlias1, (String)fieldAlias)) continue;
                    if (HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)FILTER_TYPE)) {
                        ReportPreViewService.handleFilter(idSet, id, querySchemeValueBo, querySchemeFieldBo, schemeFieldBo);
                    }
                    isRetry = true;
                    break;
                }
                if (isRetry) continue;
                iterator.remove();
                idSet.add(id);
            }
            for (QuerySchemeFieldBo schemeFieldBo : fieldList) {
                ReportPreViewService.handleNewField(idSet, id, querySchemeValueBoList, schemeFieldBo);
            }
            dynamicObject.set("content", (Object)SerializationUtils.toJsonString((Object)querySchemeValueBoList));
        }
        RPTQUERY_SCHEME_HELPER.save(queryColl);
        ReportPreViewService.saveSchemeChangeChg(rptManageId, idSet);
    }

    private static void handleFilter(Set<Long> idSet, Long id, QuerySchemeValueBo querySchemeValueBo, QuerySchemeFieldBo querySchemeFieldBo, QuerySchemeFieldBo schemeFieldBo) {
        if (schemeFieldBo.getMustInput() != querySchemeFieldBo.getMustInput()) {
            querySchemeFieldBo.setMustInput(schemeFieldBo.getMustInput());
            idSet.add(id);
        }
        if (schemeFieldBo.getGroupDate() != querySchemeFieldBo.getGroupDate()) {
            querySchemeFieldBo.setGroupDate(schemeFieldBo.getGroupDate());
            idSet.add(id);
        }
        if (!HRStringUtils.equals((String)schemeFieldBo.getContainSub(), (String)querySchemeFieldBo.getContainSub())) {
            querySchemeFieldBo.setContainSub(schemeFieldBo.getContainSub());
            querySchemeValueBo.setContainSub(HRStringUtils.equals((String)schemeFieldBo.getContainSub(), (String)"0"));
            idSet.add(id);
        }
        if (schemeFieldBo.getOrgLevel() != querySchemeFieldBo.getOrgLevel()) {
            querySchemeFieldBo.setOrgLevel(schemeFieldBo.getOrgLevel());
            idSet.add(id);
        }
        if (schemeFieldBo.getTree() != querySchemeFieldBo.getTree()) {
            querySchemeFieldBo.setTree(schemeFieldBo.getTree());
            if (schemeFieldBo.getTree()) {
                querySchemeValueBo.setCompare("==");
                querySchemeValueBo.setValue("");
                querySchemeValueBo.setName("");
                querySchemeValueBo.setBaseDataId("");
                querySchemeFieldBo.setMustInput(true);
            }
            idSet.add(id);
        }
        if (!HRStringUtils.equals((String)schemeFieldBo.getHisDate(), (String)querySchemeFieldBo.getHisDate())) {
            querySchemeFieldBo.setHisDate(schemeFieldBo.getHisDate());
            idSet.add(id);
        }
        String controlType = querySchemeFieldBo.getControlType();
        ReportPreViewService.enumScope(idSet, id, querySchemeValueBo, querySchemeFieldBo, schemeFieldBo, controlType);
        if (!HRStringUtils.equals((String)schemeFieldBo.getBdFilterRange(), (String)querySchemeFieldBo.getBdFilterRange())) {
            ReportPreViewService.baseDataScope(idSet, id, querySchemeValueBo, querySchemeFieldBo, schemeFieldBo);
        }
    }

    private static void enumScope(Set<Long> idSet, Long id, QuerySchemeValueBo querySchemeValueBo, QuerySchemeFieldBo querySchemeFieldBo, QuerySchemeFieldBo schemeFieldBo, String controlType) {
        if ((HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) && !HRStringUtils.equals((String)schemeFieldBo.getData(), (String)querySchemeFieldBo.getData())) {
            List queryFieldList = SerializationUtils.fromJsonStringToList((String)schemeFieldBo.getData(), ValueMapItem.class);
            List queryValueList = SerializationUtils.fromJsonStringToList((String)querySchemeFieldBo.getData(), ValueMapItem.class);
            boolean isReduceScope = false;
            for (ValueMapItem valueMapItem : queryValueList) {
                boolean isContain = false;
                for (ValueMapItem mapItem : queryFieldList) {
                    if (!HRStringUtils.equals((String)valueMapItem.getValue(), (String)mapItem.getValue())) continue;
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                isReduceScope = true;
                break;
            }
            querySchemeFieldBo.setData(schemeFieldBo.getData());
            if (isReduceScope) {
                querySchemeValueBo.setValue("");
                querySchemeValueBo.setName("");
            }
            idSet.add(id);
        }
    }

    private static void baseDataScope(Set<Long> idSet, Long id, QuerySchemeValueBo querySchemeValueBo, QuerySchemeFieldBo querySchemeFieldBo, QuerySchemeFieldBo schemeFieldBo) {
        String fieldBdFilterRange = schemeFieldBo.getBdFilterRange();
        String baseDataId = querySchemeValueBo.getBaseDataId();
        if (HRStringUtils.isNotEmpty((String)fieldBdFilterRange) && HRStringUtils.isNotEmpty((String)baseDataId)) {
            String[] fieldSplit = fieldBdFilterRange.split(",");
            String[] querySplit = baseDataId.split(",");
            boolean isReduceScope = false;
            for (String queryRange : querySplit) {
                boolean isContain = false;
                for (String fieldRange : fieldSplit) {
                    if (!HRStringUtils.equals((String)fieldRange, (String)queryRange)) continue;
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                isReduceScope = true;
                break;
            }
            if (isReduceScope) {
                querySchemeValueBo.setValue("");
                querySchemeValueBo.setName("");
                querySchemeValueBo.setBaseDataId("");
            }
        }
        querySchemeFieldBo.setBdFilterRange(schemeFieldBo.getBdFilterRange());
        idSet.add(id);
    }

    private static void handleNewField(Set<Long> idSet, Long id, List<QuerySchemeValueBo> querySchemeValueBoList, QuerySchemeFieldBo schemeFieldBo) {
        QuerySchemeValueBo querySchemeValueBo;
        QuerySchemeFieldBo querySchemeFieldBo;
        boolean mustInput = schemeFieldBo.getMustInput();
        boolean isNewField = true;
        Iterator<QuerySchemeValueBo> iterator = querySchemeValueBoList.iterator();
        while (iterator.hasNext() && !HRStringUtils.equals((String)(querySchemeFieldBo = (querySchemeValueBo = iterator.next()).getQuerySchemeFieldBo()).getType(), (String)CUSTOM_TYPE)) {
            String fieldAlias = querySchemeFieldBo.getFieldAlias();
            if (fieldAlias.contains("\u03b4")) {
                fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
            }
            String fieldAlias1 = schemeFieldBo.getFieldAlias();
            if (fieldAlias.contains("\u03b4")) {
                fieldAlias1 = fieldAlias1.substring(0, fieldAlias1.indexOf("\u03b4"));
            }
            if (!HRStringUtils.equals((String)fieldAlias1, (String)fieldAlias) || !HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)FILTER_TYPE)) continue;
            isNewField = false;
            break;
        }
        if (mustInput && isNewField) {
            QuerySchemeValueBo querySchemeValueBo2 = new QuerySchemeValueBo();
            querySchemeValueBo2.setCompare("==");
            querySchemeValueBo2.setQuerySchemeFieldBo(schemeFieldBo);
            querySchemeValueBoList.add(querySchemeValueBo2);
            idSet.add(id);
        }
    }

    public static void synSchemeByReportSave(Long rptManageId) {
        DynamicObject[] queryColl = RPTQUERY_SCHEME_HELPER.query("id,defaultscheme,content,schemename,creator,createtime,rptmanage", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : queryColl) {
            Long id = dynamicObject.getLong("id");
            String content = dynamicObject.getString("content");
            if (!HRStringUtils.isNotEmpty((String)content)) continue;
            List querySchemeValueBoList = SerializationUtils.fromJsonStringToList((String)content, QuerySchemeValueBo.class);
            Iterator iterator = querySchemeValueBoList.iterator();
            boolean isRetry = false;
            while (iterator.hasNext()) {
                QuerySchemeValueBo querySchemeValueBo = (QuerySchemeValueBo)iterator.next();
                QuerySchemeFieldBo querySchemeFieldBo = querySchemeValueBo.getQuerySchemeFieldBo();
                if (!HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)CUSTOM_TYPE)) continue;
                iterator.remove();
                isRetry = true;
            }
            if (isRetry) {
                idSet.add(id);
            }
            dynamicObject.set("content", (Object)SerializationUtils.toJsonString((Object)querySchemeValueBoList));
        }
        RPTQUERY_SCHEME_HELPER.save(queryColl);
        ReportPreViewService.saveSchemeChangeChg(rptManageId, idSet);
    }

    public static void saveSchemeChangeChg(Long rptManageId) {
        DynamicObject[] shareDys;
        DynamicObject[] queryDynColl = RPTQUERY_SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        DynamicObjectCollection collection = new DynamicObjectCollection();
        long[] colIds = ORM.create().genLongIds("hrptmc_queryscmchg", queryDynColl.length);
        for (int i = 0; i < queryDynColl.length; ++i) {
            DynamicObject colDy = RPTSHARE_SCHEME_CHG_HELPER.generateEmptyDynamicObject();
            colDy.set("id", (Object)colIds[i]);
            colDy.set("rptmanage", (Object)rptManageId);
            colDy.set("known", (Object)false);
            colDy.set("user", (Object)queryDynColl[i].getLong("creator.id"));
            collection.add((Object)colDy);
        }
        for (DynamicObject shareDy : shareDys = RPTSHARE_SCHEME_HELPER.query("id,userfield,scheme", new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)})) {
            DynamicObjectCollection userField = shareDy.getDynamicObjectCollection("userfield");
            for (DynamicObject dynamicObject : userField) {
                long userId = dynamicObject.getLong("fbasedataid.id");
                DynamicObject colDy = RPTSHARE_SCHEME_CHG_HELPER.generateEmptyDynamicObject();
                colDy.set("rptmanage", (Object)rptManageId);
                colDy.set("known", (Object)false);
                colDy.set("user", (Object)userId);
                collection.add((Object)colDy);
            }
        }
        RPTSHARE_SCHEME_CHG_HELPER.save(collection);
    }

    public static void saveSchemeChangeChg(Long rptManageId, Set<Long> schemeIds) {
        DynamicObject[] shareDys;
        DynamicObject[] shareChgDynColl;
        if (schemeIds.size() == 0) {
            return;
        }
        DynamicObject[] queryDynColl = RPTQUERY_SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", schemeIds)});
        Map idToCurDyMaps = Arrays.stream(queryDynColl).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (DynamicObject dynamicObject : shareChgDynColl = RPTSHARE_SCHEME_CHG_HELPER.query("rptmanage,user,known,scheme", new QFilter[]{new QFilter("scheme", "in", schemeIds)})) {
            dynamicObject.set("known", (Object)false);
        }
        if (shareChgDynColl.length > 0) {
            RPTSHARE_SCHEME_CHG_HELPER.save(shareChgDynColl);
        }
        Set oldIds = Arrays.stream(shareChgDynColl).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        schemeIds.removeAll(oldIds);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        long[] colIds = ORM.create().genLongIds("hrptmc_queryscmchg", schemeIds.size());
        Long[] array = schemeIds.toArray(new Long[schemeIds.size()]);
        for (int i = 0; i < array.length; ++i) {
            DynamicObject colDy = RPTSHARE_SCHEME_CHG_HELPER.generateEmptyDynamicObject();
            colDy.set("id", (Object)colIds[i]);
            colDy.set("rptmanage", (Object)rptManageId);
            colDy.set("scheme", (Object)array[i]);
            colDy.set("known", (Object)false);
            DynamicObject dynamicObject = (DynamicObject)idToCurDyMaps.get(array[i]);
            colDy.set("user", (Object)dynamicObject.getLong("creator.id"));
            collection.add((Object)colDy);
        }
        for (DynamicObject shareDy : shareDys = RPTSHARE_SCHEME_HELPER.query("id,userfield,scheme", new QFilter[]{new QFilter("scheme", "in", schemeIds)})) {
            DynamicObjectCollection userField = shareDy.getDynamicObjectCollection("userfield");
            for (DynamicObject dynamicObject : userField) {
                long userId = dynamicObject.getLong("fbasedataid.id");
                DynamicObject colDy = RPTSHARE_SCHEME_CHG_HELPER.generateEmptyDynamicObject();
                colDy.set("rptmanage", (Object)rptManageId);
                colDy.set("scheme", (Object)shareDy.getLong("scheme.id"));
                colDy.set("known", (Object)false);
                colDy.set("user", (Object)userId);
                collection.add((Object)colDy);
            }
        }
        RPTSHARE_SCHEME_CHG_HELPER.save(collection);
    }

    public static void clearSchemeChangeChg(long schemeId) {
        RPTSHARE_SCHEME_CHG_HELPER.deleteByFilter(new QFilter[]{new QFilter("scheme", "in", (Object)schemeId).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()))});
    }

    public static boolean querySchemeChangeChgByManageId(Long rptManageId) {
        return RPTSHARE_SCHEME_CHG_HELPER.isExists(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())).and(new QFilter("scheme", "=", (Object)QEmptyValue.value))});
    }

    public static void clearSchemeChangeChgByManageId(Long rptManageId) {
        RPTSHARE_SCHEME_CHG_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()).and(new QFilter("scheme", "=", (Object)QEmptyValue.value)))});
    }
}

