/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.report.MonthTypeEnum;
import kd.hr.hbp.common.model.report.QuarterTypeEnum;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrptmc.business.repdesign.enums.OptEnum;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;

public class ReportSplitDateStyleRuleService {
    public static boolean matchRule(String value, ReportStyleRuleInfo rule) {
        return ReportSplitDateStyleRuleService.matchRule(rule.getO(), value, ReportSplitDateStyleRuleService.getValue(rule));
    }

    private static int getMonth(String value, int num) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        if (null == MonthTypeEnum.getEnum((String)value)) {
            String year;
            String str = org.apache.commons.lang3.StringUtils.getDigits((String)value);
            if (str.startsWith(year = HRDateTimeUtils.getYear((Date)HRDateTimeUtils.addMonth((Date)new Date(), (int)num)) + "")) {
                return Integer.parseInt(str.replace(year, ""));
            }
            int month = Integer.parseInt(str);
            if (month <= 12) {
                return month;
            }
            return 0;
        }
        switch (MonthTypeEnum.valueOf((String)value)) {
            case M01: {
                return 1;
            }
            case M02: {
                return 2;
            }
            case M03: {
                return 3;
            }
            case M04: {
                return 4;
            }
            case M05: {
                return 5;
            }
            case M06: {
                return 6;
            }
            case M07: {
                return 7;
            }
            case M08: {
                return 8;
            }
            case M09: {
                return 9;
            }
            case M10: {
                return 10;
            }
            case M11: {
                return 11;
            }
            case M12: {
                return 12;
            }
        }
        return 0;
    }

    private static int getDigits(String value) {
        return Integer.parseInt(org.apache.commons.lang3.StringUtils.getDigits((String)value));
    }

    private static int getQuarter(String value, int num) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        if (null == MonthTypeEnum.getEnum((String)value)) {
            String year;
            String str = org.apache.commons.lang3.StringUtils.getDigits((String)value);
            if (str.startsWith(year = HRDateTimeUtils.getYear((Date)HRDateTimeUtils.addMonth((Date)new Date(), (int)num)) + "")) {
                return Integer.parseInt(str.replace(year, ""));
            }
            int quarter = Integer.parseInt(str);
            if (quarter <= 4) {
                return quarter;
            }
            return 0;
        }
        switch (QuarterTypeEnum.valueOf((String)value)) {
            case Q1: {
                return 1;
            }
            case Q2: {
                return 2;
            }
            case Q3: {
                return 3;
            }
            case Q4: {
                return 4;
            }
        }
        return 0;
    }

    private static int addQuarter(int quarter, int addQuarter) {
        if ((quarter += addQuarter) == 0) {
            return 4;
        }
        if (quarter == 5) {
            return 1;
        }
        return quarter;
    }

    private static int getYear(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        return ReportSplitDateStyleRuleService.getDigits(value);
    }

    private static List<Object> getValue(ReportStyleRuleInfo rule) {
        boolean flag;
        String opt = rule.getO();
        Object value = rule.getV();
        boolean bl = flag = opt.startsWith(OptEnum.IN.getOpt()) || opt.startsWith(OptEnum.NOT_IN.getOpt()) || opt.startsWith("between") && StringUtils.isNotEmpty((CharSequence)rule.getV());
        if (flag) {
            value = SerializationUtils.fromJsonStringToList((String)rule.getV(), String.class);
            return ((List)value).stream().map(val -> ReportSplitDateStyleRuleService.getValue(val, rule.getVt())).collect(Collectors.toList());
        }
        return Collections.singletonList(ReportSplitDateStyleRuleService.getValue((String)value, rule.getVt()));
    }

    public static Object getValue(String value, String valueType) {
        switch (DataTypeEnum.of((String)valueType)) {
            case STRING: {
                return value;
            }
            case DATETIME: {
                return DateUtils.stringToDate((String)value);
            }
        }
        return value;
    }

    private static boolean matchRule(String opt, String left, List<Object> right) {
        switch (Objects.requireNonNull(OptEnum.of(opt))) {
            case EQUALS: {
                return ReportSplitDateStyleRuleService.equals(left, right.get(0));
            }
            case NOT_EQUALS: {
                return !ReportSplitDateStyleRuleService.equals(left, right.get(0));
            }
            case NULL: {
                return ReportSplitDateStyleRuleService.isNull(left);
            }
            case NOT_NULL: {
                return !ReportSplitDateStyleRuleService.isNull(left);
            }
            case IN: {
                return ReportSplitDateStyleRuleService.in(left, right);
            }
            case NOT_IN: {
                return !ReportSplitDateStyleRuleService.in(left, right);
            }
            case LESS: {
                return ReportSplitDateStyleRuleService.less(left, right.get(0));
            }
            case GREATER: {
                return ReportSplitDateStyleRuleService.greater(left, right.get(0));
            }
            case LESS_OR_EQUAL: {
                return ReportSplitDateStyleRuleService.lessOrEquals(left, right.get(0));
            }
            case GREATER_OR_EQUAL: {
                return ReportSplitDateStyleRuleService.greaterOrEquals(left, right.get(0));
            }
            case BETWEEN5: {
                return ReportSplitDateStyleRuleService.between5(left, right);
            }
            case THIS_MONTH: {
                return ReportSplitDateStyleRuleService.getMonth(left, 0) == HRDateTimeUtils.getMonth((Date)new Date());
            }
            case LAST_MONTH: {
                return ReportSplitDateStyleRuleService.getMonth(left, -1) == HRDateTimeUtils.getMonth((Date)HRDateTimeUtils.addMonth((Date)new Date(), (int)-1));
            }
            case NEXT_MONTH: {
                return ReportSplitDateStyleRuleService.getMonth(left, 1) == HRDateTimeUtils.getMonth((Date)HRDateTimeUtils.addMonth((Date)new Date(), (int)1));
            }
            case THIS_QUARTER: {
                return ReportSplitDateStyleRuleService.getQuarter(left, 0) == HRDateTimeUtils.getQuarter((Date)new Date());
            }
            case LAST_QUARTER: {
                return ReportSplitDateStyleRuleService.getQuarter(left, -1) == ReportSplitDateStyleRuleService.addQuarter(HRDateTimeUtils.getQuarter((Date)new Date()), -1);
            }
            case NEXT_QUARTER: {
                return ReportSplitDateStyleRuleService.getQuarter(left, 1) == ReportSplitDateStyleRuleService.addQuarter(HRDateTimeUtils.getQuarter((Date)new Date()), 1);
            }
            case THIS_YEAR: {
                return ReportSplitDateStyleRuleService.getYear(left) == HRDateTimeUtils.getYear((Date)new Date());
            }
            case LAST_YEAR: {
                return ReportSplitDateStyleRuleService.getYear(left) == HRDateTimeUtils.getYear((Date)HRDateTimeUtils.addYear((Date)new Date(), (int)-1));
            }
            case NEXT_YEAR: {
                return ReportSplitDateStyleRuleService.getYear(left) == HRDateTimeUtils.getYear((Date)HRDateTimeUtils.addYear((Date)new Date(), (int)1));
            }
        }
        return false;
    }

    private static boolean equals(String left, Object right) {
        return ReportSplitDateStyleRuleService.getDigits(left) == ReportSplitDateStyleRuleService.getDigits((String)right);
    }

    private static boolean isNull(Object left) {
        if (left == null) {
            return true;
        }
        if (left instanceof String) {
            return StringUtils.isEmpty((CharSequence)((String)left));
        }
        return false;
    }

    private static boolean in(String left, List<Object> rights) {
        for (Object right : rights) {
            if (!ReportSplitDateStyleRuleService.equals(left, right)) continue;
            return true;
        }
        return false;
    }

    private static boolean less(String left, Object right) {
        return ReportSplitDateStyleRuleService.getDigits(left) < ReportSplitDateStyleRuleService.getDigits((String)right);
    }

    private static boolean lessOrEquals(String left, Object right) {
        return !ReportSplitDateStyleRuleService.greater(left, right);
    }

    private static boolean greater(String left, Object right) {
        return ReportSplitDateStyleRuleService.getDigits(left) > ReportSplitDateStyleRuleService.getDigits((String)right);
    }

    private static boolean greaterOrEquals(String left, Object right) {
        return !ReportSplitDateStyleRuleService.less(left, right);
    }

    private static boolean between5(String left, List<Object> right) {
        return !ReportSplitDateStyleRuleService.less(left, right.get(0)) && !ReportSplitDateStyleRuleService.greater(left, right.get(1));
    }
}

