/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.util.query.DateTimeUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.repdesign.ReportSplitDateStyleRuleService;
import kd.hr.hrptmc.business.repdesign.enums.OptEnum;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;

public class ReportStyleRuleService {
    private static boolean checkValidate(Object value, ReportStyleRuleInfo rule) {
        boolean flag;
        boolean bl = flag = null == rule || StringUtils.isEmpty((CharSequence)rule.getO()) || StringUtils.isEmpty((CharSequence)rule.getV()) && !ReportStyleRuleService.isOnlyOpt(rule.getO());
        if (flag) {
            return false;
        }
        return !ReportStyleRuleService.isNull(value) || ReportStyleRuleService.isOptNullOrNotNull(rule.getO());
    }

    public static boolean matchRule(Object value, ReportStyleRuleInfo rule, SplitDateTypeEnum splitDateTypeEnum) {
        if (!ReportStyleRuleService.checkValidate(value, rule)) {
            return false;
        }
        if (null != splitDateTypeEnum) {
            return ReportSplitDateStyleRuleService.matchRule((String)value, rule);
        }
        return ReportStyleRuleService.matchRule(value, rule);
    }

    private static boolean matchRule(Object value, ReportStyleRuleInfo rule) {
        if (DataTypeEnum.DATETIME.getDataTypeKey().equals(rule.getVt()) && value instanceof String) {
            try {
                value = DateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                String format = DateTimeFieldTimeZoneUtil.getUserDateFormat();
                try {
                    value = DateTimeUtils.parseDate((String)((String)value), (String)format);
                }
                catch (ParseException ex) {
                    value = null;
                }
            }
        }
        return ReportStyleRuleService.matchRule(rule.getO(), value, ReportStyleRuleService.getValue(rule));
    }

    private static boolean isOnlyOpt(String opt) {
        return OptEnum.NULL.getOpt().equals(opt) || OptEnum.NOT_NULL.getOpt().equals(opt) || OptEnum.THIS_MONTH.getOpt().equals(opt) || OptEnum.LAST_MONTH.getOpt().equals(opt) || OptEnum.NEXT_MONTH.getOpt().equals(opt) || OptEnum.THIS_QUARTER.getOpt().equals(opt) || OptEnum.LAST_QUARTER.getOpt().equals(opt) || OptEnum.NEXT_QUARTER.getOpt().equals(opt) || OptEnum.THIS_YEAR.getOpt().equals(opt) || OptEnum.LAST_YEAR.getOpt().equals(opt) || OptEnum.NEXT_YEAR.getOpt().equals(opt);
    }

    private static boolean isOptNullOrNotNull(String opt) {
        return OptEnum.NULL.getOpt().equals(opt) || OptEnum.NOT_NULL.getOpt().equals(opt);
    }

    private static List<Object> getValue(ReportStyleRuleInfo rule) {
        String opt = rule.getO();
        Object value = rule.getV();
        if ((ParamTypeEnum.ENUM.getType().equals(rule.getPt()) || ParamTypeEnum.BOOLEAN.getType().equals(rule.getPt())) && StringUtils.isNotEmpty((CharSequence)rule.getDv())) {
            value = SerializationUtils.fromJsonStringToList((String)rule.getDv(), String.class);
        }
        if ((opt.startsWith("between") || ParamTypeEnum.BASEDATA.getType().equals(rule.getPt()) || ParamTypeEnum.ADMINORG.getType().equals(rule.getPt())) && StringUtils.isNotEmpty((CharSequence)rule.getV())) {
            value = SerializationUtils.fromJsonStringToList((String)rule.getV(), String.class);
        }
        return ReportStyleRuleService.getValues(value, rule.getVt());
    }

    private static List<Object> getValues(Object value, String valueType) {
        if (value instanceof List) {
            return ((List)value).stream().map(val -> ReportStyleRuleService.getValue(val, valueType)).collect(Collectors.toList());
        }
        return Collections.singletonList(ReportStyleRuleService.getValue((String)value, valueType));
    }

    public static Object getValue(String value, String valueType) {
        switch (DataTypeEnum.of((String)valueType)) {
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case LONG: {
                return Long.valueOf(value);
            }
            case BIGDECIMAL: {
                return new BigDecimal(value);
            }
            case BOOLEAN: 
            case STRING: {
                return value;
            }
            case DATETIME: {
                return DateUtils.stringToDate((String)value);
            }
        }
        return value;
    }

    private static boolean matchRule(String opt, Object left, List<Object> right) {
        switch (Objects.requireNonNull(OptEnum.of(opt))) {
            case EQUALS: {
                return ReportStyleRuleService.equals(left, right);
            }
            case NOT_EQUALS: {
                return !ReportStyleRuleService.equals(left, right);
            }
            case NULL: {
                return ReportStyleRuleService.isNull(left);
            }
            case NOT_NULL: {
                return !ReportStyleRuleService.isNull(left);
            }
            case LESS: {
                return ReportStyleRuleService.less(left, right.get(0));
            }
            case GREATER: {
                return ReportStyleRuleService.greater(left, right.get(0));
            }
            case LESS_OR_EQUAL: {
                return ReportStyleRuleService.lessOrEquals(left, right.get(0));
            }
            case GREATER_OR_EQUAL: {
                return ReportStyleRuleService.greaterOrEquals(left, right.get(0));
            }
            case BETWEEN1: {
                return ReportStyleRuleService.between1(left, right);
            }
            case BETWEEN2: {
                return ReportStyleRuleService.between2(left, right);
            }
            case BETWEEN3: {
                return ReportStyleRuleService.between3(left, right);
            }
            case BETWEEN4: {
                return ReportStyleRuleService.between4(left, right);
            }
            case BETWEEN5: {
                return ReportStyleRuleService.between5(left, right);
            }
            case IN: {
                return ReportStyleRuleService.in(left, right);
            }
            case NOT_IN: {
                return !ReportStyleRuleService.in(left, right);
            }
            case CONTAINS: {
                return ReportStyleRuleService.contains(left, right.get(0));
            }
            case NOT_CONTAINS: {
                return !ReportStyleRuleService.contains(left, right.get(0));
            }
            case STARTS_WITH: {
                return ReportStyleRuleService.startsWith(left, right.get(0));
            }
            case ENDS_WITH: {
                return ReportStyleRuleService.endsWith(left, right.get(0));
            }
        }
        return false;
    }

    private static boolean equals(Object left, Object right) {
        List rs = (List)right;
        if (rs.size() > 1) {
            return Objects.equals(left, SerializationUtils.toJsonString((Object)right));
        }
        if (left instanceof Date && rs.get(0) instanceof Date) {
            return Objects.equals(left, rs.get(0));
        }
        return Objects.equals(left, String.valueOf(rs.get(0)));
    }

    private static boolean isNull(Object left) {
        if (left == null) {
            return true;
        }
        if (left instanceof String) {
            return StringUtils.isEmpty((CharSequence)((String)left));
        }
        return false;
    }

    private static boolean less(Object left, Object right) {
        if (left instanceof Date && right instanceof Date) {
            return ((Date)left).before((Date)right);
        }
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right))) < 0;
    }

    private static boolean lessOrEquals(Object left, Object right) {
        return !ReportStyleRuleService.greater(left, right);
    }

    private static boolean greater(Object left, Object right) {
        if (left instanceof Date && right instanceof Date) {
            return ((Date)left).after((Date)right);
        }
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right))) > 0;
    }

    private static boolean greaterOrEquals(Object left, Object right) {
        return !ReportStyleRuleService.less(left, right);
    }

    private static boolean between1(Object left, List<Object> right) {
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(0)))) >= 0 && new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(1)))) < 0;
    }

    private static boolean between2(Object left, List<Object> right) {
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(0)))) > 0 && new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(1)))) <= 0;
    }

    private static boolean between3(Object left, List<Object> right) {
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(0)))) > 0 && new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(1)))) < 0;
    }

    private static boolean between4(Object left, List<Object> right) {
        return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(0)))) >= 0 && new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right.get(1)))) <= 0;
    }

    private static boolean between5(Object left, List<Object> right) {
        return !((Date)left).before((Date)right.get(0)) && !((Date)left).after((Date)right.get(1));
    }

    private static boolean in(Object left, List<Object> right) {
        if ("SingletonList".equals(right.getClass().getSimpleName())) {
            return ((String)right.get(0)).contains((String)left);
        }
        return right.contains(left);
    }

    private static boolean contains(Object left, Object right) {
        return left != null && ((String)left).contains((String)right);
    }

    private static boolean startsWith(Object left, Object right) {
        return left != null && ((String)left).startsWith((String)right);
    }

    private static boolean endsWith(Object left, Object right) {
        return left != null && ((String)left).endsWith((String)right);
    }
}

