/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.hr.hrptmc.business.publish.HRReportPublishMenuService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.ReportPermissionService;

public class RptCenterPublishService {
    public static String getPublishPath(Long rptManageId) {
        DynamicObject rptCenterDy = ReportManageService.queryRptGroup(rptManageId);
        Long rptGroupId = rptCenterDy.getLong("reportgroup");
        DynamicObjectCollection rptGroupColl = ReportManageService.queryAllRptGroup();
        Map<Long, DynamicObject> groupMap = rptGroupColl.stream().collect(Collectors.toMap(rptGroup -> rptGroup.getLong("id"), x -> x));
        HashMap<Long, String> groupPathMap = new HashMap<Long, String>(1);
        return RptCenterPublishService.getGroupPath(groupMap, groupPathMap, rptGroupId);
    }

    public static Map<String, String> getPublishPathMaps() {
        HashMap<String, String> publishPathMaps = new HashMap<String, String>();
        DynamicObjectCollection rptCenterColl = ReportManageService.queryAllRptCenter();
        if (null != rptCenterColl && !rptCenterColl.isEmpty()) {
            DynamicObjectCollection rptGroupColl = ReportManageService.queryAllRptGroup();
            Map<Long, DynamicObject> groupMap = rptGroupColl.stream().collect(Collectors.toMap(rptGroup -> rptGroup.getLong("id"), x -> x));
            List endGroupList = rptGroupColl.stream().filter(rptGroup -> rptGroup.getBoolean("isendgroup")).collect(Collectors.toList());
            HashMap<Long, String> groupPathMap = new HashMap<Long, String>(endGroupList.size());
            HashMap<Long, String> endGroupPathMap = new HashMap<Long, String>(endGroupList.size());
            for (DynamicObject endGroup : endGroupList) {
                Long id = endGroup.getLong("id");
                String groupPath = RptCenterPublishService.getGroupPath(groupMap, groupPathMap, endGroup.getLong("id"));
                endGroupPathMap.put(id, groupPath);
            }
            for (DynamicObject rptCenterDy : rptCenterColl) {
                String rptManageId = rptCenterDy.getString("reportmanage");
                Long rptGroupId = rptCenterDy.getLong("reportgroup");
                String publishPath = (String)publishPathMaps.getOrDefault(rptManageId, (String)endGroupPathMap.get(rptGroupId));
                publishPathMaps.put(rptManageId, publishPath);
            }
        }
        return publishPathMaps;
    }

    private static String getGroupPath(Map<Long, DynamicObject> groupMap, Map<Long, String> groupPathMap, Long id) {
        String groupPath = groupPathMap.get(id);
        if (StringUtils.isEmpty((CharSequence)groupPath)) {
            DynamicObject groupDy = groupMap.get(id);
            Long parentId = groupDy.getLong("parent");
            if (IDStringUtils.idEmpty((Long)parentId)) {
                groupPathMap.put(groupDy.getLong("id"), groupDy.getString("name"));
                return groupDy.getString("name");
            }
            groupPath = RptCenterPublishService.getGroupPath(groupMap, groupPathMap, parentId) + "/" + groupDy.getString("name");
            groupPathMap.put(id, groupPath);
        }
        return groupPath;
    }

    public static void offline(long rptManageId) {
        ReportManageService.deleteReportCenter(rptManageId);
        ReportPermissionService.delRptCtrPerm(rptManageId);
        ReportManageService.deleteReportSubscribe(rptManageId);
        HRReportPublishMenuService.updateReportStatusUnpublished(rptManageId);
    }
}

