/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.datastore;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreInfo;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.datastore.SortFieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.enums.ControlType2ParamType;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class ReportDataStoreFieldService
implements ReportManageConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportDataStoreFieldService.class);
    private final List<JoinEntityBo> joinEntityBos;
    private final DynamicObject reportDy;
    private DynamicObject[] reportConfigs;
    private boolean isSaveSplitDateField;

    public ReportDataStoreFieldService(DynamicObject reportDy, List<JoinEntityBo> joinEntityBos) {
        this.joinEntityBos = joinEntityBos;
        this.reportDy = reportDy;
    }

    public ReportDataStoreFieldService(DynamicObject reportDy, List<JoinEntityBo> joinEntityBos, boolean isSaveSplitDateField) {
        this.joinEntityBos = joinEntityBos;
        this.reportDy = reportDy;
        this.isSaveSplitDateField = isSaveSplitDateField;
    }

    public FieldDataStoreBO getField() {
        FieldDataStoreBO fieldDataStoreBO = new FieldDataStoreBO();
        DynamicObject[] workRpts = ReportManageService.getWorkRpt(this.reportDy.getLong("id"));
        DynamicObject[] rptCfgDys = ReportManageService.getRptConfigs(this.reportDy.getLong("id"));
        List<List<FieldInfo>> distinctList = this.getDistinctList(workRpts, rptCfgDys);
        fieldDataStoreBO.setDistinctFieldInfoList(distinctList);
        List<FieldInfo> rowFieldInfoList = this.getRowFieldInfoList(workRpts);
        HashSet rowFieldNumSet = Sets.newHashSetWithExpectedSize((int)128);
        for (FieldInfo fieldInfo : rowFieldInfoList) {
            rowFieldNumSet.add(fieldInfo.getNumber());
        }
        List<FieldInfo> colFieldInfoList = this.getColFieldInfoList(workRpts);
        long anObjId = this.reportDy.getLong("anobjid.id");
        AnalyseObjectService analyseObjectService = AnalyseObjectService.getInstance();
        List<QueryFieldBo> queryFieldBos = analyseObjectService.queryAndAssembleQueryFields(anObjId);
        List<FieldInfo> fieldInfoList = this.getRowAndColFieldInfoList(rowFieldInfoList, colFieldInfoList, queryFieldBos);
        fieldDataStoreBO.setFieldInfoList(fieldInfoList);
        HashSet calFieldSet = Sets.newHashSetWithExpectedSize((int)fieldInfoList.size());
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (!"1".equals(fieldInfo.getFieldSrc())) continue;
            calFieldSet.add(fieldInfo.getNumber());
        }
        fieldDataStoreBO.setFilterFieldInfoList(this.getFilterFieldList(queryFieldBos));
        List<CalculateFieldBo> anCalculateFieldBoList = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        List<FieldInfo> drillFieldList = this.getDrillFieldList(rowFieldNumSet, queryFieldBos, anCalculateFieldBoList);
        fieldDataStoreBO.setDrillFieldInfoList(drillFieldList);
        for (FieldInfo fieldInfo : drillFieldList) {
            if (!"1".equals(fieldInfo.getFieldSrc())) continue;
            calFieldSet.add(fieldInfo.getNumber());
        }
        HashSet summaryFieldSet = Sets.newHashSetWithExpectedSize((int)calFieldSet.size());
        fieldDataStoreBO.setRefFieldInfoList(this.getRelFieldInfoList(queryFieldBos, calFieldSet, anCalculateFieldBoList, summaryFieldSet));
        fieldInfoList.removeIf(fi -> summaryFieldSet.contains(fi.getNumber()));
        drillFieldList.removeIf(df -> summaryFieldSet.contains(df.getNumber()));
        fieldDataStoreBO.setSortFieldInfoList(this.getSortFieldDataStore(workRpts, rptCfgDys, queryFieldBos));
        fieldDataStoreBO.setFilterExtFieldInfoList(this.getFilterExtFieldInfoList());
        fieldDataStoreBO.genStoreFieldList();
        LOGGER.info("ReportDataStoreService_getField:{}", (Object)fieldDataStoreBO);
        return fieldDataStoreBO;
    }

    private List<SortFieldDataStoreBO> getSortFieldDataStore(DynamicObject[] workRpts, DynamicObject[] rptCfgDys, List<QueryFieldBo> queryFieldBos) {
        Map<Long, String> legendMap = Arrays.stream(rptCfgDys).collect(Collectors.toMap(dy -> dy.getDynamicObject("workrpt").getLong("id"), dy -> dy.getString("legend")));
        ArrayList sortFieldDataStoreBOS = Lists.newArrayListWithExpectedSize((int)32);
        for (DynamicObject dynamicObject : workRpts) {
            String legend;
            String column;
            SortFieldDataStoreBO rowBo = new SortFieldDataStoreBO();
            String row = dynamicObject.getString("row");
            if (HRStringUtils.isNotEmpty((String)row)) {
                ArrayList rowFieldInfoList = Lists.newArrayListWithExpectedSize((int)32);
                List rows = JSON.parseArray((String)row, RowFieldInfo.class);
                for (RowFieldInfo rowFieldInfo : rows) {
                    if (!HRStringUtils.equals((String)rowFieldInfo.getMergeType(), (String)"1")) {
                        rowFieldInfoList.add(rowFieldInfo.getGroupName());
                    }
                    ReportManageService.recursive(rowFieldInfo._getChildFields(), rowFieldInfoList::add);
                }
                rowBo.setRptWorkId(dynamicObject.getLong("id"));
                rowBo.setType("r");
                rowBo.setSortFieldInfoList(this.getSortFieldInfoList(rowFieldInfoList, queryFieldBos));
                sortFieldDataStoreBOS.add(rowBo);
            }
            if (HRStringUtils.isNotEmpty((String)(column = dynamicObject.getString("column")))) {
                SortFieldDataStoreBO columnBo = new SortFieldDataStoreBO();
                columnBo.setRptWorkId(dynamicObject.getLong("id"));
                columnBo.setType("c");
                columnBo.setSortFieldInfoList(this.getSortFieldInfoList(JSON.parseArray((String)column, FieldInfo.class), queryFieldBos));
                sortFieldDataStoreBOS.add(columnBo);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(legend = legendMap.get(dynamicObject.getLong("id"))))) continue;
            SortFieldDataStoreBO legendBo = new SortFieldDataStoreBO();
            legendBo.setRptWorkId(dynamicObject.getLong("id"));
            legendBo.setType("l");
            legendBo.setSortFieldInfoList(this.getSortFieldInfoList(JSON.parseArray((String)legend, FieldInfo.class), queryFieldBos));
            sortFieldDataStoreBOS.add(legendBo);
        }
        return sortFieldDataStoreBOS;
    }

    private List<FieldInfo> getRowAndColFieldInfoList(List<FieldInfo> rowFieldInfoList, List<FieldInfo> colFieldInfoList, List<QueryFieldBo> queryFieldBos) {
        rowFieldInfoList.addAll(colFieldInfoList);
        for (DynamicObject reportConfig : this.reportConfigs = ReportManageService.getRptConfigs(this.reportDy.getLong("id"))) {
            List fieldInfoList;
            String json = reportConfig.getString("legend");
            if (!HRStringUtils.isNotEmpty((String)json) || (fieldInfoList = JSON.parseArray((String)json, FieldInfo.class)) == null) continue;
            rowFieldInfoList.addAll(fieldInfoList);
        }
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, qf -> qf));
        for (FieldInfo fieldInfo : rowFieldInfoList) {
            if (!HRStringUtils.isEmpty((String)fieldInfo.getControlType())) continue;
            if ("0".equals(fieldInfo.getFieldSrc())) {
                fieldInfo.setControlType(queryFieldBoMap.get(fieldInfo.getNumber()).getControlType());
                continue;
            }
            fieldInfo.setControlType(ReportDataStoreServiceHelper.getDefaultControlType(fieldInfo.getValueType()));
        }
        this.handleDateSplitDate(rowFieldInfoList, queryFieldBos);
        this.handleDateSplitCombo(rowFieldInfoList);
        return rowFieldInfoList;
    }

    private List<FieldInfo> getRowFieldInfoList(DynamicObject[] workRpt) {
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)32);
        for (DynamicObject dynamicObject : workRpt) {
            String row = dynamicObject.getString("row");
            if (!HRStringUtils.isNotEmpty((String)row)) continue;
            List rows = JSON.parseArray((String)row, RowFieldInfo.class);
            for (RowFieldInfo rowFieldInfo : rows) {
                if (!HRStringUtils.equals((String)rowFieldInfo.getMergeType(), (String)"1")) {
                    fieldInfoList.add(rowFieldInfo.getGroupName());
                }
                ReportManageService.recursive(rowFieldInfo._getChildFields(), fieldInfoList::add);
            }
        }
        fieldInfoList.removeIf(fi -> "2".equals(fi.getFieldSrc()));
        return fieldInfoList;
    }

    private List<FieldInfo> getColFieldInfoList(DynamicObject[] workRpt) {
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)32);
        for (DynamicObject dynamicObject : workRpt) {
            String column = dynamicObject.getString("column");
            if (!HRStringUtils.isNotEmpty((String)column)) continue;
            List columns = JSON.parseArray((String)column, FieldInfo.class);
            fieldInfoList.addAll(columns);
        }
        fieldInfoList.removeIf(fi -> "2".equals(fi.getFieldSrc()));
        return fieldInfoList;
    }

    private void handleDateSplitDate(List<FieldInfo> fieldInfoList, List<QueryFieldBo> anoFieldList) {
        HashSet splitDateFieldIdSet = Sets.newHashSetWithExpectedSize((int)fieldInfoList.size());
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (!this.isDateSplitDate(fieldInfo)) continue;
            splitDateFieldIdSet.add(fieldInfo.getFieldId());
            if (!this.isSaveSplitDateField) continue;
            fieldInfo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
            fieldInfo.setControlType(FieldControlType.TEXT.getValue());
        }
        if (!this.isSaveSplitDateField) {
            fieldInfoList.removeIf(this::isDateSplitDate);
        }
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (!splitDateFieldIdSet.contains(fieldInfo.getFieldId()) || fieldInfo.getNumber().contains("!")) continue;
            splitDateFieldIdSet.remove(fieldInfo.getFieldId());
        }
        fieldInfoList.addAll(this.getFieldInfoByFieldIds(splitDateFieldIdSet, anoFieldList));
    }

    private void handleDateSplitCombo(List<FieldInfo> fieldInfoList) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (!fieldInfo.getNumber().contains("!")) continue;
            String[] dateSplit = fieldInfo.getNumber().split("!");
            SplitDateTypeEnum splitDateType = SplitDateTypeEnum.getEnum((String)dateSplit[1]);
            switch (splitDateType) {
                case SN_QUARTER: 
                case FN_QUARTER: 
                case SN_MONTH: 
                case FN_MONTH: 
                case SN_DAY: 
                case FN_DAY: {
                    fieldInfo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
                    fieldInfo.setControlType(FieldControlType.COMBO.getValue());
                    break;
                }
            }
        }
    }

    private List<FieldDataStoreInfo> getFilterFieldList(List<QueryFieldBo> queryFieldBoList) {
        long reportId = this.reportDy.getLong("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObject[] results = serviceHelper.queryOriginalArray("anobjfield,splitdate.number,begindate,enddate,groupfield,ismust", new QFilter[]{new QFilter("rptmanage", "in", (Object)reportId)});
        long anObjId = this.reportDy.getLong("anobjid.id");
        List<AnObjGroupField> groupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, (List<QueryFieldBo>)Lists.newArrayList());
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, qf -> qf));
        Map<String, AnObjGroupField> groupFieldMap = groupFields.stream().collect(Collectors.toMap(AnObjGroupField::getId, qf -> qf));
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)results.length);
        Set mustInputSet = Arrays.stream(results).filter(dy -> dy.getBoolean("ismust")).map(dy -> dy.getLong("anobjfield")).collect(Collectors.toSet());
        for (DynamicObject result : results) {
            QueryFieldBo queryFieldBo;
            long fieldId = result.getLong("anobjfield");
            String number = result.getString("splitdate.number");
            long beginDateId = result.getLong("begindate");
            long endDateId = result.getLong("enddate");
            long groupFieldId = result.getLong("groupfield");
            long otherFieldId = 0L;
            if (beginDateId != 0L && beginDateId != fieldId) {
                otherFieldId = beginDateId;
            } else if (endDateId != 0L && endDateId != fieldId) {
                otherFieldId = endDateId;
            }
            if (otherFieldId != 0L) {
                QueryFieldBo queryFieldBo2 = queryFieldBoMap.get(otherFieldId + "");
                FieldDataStoreInfo fieldInfo = ReportDataStoreFieldService.queryField2FieldInfo(queryFieldBo2);
                fieldInfoList.add(fieldInfo);
            }
            if (fieldId != 0L) {
                queryFieldBo = queryFieldBoMap.get(fieldId + "");
            } else {
                AnObjGroupField anObjGroupField = groupFieldMap.get(groupFieldId + "");
                queryFieldBo = anObjGroupField.getAnObjField();
            }
            FieldDataStoreInfo fieldInfo = !HRStringUtils.isEmpty((String)number) ? ReportDataStoreFieldService.queryFieldBo2SplitData(queryFieldBo, number) : ReportDataStoreFieldService.queryField2FieldInfo(queryFieldBo);
            fieldInfoList.add(fieldInfo);
        }
        this.handleDateSplitDate(new ArrayList<FieldInfo>(fieldInfoList), queryFieldBoList);
        this.handleDateSplitCombo(new ArrayList<FieldInfo>(fieldInfoList));
        for (FieldDataStoreInfo fieldInfo : fieldInfoList) {
            fieldInfo.setMustInput(mustInputSet.contains(Long.parseLong(fieldInfo.getFieldId())));
            fieldInfo.setSortSeq(ReportDataStoreFieldService.getSortSeq(queryFieldBoMap.get(fieldInfo.getFieldId())));
        }
        return fieldInfoList;
    }

    private List<FieldInfo> getDrillFieldList(Set<String> rowFieldNumSet, List<QueryFieldBo> queryFieldBoList, List<CalculateFieldBo> anCalculateFieldBoList) {
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)queryFieldBoList.size());
        HashSet drillingNumSet = Sets.newHashSetWithExpectedSize((int)rowFieldNumSet.size());
        String url = this.reportDy.getString("drillingdrl");
        if (!HRStringUtils.isEmpty((String)url)) {
            Map drillingDrl = (Map)SerializationUtils.fromJsonString((String)url, Map.class);
            for (String rowFieldNum : rowFieldNumSet) {
                String drillField = (String)drillingDrl.get(rowFieldNum);
                if (HRStringUtils.isEmpty((String)drillField)) continue;
                String[] split = drillField.split(",");
                drillingNumSet.addAll(Arrays.asList(split).subList(1, split.length));
            }
        }
        drillingNumSet.removeIf(rowFieldNumSet::contains);
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, qf -> qf));
        Map<String, CalculateFieldBo> calculateFieldBoMap = anCalculateFieldBoList.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, ac -> ac));
        for (String drillingNum : drillingNumSet) {
            QueryFieldBo queryFieldBo = queryFieldBoMap.get(drillingNum);
            if (queryFieldBo == null) {
                CalculateFieldBo calculateFieldBo = calculateFieldBoMap.get(drillingNum);
                if (calculateFieldBo == null) continue;
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setFieldId(calculateFieldBo.getId());
                fieldInfo.setNumber(calculateFieldBo.getFieldNumber());
                fieldInfo.setNumberAlias(calculateFieldBo.getFieldNumber());
                fieldInfo.setFieldPath(calculateFieldBo.getFieldNumber());
                fieldInfo.setDisplayName(calculateFieldBo.getFieldName());
                fieldInfo.setName(fieldInfo.getDisplayName());
                fieldInfo.setValueType(calculateFieldBo.getValueType());
                fieldInfo.setControlType(calculateFieldBo.getControlType());
                fieldInfo.setFieldSrc("1");
                ReportDataStoreServiceHelper.setType(fieldInfo);
                fieldInfoList.add(fieldInfo);
                continue;
            }
            fieldInfoList.add(ReportDataStoreFieldService.queryField2FieldInfo(queryFieldBo));
        }
        return fieldInfoList;
    }

    private List<FieldInfo> getRelFieldInfoList(List<QueryFieldBo> queryFieldBoList, Set<String> calFieldSet, List<CalculateFieldBo> anCalculateFieldBoList, Set<String> summaryFieldSet) {
        long anObjId = this.reportDy.getLong("anobjid.id");
        long reportId = this.reportDy.getLong("id");
        List<CalculateFieldBo> calculateFieldBoList = CalculateFieldService.getInstance().loadCalFieldsByReportIdForBo(anObjId, reportId, Collections.emptyList());
        calculateFieldBoList.addAll(anCalculateFieldBoList);
        HashSet relFieldSet = Sets.newHashSetWithExpectedSize((int)calculateFieldBoList.size());
        for (CalculateFieldBo calculateFieldBo : calculateFieldBoList) {
            if (!calFieldSet.contains(calculateFieldBo.getFieldNumber()) || !"summary".equals(calculateFieldBo.getCalMethod())) continue;
            summaryFieldSet.add(calculateFieldBo.getFieldNumber());
            this.addCalFieldBySummary(calculateFieldBo, relFieldSet);
        }
        return this.buildFieldInfoList(relFieldSet, queryFieldBoList, anObjId, calculateFieldBoList);
    }

    private List<FieldInfo> getSortFieldInfoList(List<FieldInfo> fieldInfoList, List<QueryFieldBo> queryFieldBoList) {
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, qf -> qf));
        ArrayList sortFieldInfoList = Lists.newArrayListWithExpectedSize((int)fieldInfoList.size());
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (SortEnum.FIELD.getValue().equals(fieldInfo.getSort())) {
                FieldSortInfo fieldSortInfo = fieldInfo.getFieldSortInfo();
                String number = fieldSortInfo.getNumber();
                QueryFieldBo queryFieldBo = queryFieldBoMap.get(number);
                if (queryFieldBo == null) continue;
                sortFieldInfoList.add(ReportDataStoreFieldService.queryField2FieldInfo(queryFieldBo));
                continue;
            }
            if (SortEnum.CUSTOM.getValue().equals(fieldInfo.getSort())) {
                FieldInfo sortFieldInfo = new FieldInfo();
                sortFieldInfo.setRowFieldId(fieldInfo.getRowFieldId());
                sortFieldInfo.setNumber(fieldInfo.getNumber() + "\u03b9index");
                sortFieldInfo.setNumberAlias(fieldInfo.getNumberAlias() + "\u03b9index");
                sortFieldInfo.setFieldPath(fieldInfo.getFieldPath() + "\u03b9index");
                sortFieldInfo.setDisplayName(fieldInfo.getDisplayName());
                sortFieldInfo.setName(sortFieldInfo.getDisplayName());
                sortFieldInfo.setValueType(DataTypeEnum.INTEGER.getDataTypeKey());
                sortFieldInfo.setComplexType(FieldComplexType.NORMAL.getValue());
                sortFieldInfo.setControlType(FieldControlType.INTEGER.getValue());
                ReportDataStoreServiceHelper.setType(fieldInfo);
                sortFieldInfoList.add(sortFieldInfo);
                continue;
            }
            if (!SortEnum.ASC.getValue().equals(fieldInfo.getSort()) && !SortEnum.DESC.getValue().equals(fieldInfo.getSort())) continue;
            sortFieldInfoList.add(fieldInfo);
        }
        HashSet numberAliasSet = Sets.newHashSetWithExpectedSize((int)sortFieldInfoList.size());
        sortFieldInfoList.removeIf(next -> !numberAliasSet.add(next.getNumberAlias()));
        this.handleDateSplitDate(sortFieldInfoList, queryFieldBoList);
        this.handleDateSplitCombo(sortFieldInfoList);
        return sortFieldInfoList;
    }

    private List<FieldDataStoreInfo> getFilterExtFieldInfoList() {
        long reportId = this.reportDy.getLong("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_filterextfield");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "=", (Object)reportId)});
        HashSet numSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            numSet.add(dynamicObject.getString("number"));
        }
        Set mustInputSet = Arrays.stream(dynamicObjects).filter(dy -> dy.getBoolean("ismust")).map(dy -> dy.getString("number")).collect(Collectors.toSet());
        FieldDefineService fieldDefineService = new FieldDefineService();
        List joinEntityCommonBoList = this.joinEntityBos.stream().map(je -> je).collect(Collectors.toList());
        List entityAllFields = fieldDefineService.getEntityAllFields(joinEntityCommonBoList, (List)Lists.newArrayList());
        HashMap queryFieldBoMap = Maps.newHashMapWithExpectedSize((int)numSet.size());
        ReportDataStoreFieldService.convertToBO(queryFieldBoMap, entityAllFields);
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)numSet.size());
        for (String num : numSet) {
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldBoMap.get(num);
            if (queryFieldBo == null) continue;
            AnalyseObjectUtil.setFieldControlType((List)Lists.newArrayList((Object[])new QueryFieldCommonBo[]{queryFieldBo}));
            FieldDataStoreInfo fieldDataStoreInfo = ReportDataStoreFieldService.queryField2FieldInfo(queryFieldBo);
            fieldDataStoreInfo.setMustInput(mustInputSet.contains(queryFieldBo.getFieldAlias()));
            fieldDataStoreInfo.setSortSeq(ReportDataStoreFieldService.getSortSeq(queryFieldBo));
            fieldInfoList.add(fieldDataStoreInfo);
        }
        return fieldInfoList;
    }

    private void addCalFieldBySummary(CalculateFieldBo calculateFieldBo, Set<String> refFieldSet) {
        if ("summary".equals(calculateFieldBo.getCalMethod())) {
            List refEntityFields = calculateFieldBo.getRefEntityFields();
            List refGroupFields = calculateFieldBo.getRefGroupFields();
            refFieldSet.addAll(refEntityFields);
            refFieldSet.addAll(refGroupFields);
            List refCalculateFields = calculateFieldBo.getRefCalculateFields();
            for (CalculateFieldBo refCalculateField : refCalculateFields) {
                this.addCalFieldBySummary(refCalculateField, refFieldSet);
            }
        } else {
            refFieldSet.add(calculateFieldBo.getFieldNumber());
        }
    }

    private List<FieldInfo> buildFieldInfoList(Set<String> refFieldSet, List<QueryFieldBo> queryFieldBoList, long anObjId, List<CalculateFieldBo> calculateFieldBoList) {
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)refFieldSet.size());
        if (!refFieldSet.isEmpty()) {
            AnObjGroupFieldService instance = AnObjGroupFieldService.getInstance();
            List<AnObjGroupField> groupFields = instance.getGroupFields(anObjId, Collections.emptyList());
            Map<String, AnObjGroupField> groupFieldMap = groupFields.stream().collect(Collectors.toMap(AnObjGroupField::getNumber, ag -> ag));
            Map<String, QueryFieldBo> queryFieldMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, ag -> ag));
            Map<String, CalculateFieldBo> calculateFieldBoMap = calculateFieldBoList.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, cf -> cf));
            List<PivotIndexFieldBo> analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(anObjId, queryFieldBoList, calculateFieldBoList, true);
            Map<String, PivotIndexFieldBo> pivotIndexFieldBoMap = analysePivotIndexes.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, cf -> cf));
            for (String refField : refFieldSet) {
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setNumber(refField);
                fieldInfo.setNumberAlias(refField);
                AnObjGroupField anObjGroupField = groupFieldMap.get(refField);
                QueryFieldBo queryFieldBo = queryFieldMap.get(refField);
                CalculateFieldBo calculateFieldBo = calculateFieldBoMap.get(refField);
                PivotIndexFieldBo pivotIndexFieldBo = pivotIndexFieldBoMap.get(refField);
                if (anObjGroupField != null) {
                    QueryFieldBo anObjField = anObjGroupField.getAnObjField();
                    fieldInfo.setValueType(anObjField.getValueType());
                    fieldInfo.setControlType(anObjField.getControlType());
                    fieldInfo.setDisplayName(anObjField.getFieldName());
                    fieldInfo.setFieldPath(anObjField.getFieldPath());
                } else if (queryFieldBo != null) {
                    fieldInfo.setValueType(queryFieldBo.getValueType());
                    fieldInfo.setControlType(queryFieldBo.getControlType());
                    fieldInfo.setDisplayName(queryFieldBo.getFieldName());
                    fieldInfo.setFieldPath(queryFieldBo.getFieldPath());
                } else if (calculateFieldBo != null) {
                    fieldInfo.setValueType(calculateFieldBo.getValueType());
                    String controlType = calculateFieldBo.getControlType();
                    if (HRStringUtils.isEmpty((String)controlType)) {
                        controlType = ReportDataStoreServiceHelper.getDefaultControlType(fieldInfo.getValueType());
                    }
                    fieldInfo.setControlType(controlType);
                    fieldInfo.setDisplayName(calculateFieldBo.getFieldName());
                    fieldInfo.setFieldSrc("1");
                    fieldInfo.setFieldPath(calculateFieldBo.getFieldNumber());
                } else if (pivotIndexFieldBo != null) {
                    fieldInfo.setValueType(pivotIndexFieldBo.getValueType());
                    fieldInfo.setControlType(pivotIndexFieldBo.getControlType());
                    fieldInfo.setDisplayName(pivotIndexFieldBo.getFieldName());
                    fieldInfo.setFieldPath(pivotIndexFieldBo.getFieldPath());
                    fieldInfo.setPivotIndex(true);
                }
                fieldInfo.setName(fieldInfo.getDisplayName());
                ReportDataStoreServiceHelper.setType(fieldInfo);
                fieldInfoList.add(fieldInfo);
            }
        }
        return fieldInfoList;
    }

    private static FieldDataStoreInfo queryFieldBo2SplitData(QueryFieldBo queryFieldBo, String number) {
        FieldDataStoreInfo fieldInfo = new FieldDataStoreInfo();
        SplitDateTypeEnum splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)number);
        fieldInfo.setDisplayName(new LocaleString(splitDateTypeEnum.getName() + "\uff08" + queryFieldBo.getFieldName() + "\uff09"));
        fieldInfo.setName(fieldInfo.getDisplayName());
        fieldInfo.setNumber(queryFieldBo.getFieldAlias() + "!" + number);
        fieldInfo.setNumberAlias(fieldInfo.getNumber());
        fieldInfo.setFieldPath(queryFieldBo.getFieldPath() + "!" + number);
        fieldInfo.setValueType(queryFieldBo.getValueType());
        fieldInfo.setControlType(queryFieldBo.getControlType());
        fieldInfo.setFieldId(queryFieldBo.getId());
        fieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        fieldInfo.setComplexType(queryFieldBo.getComplexType());
        fieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        fieldInfo.setFieldSrc("0");
        ReportDataStoreServiceHelper.setType(fieldInfo);
        return fieldInfo;
    }

    private List<FieldInfo> getFieldInfoByFieldIds(Set<String> fieldIdSet, List<QueryFieldBo> anoFieldList) {
        return anoFieldList.stream().filter(af -> fieldIdSet.contains(af.getId())).map(ReportDataStoreFieldService::queryField2FieldInfo).collect(Collectors.toList());
    }

    private boolean isDateSplitDate(FieldInfo fieldInfo) {
        boolean isDateSplitDate = false;
        if (fieldInfo.getNumber().contains("!")) {
            String[] dateSplit = fieldInfo.getNumber().split("!");
            SplitDateTypeEnum splitDateType = SplitDateTypeEnum.getEnum((String)dateSplit[1]);
            switch (splitDateType) {
                case SN_QUARTER: 
                case FN_QUARTER: 
                case SN_MONTH: 
                case FN_MONTH: 
                case SN_DAY: 
                case FN_DAY: {
                    break;
                }
                default: {
                    isDateSplitDate = true;
                }
            }
        }
        return isDateSplitDate;
    }

    private static void convertToBO(Map<String, QueryFieldBo> queryFieldBoMap, List<FieldTreeNode> fieldTreeNodeList) {
        for (FieldTreeNode fieldTreeNode : fieldTreeNodeList) {
            if (fieldTreeNode.getField().booleanValue()) {
                QueryFieldBo queryFieldBo = new QueryFieldBo();
                queryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
                queryFieldBo.setComplexType(fieldTreeNode.getComplexType());
                queryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
                queryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
                queryFieldBo.setFieldName(fieldTreeNode.getName());
                queryFieldBo.setValueType(fieldTreeNode.getValueType());
                queryFieldBo.setControlType(fieldTreeNode.getControlType());
                queryFieldBo.setEntityName(fieldTreeNode.getEntityName());
                queryFieldBo.setBaseDataNum(fieldTreeNode.getBaseDataNum());
                queryFieldBoMap.put(queryFieldBo.getFieldAlias(), queryFieldBo);
            }
            if (CollectionUtils.isEmpty((Collection)fieldTreeNode.getChildren())) continue;
            ReportDataStoreFieldService.convertToBO(queryFieldBoMap, fieldTreeNode.getChildren());
        }
    }

    private static FieldDataStoreInfo queryField2FieldInfo(QueryFieldBo queryFieldBo) {
        FieldDataStoreInfo fieldInfo = new FieldDataStoreInfo();
        fieldInfo.setFieldId(queryFieldBo.getId());
        fieldInfo.setNumber(queryFieldBo.getFieldAlias());
        fieldInfo.setNumberAlias(fieldInfo.getNumber());
        fieldInfo.setFieldPath(queryFieldBo.getFieldPath());
        fieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        fieldInfo.setDisplayName(queryFieldBo.getFieldName());
        fieldInfo.setName(fieldInfo.getDisplayName());
        fieldInfo.setValueType(queryFieldBo.getValueType());
        fieldInfo.setComplexType(queryFieldBo.getComplexType());
        fieldInfo.setControlType(queryFieldBo.getControlType());
        fieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        ReportDataStoreServiceHelper.setType(fieldInfo);
        return fieldInfo;
    }

    private static boolean isBaseData(QueryFieldBo queryFieldBo) {
        return !(!queryFieldBo.getFieldPath().endsWith(".name") && !queryFieldBo.getFieldPath().endsWith(".number") || !FieldComplexType.BASE_DATA.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.ADMIN_ORG.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(queryFieldBo.getComplexType()));
    }

    private static int getSortSeq(QueryFieldBo queryFieldBo) {
        ParamTypeEnum paramTypeEnum = ControlType2ParamType.controlType2ParamType(FieldControlType.getFieldControlTypeByValue((String)queryFieldBo.getControlType()), FieldComplexType.getEnum((String)queryFieldBo.getComplexType()));
        if (paramTypeEnum == ParamTypeEnum.BASEDATA || ReportDataStoreFieldService.isBaseData(queryFieldBo)) {
            return 1;
        }
        if (paramTypeEnum == ParamTypeEnum.DATE) {
            return 2;
        }
        if (paramTypeEnum == ParamTypeEnum.TEXT) {
            return 3;
        }
        if (paramTypeEnum == ParamTypeEnum.NUMBER) {
            return 4;
        }
        if (paramTypeEnum == ParamTypeEnum.ENUM) {
            return 5;
        }
        if (paramTypeEnum == ParamTypeEnum.BOOLEAN) {
            return 6;
        }
        return 0;
    }

    private static ReportField fieldInfo2ReportField(FieldInfo fieldInfo) {
        ReportField reportField = new ReportField();
        if (fieldInfo.getRowFieldId() != null) {
            reportField.setFieldId(Long.parseLong(fieldInfo.getRowFieldId()));
        }
        reportField.setFieldAlias(fieldInfo.getNumber());
        reportField.setFieldType(fieldInfo.getValueType());
        reportField.setUniqueKey(fieldInfo.getNumberAlias());
        reportField.setSortord(fieldInfo.getSort());
        reportField.setCustomSort(fieldInfo.getCustomSort());
        reportField.setFieldSort(fieldInfo.getFieldSortInfo());
        return reportField;
    }

    private List<List<FieldInfo>> getDistinctList(DynamicObject[] workRpts, DynamicObject[] rptCfgDys) {
        ArrayList<List<FieldInfo>> distinctList = new ArrayList<List<FieldInfo>>(10);
        Map<Long, String> workRptTypeMap = Arrays.stream(rptCfgDys).collect(Collectors.toMap(dy -> dy.getDynamicObject("workrpt").getLong("id"), dy -> dy.getString("type")));
        for (DynamicObject workRpt : workRpts) {
            Long id = workRpt.getLong("id");
            String type = workRptTypeMap.get(id);
            String rowStr = workRpt.getString("row");
            if (!StringUtils.isNotEmpty((CharSequence)rowStr)) continue;
            List rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
            if ("0".equals(type) || "1".equals(type)) {
                for (RowFieldInfo rowFieldInfo : rows) {
                    if (!"2".equals(rowFieldInfo.getMergeType())) continue;
                    distinctList.add(rowFieldInfo._getAllGns());
                }
                continue;
            }
            if (!"2".equals(type) && !"3".equals(type) && !"4".equals(type)) continue;
            distinctList.add(rows.stream().map(RowFieldInfo::getGroupName).collect(Collectors.toList()));
        }
        return distinctList;
    }
}

