/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.datastore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.report.DayTypeEnum;
import kd.hr.hbp.common.model.report.MonthTypeEnum;
import kd.hr.hbp.common.model.report.QuarterTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.business.datastore.metadata.model.RptFormMetadataContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetadataContentBaseMsg;
import kd.hr.hrptmc.business.datastore.metadata.service.RptMetadataService;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.RptPhysicalTableHandlerCreator;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDtsBusinessType;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportDataStoreServiceHelper
implements RepQueryConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportDataStoreServiceHelper.class);
    private static final HRBaseServiceHelper CONFIG_SERVICE_HELPER = new HRBaseServiceHelper("hrptmc_paramconfig");

    public static void stopSyn(Long reportId) {
        DynamicObject config = ReportManageService.getParamConfigWithSchedule(reportId);
        if (config != null) {
            config.set("schedulestatus", (Object)"3");
            CONFIG_SERVICE_HELPER.saveOne(config);
            DataStoreLogService dataStoreLogService = new DataStoreLogService(reportId, true);
            dataStoreLogService.stop();
        }
    }

    public static void deleteMetadataAndTable(String entityNum, String tableName) {
        RptMetadataContentBaseMsg contentBaseMsg = new RptMetadataContentBaseMsg(entityNum, null, "3+JJD4IUAS56", "hros", tableName);
        RptFormMetadataContent rptFormMetadataContent = new RptFormMetadataContent(contentBaseMsg, Collections.emptyList());
        if (!HRStringUtils.isEmpty((String)tableName)) {
            ReportDataStoreServiceHelper.deleteTable(rptFormMetadataContent);
        }
        if (!HRStringUtils.isEmpty((String)entityNum)) {
            ReportDataStoreServiceHelper.deleteMetadata(entityNum);
        }
        LOGGER.info("ReportDataStoreServiceHelper_deleteMetadataAndTable_success,entityNum:{},tableName:{}", (Object)entityNum, (Object)tableName);
    }

    public static void deleteDtsConfig(long reportId, String entityNum) {
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        String mappingRule = ReportDataStoreServiceHelper.getMappingRule(reportId);
        String businessType = new ReportDtsBusinessType().getBusinessTypeCode();
        dtsConfigOperator.deleteDtsConfig(entityNum, businessType, "hr", mappingRule);
    }

    public static String getMappingRule(long reportId) {
        return "reportmapping#reportId=" + reportId;
    }

    public static void deleteReportSchedule(long reportId) {
        String jobId;
        DynamicObject config = ReportManageService.getParamConfigWithSchedule(reportId);
        if (config != null && !HRStringUtils.isEmpty((String)(jobId = config.getString("job.id")))) {
            ReportDataStoreServiceHelper.deleteReportSchedule(config, jobId);
        }
    }

    public static void deleteReportSchedule(DynamicObject config, String jobId) {
        DynamicObjectCollection dynamicObjectCollection = config.getDynamicObjectCollection("mulschedule");
        List scheduleIdList = dynamicObjectCollection.stream().map(dc -> dc.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        for (String scheduleId : scheduleIdList) {
            proxy.deletePlan(scheduleId);
        }
        proxy.deleteJob(jobId);
        String entityNum = config.getString("newentitynum");
        String table = config.getString("newtable");
        if (!HRStringUtils.isEmpty((String)entityNum)) {
            long reportId = config.getLong("report.id");
            config.set("schedulestatus", (Object)"3");
            ThreadPools.executeOnce((String)"ReportParConfSchService.handleSchedule.delete", () -> {
                ReportDataStoreServiceHelper.deleteDtsConfig(reportId, entityNum);
                ReportDataStoreServiceHelper.deleteMetadataAndTable(entityNum, table);
            });
            ReportManageService.deleteReportMappings(reportId);
        }
    }

    public static void setType(FieldInfo fieldInfo) {
        String type;
        switch (DataTypeEnum.of((String)fieldInfo.getValueType())) {
            case LONG: 
            case INTEGER: 
            case BIGDECIMAL: {
                type = "2";
                break;
            }
            default: {
                type = "1";
            }
        }
        fieldInfo.setType(type);
    }

    public static String getDefaultControlType(String valueType) {
        String controlType = FieldControlType.OTHER.getValue();
        switch (DataTypeEnum.of((String)valueType)) {
            case INTEGER: {
                controlType = FieldControlType.INTEGER.getValue();
                break;
            }
            case LONG: {
                controlType = FieldControlType.BIGINT.getValue();
                break;
            }
            case BIGDECIMAL: {
                controlType = FieldControlType.DECIMAL.getValue();
                break;
            }
            case BOOLEAN: 
            case STRING: {
                controlType = FieldControlType.TEXT.getValue();
                break;
            }
            case LOCALESTRING: {
                controlType = FieldControlType.MUL_LANG_TEXT.getValue();
                break;
            }
            case DATETIME: {
                controlType = FieldControlType.DATE.getValue();
                break;
            }
        }
        return controlType;
    }

    public static Map<String, Map<Object, Integer>> getCustomSortMap(long rptId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_customsort");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptId)});
        HashMap customSortMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dyn : dynamicObjects) {
            String rptFieldId = dyn.getString("rptfieldid");
            DynamicObjectCollection dynamicObjectCollection = dyn.getDynamicObjectCollection("entryentity");
            Map idMap = customSortMap.getOrDefault(rptFieldId, Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size()));
            String valueType = dyn.getString("valuetype");
            for (DynamicObject row : dynamicObjectCollection) {
                int seq = row.getInt("seq");
                if (DataTypeEnum.LONG.getDataTypeKey().equals(valueType)) {
                    idMap.put(row.getLong("long"), seq);
                    continue;
                }
                idMap.put(row.getString("string"), seq);
            }
            customSortMap.put(rptFieldId, idMap);
        }
        return customSortMap;
    }

    public static Object convertValue(String fieldAlias, Object value) {
        Object newValue = value;
        if (fieldAlias.contains("!")) {
            String[] dateSplit = fieldAlias.split("!");
            SplitDateTypeEnum splitDateType = SplitDateTypeEnum.getEnum((String)dateSplit[1]);
            String valueStr = (String)value;
            switch (splitDateType) {
                case FN_QUARTER: {
                    newValue = QuarterTypeEnum.getValue((String)valueStr);
                    break;
                }
                case FN_MONTH: {
                    newValue = MonthTypeEnum.getValue((String)valueStr);
                    break;
                }
                case FN_DAY: {
                    newValue = DayTypeEnum.getValue((String)valueStr);
                    break;
                }
            }
        }
        return newValue;
    }

    public static boolean isBaseData(String fieldAlias, String controlType) {
        boolean isBaseData = false;
        switch (FieldControlType.getFieldControlTypeByValue((String)controlType)) {
            case BASE_DATA: 
            case ORG: 
            case HIS_BASE_DATA: 
            case USER: 
            case HR_USER: 
            case ADDRESS: 
            case ADMIN_DIVISION: {
                if (!"id".equals(fieldAlias) && !fieldAlias.endsWith(".id")) break;
                isBaseData = true;
                break;
            }
        }
        return isBaseData;
    }

    public static boolean isBaseDataNameOrNum(String complexType, String fieldAlias) {
        return !fieldAlias.startsWith("RPTDIMCOUNT_") && AnalyseObjectUtil.isBaseDataType((String)complexType) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"));
    }

    public static List<QFilter> getDataFilter(String dataFilter, List<QueryFieldBo> queryFieldBos) {
        QFilter qFilter;
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        if (!HRStringUtils.isEmpty((String)dataFilter) && Objects.nonNull(qFilter = HRFilterUtil.condition2QFilter4HRReport((String)dataFilter, (String)SerializationUtils.toJsonString(queryFieldBos)))) {
            qFilterList.add(qFilter);
        }
        return qFilterList;
    }

    public static QueryFieldBo fieldInfo2QueryFieldBo(FieldInfo fieldInfo) {
        QueryFieldBo queryFieldBo = new QueryFieldBo();
        queryFieldBo.setId(fieldInfo.getFieldId());
        queryFieldBo.setFieldAlias(fieldInfo.getNumber());
        queryFieldBo.setFieldPath(fieldInfo.getFieldPath());
        queryFieldBo.setBaseDataNum(fieldInfo.getBaseDataNum());
        queryFieldBo.setFieldName(fieldInfo.getDisplayName());
        queryFieldBo.setValueType(fieldInfo.getValueType());
        queryFieldBo.setComplexType(fieldInfo.getComplexType());
        queryFieldBo.setControlType(fieldInfo.getControlType());
        queryFieldBo.setEntityNumber(fieldInfo.getEntityNumber());
        return queryFieldBo;
    }

    private static void deleteMetadata(String entityNum) {
        RptMetadataService service = RptMetadataService.getInstance();
        service.deleteMetaData(entityNum);
    }

    private static void deleteTable(RptFormMetadataContent content) {
        PhysicalTableHandler handler = RptPhysicalTableHandlerCreator.getHandler(content);
        handler.deleteTable('a');
    }
}

