/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.display;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayCol;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayIndex;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayRow;
import kd.hr.hrptmc.business.repdesign.display.UserDisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.common.constant.display.DisplayConstants;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;

@ExcludeFromJacocoGeneratedReport
public class ReportDisplayHelper
implements DisplayConstants,
ReportManageConstants {
    public static DynamicObject queryRptDisplaySchemeObj(String displayName, Long pkId) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(displayName);
        return serviceHelper.queryOne("id,schemedesc,name,modifytime", new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryPersonalScheme(Long reportFormId, String publishType) {
        QFilter filter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter reportFormIdFilter = new QFilter("rptmanage", "=", (Object)reportFormId);
        QFilter publishTypeFilter = new QFilter("publishtype", "=", (Object)publishType);
        if ("appMenu".equals(publishType)) {
            publishTypeFilter.or(new QFilter("publishtype", "=", (Object)QEmptyValue.value));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        return serviceHelper.query("id, name, defaultscheme", new QFilter[]{filter, reportFormIdFilter, publishTypeFilter}, "defaultscheme desc, createtime desc");
    }

    public static DynamicObject queryDefaultScheme(Long reportFormId, String publishType) {
        QFilter filter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter reportFormIdFilter = new QFilter("rptmanage", "=", (Object)reportFormId);
        QFilter defaultQFilter = new QFilter("defaultscheme", "=", (Object)"1");
        QFilter publishTypeFilter = new QFilter("publishtype", "=", (Object)publishType);
        if ("appMenu".equals(publishType)) {
            publishTypeFilter.or(new QFilter("publishtype", "=", (Object)QEmptyValue.value));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        DynamicObject[] query = serviceHelper.query("id, name, defaultscheme", new QFilter[]{filter, reportFormIdFilter, defaultQFilter, publishTypeFilter}, "defaultscheme desc, createtime desc");
        if (query.length > 0) {
            return query[0];
        }
        return null;
    }

    public static boolean isShowDisplayScheme(DisplaySchemeInfo displaySchemeInfo) {
        return displaySchemeInfo != null && (!CollectionUtils.isEmpty(displaySchemeInfo.getSelectedRowField()) || !CollectionUtils.isEmpty(displaySchemeInfo.getSelectedColField()) || !CollectionUtils.isEmpty(displaySchemeInfo.getSelectedIdxField()));
    }

    public static DynamicObject queryRptDisplayScheme(Long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        return serviceHelper.queryOne("id,defaultscheme", (Object)pkId);
    }

    public static void deleteRptDisplaySchemeById(Long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        serviceHelper.deleteOne((Object)pkId);
    }

    public static void cancelOtherDefaultScheme(String reportFormId, String publishType, Long pkId) {
        DynamicObject[] dynamicObjects;
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and(new QFilter("defaultscheme", "=", (Object)"1"));
        qFilter.and(new QFilter("id", "!=", (Object)pkId));
        QFilter publishTypeFilter = new QFilter("publishtype", "=", (Object)publishType);
        if ("appMenu".equals(publishType)) {
            publishTypeFilter.or(new QFilter("publishtype", "=", (Object)QEmptyValue.value));
        }
        qFilter.and(publishTypeFilter);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(reportFormId);
        for (DynamicObject dyObj : dynamicObjects = serviceHelper.query("id, defaultscheme", new QFilter[]{qFilter})) {
            dyObj.set("defaultscheme", (Object)0);
        }
        serviceHelper.update(dynamicObjects);
    }

    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        int index = 0;
        for (T element : elements) {
            action.accept(index, (Integer)element);
            ++index;
        }
    }

    public static DynamicObject addDisplayScheme(String rptDisplayFormId, Long reportFormId, String publishType, Map<String, Object> returnData) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(rptDisplayFormId);
        DynamicObject schmObj = serviceHelper.generateEmptyDynamicObject();
        schmObj.set("rptmanage", (Object)reportFormId);
        schmObj.set("publishtype", (Object)publishType);
        schmObj.set("name", returnData.get("name"));
        schmObj.set("number", returnData.get("name"));
        schmObj.set("schemedesc", returnData.get("schemedesc"));
        schmObj.set("defaultscheme", (Object)Boolean.FALSE);
        schmObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        schmObj.set("user", (Object)RequestContext.get().getCurrUserId());
        Date currDate = new Date();
        schmObj.set("createtime", (Object)currDate);
        schmObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        schmObj.set("modifytime", (Object)currDate);
        return (DynamicObject)serviceHelper.saveOne(schmObj);
    }

    public static DynamicObject updateDisplayScheme(String displayName, String pkId, Map<String, Object> returnData) {
        DynamicObject shareSchemeObj = ReportDisplayHelper.queryRptDisplaySchemeObj(displayName, Long.parseLong(pkId));
        Object schemeName = returnData.get("name");
        Object schemeDesc = returnData.get("schemedesc");
        shareSchemeObj.set("name", schemeName);
        shareSchemeObj.set("schemedesc", schemeDesc);
        shareSchemeObj.set("modifytime", (Object)new Date());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(displayName);
        return (DynamicObject)serviceHelper.updateOne(shareSchemeObj);
    }

    public static DynamicObject updateDisplaySchemeEntry(String displayName, String pkId, UserDisplaySchemeInfo userDisplaySchemeInfo, Boolean isDefaultScheme) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(pkId));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(displayName);
        DynamicObject schemeObj = serviceHelper.loadDynamicObject(new QFilter[]{qFilter});
        schemeObj.set("defaultscheme", (Object)isDefaultScheme);
        List<UserDisplayRow> row = userDisplaySchemeInfo.getRow();
        List<UserDisplayCol> col = userDisplaySchemeInfo.getCol();
        List<UserDisplayIndex> index = userDisplaySchemeInfo.getIndex();
        DynamicObjectCollection rowEntryColl = schemeObj.getDynamicObjectCollection("rowentryentity");
        rowEntryColl.clear();
        DynamicObjectType rowEntryCollDynamicObjectType = rowEntryColl.getDynamicObjectType();
        for (UserDisplayRow userDisplayRow : row) {
            DynamicObject dyn = new DynamicObject(rowEntryCollDynamicObjectType);
            dyn.set("rowfield", (Object)userDisplayRow.getRowField());
            dyn.set("rowsecondaryheader", (Object)userDisplayRow.getRowSecondaryHeader());
            dyn.set("rowhide", (Object)userDisplayRow.isRowHide());
            dyn.set("rowfreeze", (Object)userDisplayRow.isRowFreeze());
            dyn.set("seq", (Object)userDisplayRow.getSeq());
            dyn.set("userfield", (Object)RequestContext.get().getCurrUserId());
            rowEntryColl.add((Object)dyn);
        }
        schemeObj.set("rowentryentity", (Object)rowEntryColl);
        DynamicObjectCollection colEntryColl = schemeObj.getDynamicObjectCollection("colentryentity");
        colEntryColl.clear();
        DynamicObjectType colEntryCollDynamicObjectType = colEntryColl.getDynamicObjectType();
        for (UserDisplayCol userDisplayCol : col) {
            DynamicObject dyn = new DynamicObject(colEntryCollDynamicObjectType);
            dyn.set("colfield", (Object)userDisplayCol.getColField());
            dyn.set("colhide", (Object)userDisplayCol.isColHide());
            dyn.set("seq", (Object)userDisplayCol.getSeq());
            colEntryColl.add((Object)dyn);
        }
        schemeObj.set("colentryentity", (Object)colEntryColl);
        DynamicObjectCollection indexEntryColl = schemeObj.getDynamicObjectCollection("indexentryentity");
        indexEntryColl.clear();
        DynamicObjectType idxEntryCollDynamicObjectType = indexEntryColl.getDynamicObjectType();
        for (UserDisplayIndex userDisplayIndex : index) {
            DynamicObject dyn = new DynamicObject(idxEntryCollDynamicObjectType);
            dyn.set("indexfield", (Object)userDisplayIndex.getIndexField());
            dyn.set("indexhide", (Object)userDisplayIndex.isIndexHide());
            dyn.set("seq", (Object)userDisplayIndex.getSeq());
            indexEntryColl.add((Object)dyn);
        }
        schemeObj.set("indexentryentity", (Object)indexEntryColl);
        return (DynamicObject)serviceHelper.updateOne(schemeObj);
    }
}

