/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleInfo;

public class ReportHeadRowInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4024100527782361158L;
    private String code;
    private String codeAlias;
    private String name;
    private String align = "left";
    private boolean hasChildren = false;
    private boolean lock = false;
    private boolean hyperLink = false;
    private boolean drilling = false;
    private String drillingKey;
    private List<ReportHeadRowInfo> children;
    private Map<String, ReportStyleInfo> rs;
    private String separatorPrefix = "\u03b5";

    public ReportHeadRowInfo() {
    }

    public ReportHeadRowInfo(String code, String codeAlias, String name, String align) {
        this.code = code;
        this.codeAlias = codeAlias;
        this.name = name;
        this.align = align;
    }

    public ReportHeadRowInfo(String code, String codeAlias, String name, String align, String separatorPrefix) {
        this.code = code;
        this.codeAlias = codeAlias;
        this.name = name;
        this.align = align;
        this.separatorPrefix = separatorPrefix == null || separatorPrefix.trim().length() == 0 ? "\u03b5" : separatorPrefix;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeAlias() {
        return this.codeAlias;
    }

    public void setCodeAlias(String codeAlias) {
        this.codeAlias = codeAlias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getHasChildren() {
        return !CollectionUtils.isEmpty(this.children);
    }

    public List<ReportHeadRowInfo> getChildren() {
        return this.children;
    }

    public void setChildren(List<ReportHeadRowInfo> children) {
        this.children = children;
    }

    public void addChildren(ReportHeadRowInfo children) {
        if (this.children == null) {
            this.children = new ArrayList<ReportHeadRowInfo>();
        }
        this.children.add(children);
    }

    public String getAlign() {
        if (!CollectionUtils.isEmpty(this.children)) {
            return "center";
        }
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public boolean getLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public Map<String, ReportStyleInfo> getRs() {
        return this.rs;
    }

    public void setRs(Map<String, ReportStyleInfo> rs) {
        this.rs = rs;
    }

    public boolean getHyperLink() {
        return this.hyperLink;
    }

    public void setHyperLink(boolean hyperLink) {
        this.hyperLink = hyperLink;
    }

    public boolean getDrilling() {
        return this.drilling;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public String getDrillingKey() {
        return this.drillingKey;
    }

    public void setDrillingKey(String drillingKey) {
        this.drillingKey = drillingKey;
    }

    public String getSeparatorPrefix() {
        return this.separatorPrefix;
    }

    public void setSeparatorPrefix(String separatorPrefix) {
        this.separatorPrefix = separatorPrefix;
    }

    public ReportHeadRowInfo clone() {
        try {
            ReportHeadRowInfo clone = (ReportHeadRowInfo)super.clone();
            if (this.getHasChildren()) {
                clone.setChildren(this.getChildren().stream().map(ReportHeadRowInfo::clone).collect(Collectors.toList()));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

