/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;

public class DataExtractDirtyRepairTask
extends AbstractTask
implements RepQueryConfigConstants {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityinfo");
        QFilter qFilter = new QFilter("id", "like", (Object)"hrom_re_%");
        qFilter.or("id", "like", (Object)"hrom_an_%");
        DynamicObject[] dbEntities = serviceHelper.queryOriginalArray("id,tablename", new QFilter[]{qFilter});
        Map<String, String> anoBindingEntityMap = this.getAnoBindingEntityMap();
        Map<String, String> repBindingEntityMap = this.getRepBindingEntityMap();
        repBindingEntityMap.putAll(anoBindingEntityMap);
        this.executeRepair(dbEntities, repBindingEntityMap);
    }

    private Map<String, String> getAnoBindingEntityMap() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjextract");
        DynamicObjectCollection anObjDataExtractConfigCol = helper.queryOriginalCollection("metadatanum", new QFilter[]{new QFilter("openextract", "=", (Object)true)});
        HashMap bindingConfigMap = Maps.newHashMapWithExpectedSize((int)anObjDataExtractConfigCol.size());
        anObjDataExtractConfigCol.forEach(dy -> {
            String metaDataNum = dy.getString("metadatanum");
            if (HRStringUtils.isEmpty((String)metaDataNum)) {
                return;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNum);
            String tableName = dataEntityType.getAlias();
            bindingConfigMap.put(metaDataNum, tableName);
        });
        return bindingConfigMap;
    }

    private Map<String, String> getRepBindingEntityMap() {
        HRBaseServiceHelper configServiceHelp = new HRBaseServiceHelper("hrptmc_paramconfig");
        DynamicObject[] configs = configServiceHelp.queryOriginalArray("newentitynum,newtable", new QFilter[]{new QFilter("enableextract", "=", (Object)true)});
        HashMap bindingConfigMap = Maps.newHashMapWithExpectedSize((int)configs.length);
        for (DynamicObject config : configs) {
            String entityNum = config.getString("newentitynum");
            String table = config.getString("newtable");
            if (HRStringUtils.isEmpty((String)entityNum)) continue;
            bindingConfigMap.put(entityNum, table);
        }
        return bindingConfigMap;
    }

    private void executeRepair(DynamicObject[] dbEntities, Map<String, String> bindingEntityMap) {
        HRBaseServiceHelper dirtyServiceHelper = new HRBaseServiceHelper("hrptmc_dirtydatarepair");
        DynamicObject[] dirtyDyn = dirtyServiceHelper.loadDynamicObjectArray(new QFilter[0]);
        Map<String, DynamicObject> dirtyMap = Arrays.stream(dirtyDyn).collect(Collectors.toMap(dd -> dd.getString("entitynumber"), dd -> dd));
        HashSet delSet = Sets.newHashSetWithExpectedSize((int)dirtyMap.size());
        DynamicObjectCollection newDirtyCol = new DynamicObjectCollection();
        for (DynamicObject entity : dbEntities) {
            String entityNum = entity.getString("id");
            if (!entityNum.startsWith("hrom_re_") && !entityNum.startsWith("hrom_an_")) continue;
            DynamicObject dirty = dirtyMap.get(entityNum);
            if (!bindingEntityMap.containsKey(entityNum)) {
                String table = entity.getString("tablename");
                if (dirty == null) {
                    dirty = dirtyServiceHelper.generateEmptyDynamicObject();
                    dirty.set("entitynumber", (Object)entityNum);
                    dirty.set("table", (Object)table);
                    dirty.set("count", (Object)1);
                    newDirtyCol.add((Object)dirty);
                    continue;
                }
                if (dirty.getInt("count") != 1) continue;
                ReportDataStoreServiceHelper.deleteMetadataAndTable(entityNum, table);
                delSet.add(dirty.getLong("id"));
                continue;
            }
            if (dirty == null) continue;
            delSet.add(dirty.getLong("id"));
        }
        dirtyServiceHelper.delete(delSet.toArray());
        dirtyServiceHelper.save(newDirtyCol);
    }
}

