/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.task;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreService;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;

public class ReportDataExtractTask
extends AbstractTask
implements RepQueryConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportDataExtractTask.class);
    private static final ConcurrentHashMap<Long, Long> CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long reportId = (Long)map.get("report");
        LOGGER.info("ReportDataExtractTask_execute,reportId:{}", (Object)reportId);
        boolean existsRptId = ReportManageService.isExistsRptId(reportId);
        if (!existsRptId) {
            return;
        }
        Long threadId = CONCURRENT_HASH_MAP.get(reportId);
        if (threadId != null && !Objects.equals(Thread.currentThread().getId(), threadId)) {
            LOGGER.info("ReportDataExtractTask_execute_thread:{}", (Object)threadId);
            return;
        }
        CONCURRENT_HASH_MAP.put(reportId, Thread.currentThread().getId());
        try {
            ReportDataStoreService reportDataStoreService = new ReportDataStoreService(reportId);
            if (reportDataStoreService.beforeExecute()) {
                reportDataStoreService.execute();
            }
        }
        catch (Exception exception) {
            DynamicObject config = ReportManageService.getParamConfigWithSchedule(reportId);
            ReportManageService.updateScheduleStatus(config, "2");
            LOGGER.error((Throwable)exception);
            DataStoreLogService dataStoreLogService = new DataStoreLogService(reportId, true);
            dataStoreLogService.error(exception.toString());
            throw new KDBizException(exception.getMessage());
        }
        finally {
            CONCURRENT_HASH_MAP.remove(reportId);
        }
    }
}

