/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;

public class ReportParConfSchService
implements RepQueryConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportParConfSchService.class);

    public void handleSchedule(DynamicObject[] dynamicObjects) {
        for (DynamicObject config : dynamicObjects) {
            Object job = config.get("job");
            String jobId = job instanceof DynamicObject ? config.getString("job.id") : (String)job;
            if (config.getBoolean("enableextract")) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sch_job");
                if (!HRStringUtils.isEmpty((String)jobId) && serviceHelper.isExists((Object)jobId)) {
                    DynamicObjectCollection dynamicObjectCollection = config.getDynamicObjectCollection("mulschedule");
                    ArrayList scheduleIdList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        DynamicObject schedule = dynamicObject.getDynamicObject("fbasedataid");
                        if (schedule == null) continue;
                        scheduleIdList.add(schedule.getString("id"));
                    }
                    this.updatePlan(config, jobId, scheduleIdList);
                    continue;
                }
                this.createScheduleJob(config);
                continue;
            }
            if (HRStringUtils.isEmpty((String)jobId)) continue;
            ReportDataStoreServiceHelper.deleteReportSchedule(config, jobId);
            config.set("job", null);
            config.set("mulschedule", null);
            config.set("newentitynum", null);
            config.set("newtable", null);
        }
    }

    public void deleteScheduleJob(String jobId, String scheduleId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.deletePlan(scheduleId);
        proxy.deleteJob(jobId);
    }

    public void createScheduleJob(DynamicObject config) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        JobInfo jobInfo = this.getJobInfo(config);
        String jobId = proxy.createJob(jobInfo);
        List<PlanInfo> planInfoList = this.getPlanInfoList(config, jobId);
        ArrayList planIdList = Lists.newArrayListWithExpectedSize((int)planInfoList.size());
        for (PlanInfo planInfo : planInfoList) {
            String planId = proxy.createPlan(planInfo);
            planIdList.add(planId);
        }
        config.set("job", (Object)jobId);
        this.fillSchedule(config, planIdList);
        if (config.getBoolean("executewithsave")) {
            if (!planIdList.isEmpty()) {
                jobInfo.setScheduleId((String)planIdList.get(0));
            }
            JobClient.dispatch((JobInfo)jobInfo);
        }
    }

    public void updatePlan(DynamicObject config, String jobId, List<String> scheduleIdList) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        for (String scheduleId : scheduleIdList) {
            proxy.deletePlan(scheduleId);
        }
        List<PlanInfo> planInfoList = this.getPlanInfoList(config, jobId);
        ArrayList planIdList = Lists.newArrayListWithExpectedSize((int)planInfoList.size());
        for (PlanInfo planInfo : planInfoList) {
            String planId = proxy.createPlan(planInfo);
            planIdList.add(planId);
        }
        this.fillSchedule(config, planIdList);
        if (config.getBoolean("executewithsave")) {
            JobInfo jobInfo = this.getJobInfo(config);
            jobInfo.setId(jobId);
            if (!planIdList.isEmpty()) {
                jobInfo.setScheduleId((String)planIdList.get(0));
            }
            JobClient.dispatch((JobInfo)jobInfo);
        }
    }

    private JobInfo getJobInfo(DynamicObject config) {
        String reportName = config.getString("report.name");
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setNumber("ReportParamConfigJob_" + config.getString("report.number"));
        jobInfo.setName("ReportParamConfigJob_" + reportName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(null);
        jobInfo.setAppId("hrptmc");
        jobInfo.setTaskClassname("kd.hr.hrptmc.business.repdesign.task.ReportDataExtractTask");
        jobInfo.setEnable(true);
        jobInfo.setRunByUserId(0L);
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        long reportId = config.getLong("report.id");
        param.put("report", reportId);
        jobInfo.setParams((Map)param);
        return jobInfo;
    }

    private List<PlanInfo> getPlanInfoList(DynamicObject config, String jobId) {
        String reportName = "ReportParamConfigPlan_" + config.getString("report.name");
        String number = "ReportParamConfigPlan_" + config.getString("report.number");
        String cycle = config.getString("cycle");
        ArrayList planInfoList = Lists.newArrayListWithExpectedSize((int)2);
        switch (cycle) {
            case "0": {
                RepeatModeEnum repeatModeEnum = RepeatModeEnum.ByHours;
                String cronExpression = "0 0 * * * ?";
                planInfoList.add(this.getPlanInfo(jobId, number, reportName, repeatModeEnum, cronExpression));
                break;
            }
            case "1": {
                RepeatModeEnum repeatModeEnum = RepeatModeEnum.ByDays;
                String cronExpression = "0 0 " + config.getString("scheduletime") + " * * ?";
                planInfoList.add(this.getPlanInfo(jobId, number, reportName, repeatModeEnum, cronExpression));
                break;
            }
            case "2": {
                RepeatModeEnum repeatModeEnum = RepeatModeEnum.ByWeeks;
                String week = config.getString("week");
                if (week.startsWith(",")) {
                    week = week.substring(1);
                }
                if (week.endsWith(",")) {
                    week = week.substring(0, week.length() - 1);
                }
                String cronExpression = "0 0 " + config.getString("scheduletime") + " ? * " + week;
                PlanInfo planInfo = this.getPlanInfo(jobId, number, reportName, repeatModeEnum, cronExpression);
                planInfo.setWeekdaysExp(week);
                planInfoList.add(planInfo);
                break;
            }
            default: {
                String cronExpression;
                RepeatModeEnum repeatModeEnum = RepeatModeEnum.ByMonths;
                String dayStr = config.getString("day");
                String[] split = dayStr.split(",");
                ArrayList otherDayList = Lists.newArrayListWithExpectedSize((int)split.length);
                String lastDay = null;
                for (String day : split) {
                    if ("L".equals(day)) {
                        lastDay = day;
                        continue;
                    }
                    if (HRStringUtils.isEmpty((String)day)) continue;
                    otherDayList.add(day);
                }
                if (!HRStringUtils.isEmpty(lastDay)) {
                    cronExpression = "0 0 " + config.getString("scheduletime") + " " + lastDay + " * ?";
                    PlanInfo planInfo1 = this.getPlanInfo(jobId, "ReportParamConfigPlan2_" + config.getString("report.number"), "ReportParamConfigPlan2_" + config.getString("report.name"), repeatModeEnum, cronExpression);
                    planInfo1.setDaysExp(lastDay);
                    planInfoList.add(planInfo1);
                }
                if (otherDayList.isEmpty()) break;
                String join = String.join((CharSequence)",", otherDayList);
                cronExpression = "0 0 " + config.getString("scheduletime") + " " + join + " * ?";
                PlanInfo planInfo1 = this.getPlanInfo(jobId, number, reportName, repeatModeEnum, cronExpression);
                planInfo1.setDaysExp(join);
                planInfoList.add(planInfo1);
            }
        }
        return planInfoList;
    }

    private PlanInfo getPlanInfo(String jobId, String number, String name, RepeatModeEnum repeatModeEnum, String cronExpression) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setName(name);
        planInfo.setNumber(number);
        Calendar startTime = Calendar.getInstance();
        planInfo.setStartTime(startTime);
        Calendar endTime = Calendar.getInstance();
        endTime.set(1, 2999);
        planInfo.setEndTime(endTime);
        planInfo.setEnable(true);
        planInfo.setRepeatMode(repeatModeEnum);
        planInfo.setCronExpression(cronExpression);
        return planInfo;
    }

    private void fillSchedule(DynamicObject config, List<String> planIdList) {
        DynamicObjectCollection dynamicObjectCollection = config.getDynamicObjectCollection("mulschedule");
        dynamicObjectCollection.clear();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sch_schedule");
        for (String planId : planIdList) {
            DynamicObject mulSchedule = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            DynamicObject schedule = (DynamicObject)mainEntityType.createInstance();
            schedule.set("id", (Object)planId);
            mulSchedule.set("fbasedataid", (Object)schedule);
            dynamicObjectCollection.add((Object)mulSchedule);
        }
        config.set("mulschedule", (Object)dynamicObjectCollection);
    }
}

