/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.swc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.virtulentity.HRVirtualEntityHelper;
import kd.hr.hbp.business.virtulentity.HRVirtualEntityQueryInfo;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryResultInfo;
import kd.hr.hbp.common.model.virtulentity.TotalRowValueInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.DimensionValueInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class TestServiceImpl
implements IVirtualEntityService {
    private static final Log LOGGER = LogFactory.getLog(TestServiceImpl.class);
    private static final String HSAS_SALARYDETAILRPTQUERY = "hsas_salarydetailrptquery";

    public VirtualConfigInfo getVirtualConfig() {
        VirtualConfigInfo virtualConfigInfo = new VirtualConfigInfo();
        virtualConfigInfo.setCustomSort(true);
        virtualConfigInfo.setHisDateQuery(true);
        virtualConfigInfo.setOrgTree(true);
        virtualConfigInfo.setTotalRow(true);
        virtualConfigInfo.setFieldSort(true);
        return virtualConfigInfo;
    }

    public DataSet getDetailReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo);
        DataSet dataSet = this.queryData(queryParamInfo, qFilters, orderBy);
        return dataSet;
    }

    public QueryEntityType getQueryEntityType() {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)HSAS_SALARYDETAILRPTQUERY);
        return queryEntityType;
    }

    public SummaryQueryResultInfo getSummaryReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo);
        DataSet dataSet = this.queryData(queryParamInfo, qFilters, orderBy);
        SummaryQueryResultInfo summaryQueryResultInfo = new SummaryQueryResultInfo(dataSet, true);
        return summaryQueryResultInfo;
    }

    private DataSet queryData(VirtualEntityQueryParamInfo queryParamInfo, QFilter[] qFilters, String orderBy) {
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        Set groupByField = selectedFieldInfoList.stream().filter(VirtualFieldInfo::isGroupField).map(VirtualFieldInfo::getNumber).collect(Collectors.toSet());
        List virtualFieldInfos = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isNotEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        List bkjxFieldInfo = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        DataSetBuilder dataSetBuilder = Algo.create((String)"test").createDataSetBuilder(new RowMeta(new Field[0]));
        DataSet dataSet = dataSetBuilder.build();
        if (virtualFieldInfos.size() > 0) {
            HRVirtualEntityQueryInfo hrVirtualEntityQueryInfo = this.getHrVirtualEntityQueryInfo(queryParamInfo, qFilters, orderBy, selectedFieldInfoList);
            HRVirtualEntityHelper entityHelper = HRVirtualEntityHelper.getInstance();
            HRComplexObjContext context = entityHelper.getHrComplexObjContext(hrVirtualEntityQueryInfo);
            if (!groupByField.isEmpty()) {
                List complexObjFieldInfoList = context.getComplexObjFieldInfoList().stream().filter(field -> groupByField.contains(field.getAlias())).collect(Collectors.toList());
                context.setGroupFieldList(complexObjFieldInfoList);
                context.setQueryMode("2");
            }
            dataSet = entityHelper.getQueryDataSet(context, hrVirtualEntityQueryInfo.getStart(), hrVirtualEntityQueryInfo.getLimit());
        }
        for (VirtualFieldInfo virtualFieldInfo : bkjxFieldInfo) {
            if (virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.INTEGER) || virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.BIGDECIMAL) || virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.LONG)) {
                dataSet = dataSet.addField("10", virtualFieldInfo.getNumber());
                continue;
            }
            dataSet = dataSet.addField("\"kstrb10\"", virtualFieldInfo.getNumber());
        }
        return dataSet;
    }

    private HRVirtualEntityQueryInfo getHrVirtualEntityQueryInfo(VirtualEntityQueryParamInfo queryParamInfo, QFilter[] qFilters, String orderBy, List<VirtualFieldInfo> selectedFieldInfoList) {
        HRVirtualEntityQueryInfo hrVirtualEntityQueryInfo = new HRVirtualEntityQueryInfo();
        QueryEntityType queryEntityType = this.getQueryEntityType();
        hrVirtualEntityQueryInfo.setQueryEntityType(queryEntityType);
        Set collect = selectedFieldInfoList.stream().map(bo -> bo.getNumber()).collect(Collectors.toSet());
        hrVirtualEntityQueryInfo.setQueryFields(String.join((CharSequence)",", collect));
        hrVirtualEntityQueryInfo.setStart(queryParamInfo.getStart());
        hrVirtualEntityQueryInfo.setLimit(queryParamInfo.getLimit());
        hrVirtualEntityQueryInfo.setOrderBys(orderBy);
        hrVirtualEntityQueryInfo.setWhereQFilters(new ArrayList<QFilter>(Arrays.asList(qFilters)));
        hrVirtualEntityQueryInfo.setOnQFilters(new ArrayList());
        hrVirtualEntityQueryInfo.setReportId(queryParamInfo.getReportId() == null ? 0L : queryParamInfo.getReportId());
        return hrVirtualEntityQueryInfo;
    }

    public List<List<DimensionValueInfo>> getSummaryReportColumnDimensionData(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getColOrderBy(queryParamInfo);
        List selectedFieldInfoList = queryParamInfo.getColumnDimensionList();
        List virtualFieldInfos = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isNotEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        ArrayList<List<DimensionValueInfo>> list = new ArrayList<List<DimensionValueInfo>>(16);
        if (virtualFieldInfos.size() > 0) {
            HRVirtualEntityQueryInfo hrVirtualEntityQueryInfo = this.getHrVirtualEntityQueryInfo(queryParamInfo, qFilters, orderBy, selectedFieldInfoList);
            HRComplexObjContext hrComplexObjContext = HRVirtualEntityHelper.getInstance().getHrComplexObjContext(hrVirtualEntityQueryInfo);
            hrComplexObjContext.setQueryMode("2");
            List groupField = hrComplexObjContext.getComplexObjFieldInfoList().stream().filter(field -> !field.isNumber()).collect(Collectors.toList());
            hrComplexObjContext.setGroupFieldList(groupField);
            hrComplexObjContext.setDistinct(true);
            hrComplexObjContext.setOrder(false);
            hrComplexObjContext.setReturnDependOrderValue(true);
            hrComplexObjContext.setReturnEnumOriginalValue(true);
            LOGGER.info("queryDimensionData hrComplexObjContext:{}", (Object)hrComplexObjContext);
            ReportQueryService reportQueryService = new ReportQueryService(hrComplexObjContext);
            List listMap = reportQueryService.queryDimensionData();
            LOGGER.info("queryDimensionData size:{}", (Object)listMap.size());
            for (Map map : listMap) {
                ArrayList<DimensionValueInfo> dimensionValueInfos = new ArrayList<DimensionValueInfo>(10);
                boolean right = true;
                for (VirtualFieldInfo virtualFieldInfo : virtualFieldInfos) {
                    String fieldName = virtualFieldInfo.getNumber();
                    DimensionData dimensionData = (DimensionData)map.get(fieldName);
                    if (dimensionData == null) {
                        right = false;
                        break;
                    }
                    DimensionValueInfo dimensionValueInfo = new DimensionValueInfo();
                    dimensionValueInfo.setName(dimensionData.getValue());
                    dimensionValueInfo.setReferToOrderValue(dimensionData.getReferToOrderValue());
                    dimensionValueInfo.setId(dimensionData.getId());
                    dimensionValueInfos.add(dimensionValueInfo);
                }
                if (!right) continue;
                list.add(dimensionValueInfos);
            }
        }
        return list;
    }

    public TotalRowValueInfo getTotalRow(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo);
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        List virtualFieldInfos = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isNotEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        List bkjxFieldInfo = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        DataSetBuilder dataSetBuilder = Algo.create((String)"test").createDataSetBuilder(new RowMeta(new Field[0]));
        DataSet dataSet = dataSetBuilder.build();
        if (virtualFieldInfos.size() > 0) {
            HRVirtualEntityQueryInfo hrVirtualEntityQueryInfo = this.getHrVirtualEntityQueryInfo(queryParamInfo, qFilters, orderBy, selectedFieldInfoList);
            dataSet = HRVirtualEntityHelper.getInstance().getQueryDataSet(hrVirtualEntityQueryInfo);
        }
        for (VirtualFieldInfo virtualFieldInfo : bkjxFieldInfo) {
            if (virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.INTEGER) || virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.BIGDECIMAL) || virtualFieldInfo.getFieldValueType().equals((Object)DataTypeEnum.LONG)) {
                dataSet = dataSet.addField("10", virtualFieldInfo.getNumber());
                continue;
            }
            dataSet = dataSet.addField("\"kstrb10\"", virtualFieldInfo.getNumber());
        }
        TotalRowValueInfo totalRowValueInfo = new TotalRowValueInfo(dataSet, true);
        return totalRowValueInfo;
    }

    public Long getTotalCount(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo);
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        List virtualFieldInfos = selectedFieldInfoList.stream().filter(bo -> HRStringUtils.isNotEmpty((String)bo.getFieldPath())).collect(Collectors.toList());
        if (virtualFieldInfos.size() > 0) {
            HRVirtualEntityQueryInfo hrVirtualEntityQueryInfo = this.getHrVirtualEntityQueryInfo(queryParamInfo, qFilters, orderBy, selectedFieldInfoList);
            HRComplexObjContext hrComplexObjContext = HRVirtualEntityHelper.getInstance().getHrComplexObjContext(hrVirtualEntityQueryInfo);
            ReportQueryService reportQueryService = new ReportQueryService(hrComplexObjContext);
            return reportQueryService.queryDataCount(queryParamInfo.getStart(), queryParamInfo.getLimit());
        }
        return 0L;
    }

    public List<OrderField> getOrderFields() {
        return null;
    }

    public DynamicObjectCollection getAllVirtualFieldCollection() {
        DynamicObject[] query;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrptmc_virtentfields");
        DynamicObject virField = hrBaseServiceHelper.generateEmptyDynamicObject();
        DynamicObjectCollection allVirtualFieldCollection = new DynamicObjectCollection(virField.getDynamicObjectType(), null);
        HRBaseServiceHelper aaaa = new HRBaseServiceHelper("kdtest_hrptmc_aaaaaa");
        for (DynamicObject dynamicObject : query = aaaa.query("id,fieldnumber,fieldname,fieldvaluetype,controltype,complextype,fieldpath,iscommonfield,group", null)) {
            DynamicObject dyn = hrBaseServiceHelper.generateEmptyDynamicObject();
            dyn.set("id", (Object)dynamicObject.getLong("id"));
            dyn.set("fieldnumber", (Object)dynamicObject.getString("fieldnumber"));
            dyn.set("fieldname", (Object)dynamicObject.getString("fieldname"));
            dyn.set("fieldvaluetype", (Object)dynamicObject.getString("fieldvaluetype"));
            dyn.set("controltype", (Object)dynamicObject.getString("controltype"));
            dyn.set("complextype", (Object)dynamicObject.getString("complextype"));
            dyn.set("fieldpath", (Object)dynamicObject.getString("fieldpath"));
            dyn.set("iscommonfield", (Object)dynamicObject.getBoolean("iscommonfield"));
            dyn.set("group", dynamicObject.get("group"));
            allVirtualFieldCollection.add((Object)dyn);
        }
        return allVirtualFieldCollection;
    }

    private String getOrderBy(VirtualEntityQueryParamInfo queryParamInfo) {
        StringBuilder orderBySb = new StringBuilder();
        LinkedHashMap sortFieldInfoList = queryParamInfo.getSortFieldsMap();
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            orderBySb.append((String)entry.getKey()).append(' ').append((String)entry.getValue()).append(',');
        }
        int indexPoint = orderBySb.lastIndexOf(",");
        if (indexPoint != -1) {
            orderBySb.deleteCharAt(indexPoint);
        }
        return orderBySb.toString();
    }

    private String getColOrderBy(VirtualEntityQueryParamInfo queryParamInfo) {
        StringBuilder orderBySb = new StringBuilder();
        LinkedHashMap sortFieldInfoList = queryParamInfo.getColSortFieldsMap();
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            orderBySb.append((String)entry.getKey()).append(' ').append((String)entry.getValue()).append(',');
        }
        int indexPoint = orderBySb.lastIndexOf(",");
        if (indexPoint != -1) {
            orderBySb.deleteCharAt(indexPoint);
        }
        return orderBySb.toString();
    }

    private QFilter[] getFilters(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList qFilterList = new ArrayList(10);
        List reportFilterList = queryParamInfo.getReportFilterList();
        if (reportFilterList != null && !reportFilterList.isEmpty()) {
            qFilterList.addAll(reportFilterList);
        }
        QFilter[] qFilters = new QFilter[qFilterList.size()];
        int index = 0;
        for (QFilter qFilter : qFilterList) {
            qFilters[index++] = qFilter;
        }
        return qFilters;
    }
}

