/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrptmc.business.task.ReportSortDataSyncAbstractTask;
import org.apache.commons.collections.CollectionUtils;

public class ReportCustomSortDataSyncTask
extends ReportSortDataSyncAbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ReportCustomSortDataSyncTask.class);
    private final HRBaseServiceHelper customSortHelper = new HRBaseServiceHelper("hrptmc_customsort");
    private DynamicObject[] sortDyoArr;
    private boolean fullSync = true;

    @Override
    protected Set<Long> getWaitSyncRptPk(Map<String, Object> map) {
        QFilter[] customSortQFilters;
        Object rptManage = map.get("rptmanage");
        if (rptManage instanceof Long && (Long)rptManage > 0L) {
            this.fullSync = false;
            Long rtpPk = (Long)rptManage;
            customSortQFilters = new QFilter[]{new QFilter("rptmanage", "=", (Object)rtpPk)};
        } else {
            customSortQFilters = new QFilter[]{};
        }
        LOGGER.info("Report-sort-data-sync:custom full-sync:{}", (Object)this.fullSync);
        this.sortDyoArr = this.customSortHelper.queryOriginalArray("id,rptmanage,rptfieldid,entitynumber,entityfield,fieldtype,valuetype", customSortQFilters);
        return Arrays.stream(this.sortDyoArr).map(customSortDyo -> customSortDyo.getLong("rptmanage")).collect(Collectors.toSet());
    }

    @Override
    protected ReportSortTypeEnum getSortTypeEnum() {
        return ReportSortTypeEnum.SELF_SORT;
    }

    @Override
    protected void doSync(DBRoute dbRoute, Map<Long, Set<String>> rptFieldMap, String bizSortTable) {
        Set<Long> rptPKSet = rptFieldMap.keySet();
        Set customSortPKSet = Arrays.stream(this.sortDyoArr).filter(customSortDyo -> rptPKSet.contains(customSortDyo.getLong("rptmanage"))).map(customSortDyo -> customSortDyo.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("Report-sort-data-sync:custom sync entityfieldid:{}", customSortPKSet);
        if (CollectionUtils.isEmpty(customSortPKSet)) {
            return;
        }
        String hmpSortDataSql = "select fentryid,fid,flong,fstring,fseq from t_hrptmc_customsortety where fid in (" + customSortPKSet.stream().map(String::valueOf).collect(Collectors.joining(",")) + " ) ";
        List sortDataList = (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)hmpSortDataSql, (Object[])new Object[0], rs -> {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
            while (rs.next()) {
                Object[] objects = new Object[]{rs.getLong("fentryid"), rs.getLong("fid"), rs.getLong("flong"), rs.getString("fstring"), rs.getInt("fseq")};
                dataList.add(objects);
            }
            return dataList;
        });
        Set<Long> deleteSortFieldIds = null;
        if (!this.fullSync) {
            deleteSortFieldIds = sortDataList.stream().map(arr -> (Long)arr[1]).collect(Collectors.toSet());
        }
        this.syncDataToDb(this.fullSync, bizSortTable, dbRoute, sortDataList, deleteSortFieldIds);
    }
}

