/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.service.complexobj.ExtendSortService;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.task.ReportSortService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class ReportSortDataSyncAbstractTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ReportSortDataSyncAbstractTask.class);
    protected final ExtendSortService extendSortService = new ExtendSortService();

    protected abstract Set<Long> getWaitSyncRptPk(Map<String, Object> var1);

    protected abstract void doSync(DBRoute var1, Map<Long, Set<String>> var2, String var3);

    protected abstract ReportSortTypeEnum getSortTypeEnum();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set<Long> rptIds = this.getWaitSyncRptPk(map);
        if (CollectionUtils.isEmpty(rptIds)) {
            return;
        }
        ReportSortService reportSortService = new ReportSortService();
        Map<String, Map<Long, Set<String>>> dbRouteRptEntityMap = reportSortService.batchRptEntityByDbRoute(rptIds);
        Map<String, Map<Long, Set<String>>> reportCustomSortSyncMsg = AnObjDataExtractService.getInstance().getReportCustomSortSyncMsg();
        dbRouteRptEntityMap.putAll(reportCustomSortSyncMsg);
        LOGGER.info("Report-sort-data-sync wait sync dbRouteRptEntityMap:{}", dbRouteRptEntityMap);
        for (Map.Entry<String, Map<Long, Set<String>>> dbRouteRptEntityEntry : dbRouteRptEntityMap.entrySet()) {
            String[] split = dbRouteRptEntityEntry.getKey().split(":");
            String dbRouteKey = split[0];
            String appNumber = split[1];
            Map<Long, Set<String>> rptEntityMap = dbRouteRptEntityEntry.getValue();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String bizSortTable = this.extendSortService.getBizSortTableByDbRouteKey(appNumber, dbRouteKey, this.getSortTypeEnum().getSortType());
            if (dbRoute == null || HRStringUtils.isEmpty((String)bizSortTable) || MapUtils.isEmpty(rptEntityMap) || !this.extendSortService.checkSortTable(dbRouteKey, bizSortTable)) continue;
            LOGGER.info("Report-sort-data-sync start sync dbRouteKey:{},bizSortTable:{},rptEntityMap:{}", new Object[]{dbRouteKey, bizSortTable, rptEntityMap});
            this.doSync(dbRoute, rptEntityMap, bizSortTable);
        }
    }

    protected void syncDataToDb(boolean fullSync, String sortTable, DBRoute dbRoute, List<Object[]> sortDataList, Set<Long> deleteSortFieldIds) {
        try (TXHandle tx = TX.required();){
            this.deleteOldData(fullSync, sortTable, dbRoute, deleteSortFieldIds);
            this.insertSortData(sortTable, dbRoute, sortDataList);
        }
    }

    private void deleteOldData(boolean deleteAll, String sortTable, DBRoute dbRoute, Set<Long> deleteSortFieldIds) {
        if (deleteAll) {
            String delSql = "truncate table " + sortTable;
            HRDBUtil.execute((DBRoute)dbRoute, (String)delSql, null);
        } else if (deleteSortFieldIds != null && deleteSortFieldIds.size() > 0) {
            String delSql = "delete from " + sortTable + " where fentitysortfieldid in (" + deleteSortFieldIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
            HRDBUtil.execute((DBRoute)dbRoute, (String)delSql, null);
        }
    }

    private void insertSortData(String sortTable, DBRoute dbRoute, List<Object[]> sortDataList) {
        if (CollectionUtils.isEmpty(sortDataList)) {
            return;
        }
        String insertSql = "insert into " + sortTable + "(fid,fentitysortfieldid,flong,fstring,findex) values (?,?,?,?,?)";
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)insertSql, sortDataList);
    }
}

