/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.virtualentity;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.VirtualEntityConstants;

@ExcludeFromJacocoGeneratedReport
public class VirtualEntityService {
    private static final Log LOGGER = LogFactory.getLog(VirtualEntityService.class);

    public static VirtualConfigInfo getVirtualConfigInfo(Long anObjId) {
        AnalyseObjectService service = AnalyseObjectService.getInstance();
        String virtualEntityNumber = service.getMainEntityNumber(anObjId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_virtualentity");
        DynamicObject virtualEntityDy = helper.queryOne("virtualscene.senenumber,virtualscene.issupport", new QFilter[]{new QFilter("number", "=", (Object)virtualEntityNumber)});
        Map<String, Boolean> sceneMap = virtualEntityDy.getDynamicObjectCollection("virtualscene").stream().collect(Collectors.toMap(dy -> dy.getString("senenumber"), dy -> dy.getBoolean("issupport")));
        VirtualConfigInfo virtualConfigInfo = new VirtualConfigInfo();
        try {
            Class<?> cls = virtualConfigInfo.getClass();
            for (String scene : VirtualEntityConstants.virtualScene) {
                if (!sceneMap.get(scene).booleanValue()) continue;
                Method method = cls.getMethod("set" + VirtualEntityService.getMethodName(scene), Boolean.TYPE);
                method.invoke((Object)virtualConfigInfo, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Set_virtualConfigInfo_error!", (Throwable)e);
        }
        return virtualConfigInfo;
    }

    public static String getMethodName(String fieldName) {
        char[] chars = fieldName.toCharArray();
        chars[0] = VirtualEntityService.toUpperCase(chars[0]);
        return String.valueOf(chars);
    }

    public static char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c ^ 0x20);
        }
        return c;
    }
}

