/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.center;

import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptc.common.constant.center.ReportCenterEntityConstants;
import kd.hr.hrptmc.common.constant.center.ReportCenterGroupConstants;

public class ReportCenterGroupEdit
extends HRDataBaseEdit
implements ReportCenterGroupConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterGroupEdit.class);

    public void beforeBindData(EventObject e) {
        try {
            DynamicObject parentDy;
            super.beforeBindData(e);
            Object parent = this.getModel().getValue("parent");
            if (parent == null && !this.isRoot()) {
                this.getModel().setValue("parent", (Object)1000L);
            } else if (parent != null && (parentDy = (DynamicObject)parent).getBoolean("isendgroup")) {
                this.getModel().setValue("parent", null);
            }
            this.getModel().setDataChanged(false);
        }
        catch (Exception exception) {
            LOGGER.error("beforeBindData_error_", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject eventObject) {
        try {
            super.afterBindData(eventObject);
            FormShowParameter form = this.getView().getFormShowParameter();
            if (this.isRoot()) {
                form.setStatus(OperationStatus.VIEW);
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            }
            if (this.existChildrenNodes() || this.existPublishReport()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isendgroup"});
            }
        }
        catch (Exception exception) {
            LOGGER.error("afterBindData_error_", (Throwable)exception);
        }
    }

    private boolean isRoot() {
        DynamicObject entity = this.getModel().getDataEntity();
        return String.valueOf(1000L).equals(String.valueOf(entity.getPkValue()));
    }

    private boolean existChildrenNodes() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (pkValue != null && !String.valueOf(pkValue).equals("0")) {
            String longNumber = dataEntity.getString("longnumber");
            IDataEntityProperty parentProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"parent");
            String longNumberDLM = ".";
            if (parentProp instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)parentProp).getLongNumberDLM();
            }
            return CENTER_GROUP_HELPER.isExists(new QFilter("longnumber", "like", (Object)(longNumber + longNumberDLM + "%")));
        }
        return false;
    }

    private boolean existPublishReport() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (pkValue != null && !String.valueOf(pkValue).equals("0")) {
            return ReportCenterEntityConstants.CENTER_HELPER.isExists(new QFilter("reportgroup", "=", pkValue));
        }
        return false;
    }
}

