/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.formplugin.perm.model.PermFieldData;
import org.jetbrains.annotations.NotNull;

public class PermGroup
implements Serializable,
Comparable<PermGroup> {
    private static final long serialVersionUID = 4388856118297063407L;
    private String groupKey;
    private List<PermFieldData> userRepPermFieldData = Lists.newArrayListWithExpectedSize((int)10);

    public PermGroup() {
    }

    public PermGroup(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public List<PermFieldData> getUserRepPermFieldData() {
        return this.userRepPermFieldData;
    }

    public void setUserRepPermFieldData(List<PermFieldData> userRepPermFieldData) {
        this.userRepPermFieldData = userRepPermFieldData;
    }

    public Map<String, PermFieldData> getUserRepPermFieldDataMap() {
        if (this.userRepPermFieldData == null) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return this.userRepPermFieldData.stream().collect(Collectors.toMap(PermFieldData::getFieldId, Function.identity(), (oldValue, newValue) -> oldValue));
    }

    public void sortData() {
        if (this.userRepPermFieldData != null) {
            this.userRepPermFieldData = this.userRepPermFieldData.stream().sorted((x, y) -> x.isHasSubGroup() ? -1 : (y.isHasSubGroup() ? 1 : 0)).collect(Collectors.toList());
        }
    }

    @Override
    public int compareTo(@NotNull PermGroup o) {
        String xGroupKey = this.getGroupKey();
        String yGroupKey = o.getGroupKey();
        if (HRStringUtils.isNotEmpty((String)xGroupKey) && HRStringUtils.isNotEmpty((String)yGroupKey)) {
            String xIndex = xGroupKey.replaceFirst("group_", "");
            String yIndex = yGroupKey.replaceFirst("group_", "");
            return Integer.parseInt(xIndex) - Integer.parseInt(yIndex);
        }
        if (HRStringUtils.isNotEmpty((String)xGroupKey)) {
            return -1;
        }
        return 0;
    }
}

