/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm.processor;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.common.model.perm.AdminOrgFieldStructureVO;
import kd.hr.hrptc.common.model.perm.AdminOrgStructureVO;
import kd.hr.hrptc.common.model.perm.FieldDimType;
import kd.hr.hrptc.formplugin.perm.ReportUserPermEdit;
import kd.hr.hrptc.formplugin.perm.model.PermFieldData;
import kd.hr.hrptc.formplugin.perm.model.PermGroup;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermData;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermDataRangeReturnVO;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermFieldReturnVO;
import kd.hr.hrptc.formplugin.perm.utils.ReportUserPermFormUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportUserPermVOProcessor
implements ReportUserPermConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportUserPermVOProcessor.class);
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
    private final ReportUserPermEdit plugin;

    public ReportUserPermVOProcessor(ReportUserPermEdit plugin) {
        this.plugin = plugin;
    }

    private IDataModel getModel() {
        return this.plugin.getView().getModel();
    }

    private IFormView getView() {
        return this.plugin.getView();
    }

    public UserRepPermFieldReturnVO getReportPermFieldReturnVO() {
        UserRepPermFieldReturnVO repPermDimReturnVO = new UserRepPermFieldReturnVO();
        Map<Object, Boolean> selectedReportIsMergeMap = ReportUserPermFormUtils.getSelectedReportIsMergeMap(this.getModel());
        ArrayList deleteIds = Lists.newArrayListWithExpectedSize((int)selectedReportIsMergeMap.size());
        LinkedHashMap currentReportIdToFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)selectedReportIsMergeMap.size());
        Set oldReportIds = selectedReportIsMergeMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        Set<Long> transSelectNodeIds = ReportUserPermFormUtils.getTransSelectNodeIds(this.getView());
        Map<String, Set<String>> disableFieldMap = this.getDisableFieldMap();
        if (transSelectNodeIds.isEmpty()) {
            deleteIds.addAll(oldReportIds);
        } else {
            Set selectIds = transSelectNodeIds.stream().map(String::valueOf).collect(Collectors.toSet());
            ArrayList addRepPermDimMap = Lists.newArrayListWithExpectedSize((int)selectIds.size());
            if (!oldReportIds.equals(selectIds)) {
                DynamicObject[] dbRepDimMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", transSelectNodeIds)});
                for (DynamicObject dbRepDimMapDy : dbRepDimMapDys) {
                    currentReportIdToFieldMap.put(dbRepDimMapDy.getDynamicObject("rptmanage").getString("id"), dbRepDimMapDy);
                }
                deleteIds = Lists.newArrayList(oldReportIds);
                deleteIds.removeAll(selectIds);
                for (String oldReportId : oldReportIds) {
                    currentReportIdToFieldMap.remove(oldReportId);
                }
                if (!currentReportIdToFieldMap.isEmpty()) {
                    Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(currentReportIdToFieldMap.values().toArray(new DynamicObject[0]));
                    Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.getView(), queryFieldBoMap.values());
                    for (DynamicObject dimMapDy : currentReportIdToFieldMap.values()) {
                        addRepPermDimMap.add(this.buildRepPermDimMap(dimMapDy, disableFieldMap, selectedReportIsMergeMap, queryFieldBoMap, adminOrgFieldStructureVOMap));
                    }
                    repPermDimReturnVO.setAddUserRepPermFields(addRepPermDimMap);
                }
            }
        }
        repPermDimReturnVO.setDeleteIds(deleteIds);
        return repPermDimReturnVO;
    }

    public List<UserRepPermData> mergeUserRepPermFieldData(UserRepPermFieldReturnVO userRepPermFieldReturnVO) {
        DynamicObjectCollection reportPermDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        HashSet deleteIds = Sets.newHashSet(userRepPermFieldReturnVO.getDeleteIds());
        List<UserRepPermData> addUserRepPermFields = userRepPermFieldReturnVO.getAddUserRepPermFields();
        int expectSize = reportPermDataEntry.size() + addUserRepPermFields.size();
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)expectSize);
        HashMap userRepPermDataMap = Maps.newHashMapWithExpectedSize((int)expectSize);
        HashSet mergeGroupKey = Sets.newHashSetWithExpectedSize((int)expectSize);
        HashMap permFieldDataMap = Maps.newHashMapWithExpectedSize((int)expectSize);
        HashMap mergeReportFieldDimKeyMap = Maps.newHashMapWithExpectedSize((int)expectSize);
        Set addNewReportIds = addUserRepPermFields.stream().map(UserRepPermData::getReportId).map(Long::parseLong).collect(Collectors.toSet());
        Map<Object, Boolean> selectedReportIsMergeMap = ReportUserPermFormUtils.getSelectedReportIsMergeMap(this.getModel());
        for (Long newReportId : addNewReportIds) {
            selectedReportIsMergeMap.put(newReportId, true);
        }
        DynamicObject[] dbRepDimMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", selectedReportIsMergeMap.keySet())});
        Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(dbRepDimMapDys);
        for (DynamicObject repPermDataEntryDy : reportPermDataEntry) {
            DynamicObject reportDy = repPermDataEntryDy.getDynamicObject("report");
            String groupKey = repPermDataEntryDy.getString("permgroup");
            String reportId = reportDy.getString("id");
            if (deleteIds.contains(reportId)) continue;
            UserRepPermData userRepPermData = (UserRepPermData)userRepPermDataMap.get(reportId);
            if (userRepPermData == null) {
                userRepPermData = new UserRepPermData(reportId, reportDy.getString("name"), reportDy.getString("description"), repPermDataEntryDy.getBoolean("ismerge"));
                userRepPermDataMap.put(reportId, userRepPermData);
            }
            Map<String, PermGroup> groupMap = userRepPermData.getPermGroupMap();
            List<PermGroup> permGroups = userRepPermData.getPermGroups();
            PermGroup permGroup = groupMap.get(groupKey);
            if (permGroup == null) {
                permGroup = new PermGroup(groupKey);
                groupMap.put(groupKey, permGroup);
                permGroups.add(permGroup);
            }
            List<PermFieldData> userRepPermFieldData = permGroup.getUserRepPermFieldData();
            DynamicObject queryFieldDy = repPermDataEntryDy.getDynamicObject("queryfield");
            String fieldId = queryFieldDy.getString("id");
            QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldId);
            PermFieldData fieldData = (PermFieldData)permFieldDataMap.get(reportId + "|" + groupKey + "&" + fieldId);
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType);
            String dimUniqueKey = groupKey + "&" + mergeDimKey;
            if (fieldData == null) {
                fieldData = new PermFieldData();
                fieldData.setFieldId(fieldId);
                fieldData.setDimUniqueKey(dimUniqueKey);
                fieldData.setData(repPermDataEntryDy.getString("data"));
                fieldData.setNoLimit(repPermDataEntryDy.getBoolean("nolimit"));
                fieldData.setIncludeSub(repPermDataEntryDy.getBoolean("includesub"));
                userRepPermFieldData.add(fieldData);
                permFieldDataMap.put(reportId + "|" + groupKey + "&" + fieldId, fieldData);
            }
            DynamicObject adminOrgStruct = repPermDataEntryDy.getDynamicObject("adminorgstruct");
            if (userRepPermData.isMerge()) {
                mergeGroupKey.add(groupKey);
                if (adminOrgStruct == null) {
                    mergeReportFieldDimKeyMap.put(dimUniqueKey, fieldData);
                }
            }
            if (adminOrgStruct == null) continue;
            fieldData.setHasSubGroup(true);
            List<PermFieldData> subGroupFields = fieldData.getSubGroupFields();
            PermFieldData subFieldData = new PermFieldData();
            subFieldData.setFieldId(fieldId);
            subFieldData.setDimUniqueKey(dimUniqueKey + "#" + adminOrgStruct.getString("id"));
            subFieldData.setDimSubGroupId(adminOrgStruct.getString("id"));
            subFieldData.setData(repPermDataEntryDy.getString("data"));
            subFieldData.setNoLimit(repPermDataEntryDy.getBoolean("nolimit"));
            subFieldData.setIncludeSub(repPermDataEntryDy.getBoolean("includesub"));
            subGroupFields.add(subFieldData);
            if (!userRepPermData.isMerge()) continue;
            mergeReportFieldDimKeyMap.put(subFieldData.getDimUniqueKey(), subFieldData);
        }
        dataList.addAll(userRepPermDataMap.values());
        if (mergeGroupKey.isEmpty()) {
            mergeGroupKey.add("group_1");
        }
        for (UserRepPermData addUserRepPermField : addUserRepPermFields) {
            List<PermFieldData> userRepPermFieldData = addUserRepPermField.getUserRepPermFieldData();
            ArrayList permGroups = Lists.newArrayListWithExpectedSize((int)mergeGroupKey.size());
            for (String groupKey : mergeGroupKey) {
                PermGroup permGroup = new PermGroup(groupKey);
                permGroup.setUserRepPermFieldData(userRepPermFieldData);
                permGroups.add(permGroup);
                for (PermFieldData permFieldData : userRepPermFieldData) {
                    String fieldId = permFieldData.getFieldId();
                    QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldId);
                    String fieldDimType = this.getFieldDimType(queryFieldBo);
                    String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType);
                    String dimUniqueKey = groupKey + "&" + mergeDimKey;
                    if (permFieldData.isHasSubGroup()) {
                        List<PermFieldData> subGroupFields = permFieldData.getSubGroupFields();
                        String prefix = dimUniqueKey;
                        for (PermFieldData subGroupField : subGroupFields) {
                            dimUniqueKey = prefix + "#" + subGroupField.getDimSubGroupId();
                            PermFieldData oldData = (PermFieldData)mergeReportFieldDimKeyMap.get(dimUniqueKey);
                            if (oldData == null) continue;
                            subGroupField.setData(oldData.getData());
                            subGroupField.setNoLimit(oldData.isNoLimit());
                            subGroupField.setIncludeSub(oldData.isIncludeSub());
                        }
                        continue;
                    }
                    PermFieldData oldData = (PermFieldData)mergeReportFieldDimKeyMap.get(dimUniqueKey);
                    if (oldData == null) continue;
                    permFieldData.setData(oldData.getData());
                    permFieldData.setNoLimit(oldData.isNoLimit());
                    permFieldData.setIncludeSub(oldData.isIncludeSub());
                }
            }
            addUserRepPermField.setPermGroups(permGroups);
            dataList.add(addUserRepPermField);
        }
        return dataList;
    }

    public List<UserRepPermData> buildPermDataListByReturnVO(UserRepPermDataRangeReturnVO dataRangeReturnVO) {
        List<PermGroup> mergeRepPermData = dataRangeReturnVO.getMergeRepPermData();
        List<UserRepPermData> independentRepPermData = dataRangeReturnVO.getIndependentRepPermData();
        Set<Long> selectedReportIds = ReportUserPermFormUtils.getTransSelectNodeIds(this.getView());
        HashSet independentReportIds = Sets.newHashSetWithExpectedSize((int)independentRepPermData.size());
        Iterator<UserRepPermData> iterator = independentRepPermData.iterator();
        while (iterator.hasNext()) {
            UserRepPermData userRepPermData = iterator.next();
            if (HRStringUtils.isNotEmpty((String)userRepPermData.getReportId())) {
                independentReportIds.add(Long.parseLong(userRepPermData.getReportId()));
                continue;
            }
            iterator.remove();
        }
        selectedReportIds.removeAll(independentReportIds);
        ArrayList permData = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, Set<String>> disableFieldMap = this.getDisableFieldMap();
        if (!selectedReportIds.isEmpty() && mergeRepPermData != null && !mergeRepPermData.isEmpty()) {
            DynamicObject[] dbRepFieldMapDys;
            LinkedHashMap currentReportIdToFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)selectedReportIds.size());
            for (DynamicObject dbRepFieldMapDy : dbRepFieldMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", selectedReportIds)})) {
                currentReportIdToFieldMap.put(dbRepFieldMapDy.getDynamicObject("rptmanage").getString("id"), dbRepFieldMapDy);
            }
            Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(currentReportIdToFieldMap.values().toArray(new DynamicObject[0]));
            for (Long mergeReportId : selectedReportIds) {
                UserRepPermData userRepPermData = new UserRepPermData();
                String reportId = String.valueOf(mergeReportId);
                userRepPermData.setReportId(reportId);
                DynamicObject repFieldMapDys = (DynamicObject)currentReportIdToFieldMap.get(reportId);
                Set<String> disableFieldIdSet = disableFieldMap.get(reportId);
                ArrayList newGroups = Lists.newArrayListWithExpectedSize((int)mergeRepPermData.size());
                for (PermGroup permGroup : mergeRepPermData) {
                    PermGroup newPermGroup = new PermGroup(permGroup.getGroupKey());
                    List<PermFieldData> userRepPermFieldData = permGroup.getUserRepPermFieldData();
                    Map mergeDimKeyMap = userRepPermFieldData.stream().collect(Collectors.toMap(PermFieldData::getDimNumber, Function.identity()));
                    DynamicObjectCollection fieldEntryDys = repFieldMapDys.getDynamicObjectCollection("entryentity");
                    ArrayList newFieldDataList = Lists.newArrayListWithExpectedSize((int)fieldEntryDys.size());
                    for (DynamicObject fieldEntryDy : fieldEntryDys) {
                        String fieldDimType;
                        DynamicObject fieldDy = fieldEntryDy.getDynamicObject("aoqfield");
                        boolean mustInput = fieldEntryDy.getBoolean("ismust");
                        String fieldId = fieldDy.getString("id");
                        QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldId);
                        String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType = this.getFieldDimType(queryFieldBo));
                        PermFieldData fieldData = (PermFieldData)mergeDimKeyMap.get(mergeDimKey);
                        if (fieldData == null) continue;
                        PermFieldData newFieldData = new PermFieldData();
                        newFieldData.setFieldId(fieldId);
                        if (mustInput) {
                            newFieldData.setOpen(true);
                        } else if (disableFieldIdSet != null && disableFieldIdSet.contains(fieldId)) {
                            newFieldData.setOpen(false);
                        }
                        if (fieldData.isHasSubGroup()) {
                            newFieldData.setHasSubGroup(true);
                            List<PermFieldData> subGroupFields = fieldData.getSubGroupFields();
                            ArrayList newSubGroupFields = Lists.newArrayListWithExpectedSize((int)subGroupFields.size());
                            for (PermFieldData subGroupField : subGroupFields) {
                                PermFieldData newSubGroupFieldData = new PermFieldData();
                                newSubGroupFieldData.setFieldId(newFieldData.getFieldId());
                                newSubGroupFieldData.setData(subGroupField.getData());
                                newSubGroupFieldData.setDimSubGroupId(subGroupField.getDimSubGroupId());
                                newSubGroupFieldData.setDimNumber(subGroupField.getDimNumber());
                                newSubGroupFieldData.setNoLimit(subGroupField.isNoLimit());
                                newSubGroupFieldData.setIncludeSub(subGroupField.isIncludeSub());
                                newSubGroupFields.add(newSubGroupFieldData);
                            }
                            newFieldData.setSubGroupFields(newSubGroupFields);
                        } else {
                            newFieldData.setData(fieldData.getData());
                            newFieldData.setNoLimit(fieldData.isNoLimit());
                            newFieldData.setIncludeSub(fieldData.isIncludeSub());
                        }
                        newFieldDataList.add(newFieldData);
                    }
                    newPermGroup.setUserRepPermFieldData(newFieldDataList);
                    newGroups.add(newPermGroup);
                }
                userRepPermData.setPermGroups(newGroups);
                permData.add(userRepPermData);
            }
        }
        permData.addAll(independentRepPermData);
        if (!independentRepPermData.isEmpty()) {
            List sortReportIds = independentRepPermData.stream().map(UserRepPermData::getReportId).collect(Collectors.toList());
            this.getView().getPageCache().put("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX", JSONArray.toJSONString(sortReportIds));
        }
        return permData;
    }

    public UserRepPermDataRangeReturnVO getUserRepPermDataRangeReturnVO() {
        DynamicObjectCollection reportPermDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        UserRepPermDataRangeReturnVO returnVO = new UserRepPermDataRangeReturnVO();
        List<Object> independentRepPermData = Lists.newArrayListWithExpectedSize((int)reportPermDataEntry.size());
        HashMap entityNumberToIdsMap = Maps.newHashMapWithExpectedSize((int)reportPermDataEntry.size());
        ArrayList queryFieldIds = Lists.newArrayListWithExpectedSize((int)reportPermDataEntry.size());
        for (DynamicObject reportPermDataEntryDy : reportPermDataEntry) {
            DynamicObject queryFieldDy = reportPermDataEntryDy.getDynamicObject("queryfield");
            if (queryFieldDy == null) continue;
            queryFieldIds.add(queryFieldDy.getPkValue());
        }
        DynamicObject[] queryFieldDys = QUERY_FIELD_HELPER.loadDynamicObjectArray(queryFieldIds.toArray());
        List queryFieldBos = AnalyseObjectService.getInstance().assembleQueryFields(queryFieldDys);
        Map queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, Function.identity(), (oldValue, newValue) -> oldValue));
        for (DynamicObject reportPermDataEntryDy : reportPermDataEntry) {
            QueryFieldBo queryFieldBo;
            DynamicObject queryFieldDy = reportPermDataEntryDy.getDynamicObject("queryfield");
            String data = reportPermDataEntryDy.getString("data");
            if (queryFieldDy == null || !HRStringUtils.isNotEmpty((String)data) || (queryFieldBo = (QueryFieldBo)queryFieldBoMap.get(queryFieldDy.getString("id"))) == null) continue;
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            if (FieldDimType.COMBO.getValue().equals(fieldDimType)) continue;
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            String[] ids = data.split(",");
            entityNumberToIdsMap.putIfAbsent(entityNumber, Sets.newHashSetWithExpectedSize((int)reportPermDataEntry.size()));
            entityNumberToIdsMap.computeIfPresent(entityNumber, (oldKey, set) -> {
                set.addAll(Sets.newHashSet((Object[])ids));
                return set;
            });
        }
        LOGGER.info("getUserRepPermDataRangeReturnVO_entityNumberToIdsMap_{}", (Object)entityNumberToIdsMap);
        Map<String, String> baseDataIdToShowNameMap = ReportUserPermFormUtils.getBaseDataIdToShowNameMap(this.mainEntityTypeUtil, entityNumberToIdsMap);
        LOGGER.info("getUserRepPermDataRangeReturnVO_baseDataIdToShowNameMap_{}", baseDataIdToShowNameMap);
        Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.getView(), queryFieldBoMap.values());
        LinkedHashMap mergeGroupMap = Maps.newLinkedHashMapWithExpectedSize((int)reportPermDataEntry.size());
        HashMap independentRepPermDataMap = Maps.newHashMapWithExpectedSize((int)reportPermDataEntry.size());
        HashMap fieldDataMap = Maps.newHashMapWithExpectedSize((int)reportPermDataEntry.size());
        HashSet mergeDimKeys = Sets.newHashSetWithExpectedSize((int)reportPermDataEntry.size());
        HashSet mergeDimSubKeys = Sets.newHashSetWithExpectedSize((int)reportPermDataEntry.size());
        List reportPermDataEntryList = reportPermDataEntry.stream().sorted((x, y) -> {
            if (x.getBoolean("mustinput")) {
                return -1;
            }
            if (y.getBoolean("mustinput")) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
        for (DynamicObject reportPermDataEntryDy : reportPermDataEntryList) {
            Map<String, PermGroup> permGroupMap;
            PermGroup permGroup;
            boolean isMerge = reportPermDataEntryDy.getBoolean("ismerge");
            DynamicObject queryField = reportPermDataEntryDy.getDynamicObject("queryfield");
            String fieldId = String.valueOf(queryField.getPkValue());
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldBoMap.get(fieldId);
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String data = reportPermDataEntryDy.getString("data");
            String groupKey = reportPermDataEntryDy.getString("permgroup");
            String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType);
            String dimUniqueKey = groupKey + "&" + mergeDimKey;
            DynamicObject adminOrgStructDy = reportPermDataEntryDy.getDynamicObject("adminorgstruct");
            String dimSubGroupId = adminOrgStructDy == null ? null : String.valueOf(adminOrgStructDy.getPkValue());
            String showName = this.getShowName(queryFieldBo, data, baseDataIdToShowNameMap);
            if (isMerge) {
                PermFieldData fieldData;
                ArrayList userRepPermFieldData;
                PermGroup permGroup2 = (PermGroup)mergeGroupMap.get(groupKey);
                if (permGroup2 == null) {
                    permGroup2 = new PermGroup(groupKey);
                    mergeGroupMap.put(groupKey, permGroup2);
                }
                if ((userRepPermFieldData = permGroup2.getUserRepPermFieldData()) == null) {
                    userRepPermFieldData = Lists.newArrayListWithExpectedSize((int)reportPermDataEntry.size());
                    permGroup2.setUserRepPermFieldData(userRepPermFieldData);
                }
                if (mergeDimKeys.add(dimUniqueKey)) {
                    fieldData = this.buildPermFieldData(reportPermDataEntryDy, fieldDimType, dimUniqueKey, mergeDimKey, queryFieldBo, data, dimSubGroupId, true, showName, adminOrgFieldStructureVOMap);
                    userRepPermFieldData.add(fieldData);
                    fieldDataMap.put(dimUniqueKey, fieldData);
                    if (!HRStringUtils.isNotEmpty((String)dimSubGroupId)) continue;
                    mergeDimSubKeys.add(dimUniqueKey + "#" + dimSubGroupId);
                    continue;
                }
                if (!FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType)) continue;
                fieldData = (PermFieldData)fieldDataMap.get(dimUniqueKey);
                if (!mergeDimSubKeys.add(dimUniqueKey + "#" + dimSubGroupId)) continue;
                fieldData.setDimSubGroupId(dimSubGroupId);
                boolean includeSub = reportPermDataEntryDy.getBoolean("includesub");
                fieldData.setIncludeSub(includeSub);
                fieldData.setData(data);
                fieldData.setShowData(showName);
                fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
                continue;
            }
            DynamicObject reportDy = reportPermDataEntryDy.getDynamicObject("report");
            String reportId = reportDy.getString("id");
            String fieldUniqueKey = reportId + "|" + dimUniqueKey;
            UserRepPermData userRepPermData = (UserRepPermData)independentRepPermDataMap.get(reportId);
            if (userRepPermData == null) {
                userRepPermData = new UserRepPermData(reportId, reportDy.getString("name"), reportDy.getString("description"), false);
                independentRepPermDataMap.put(reportId, userRepPermData);
            }
            if ((permGroup = (permGroupMap = userRepPermData.getPermGroupMap()).get(groupKey)) == null) {
                permGroup = new PermGroup(groupKey);
                userRepPermData.getPermGroups().add(permGroup);
            }
            List<PermFieldData> userRepPermFieldData = permGroup.getUserRepPermFieldData();
            PermFieldData fieldData = (PermFieldData)fieldDataMap.get(fieldUniqueKey);
            if (fieldData == null) {
                fieldData = this.buildPermFieldData(reportPermDataEntryDy, fieldDimType, dimUniqueKey, mergeDimKey, queryFieldBo, data, dimSubGroupId, false, showName, adminOrgFieldStructureVOMap);
                userRepPermFieldData.add(fieldData);
            } else if (FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType)) {
                fieldData.setDimSubGroupId(dimSubGroupId);
                boolean includeSub = reportPermDataEntryDy.getBoolean("includesub");
                fieldData.setIncludeSub(includeSub);
                fieldData.setData(data);
                fieldData.setShowData(showName);
                fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
            }
            fieldDataMap.put(fieldUniqueKey, fieldData);
        }
        Set<Long> transSelectNodeIds = ReportUserPermFormUtils.getTransSelectNodeIds(this.getView());
        returnVO.setSelectReportSize(transSelectNodeIds.size());
        independentRepPermData.addAll(independentRepPermDataMap.values());
        if (!independentRepPermData.isEmpty()) {
            List sortIdList;
            String sortIndexStr = this.getView().getPageCache().get("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX");
            if (HRStringUtils.isEmpty((String)sortIndexStr)) {
                DynamicObjectCollection selectReportEntry = this.getModel().getEntryEntity("selectreportentry");
                sortIdList = Lists.newArrayListWithExpectedSize((int)selectReportEntry.size());
                for (DynamicObject selectReportEntryDy : selectReportEntry) {
                    DynamicObject reportDy;
                    boolean isMerge = selectReportEntryDy.getBoolean("selectreportismerge");
                    if (isMerge || (reportDy = selectReportEntryDy.getDynamicObject("selectreport")) == null) continue;
                    sortIdList.add(reportDy.getString("id"));
                }
                this.getView().getPageCache().put("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX", JSONArray.toJSONString((Object)sortIdList));
            } else {
                sortIdList = JSONArray.parseArray((String)sortIndexStr, String.class);
            }
            HashMap sortIndexMap = Maps.newHashMapWithExpectedSize((int)sortIdList.size());
            for (int index = 0; index < sortIdList.size(); ++index) {
                String reportId = (String)sortIdList.get(index);
                sortIndexMap.putIfAbsent(reportId, index);
            }
            independentRepPermData = independentRepPermData.stream().sorted((x, y) -> {
                String xReportId = x.getReportId();
                String yReportId = y.getReportId();
                Integer xIndex = (Integer)sortIndexMap.get(xReportId);
                Integer yIndex = (Integer)sortIndexMap.get(yReportId);
                if (xIndex != null && yIndex != null) {
                    return xIndex - yIndex;
                }
                if (xIndex != null) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
        }
        returnVO.setMergeRepPermData(Lists.newArrayList(mergeGroupMap.values()));
        returnVO.setIndependentRepPermData(independentRepPermData);
        return returnVO;
    }

    public UserRepPermData buildRepPermDimMap(DynamicObject dimMapDy, Map<String, Set<String>> disableDimMap, Map<Object, Boolean> selectedReportIsMergeMap, Map<String, QueryFieldBo> queryFieldBoMap, Map<String, AdminOrgFieldStructureVO> adminOrgFieldStructureVOMap) {
        DynamicObject rptManage = dimMapDy.getDynamicObject("rptmanage");
        UserRepPermData userRepPermData = new UserRepPermData(rptManage.getString("id"), rptManage.getString("name"), rptManage.getString("description"));
        Boolean isMerge = selectedReportIsMergeMap.get(rptManage.getPkValue());
        if (isMerge != null) {
            userRepPermData.setMerge(isMerge);
        }
        DynamicObjectCollection dimEntry = dimMapDy.getDynamicObjectCollection("entryentity");
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
        for (DynamicObject dimDy : dimEntry) {
            DynamicProperty property;
            PermFieldData permField = new PermFieldData();
            DynamicObject queryFieldDy = dimDy.getDynamicObject("aoqfield");
            boolean isMust = dimDy.getBoolean("ismust");
            String fieldId = queryFieldDy.getString("id");
            QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldId);
            permField.setFieldId(fieldId);
            permField.setMustInput(isMust);
            Set<String> disableDim = disableDimMap.get(userRepPermData.getReportId());
            permField.setOpen(isMust || disableDim == null || !disableDim.contains(fieldId));
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
            if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
                property = this.getFieldProperty(mainEntityType, queryFieldBo.getFieldPath());
                if (property != null) {
                    permField.setDimName(property.getDisplayName().getLocaleValue());
                    permField.setComboItems(queryFieldBo.getData());
                }
            } else if (FieldDimType.BU.getValue().equals(fieldDimType)) {
                property = this.getFieldProperty(this.mainEntityTypeUtil.getMainEntityType(queryFieldBo.getEntityNumber()), queryFieldBo.getFieldPath());
                if (property instanceof OrgProp) {
                    permField.setOrgFuncId(((OrgProp)property).getOrgFunc());
                    OrgViewSchemeProp orgViewScheme = ((OrgProp)property).getOrgViewScheme();
                    String orgViewSchemeNumber = orgViewScheme == null ? "" : orgViewScheme.getNumber();
                    permField.setOrgViewSchemeNumber(orgViewSchemeNumber);
                }
                permField.setDimName(mainEntityType.getDisplayName().getLocaleValue());
                permField.setBaseDataNumber(entityNumber);
            } else if (FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType)) {
                permField.setDimName(mainEntityType.getDisplayName().getLocaleValue());
                permField.setHasSubGroup(true);
                permField.setSubGroupFields(this.buildSubGroupFields(permField, queryFieldBo, adminOrgFieldStructureVOMap));
                permField.setBaseDataNumber(entityNumber);
            } else {
                permField.setDimName(mainEntityType.getDisplayName().getLocaleValue());
                permField.setBaseDataNumber(entityNumber);
            }
            permField.setFieldDimType(fieldDimType);
            dimList.add(permField);
        }
        userRepPermData.setUserRepPermFieldData(dimList);
        return userRepPermData;
    }

    private PermFieldData buildPermFieldData(DynamicObject reportPermDataEntryDy, String fieldDimType, String dimUniqueKey, String mergeDimKey, QueryFieldBo queryFieldBo, String permData, String dimSubGroupId, boolean isMerge, String showName, Map<String, AdminOrgFieldStructureVO> adminOrgFieldStructureVOMap) {
        PermFieldData fieldData = new PermFieldData();
        fieldData.setData(permData);
        fieldData.setFieldDimType(fieldDimType);
        fieldData.setDimUniqueKey(dimUniqueKey);
        fieldData.setDimNumber(mergeDimKey);
        fieldData.setDimSubGroupId(dimSubGroupId);
        if (!isMerge) {
            DynamicObject queryField = reportPermDataEntryDy.getDynamicObject("queryfield");
            fieldData.setFieldId(String.valueOf(queryField.getPkValue()));
        }
        boolean mustInput = reportPermDataEntryDy.getBoolean("mustinput");
        boolean noLimit = reportPermDataEntryDy.getBoolean("nolimit");
        boolean includeSub = reportPermDataEntryDy.getBoolean("includesub");
        fieldData.setMustInput(mustInput);
        fieldData.setNoLimit(noLimit);
        String entityNumber = queryFieldBo._getFieldEntityNumber();
        MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
        fieldData.setShowData(showName);
        if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
            DynamicProperty fieldProperty = this.getFieldProperty(mainEntityType, queryFieldBo.getFieldPath());
            if (fieldProperty != null) {
                fieldData.setDimName(fieldProperty.getDisplayName().getLocaleValue());
            }
            fieldData.setComboItems(queryFieldBo.getData());
        } else if (FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType)) {
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
            fieldData.setHasSubGroup(true);
            fieldData.setIncludeSub(includeSub);
            fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
            fieldData.setBaseDataNumber(entityNumber);
        } else if (FieldDimType.BU.getValue().equals(fieldDimType)) {
            DynamicProperty fieldProperty = this.getFieldProperty(this.mainEntityTypeUtil.getMainEntityType(queryFieldBo.getEntityNumber()), queryFieldBo.getFieldPath());
            if (fieldProperty instanceof OrgProp) {
                fieldData.setOrgFuncId(((OrgProp)fieldProperty).getOrgFunc());
                OrgViewSchemeProp orgViewScheme = ((OrgProp)fieldProperty).getOrgViewScheme();
                String orgViewSchemeNumber = orgViewScheme == null ? "" : orgViewScheme.getNumber();
                fieldData.setOrgViewSchemeNumber(orgViewSchemeNumber);
            }
            fieldData.setBaseDataNumber(entityNumber);
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
        } else {
            fieldData.setBaseDataNumber(entityNumber);
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
        }
        return fieldData;
    }

    private List<PermFieldData> buildSubGroupFields(PermFieldData parentField, QueryFieldBo queryFieldBo, Map<String, AdminOrgFieldStructureVO> adminOrgFieldStructureVOMap) {
        String adminOrgFieldUniqueKey = this.getAdminOrgFieldUniqueKey(queryFieldBo.getEntityNumber(), queryFieldBo.getFieldNumber(), queryFieldBo._getFieldEntityNumber());
        AdminOrgFieldStructureVO adminOrgFieldStructureVO = adminOrgFieldStructureVOMap.get(adminOrgFieldUniqueKey);
        List<PermFieldData> subGroupFieldList = parentField.getSubGroupFields();
        if (adminOrgFieldStructureVO != null) {
            String dimSubGroupId = parentField.getDimSubGroupId();
            Collection structures = null;
            if (HRStringUtils.isNotEmpty((String)dimSubGroupId)) {
                Map structureVOMap = adminOrgFieldStructureVO.getStructureVOMap();
                AdminOrgStructureVO structureVO = (AdminOrgStructureVO)structureVOMap.get(dimSubGroupId);
                if (structureVO != null) {
                    structures = Lists.newArrayList((Object[])new AdminOrgStructureVO[]{structureVO});
                }
            } else {
                structures = adminOrgFieldStructureVO._getStructureVOList();
            }
            if (structures != null) {
                for (AdminOrgStructureVO structureVO : structures) {
                    PermFieldData subGroupField = new PermFieldData();
                    subGroupField.setMustInput(parentField.isMustInput());
                    subGroupField.setFieldId(parentField.getFieldId());
                    subGroupField.setDimName(parentField.getDimName());
                    subGroupField.setOpen(parentField.isOpen());
                    subGroupField.setDimUniqueKey(parentField.getDimUniqueKey() + "#" + structureVO.getId());
                    subGroupField.setDimSubGroupId(structureVO.getId());
                    subGroupField.setDimSubGroupName(structureVO.getName());
                    subGroupField.setData(parentField.getData());
                    subGroupField.setShowData(parentField.getShowData());
                    subGroupField.setIncludeSub(parentField.isIncludeSub());
                    subGroupFieldList.add(subGroupField);
                }
            }
        }
        parentField.setDimSubGroupId("");
        parentField.setData("");
        return subGroupFieldList;
    }

    public Map<String, Set<String>> getDisableFieldMap() {
        DynamicObjectCollection fieldDisableEntry = this.getModel().getEntryEntity("fielddisableentry");
        HashMap disableFieldMap = Maps.newHashMapWithExpectedSize((int)fieldDisableEntry.size());
        for (DynamicObject dimDisableDy : fieldDisableEntry) {
            DynamicObject disableFieldReportDy = dimDisableDy.getDynamicObject("disablefieldreport");
            DynamicObject disableFieldDy = dimDisableDy.getDynamicObject("disablefield");
            if (disableFieldReportDy == null || disableFieldDy == null) continue;
            String disableFieldReportId = disableFieldReportDy.getString("id");
            String disableFieldId = disableFieldDy.getString("id");
            disableFieldMap.putIfAbsent(disableFieldReportId, Sets.newHashSetWithExpectedSize((int)fieldDisableEntry.size()));
            disableFieldMap.computeIfPresent(disableFieldReportId, (oldKey, oldValue) -> {
                oldValue.add(disableFieldId);
                return oldValue;
            });
        }
        return disableFieldMap;
    }

    private String getShowName(QueryFieldBo queryFieldBo, String data, Map<String, String> baseDataIdToShowNameMap) {
        String entityNumber = queryFieldBo._getFieldEntityNumber();
        if (HRStringUtils.isNotEmpty((String)data)) {
            LOGGER.info("getUserRepPermDataRangeReturnVO_data_{}", (Object)data);
            String[] ids = data.split(",");
            ArrayList showNames = Lists.newArrayListWithExpectedSize((int)ids.length);
            LOGGER.info("getUserRepPermDataRangeReturnVO_baseDataIdToShowNameMap_{}", baseDataIdToShowNameMap);
            for (String id : ids) {
                String showName = baseDataIdToShowNameMap.get(entityNumber + "_" + id);
                LOGGER.info("buildPermFieldData_baseDataIdKey_{}", (Object)(entityNumber + "_" + id));
                if (!HRStringUtils.isNotEmpty((String)showName)) continue;
                showNames.add(showName);
            }
            return String.join((CharSequence)",", showNames);
        }
        return data;
    }
}

