/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm.utils;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.LongProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportUserPermFormUtils
implements ReportUserPermConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportUserPermFormUtils.class);

    public static Map<Object, Boolean> getSelectedReportIsMergeMap(IDataModel model) {
        DynamicObjectCollection permDataEntry = model.getEntryEntity("rptpermdataentry");
        HashMap selectReportIsMergeMap = Maps.newHashMapWithExpectedSize((int)permDataEntry.size());
        for (DynamicObject permDataDy : permDataEntry) {
            Object pkValue;
            DynamicObject reportDy = permDataDy.getDynamicObject("report");
            if (reportDy == null || selectReportIsMergeMap.containsKey(pkValue = reportDy.getPkValue())) continue;
            boolean isMerge = permDataDy.getBoolean("ismerge");
            selectReportIsMergeMap.put(pkValue, isMerge);
        }
        DynamicObjectCollection selectReportEntry = model.getEntryEntity("selectreportentry");
        HashSet selectReportIds = Sets.newHashSetWithExpectedSize((int)selectReportEntry.size());
        for (DynamicObject selectReportEntryDy : selectReportEntry) {
            DynamicObject selectReportDy = selectReportEntryDy.getDynamicObject("selectreport");
            if (selectReportDy == null) continue;
            Object pkValue = selectReportDy.getPkValue();
            if (!selectReportIsMergeMap.containsKey(pkValue)) {
                selectReportIsMergeMap.put(pkValue, selectReportEntryDy.getBoolean("selectreportismerge"));
            }
            selectReportIds.add(pkValue);
        }
        for (Object reportId : selectReportIsMergeMap.keySet()) {
            if (selectReportIds.contains(reportId)) continue;
            int newEntryRow = model.createNewEntryRow("selectreportentry");
            model.setValue("selectreport", reportId, newEntryRow);
        }
        return selectReportIsMergeMap;
    }

    public static void changeSelectReportIsMerge(IDataModel model, Object reportId, boolean isMerge) {
        if (reportId == null || model == null) {
            return;
        }
        DynamicObjectCollection selectReportEntry = model.getEntryEntity("selectreportentry");
        for (DynamicObject selectReportEntryDy : selectReportEntry) {
            DynamicObject selectReportDy = selectReportEntryDy.getDynamicObject("selectreport");
            if (selectReportDy == null || !String.valueOf(reportId).equals(selectReportDy.getString("id"))) continue;
            selectReportEntryDy.set("selectreportismerge", (Object)isMerge);
            break;
        }
        model.updateEntryCache(selectReportEntry);
    }

    public static Set<Long> getTransSelectNodeIds(IFormView formView) {
        String reportRangeSelectIdStr = formView.getPageCache().get("CACHE_KEY_OF_REPORT_RANGE_SELECT_IDS");
        LOGGER.info("getTransSelectNodeIds_selectedData_{}", (Object)reportRangeSelectIdStr);
        if (HRStringUtils.isNotEmpty((String)reportRangeSelectIdStr)) {
            List selectIds = JSONArray.parseArray((String)reportRangeSelectIdStr, Long.class);
            return Sets.newHashSet((Iterable)selectIds);
        }
        Map<Object, Boolean> selectedReportIsMergeMap = ReportUserPermFormUtils.getSelectedReportIsMergeMap(formView.getModel());
        Set<Long> selectIds = selectedReportIsMergeMap.keySet().stream().map(String::valueOf).map(Long::parseLong).collect(Collectors.toSet());
        formView.getPageCache().put("CACHE_KEY_OF_REPORT_RANGE_SELECT_IDS", JSONArray.toJSONString(selectIds));
        return selectIds;
    }

    public static Map<String, QueryFieldBo> initQueryFieldBoMap(DynamicObject[] fieldMapArray) {
        ArrayList repQueryFieldIds = Lists.newArrayListWithExpectedSize((int)fieldMapArray.length);
        for (DynamicObject dimMapDy : fieldMapArray) {
            DynamicObjectCollection fieldEntry = dimMapDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject fieldEntryDy : fieldEntry) {
                DynamicObject aoqFieldDy;
                if (fieldEntryDy == null || (aoqFieldDy = fieldEntryDy.getDynamicObject("aoqfield")) == null) continue;
                repQueryFieldIds.add(aoqFieldDy.getPkValue());
            }
        }
        DynamicObject[] reqFieldDys = QUERY_FIELD_HELPER.loadDynamicObjectArray(repQueryFieldIds.toArray());
        List queryFieldBos = AnalyseObjectService.getInstance().assembleQueryFields(reqFieldDys);
        return queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, Function.identity()));
    }

    public static Map<String, String> getBaseDataIdToShowNameMap(MainEntityTypeUtil mainEntityTypeUtil, Map<String, Set<String>> entityNumberToIdsMap) {
        HashMap showMap = Maps.newHashMapWithExpectedSize((int)entityNumberToIdsMap.size());
        for (Map.Entry<String, Set<String>> dataMapEntry : entityNumberToIdsMap.entrySet()) {
            DynamicObject[] dbDys;
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(dataMapEntry.getKey());
            Set<String> value = dataMapEntry.getValue();
            if (!(mainEntityType instanceof BasedataEntityType) || value.isEmpty()) continue;
            String nameProperty = ((BasedataEntityType)mainEntityType).getNameProperty();
            ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
            Set<Object> ids = primaryKey instanceof LongProp ? value.stream().map(Long::parseLong).collect(Collectors.toSet()) : Sets.newHashSet(value);
            HRBaseServiceHelper helper = new HRBaseServiceHelper(mainEntityType.getName());
            String selectFieldStr = primaryKey.getName() + "," + nameProperty;
            for (DynamicObject dbDy : dbDys = helper.queryOriginalArray(selectFieldStr, new QFilter[]{new QFilter(primaryKey.getName(), "in", (Object)ids)})) {
                showMap.put(dataMapEntry.getKey() + "_" + dbDy.getString(primaryKey.getName()), dbDy.getString(nameProperty));
            }
        }
        LOGGER.info("getBaseDataIdToShowNameMap_data_{}", (Object)showMap);
        return showMap;
    }
}

