/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.permission;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptc.business.util.HRTreeSearchTool;
import kd.hr.hrptmc.business.repdesign.ReportManageService;

public class RptGroupTreeList
extends StandardTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(RptGroupTreeList.class);

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel tv1 = this.getTreeListView().getTreeModel();
        e.setChildNodes(HRTreeSearchTool.getChildrenNodes((ITreeModel)tv1, (String)((String)e.getNodeId())));
        HRTreeSearchTool.resetCurrentNode();
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject evt) {
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel != null) {
            TreeNode root = this.createRootNode();
            root.setIsOpened(true);
            this.setChildrenNode(root);
            treeModel.setRoot(root);
            treeModel.setCurrentNodeId((Object)root.getId());
        }
        this.getPageCache().put("initTreePage", "hrptc_rptdimmap");
    }

    private void setChildrenNode(TreeNode root) {
        DynamicObjectCollection rptGroupColl = ReportManageService.queryAllRptGroup();
        HashMap<Long, List<DynamicObject>> rptGroupMap = new HashMap<Long, List<DynamicObject>>(rptGroupColl.size());
        for (DynamicObject dy : rptGroupColl) {
            long parent = dy.getLong("parent");
            if (0L == parent) continue;
            ArrayList<DynamicObject> rptGroupList = (ArrayList<DynamicObject>)rptGroupMap.get(parent);
            if (null == rptGroupList) {
                rptGroupList = new ArrayList<DynamicObject>(10);
            }
            rptGroupList.add(dy);
            rptGroupMap.put(parent, rptGroupList);
        }
        this.setChildrenNode(root, rptGroupMap, 1000L);
    }

    private void setChildrenNode(TreeNode root, Map<Long, List<DynamicObject>> rptGroupMap, Long parentId) {
        List<DynamicObject> rptGroupList = rptGroupMap.get(parentId);
        if (!CollectionUtils.isEmpty(rptGroupList)) {
            for (DynamicObject dy : rptGroupList) {
                TreeNode node = this.createNode(dy.getString("id"), dy.getString("name"), dy.getString("longnumber"), dy.getString("parent"), dy.getBoolean("isendgroup"));
                this.setChildrenNode(node, rptGroupMap, dy.getLong("id"));
                root.addChild(node);
            }
        }
    }

    private TreeNode createRootNode() {
        HRBaseServiceHelper CENTER_GROUP_HELPER = new HRBaseServiceHelper("hrptc_reportgroup");
        DynamicObject rootNode = CENTER_GROUP_HELPER.loadSingle((Object)1000L);
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(1000L));
        if (rootNode != null) {
            node.setText(rootNode.getString("name"));
            node.setLongNumber(rootNode.getString("longnumber"));
        } else {
            node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportCenterGroupConstants_0", (String)"hrmp-hrptc-common", (Object[])new Object[0]));
            node.setLongNumber("ALL");
        }
        node.setParentid("");
        node.addChildren((List)Lists.newArrayListWithExpectedSize((int)10));
        node.setIsOpened(true);
        return node;
    }

    private TreeNode createNode(String id, String name, String longNumber, String parentId, boolean isLeaf) {
        TreeNode node = new TreeNode();
        node.setId(id);
        node.setText(name);
        node.setLongNumber(longNumber);
        node.setParentid(parentId);
        if (!isLeaf) {
            node.addChildren((List)Lists.newArrayListWithExpectedSize((int)10));
        }
        node.setIsOpened(false);
        node.setLeaf(isLeaf);
        return node;
    }

    protected List<String> getAllTreeNodeChildNodeIds(TreeNode parentNode) {
        ArrayList childNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        List children = parentNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                childNodeIds.add(child.getId());
                childNodeIds.addAll(this.getAllTreeNodeChildNodeIds(child));
            }
        }
        return childNodeIds;
    }
}

