/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.share.ReportShareConstants;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptmc.business.repdesign.info.RptFilterInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.ReportPreViewServicePlugin;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportFilterService;

public class ReportCenterPreViewPlugin
extends ReportPreViewServicePlugin
implements ReportSubscribeConstants,
ReportShareConstants {
    private static final String BTN_SUBSCRIBE = "subscribebtn";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_SHARE = "sharebtn";
    private static final String BTN_DISPLAY_SET = "displayset";
    private static final String OP_SUBSCRIBE = "subscribe";
    private static final String OP_SHARE = "share";
    private static final String OP_QUERY = "query";
    private static final Log LOGGER = LogFactory.getLog(ReportCenterPreViewPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            this.setBtnVisible();
            this.setUserDisplayScheme();
            this.setContainsSub();
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterPreViewPlugin afterBindData error:", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        if ("clickQuery".equals(args.getEventName())) {
            this.hideBtn();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        try {
            this.doBeforeDoOperation(args);
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterPreViewPlugin beforeDoOperation: ", (Throwable)exception);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)OP_QUERY, (String)operateKey)) {
            this.hideBtn();
        }
    }

    private void doBeforeDoOperation(BeforeDoOperationEventArgs args) throws Exception {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_SUBSCRIBE)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hrptmc_subscribeconfig");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("reportId", this.getView().getFormShowParameter().getCustomParam("reportId"));
            formShowParameter.setCustomParam("reportName", this.getView().getFormShowParameter().getCustomParam("reportName"));
            formShowParameter.setCustomParam("reportNumber", this.getView().getFormShowParameter().getCustomParam("reportNumber"));
            formShowParameter.setCustomParam("reportGroupId", this.getView().getFormShowParameter().getCustomParam("reportGroupId"));
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)OP_SHARE)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hrptmc_rptshareconfig");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("reportId", this.getView().getFormShowParameter().getCustomParam("reportId"));
            formShowParameter.setCustomParam("reportName", this.getView().getFormShowParameter().getCustomParam("reportName"));
            formShowParameter.setCustomParam("reportNumber", this.getView().getFormShowParameter().getCustomParam("reportNumber"));
            formShowParameter.setCustomParam("reportEsIndexId", this.getView().getFormShowParameter().getCustomParam("reportEsIndexId"));
            formShowParameter.setCustomParam("baseDataEsIndexId", this.getView().getFormShowParameter().getCustomParam("baseDataEsIndexId"));
            formShowParameter.setCustomParam("openFrom", this.getView().getFormShowParameter().getCustomParam("openFrom"));
            formShowParameter.setCustomParam("mySubScribeId", this.getView().getFormShowParameter().getCustomParam("mySubScribeId"));
            ReportFilterService rptFilterService = new ReportFilterService((AbstractFormPlugin)this, this.getRptCacheService(), this.getModel());
            RptFilterInfo rptFilterInfo = rptFilterService.getRptFilterInfo(false);
            List whereQFilter = rptFilterInfo.getWhereQFilter();
            if (whereQFilter != null && !whereQFilter.isEmpty()) {
                ArrayList filters = Lists.newArrayListWithExpectedSize((int)whereQFilter.size());
                for (QFilter qFilter : whereQFilter) {
                    filters.add(qFilter.toSerializedString());
                }
                formShowParameter.setCustomParam("reportFilters", (Object)SerializationUtils.toJsonString((Object)filters));
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private void hideBtn() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openFrom = (String)formShowParameter.getCustomParam("openFrom");
        if (HRStringUtils.equals((String)openFrom, (String)"mySubscribe")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REFRESH});
        } else if (HRStringUtils.equals((String)openFrom, (String)OP_SHARE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REFRESH, BTN_DISPLAY_SET});
        }
    }

    private void setBtnVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openFrom = (String)formShowParameter.getCustomParam("openFrom");
        if (HRStringUtils.equals((String)openFrom, (String)"mySubscribe")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SUBSCRIBE, BTN_REFRESH});
        } else if (HRStringUtils.equals((String)openFrom, (String)OP_SHARE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SUBSCRIBE, BTN_SHARE, BTN_REFRESH, BTN_DISPLAY_SET});
        } else if (!HRStringUtils.equals((String)openFrom, (String)"reportCenter")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SUBSCRIBE, BTN_SHARE});
        }
    }

    private void setUserDisplayScheme() {
        if (this.isShareReport()) {
            Control control = this.getView().getControl("userdispscm");
            if (control == null) {
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long userDisplaySchemeId = (Long)formShowParameter.getCustomParam("shareReportUserDisplayScheme");
            if (userDisplaySchemeId == null || userDisplaySchemeId == 0L) {
                return;
            }
            this.getModel().setValue("userdispscm", (Object)userDisplaySchemeId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"userdispscm"});
            this.getView().updateView("userdispscm");
        }
    }

    private void setContainsSub() {
        if (this.isShareReport()) {
            Control control = this.getView().getControl("containsub");
            if (control == null) {
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Boolean containSubParam = (Boolean)formShowParameter.getCustomParam("shareReportContainSub");
            if (containSubParam == null) {
                return;
            }
            this.getModel().setValue("containsub", (Object)containSubParam);
            this.getView().updateView("containsub");
        }
    }

    private boolean isShareReport() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openFrom = (String)formShowParameter.getCustomParam("openFrom");
        return HRStringUtils.equals((String)openFrom, (String)OP_SHARE);
    }
}

