/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.share;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptc.business.share.ReportShareConfigService;
import kd.hr.hrptc.common.constant.share.ReportShareConstants;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareConfigBo;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareFilterRangeBo;

public class ReportShareConfigPlugin
extends HRDataBaseEdit
implements ReportShareConstants,
BeforeF7SelectListener {
    private final ReportShareConfigService shareService = new ReportShareConfigService();
    private final String CONFIG_CACHE = "configCache";
    private static final String CONTAIN_SUB = "containsub";
    private static final Log LOGGER = LogFactory.getLog(ReportShareConfigPlugin.class);
    private static final String OP_OK = "ok";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        MulBasedataEdit receiveUserEdit = (MulBasedataEdit)this.getView().getControl("receiveuser");
        receiveUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            this.doBeforeBindData();
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareConfigPlugin beforeBindData error: ", (Throwable)exception);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        try {
            IDataEntityProperty property = evt.getProperty();
            if (HRStringUtils.equals((String)property.getName(), (String)"receiveuser")) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", (Object)RequestContext.get().getCurrUserId()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareConfigPlugin beforeF7Select error: ", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        try {
            this.doBeforeDoOperation(args);
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareConfigPlugin beforeDoOperation error: ", (Throwable)exception);
        }
    }

    private void doBeforeBindData() {
        Map msgCenterEnableMsgChannels = this.shareService.getMsgCenterEnableMsgChannels();
        if (msgCenterEnableMsgChannels.size() > 0) {
            MulComboEdit noticeTypeControl = (MulComboEdit)this.getControl("noticetype");
            ArrayList items = Lists.newArrayListWithCapacity((int)msgCenterEnableMsgChannels.size());
            msgCenterEnableMsgChannels.forEach((number, name) -> {
                if (number.equals(MessageChannels.SYSNOTICE.getNumber())) {
                    return;
                }
                ComboItem item = new ComboItem(new LocaleString(name), number);
                items.add(item);
            });
            ComboItem mcItem = new ComboItem(new LocaleString(MessageChannels.MC.getName()), MessageChannels.MC.getNumber());
            items.add(mcItem);
            noticeTypeControl.setComboItems((List)items);
        }
        ReportShareConfigBo reportShareConfigBo = new ReportShareConfigBo();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2099, 11, 30);
        this.getModel().setValue("expiration", (Object)calendar.getTime());
        reportShareConfigBo.setOnlyQueryResult(true);
        reportShareConfigBo.setExpiration(calendar.getTime());
        this.getPageCache().put("configCache", SerializationUtils.toJsonString((Object)reportShareConfigBo));
    }

    private void doBeforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_OK)) {
            String openFrom;
            ReportShareConfigBo reportShareConfigBo = new ReportShareConfigBo();
            Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("reportId");
            reportShareConfigBo.setReportId(reportId);
            Map reportNumberAndName = ReportHisVersionService.getInstance().getReportNumberAndName(reportId.longValue(), new Date());
            reportShareConfigBo.setReportName((LocaleString)reportNumberAndName.get("name"));
            reportShareConfigBo.setReportNumber((String)reportNumberAndName.get("number"));
            reportShareConfigBo.setShareUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
            List receiveUsers = ((DynamicObjectCollection)this.getModel().getValue("receiveuser")).stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(bd -> bd.getLong("id")).collect(Collectors.toList());
            reportShareConfigBo.setReceiveUsers(receiveUsers);
            String onlyQueryResult = (String)this.getModel().getValue("onlyqueryresult");
            reportShareConfigBo.setOnlyQueryResult(HRStringUtils.equals((String)onlyQueryResult, (String)"1"));
            reportShareConfigBo.setExpiration((Date)this.getModel().getValue("expiration"));
            reportShareConfigBo.setNoticeType((String)this.getModel().getValue("noticetype"));
            OrmLocaleValue content = (OrmLocaleValue)this.getModel().getValue("content");
            if (content != null) {
                reportShareConfigBo.setContent(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)content));
            }
            if (HRStringUtils.equals((String)(openFrom = (String)this.getView().getFormShowParameter().getCustomParam("openFrom")), (String)"reportCenter")) {
                reportShareConfigBo.setShareSource("ReportCenter");
            } else if (HRStringUtils.equals((String)openFrom, (String)"mySubscribe")) {
                reportShareConfigBo.setShareSource("ReportSubscribe");
                Long mySubscribeId = (Long)this.getView().getFormShowParameter().getCustomParam("mySubScribeId");
                reportShareConfigBo.setReportSubscribeId(mySubscribeId);
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    this.collectReportFilterValues(reportShareConfigBo);
                    this.collectWhereQFilters(reportShareConfigBo);
                    String mySubscribeEsIndexId = (String)this.getView().getFormShowParameter().getCustomParam("reportEsIndexId");
                    this.shareService.saveReportShareConfigBo(reportShareConfigBo, mySubscribeEsIndexId);
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    throw exception;
                }
            }
        }
    }

    private void collectWhereQFilters(ReportShareConfigBo reportShareConfigBo) {
        String filterStr = (String)this.getView().getFormShowParameter().getCustomParam("reportFilters");
        if (HRStringUtils.isEmpty((String)filterStr)) {
            return;
        }
        reportShareConfigBo.setReportQFilterStr(filterStr);
    }

    private void collectReportFilterValues(ReportShareConfigBo reportShareConfigBo) {
        IFormView reportPreView = this.getView().getParentView();
        if (reportPreView == null) {
            return;
        }
        ArrayList shareFilterRangeBoList = Lists.newArrayListWithCapacity((int)10);
        Control containSubControl = reportPreView.getControl(CONTAIN_SUB);
        if (containSubControl != null) {
            ReportShareFilterRangeBo containSubBo = new ReportShareFilterRangeBo();
            containSubBo.setFieldAlias(CONTAIN_SUB);
            containSubBo.setContainSub((Boolean)reportPreView.getModel().getValue(CONTAIN_SUB));
            shareFilterRangeBoList.add(containSubBo);
            reportShareConfigBo.setShareFilterRangeBoList((List)shareFilterRangeBoList);
        }
        FormShowParameter formShowParameter = reportPreView.getFormShowParameter();
        List filters = Lists.newArrayListWithCapacity((int)10);
        String filterData = (String)formShowParameter.getCustomParam("filterdata");
        if (HRStringUtils.isNotEmpty((String)filterData)) {
            filters = JSON.parseArray((String)filterData, FilterBo.class);
        }
        if (filters.isEmpty()) {
            return;
        }
        for (FilterBo filter : filters) {
            String fieldAlias = filter.getFieldAlias();
            String filterType = filter.getFilterType();
            ReportShareFilterRangeBo shareFilterRangeBo = new ReportShareFilterRangeBo(fieldAlias, filterType);
            this.handleFilterRangeAndDefault(filter, shareFilterRangeBo, reportPreView);
            shareFilterRangeBoList.add(shareFilterRangeBo);
        }
        reportShareConfigBo.setShareFilterRangeBoList((List)shareFilterRangeBoList);
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleFilterRangeAndDefault(FilterBo filter, ReportShareFilterRangeBo shareFilterRangeBo, IFormView reportPreView) {
        String fieldAlias = filter.getFieldAlias();
        String filterType = filter.getFilterType();
        FilterType filterTypeByValue = FilterType.getFilterTypeByValue((String)filterType);
        switch (filterTypeByValue) {
            case NUMBER: {
                BigDecimal numberValue = (BigDecimal)reportPreView.getModel().getValue(fieldAlias);
                if (numberValue != null) {
                    shareFilterRangeBo.setFilterDefault(numberValue.toString());
                }
                String opt = (String)reportPreView.getModel().getValue(fieldAlias + "_" + "opt");
                shareFilterRangeBo.setOpt(opt);
                break;
            }
            case STRING: {
                String stringValue = (String)reportPreView.getModel().getValue(fieldAlias);
                if (!HRStringUtils.isNotEmpty((String)stringValue)) break;
                shareFilterRangeBo.setFilterDefault(stringValue);
                break;
            }
            case ENUM: {
                String enumValue = (String)reportPreView.getModel().getValue(fieldAlias);
                if (!HRStringUtils.isNotEmpty((String)enumValue)) break;
                shareFilterRangeBo.setFilterDefault(enumValue);
                shareFilterRangeBo.setFilterRange(enumValue);
                break;
            }
            case DATE: {
                String dateType = filter.getDateType();
                shareFilterRangeBo.setDateFilterType(filter.getDateFilterType());
                shareFilterRangeBo.setDateFilterText(filter.getDateFilterText());
                if (HRStringUtils.equals((String)dateType, (String)"0")) {
                    String vestDate = reportPreView.getPageCache().get(fieldAlias + "_vestdate");
                    if (!HRStringUtils.isNotEmpty((String)vestDate)) break;
                    this.handleVestDateFilter(vestDate, shareFilterRangeBo);
                    break;
                }
                Date dateValue = (Date)reportPreView.getModel().getValue(fieldAlias);
                if (dateValue == null) break;
                DateFormat userDateFormat = ReportTimeZoneUtil.getUserDateFormat();
                shareFilterRangeBo.setFilterStartDateDefault(userDateFormat.format(dateValue));
                break;
            }
            case BASE_DATA_ENUM: {
                String selectF7 = reportPreView.getPageCache().get(fieldAlias + "_selectF7");
                if (!HRStringUtils.isNotEmpty((String)selectF7)) break;
                List ids = SerializationUtils.fromJsonStringToList((String)selectF7, String.class);
                String baseDataValue = String.join((CharSequence)",", ids);
                shareFilterRangeBo.setFilterDefault(baseDataValue);
                shareFilterRangeBo.setFilterRange(baseDataValue);
                break;
            }
            case BASE_DATA: 
            case HIS_BASE_DATA: 
            case ADMIN_ORG: {
                MulBasedataDynamicObjectCollection baseDataValues;
                if (HRStringUtils.equals((String)fieldAlias, (String)"userdispscm")) {
                    DynamicObject userDisplaySchemeDy = (DynamicObject)reportPreView.getModel().getValue("userdispscm");
                    if (userDisplaySchemeDy == null) break;
                    shareFilterRangeBo.setUserDisplayScheme(Long.valueOf(userDisplaySchemeDy.getLong("id")));
                    break;
                }
                Object value = reportPreView.getModel().getValue(fieldAlias);
                if (value instanceof DynamicObject) {
                    DynamicObject baseDataValue = (DynamicObject)value;
                    shareFilterRangeBo.setFilterDefault(baseDataValue.getString("id"));
                    shareFilterRangeBo.setFilterRange(baseDataValue.getString("id"));
                    break;
                }
                if (!(value instanceof MulBasedataDynamicObjectCollection) || (baseDataValues = (MulBasedataDynamicObjectCollection)value).isEmpty()) break;
                List baseDataIds = baseDataValues.stream().map(val -> {
                    Object id = val.get(2);
                    if (id == null) {
                        return "";
                    }
                    if (id instanceof Long) {
                        return String.valueOf(id);
                    }
                    return id.toString();
                }).collect(Collectors.toList());
                String baseDataIdStr = String.join((CharSequence)",", baseDataIds);
                shareFilterRangeBo.setFilterDefault(baseDataIdStr);
                shareFilterRangeBo.setFilterRange(baseDataIdStr);
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleVestDateFilter(String vestDate, ReportShareFilterRangeBo shareFilterRangeBo) {
        Map cast = (Map)SerializationUtils.fromJsonString((String)vestDate, Map.class);
        String datePickerType = (String)cast.get("datePickerType");
        Object datePickerContent = cast.get("datePickerContent");
        if (datePickerContent instanceof String && HRStringUtils.isEmpty((String)((String)datePickerContent))) {
            return;
        }
        if (datePickerContent instanceof List) {
            if (CollectionUtils.isEmpty((Collection)((List)datePickerContent))) {
                return;
            }
            List list = (List)datePickerContent;
            for (String str : list) {
                if (!HRStringUtils.isEmpty((String)str)) continue;
                return;
            }
        }
        if (HRStringUtils.isEmpty((String)datePickerType)) {
            return;
        }
        if (HRStringUtils.isNotEmpty((String)datePickerType) && datePickerType.startsWith("timescope")) {
            List datePickerContents = (List)cast.get("datePickerContent");
            shareFilterRangeBo.setFilterStartDateDefault((String)datePickerContents.get(0));
            shareFilterRangeBo.setFilterEndDateDefault((String)datePickerContents.get(1));
            shareFilterRangeBo.setDateFilterType(datePickerType);
            shareFilterRangeBo.setDateFilterText(null);
        } else {
            shareFilterRangeBo.setDateFilterType(datePickerType);
            shareFilterRangeBo.setDateFilterText((String)cast.get("datePickerContent"));
            shareFilterRangeBo.setFilterStartDateDefault(null);
            shareFilterRangeBo.setFilterEndDateDefault(null);
        }
    }
}

