/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.subscribe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.subscribe.ReportSubscribeConfigService;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportSubscribeConfigBo;
import kd.hr.hrptmc.common.constant.center.ReportCenterGroupConstants;

public class ReportSubscribeRecordListPlugin
extends StandardTreeListPlugin
implements ReportSubscribeConstants,
ReportCenterGroupConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportSubscribeRecordListPlugin.class);
    private static final String OP_SUBSCRIBE_RULE = "subscriberule";
    private static final String OP_CANCEL_SUBSCRIBE = "cancelsubscribe";
    private final ReportSubscribeConfigService configService = new ReportSubscribeConfigService();

    public void initialize() {
        super.initialize();
        try {
            this.setInitTreeNodeFilter(this.getTreeListView());
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeRecordListPlugin initialize error:", (Throwable)exception);
        }
    }

    public void initializeTree(EventObject evt) {
        try {
            ITreeModel treeModel = this.getTreeModel();
            if (treeModel != null) {
                TreeNode root = this.createRootNode();
                treeModel.setRoot(root);
                treeModel.setCurrentNodeId((Object)root.getId());
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeRecordListPlugin initializeTree error:", (Throwable)exception);
        }
    }

    public void initTreeToolbar(EventObject evt) {
        super.initTreeToolbar(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            if (StringUtils.equals((CharSequence)"report_number", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
                args.setCancel(true);
                Long subscribeRecordId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
                DynamicObject report = this.configService.getSubscribeReportDy(subscribeRecordId.longValue());
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setHasRight(true);
                showParameter.setFormId(report.getString("report.number"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("openFrom", (Object)"reportCenter");
                showParameter.setCustomParam("reportId", (Object)report.getLong("report.id"));
                showParameter.setCustomParam("reportName", (Object)report.getString("report.name"));
                showParameter.setCustomParam("reportNumber", (Object)report.getString("report.number"));
                showParameter.setCustomParam("reportGroupId", (Object)report.getString("reportgroup.id"));
                showParameter.setCustomParam("CUSTOM_PARAM_PUBLISH_TYPE", (Object)"reportCenter");
                this.getView().showForm(showParameter);
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeRecordListPlugin billListHyperLinkClick error:", (Throwable)exception);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()));
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        try {
            String currentNodeId = (String)evt.getNodeId();
            if (!String.valueOf(1000L).equals(currentNodeId)) {
                TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                List<String> childNodeIds = this.getAllTreeNodeChildNodeIds(treeNode);
                childNodeIds.add(currentNodeId);
                QFilter qFilter = new QFilter("reportgroup", "in", childNodeIds.stream().map(Long::parseLong).collect(Collectors.toList()));
                evt.addQFilter(qFilter);
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeRecordListPlugin buildTreeListFilter error:", (Throwable)exception);
        }
    }

    private List<String> getAllTreeNodeChildNodeIds(TreeNode parentNode) {
        ArrayList childNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        List children = parentNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                childNodeIds.add(child.getId());
                childNodeIds.addAll(this.getAllTreeNodeChildNodeIds(child));
            }
        }
        return childNodeIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            this.doAfterDoOperation(args);
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeRecordListPlugin afterDoOperation error:", (Throwable)exception);
        }
    }

    private void doAfterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_SUBSCRIBE_RULE)) {
            Long subscribeRecordId = (Long)((IListView)this.getView()).getFocusRowPkId();
            DynamicObject report = this.configService.getSubscribeReportDy(subscribeRecordId.longValue());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hrptmc_subscribeconfig");
            formShowParameter.setHasRight(true);
            formShowParameter.setCustomParam("reportId", (Object)report.getLong("report.id"));
            formShowParameter.setCustomParam("reportName", (Object)report.getString("report.name"));
            formShowParameter.setCustomParam("reportNumber", (Object)report.getString("report.number"));
            formShowParameter.setCustomParam("reportGroupId", (Object)report.getString("reportgroup.id"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_SUBSCRIBE_RULE));
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)OP_CANCEL_SUBSCRIBE)) {
            Long focusRowPkId = (Long)((IListView)this.getView()).getFocusRowPkId();
            Long reportId = this.configService.getSubscribeReportId(focusRowPkId.longValue());
            ReportSubscribeConfigBo reportSubscribeConfig = this.configService.getReportSubscribeConfig(reportId.longValue(), RequestContext.get().getCurrUserId());
            if (reportSubscribeConfig != null) {
                this.configService.cancelSubscribe(reportSubscribeConfig);
            }
            ((IListView)this.getView()).refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)OP_SUBSCRIBE_RULE, (String)evt.getActionId())) {
            ((IListView)this.getView()).refresh();
        }
    }
}

