/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.ScheduleService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractTask;
import kd.hr.hrptmc.business.anobj.AnObjDataStoreTaskServiceHelper;
import kd.hr.hrptmc.common.constant.dataextract.AnObjExtractConstants;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;

public class AnObjDataExtractConfigPlugin
extends AbstractFormPlugin
implements AnObjExtractConstants {
    private static final String OPEN_EXTRACT = "openextract";
    private static final String CYCLE = "cycle";
    private static final String TIME_DAY = "timeday";
    private static final String TIME_WEEK = "timeweek";
    private static final String TIME_HOUR = "timehour";
    private static final String EXECUTE_NOW = "executenow";
    private static final String OP_OK = "ok";
    private static final String KEY_CONFIG = "anObjExtractConfig";
    private static final Log LOGGER = LogFactory.getLog(AnObjDataExtractConfigPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            this.doBeforeBindData();
        }
        catch (Exception exception) {
            LOGGER.error("AnObjDataExtractConfigPlugin beforeBindData: ", (Throwable)exception);
        }
    }

    private void doBeforeBindData() {
        Long anObjId = (Long)this.getView().getFormShowParameter().getCustomParam("anObjId");
        AnObjExtractConfigBo anObjExtractConfig = AnObjDataExtractService.getInstance().getAnObjExtractConfig(anObjId.longValue());
        if (anObjExtractConfig == null || !anObjExtractConfig.isOpenExtract()) {
            this.getModel().setValue(OPEN_EXTRACT, (Object)"0");
            this.setControlVisible(CYCLE, false);
            this.setControlVisible(TIME_DAY, false);
            this.setControlVisible(TIME_WEEK, false);
            this.setControlVisible(TIME_HOUR, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{EXECUTE_NOW});
        } else {
            this.getModel().setValue(OPEN_EXTRACT, (Object)"1");
            this.getModel().setValue(CYCLE, (Object)anObjExtractConfig.getCycle());
            CronStruct cronParser = CronStruct.parse((String)anObjExtractConfig.getCronExpr());
            this.initCron(cronParser, anObjExtractConfig.getCycle());
            this.getModel().setValue(EXECUTE_NOW, (Object)anObjExtractConfig.isExecuteNow());
        }
        if (anObjExtractConfig != null) {
            this.getPageCache().put(KEY_CONFIG, SerializationUtils.toJsonString((Object)anObjExtractConfig));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        try {
            String prop = args.getProperty().getName();
            if (HRStringUtils.equals((String)prop, (String)CYCLE)) {
                this.changeCycle((String)args.getChangeSet()[0].getNewValue());
            } else if (HRStringUtils.equals((String)prop, (String)OPEN_EXTRACT)) {
                this.changeOpenExtract((String)args.getChangeSet()[0].getNewValue());
            }
        }
        catch (Exception exception) {
            LOGGER.error("AnObjDataExtractConfigPlugin propertyChanged: ", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        try {
            if (HRStringUtils.equals((String)operateKey, (String)OP_OK)) {
                if (this.validateConfig()) {
                    String cronExpr = this.getCronExpr();
                    this.saveConfig(cronExpr);
                } else {
                    args.setCancel(true);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("AnObjDataExtractConfigPlugin beforeDoOperation: ", (Throwable)exception);
        }
    }

    private void saveConfig(String cronExpr) {
        JobInfo scheduleJob;
        AnObjExtractConfigBo anObjExtractConfig;
        block20: {
            String anObjExtractConfigStr = this.getPageCache().get(KEY_CONFIG);
            anObjExtractConfig = new AnObjExtractConfigBo();
            if (HRStringUtils.isNotEmpty((String)anObjExtractConfigStr)) {
                anObjExtractConfig = (AnObjExtractConfigBo)SerializationUtils.fromJsonString((String)anObjExtractConfigStr, AnObjExtractConfigBo.class);
            }
            Long anObjId = (Long)this.getView().getFormShowParameter().getCustomParam("anObjId");
            anObjExtractConfig.setAnObjId(anObjId);
            String openExtract = (String)this.getModel().getValue(OPEN_EXTRACT);
            anObjExtractConfig.setOpenExtract(HRStringUtils.equals((String)openExtract, (String)"1"));
            scheduleJob = null;
            if (anObjExtractConfig.isOpenExtract()) {
                anObjExtractConfig.setCycle((String)this.getModel().getValue(CYCLE));
                anObjExtractConfig.setCronExpr(cronExpr);
                anObjExtractConfig.setExecuteNow(((Boolean)this.getModel().getValue(EXECUTE_NOW)).booleanValue());
                if (anObjExtractConfig.getRunStatus() == null) {
                    anObjExtractConfig.setRunStatus("0");
                }
                String anObjName = (String)this.getView().getFormShowParameter().getCustomParam("anObjName");
                String anObjNum = (String)this.getView().getFormShowParameter().getCustomParam("anObjNum");
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
                        if (HRStringUtils.isEmpty((String)anObjExtractConfig.getScheduleJobId()) || !jobDao.isExist(anObjExtractConfig.getScheduleJobId())) {
                            scheduleJob = AnObjDataExtractService.getInstance().createScheduleJob(anObjExtractConfig.getAnObjId().longValue(), anObjName, anObjNum);
                            anObjExtractConfig.setScheduleJobId(scheduleJob.getId());
                        } else {
                            scheduleJob = jobDao.get(anObjExtractConfig.getScheduleJobId());
                        }
                        AnObjDataExtractService.getInstance().saveSchedulePlan(anObjExtractConfig, scheduleJob, anObjExtractConfig.getCycle(), cronExpr, anObjName, anObjNum);
                        break block20;
                    }
                    catch (Exception exception) {
                        txHandle.markRollback();
                        LOGGER.error("AnObjDataExtractConfigPlugin save scheduleJob and schedulePlan error: ", (Throwable)exception);
                        throw new KDBizException("save scheduleJob and schedulePlan error.");
                    }
                }
            }
            AnObjDataStoreTaskServiceHelper.clearConfig((AnObjExtractConfigBo)anObjExtractConfig);
        }
        AnObjDataExtractService.getInstance().saveAnObjExtractConfig(anObjExtractConfig);
        if (anObjExtractConfig.isOpenExtract() && anObjExtractConfig.isExecuteNow() && scheduleJob != null) {
            scheduleJob.setJobType(JobType.REALTIME);
            scheduleJob.setTaskClassname(AnObjDataExtractTask.class.getName());
            JobClient.dispatch(scheduleJob);
        }
    }

    private boolean validateConfig() {
        String openConfig = (String)this.getModel().getValue(OPEN_EXTRACT);
        if (HRStringUtils.equals((String)openConfig, (String)"0")) {
            return true;
        }
        String cycle = (String)this.getModel().getValue(CYCLE);
        if (HRStringUtils.isEmpty((String)cycle)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u5468\u671f\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = true;
        switch (cycle) {
            case "day": {
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_HOUR)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u65f6\u95f4\uff08\u6309\u5c0f\u65f6\uff09\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "week": {
                if (HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_WEEK)))) {
                    result = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                }
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_HOUR)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u65f6\u95f4\uff08\u6309\u5c0f\u65f6\uff09\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "month": {
                if (HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_DAY)))) {
                    result = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                }
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_HOUR)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u65f6\u95f4\uff08\u6309\u5c0f\u65f6\uff09\u201d\u3002", (String)"AnObjDataExtractConfigPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        return result;
    }

    private String getCronExpr() {
        String cycle = (String)this.getModel().getValue(CYCLE);
        if (cycle == null) {
            return null;
        }
        String hour = "*";
        String day = "*";
        String week = "*";
        switch (cycle) {
            case "hour": {
                week = "?";
                break;
            }
            case "day": {
                week = "?";
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
            case "month": {
                week = "?";
                String timeDay = (String)this.getModel().getValue(TIME_DAY);
                day = this.getTimeListStr(timeDay);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
            case "week": {
                day = "?";
                String timeWeek = (String)this.getModel().getValue(TIME_WEEK);
                week = this.getTimeListStr(timeWeek);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
        }
        CronStruct cron = new CronStruct();
        cron.setSeconds("0");
        cron.setMinutes("0");
        cron.setHours(hour);
        cron.setDayOfMonth(day);
        cron.setMonth("*");
        cron.setDayOfWeek(week);
        return cron.toString();
    }

    private void changeOpenExtract(String newVal) {
        boolean open = HRStringUtils.equals((String)newVal, (String)"1");
        if (open) {
            this.setControlVisible(CYCLE, Boolean.TRUE);
        } else {
            this.setControlVisible(CYCLE, Boolean.FALSE);
            this.setControlVisible(CYCLE, Boolean.FALSE);
            this.setControlVisible(TIME_DAY, Boolean.FALSE);
            this.setControlVisible(TIME_WEEK, Boolean.FALSE);
            this.setControlVisible(TIME_HOUR, Boolean.FALSE);
        }
        this.getView().setVisible(Boolean.valueOf(open), new String[]{EXECUTE_NOW});
    }

    private void changeCycle(String newVal) {
        if (newVal == null) {
            this.setControlVisible(TIME_DAY, false);
            this.setControlVisible(TIME_WEEK, false);
            this.setControlVisible(TIME_HOUR, false);
            return;
        }
        switch (newVal) {
            case "hour": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_HOUR, false);
                break;
            }
            case "day": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "week": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, true);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "month": {
                this.setControlVisible(TIME_DAY, true);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
        }
    }

    private void setControlVisible(String control, boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{control});
        ComboEdit cycleEdit = (ComboEdit)this.getView().getControl(control);
        cycleEdit.setMustInput(visible);
        this.getView().updateView(control);
        if (!visible) {
            this.getModel().setValue(control, null);
        }
    }

    private String getTimeListStr(String timeStr) {
        if (HRStringUtils.isEmpty((String)timeStr)) {
            return timeStr;
        }
        if (timeStr.startsWith(",")) {
            timeStr = timeStr.substring(1);
        }
        if (timeStr.endsWith(",")) {
            timeStr = timeStr.substring(0, timeStr.length() - 1);
        }
        return timeStr;
    }

    private void initCron(CronStruct cronParser, String cycle) {
        switch (cycle) {
            case "hour": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_HOUR, false);
                break;
            }
            case "day": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "week": {
                this.setControlVisible(TIME_DAY, false);
                this.getModel().setValue(TIME_WEEK, (Object)cronParser.getDayOfWeek());
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "month": {
                this.setControlVisible(TIME_WEEK, false);
                this.getModel().setValue(TIME_DAY, (Object)cronParser.getDayOfMonth());
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
        }
    }
}

